/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.codegen.NumberComparisonUtils;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/BooleanComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "op", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "a", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "b", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "getExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getOp", "()Lcom/intellij/psi/tree/IElementType;", "getA", "()Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "getB", "jumpIfFalse", "", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "discard", "getObjectCompareOpcode", "", "opToken", "backend.jvm.codegen"})
public final class BooleanComparison
extends BooleanValue {
    @NotNull
    private final IrFunctionAccessExpression expression;
    @NotNull
    private final IElementType op;
    @NotNull
    private final MaterialValue a;
    @NotNull
    private final MaterialValue b;

    public BooleanComparison(@NotNull IrFunctionAccessExpression expression2, @NotNull IElementType op, @NotNull MaterialValue a, @NotNull MaterialValue b) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        super(a.getCodegen());
        this.expression = expression2;
        this.op = op;
        this.a = a;
        this.b = b;
    }

    @NotNull
    public final IrFunctionAccessExpression getExpression() {
        return this.expression;
    }

    @NotNull
    public final IElementType getOp() {
        return this.op;
    }

    @NotNull
    public final MaterialValue getA() {
        return this.a;
    }

    @NotNull
    public final MaterialValue getB() {
        return this.b;
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int opcode = this.a.getType().getSort() == 10 ? this.getObjectCompareOpcode(this.op) : NumberComparisonUtils.INSTANCE.patchOpcode(NumberComparisonUtils.INSTANCE.getNumberCompareOpcode(this.op), this.getMv(), this.op, this.a.getType());
        this.markLineNumber(this.expression);
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        int n;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.a.getType().getSort() == 10) {
            Integer n2 = NumberComparisonUtils.INSTANCE.getNegatedOperations().get(this.getObjectCompareOpcode(this.op));
            Intrinsics.checkNotNull((Object)n2);
            n = ((Number)n2).intValue();
        } else {
            Integer n3 = NumberComparisonUtils.INSTANCE.getNegatedOperations().get(NumberComparisonUtils.INSTANCE.getNumberCompareOpcode(this.op));
            Intrinsics.checkNotNull((Object)n3);
            n = NumberComparisonUtils.INSTANCE.patchOpcode(((Number)n3).intValue(), this.getMv(), this.op, this.a.getType());
        }
        int opcode = n;
        this.markLineNumber(this.expression);
        this.getMv().visitJumpInsn(opcode, target);
    }

    @Override
    public void discard() {
        this.markLineNumber(this.expression);
        this.b.discard();
        this.a.discard();
    }

    private final int getObjectCompareOpcode(IElementType opToken) {
        int n;
        IElementType iElementType = opToken;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            n = 166;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            n = 165;
        } else {
            throw new UnsupportedOperationException("Don't know how to generate this condJump: " + opToken);
        }
        return n;
    }
}

