/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ClassFakeOverrideReplacement;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmDefaultUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceSuperCallsLoweringKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "transformMemberDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateCloneImplementation", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "fakeOverride", "cloneFun", "generateDefaultImplsRedirectionBody", "irFunction", "superFunction", "callee", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInheritedDefaultMethodsOnClassesLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n+ 2 transform.kt\norg/jetbrains/kotlin/ir/util/TransformKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n*L\n1#1,107:1\n26#2,4:108\n1#3:112\n1786#4,3:113\n418#5,10:116\n379#5,13:128\n76#6,2:126\n133#7,2:141\n*S KotlinDebug\n*F\n+ 1 InheritedDefaultMethodsOnClassesLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InheritedDefaultMethodsOnClassesLowering\n*L\n29#1:108,4\n41#1:113,3\n57#1:116,10\n77#1:128,13\n57#1:126,2\n77#1:141,2\n*E\n"})
public final class InheritedDefaultMethodsOnClassesLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InheritedDefaultMethodsOnClassesLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        if (!JvmIrUtilsKt.isJvmInterface(irClass)) {
            List<IrDeclaration> $this$transformInPlace$iv = irClass.getDeclarations();
            boolean $i$f$transformInPlace = false;
            int i$iv = 0;
            int n = $this$transformInPlace$iv.size();
            while (i$iv < n) {
                void it;
                IrElement irElement;
                IrDeclaration irDeclaration = $this$transformInPlace$iv.get(i$iv);
                int n2 = i$iv++;
                List<IrDeclaration> list = $this$transformInPlace$iv;
                boolean bl = false;
                IrElement irElement2 = irElement = (IrElement)this.transformMemberDeclaration((IrDeclaration)it);
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
                }
                list.set(n2, (IrDeclaration)((IrElement)((IrDeclaration)irElement2)));
            }
        }
    }

    private final IrDeclaration transformMemberDeclaration(IrDeclaration declaration) {
        Object $this$all$iv;
        if (!(declaration instanceof IrSimpleFunction)) {
            return declaration;
        }
        if (((IrSimpleFunction)declaration).isFakeOverride() && Intrinsics.areEqual((Object)((IrSimpleFunction)declaration).getName().asString(), (Object)"clone")) {
            Object v0;
            IrSimpleFunction it;
            List<IrOverridableDeclaration> overriddenFunctions;
            block9: {
                overriddenFunctions = IrUtilsKt.allOverridden((IrOverridableDeclaration)declaration, false);
                Iterable iterable = overriddenFunctions;
                for (Object t : iterable) {
                    it = (IrSimpleFunction)t;
                    boolean bl = false;
                    if (!AdditionalIrUtilsKt.hasEqualFqName(IrUtilsKt.getParentAsClass(it), StandardNames.FqNames.cloneable.toSafe())) continue;
                    v0 = t;
                    break block9;
                }
                v0 = null;
            }
            IrSimpleFunction cloneFun = v0;
            if (cloneFun != null) {
                boolean bl;
                block10: {
                    $this$all$iv = overriddenFunctions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator2 = $this$all$iv.iterator();
                        while (iterator2.hasNext()) {
                            Object element$iv = iterator2.next();
                            it = (IrSimpleFunction)element$iv;
                            boolean bl2 = false;
                            if (it.isFakeOverride() || Intrinsics.areEqual((Object)it, (Object)cloneFun)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return this.generateCloneImplementation((IrSimpleFunction)declaration, cloneFun);
                }
            }
        }
        ClassFakeOverrideReplacement.DefaultImplsRedirection defaultImplsRedirection = ($this$all$iv = this.context.getCachedDeclarations().getClassFakeOverrideReplacement((IrSimpleFunction)declaration)) instanceof ClassFakeOverrideReplacement.DefaultImplsRedirection ? (ClassFakeOverrideReplacement.DefaultImplsRedirection)$this$all$iv : null;
        if (defaultImplsRedirection == null) {
            return declaration;
        }
        ClassFakeOverrideReplacement.DefaultImplsRedirection defaultImplsRedirection2 = defaultImplsRedirection;
        IrSimpleFunction newFunction = defaultImplsRedirection2.component1();
        IrSimpleFunction superFunction = defaultImplsRedirection2.component2();
        IrSimpleFunction callee = defaultImplsRedirection2.component3();
        return this.generateDefaultImplsRedirectionBody(newFunction, superFunction, callee);
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateCloneImplementation(IrSimpleFunction fakeOverride, IrSimpleFunction cloneFun) {
        void $this$generateCloneImplementation_u24lambda_u240_u240_u240;
        void $this$generateCloneImplementation_u24lambda_u240_u240;
        IrCall irCall;
        void this_$iv$iv;
        JvmIrBuilder jvmIrBuilder;
        boolean bl = fakeOverride.isFakeOverride();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        IrSimpleFunction irFunction = JvmDefaultUtilsKt.createDefaultImplsRedirection(this.context.getIrFactory(), fakeOverride);
        int offset = IrUtilsKt.getParentAsClass(fakeOverride).getStartOffset();
        JvmIrBuilder $this$generateCloneImplementation_u24lambda_u240 = jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder(this.context, irFunction.getSymbol(), offset, offset);
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = $this$generateCloneImplementation_u24lambda_u240;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var14_16 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl3 = false;
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$generateCloneImplementation_u24lambda_u240_u240, cloneFun, null, IrUtilsKt.getParentAsClass(cloneFun).getSymbol());
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$generateCloneImplementation_u24lambda_u240_u240;
        void var20_22 = $this$generateCloneImplementation_u24lambda_u240_u240;
        boolean bl4 = false;
        IrBuilder irBuilder = (IrBuilder)$this$generateCloneImplementation_u24lambda_u240_u240;
        IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$generateCloneImplementation_u24lambda_u240_u240_u240.setDispatchReceiver(ExpressionHelpersKt.irGet(irBuilder, irValueParameter));
        Unit unit = Unit.INSTANCE;
        var20_22.unaryPlus(ExpressionHelpersKt.irReturn(irBuilderWithScope, irCall));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        return irFunction;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction generateDefaultImplsRedirectionBody(IrSimpleFunction irFunction, IrSimpleFunction superFunction, IrSimpleFunction callee) {
        void $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241;
        IrCall irCall;
        void $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240;
        void this_$iv$iv;
        DeclarationIrBuilder declarationIrBuilder;
        IrClassSymbol superQualifierSymbol = Intrinsics.areEqual((Object)callee, (Object)superFunction) ? IrUtilsKt.getParentAsClass(superFunction).getSymbol() : null;
        int offset = IrUtilsKt.getParentAsClass(irFunction).getStartOffset();
        JvmBackendContext backendContext = this.context;
        DeclarationIrBuilder $this$generateDefaultImplsRedirectionBody_u24lambda_u240 = declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)irFunction.getSymbol(), offset, offset);
        boolean bl = false;
        IrBuilderWithScope $this$irBlock_u24default$iv = $this$generateDefaultImplsRedirectionBody_u24lambda_u240;
        int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
        IrStatementOrigin origin$iv = null;
        IrType resultType$iv = null;
        boolean $i$f$irBlock = false;
        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
        boolean $i$f$block = false;
        void var18_18 = this_$iv$iv;
        IrBuilder irBuilder = $this$generateDefaultImplsRedirectionBody_u24lambda_u240;
        IrSimpleFunction irSimpleFunction = irFunction;
        boolean bl2 = false;
        Map<IrValueParameter, IrExpression> parameter2arguments = backendContext.getMultiFieldValueClassReplacements().mapFunctionMfvcStructures((IrBlockBuilder)$this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240, callee, irFunction, (Function2<? super IrValueParameter, ? super IrType, ? extends IrExpression>)((Function2)(arg_0, arg_1) -> InheritedDefaultMethodsOnClassesLowering.generateDefaultImplsRedirectionBody$lambda$0$0$0((IrBlockBuilder)$this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240, irFunction, superQualifierSymbol, superFunction, arg_0, arg_1)));
        IrCall irCall2 = irCall = ExpressionHelpersKt.irCall$default((IrBuilder)$this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240, callee.getSymbol(), irFunction.getReturnType(), 0, null, 12, null);
        void var25_25 = $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240;
        boolean bl3 = false;
        if (superQualifierSymbol == null) {
            int n = ((Collection)IrUtilsKt.getParentAsClass(superFunction).getTypeParameters()).size();
            for (int index = 0; index < n; ++index) {
                $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241.getTypeArguments().set(index, JvmIrUtilsKt.createPlaceholderAnyNType($this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240.getContext().getIrBuiltIns()));
            }
            IrUtilsKt.passTypeArgumentsFrom((IrFunctionAccessExpression)$this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241, irFunction, IrUtilsKt.getParentAsClass(superFunction).getTypeParameters().size());
        } else {
            $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241.setSuperQualifierSymbol(superQualifierSymbol);
            IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241, irFunction, 0, 2, null);
        }
        for (Map.Entry<IrValueParameter, IrExpression> entry : parameter2arguments.entrySet()) {
            IrValueParameter parameter = entry.getKey();
            IrExpression argument = entry.getValue();
            $this$generateDefaultImplsRedirectionBody_u24lambda_u240_u240_u241.getArguments().set(parameter, argument);
        }
        var25_25.unaryPlus(irCall);
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilder, (IrExpression)this_$iv$iv.doBuild()));
        return irFunction;
    }

    private static final IrExpression generateDefaultImplsRedirectionBody$lambda$0$0$0(IrBlockBuilder $this_irBlock, IrSimpleFunction $irFunction, IrClassSymbol $superQualifierSymbol, IrSimpleFunction $superFunction, IrValueParameter sourceParameter, IrType irType) {
        Intrinsics.checkNotNullParameter((Object)sourceParameter, (String)"sourceParameter");
        Intrinsics.checkNotNullParameter((Object)irType, (String)"<unused var>");
        IrGetValueImpl it = ExpressionHelpersKt.irGet($this_irBlock, sourceParameter);
        boolean bl = false;
        return !Intrinsics.areEqual((Object)sourceParameter, (Object)$irFunction.getDispatchReceiverParameter()) || $superQualifierSymbol != null ? (IrExpression)it : InterfaceSuperCallsLoweringKt.reinterpretAsDispatchReceiverOfType(it, IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass($superFunction)));
    }
}

