/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceObjectCallsLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nInterfaceObjectCallsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceObjectCallsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/InterfaceObjectCallsLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class InterfaceObjectCallsLowering
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public InterfaceObjectCallsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.acceptChildren(this, null);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this, null);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        expression2.acceptChildren(this, null);
        if (expression2.getSuperQualifierSymbol() != null && !IrUtilsKt.isSuperToAny(expression2)) {
            return;
        }
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!IrUtilsKt.isMethodOfAny(callee)) {
            return;
        }
        if (!IrUtilsKt.hasInterfaceParent(callee)) {
            boolean bl;
            IrExpression irExpression = expression2.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression $this$visitCall_u24lambda_u240 = irExpression;
                boolean bl2 = false;
                bl = JvmIrUtilsKt.isJvmInterface(IrTypeErasureUtilsKt.getErasedUpperBound($this$visitCall_u24lambda_u240.getType()));
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default(callee, null, 1, null);
        if (irSimpleFunction == null) {
            return;
        }
        IrSimpleFunction resolved = irSimpleFunction;
        expression2.setSymbol(resolved.getSymbol());
        if (expression2.getSuperQualifierSymbol() != null) {
            expression2.setSuperQualifierSymbol(this.context.getIrBuiltIns().getAnyClass());
        }
    }
}

