/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationMemberGenerator;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformerKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0019\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010#\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0012H\u0016J8\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "jvmContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "publicAnnotationImplementationClasses", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "inInlineFunctionScope", "", "getInInlineFunctionScope", "()Z", "implementor", "Lorg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "transformArrayEqualsArgument", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "getArrayContentEqualsSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "implementPlatformSpecificParts", "", "annotationClass", "implementAnnotationPropertiesAndConstructor", "generatedConstructor", "generateFunctionBodies", "eqFun", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "hcFun", "toStringFun", "generator", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationMemberGenerator;", "AnnotationPropertyImplementor", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,325:1\n1807#2,3:326\n436#3:329\n1#4:330\n1#4:331\n418#5,10:332\n76#6,2:342\n*S KotlinDebug\n*F\n+ 1 JvmAnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer\n*L\n42#1:326,3\n80#1:329\n80#1:330\n101#1:332,10\n101#1:342,2\n*E\n"})
public final class JvmAnnotationImplementationTransformer
extends AnnotationImplementationTransformer {
    @NotNull
    private final JvmBackendContext jvmContext;
    @NotNull
    private final Set<IrClassSymbol> publicAnnotationImplementationClasses;
    @NotNull
    private final AnnotationPropertyImplementor implementor;

    public JvmAnnotationImplementationTransformer(@NotNull JvmBackendContext jvmContext, @NotNull IrFile file) {
        Intrinsics.checkNotNullParameter((Object)jvmContext, (String)"jvmContext");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(jvmContext, jvmContext.getSymbolTable(), file);
        this.jvmContext = jvmContext;
        this.publicAnnotationImplementationClasses = new LinkedHashSet();
        this.implementor = new AnnotationPropertyImplementor(this.jvmContext.getIrFactory(), this.jvmContext.getIrBuiltIns(), this.jvmContext.getSymbols().getJavaLangClass(), this.jvmContext.getSymbols().getKClassJavaPropertyGetter().getSymbol(), AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION());
    }

    private final boolean getInInlineFunctionScope() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getAllScopes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ScopeWithIr it = (ScopeWithIr)element$iv;
                    boolean bl2 = false;
                    IrElement irElement = it.getIrElement();
                    IrDeclaration irDeclaration = irElement instanceof IrDeclaration ? (IrDeclaration)irElement : null;
                    boolean bl3 = irDeclaration != null ? JvmIrInlineUtilsKt.isInPublicInlineScope(irDeclaration) : false;
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(implClass));
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClassSymbol constructedClass = IrTypesKt.getClassOrNull(expression2.getType());
        Object object = constructedClass;
        boolean bl = object != null && (object = (IrClass)object.getOwner()) != null ? IrUtilsKt.isAnnotationClass((IrClass)object) : false;
        if (bl && this.getInInlineFunctionScope()) {
            ((Collection)this.publicAnnotationImplementationClasses).add(constructedClass);
        }
        return super.visitConstructorCall(expression2);
    }

    @Override
    @NotNull
    public IrExpression transformArrayEqualsArgument(@NotNull IrExpression $this$transformArrayEqualsArgument, @NotNull IrType type, @NotNull IrBlockBodyBuilder irBuilder) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)$this$transformArrayEqualsArgument, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)irBuilder, (String)"irBuilder");
        if (!IrTypeUtilsKt.isUnsignedArray(type)) {
            irExpression = $this$transformArrayEqualsArgument;
        } else {
            IrCall irCall;
            IrCall $this$transformArrayEqualsArgument_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)irBuilder, this.jvmContext.getSymbols().getUnsafeCoerceIntrinsic());
            boolean bl = false;
            $this$transformArrayEqualsArgument_u24lambda_u240.getTypeArguments().set(0, type);
            $this$transformArrayEqualsArgument_u24lambda_u240.getTypeArguments().set(1, InlineClassAbiKt.unboxInlineClass(type));
            $this$transformArrayEqualsArgument_u24lambda_u240.getArguments().set(0, $this$transformArrayEqualsArgument);
            irExpression = irCall;
        }
        return irExpression;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public IrFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            targetType = IrTypeUtilsKt.isPrimitiveArray(type) != false ? type : (IrTypeUtilsKt.isUnsignedArray(type) != false ? InlineClassAbiKt.unboxInlineClass(type) : (IrType)this.jvmContext.getSymbols().getArrayOfAnyNType());
            $this$findDeclaration$iv = (IrDeclarationContainer)this.jvmContext.getSymbols().getArraysClass().getOwner();
            $i$f$findDeclaration = false;
            for (T var7_8 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                it$iv = (IrDeclaration)var7_8;
                $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                if (!(it$iv instanceof IrFunction)) ** GOTO lbl-1000
                it = (IrFunction)it$iv;
                $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$requiredSymbol$1 = false;
                if (Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals") != false && IrUtilsKt.hasShape$default(it, false, false, 0, 2, CollectionsKt.listOf((Object[])(var12_13 = new IrType[]{targetType, targetType})), 7, null) != false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                v1 = var7_8;
                break block5;
            }
            v1 = v2 = null;
        }
        if (!(v1 instanceof IrFunction)) {
            v2 = null;
        }
        if ((requiredSymbol = (IrFunction)((IrDeclaration)v2)) == null) {
            $i$a$-requireNotNull-JvmAnnotationImplementationTransformer$getArrayContentEqualsSymbol$1 = false;
            var4_5 = "Can't find Arrays.equals method for type " + RenderIrElementKt.render$default(targetType, null, 1, null);
            throw new IllegalArgumentException(var4_5.toString());
        }
        return requiredSymbol.getSymbol();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void implementPlatformSpecificParts(@NotNull IrClass annotationClass, @NotNull IrClass implClass) {
        void this_$iv$iv;
        void $this$implementPlatformSpecificParts_u24lambda_u240_u240;
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        if (this.publicAnnotationImplementationClasses.contains(annotationClass.getSymbol())) {
            JvmIrAttributesKt.setPublicAbi(implClass, true);
        }
        IrAnnotationContainer irAnnotationContainer = IrTypesKt.getStarProjectedType(this.jvmContext.getSymbols().getJavaLangClass());
        IrDeclarationOrigin irDeclarationOrigin = AnnotationImplementationTransformerKt.getANNOTATION_IMPLEMENTATION();
        IrAnnotationContainer $this$implementPlatformSpecificParts_u24lambda_u240 = irAnnotationContainer = DeclarationBuildersKt.addFunction$default(implClass, "annotationType", (IrType)irAnnotationContainer, null, null, false, false, false, false, irDeclarationOrigin, 0, 0, 1772, null);
        boolean bl = false;
        JvmIrBuilder jvmIrBuilder = JvmIrBuilderKt.createJvmIrBuilder$default(this.jvmContext, ((IrSimpleFunction)$this$implementPlatformSpecificParts_u24lambda_u240).getSymbol(), 0, 0, 6, null);
        IrAnnotationContainer irAnnotationContainer2 = $this$implementPlatformSpecificParts_u24lambda_u240;
        boolean bl2 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u240_u240;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$implementPlatformSpecificParts_u24lambda_u240_u240_u240 = this_$iv$iv;
        boolean bl3 = false;
        $this$implementPlatformSpecificParts_u24lambda_u240_u240_u240.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$implementPlatformSpecificParts_u24lambda_u240_u240_u240, JvmIrUtilsKt.javaClassReference((JvmIrBuilder)$this$implementPlatformSpecificParts_u24lambda_u240_u240, IrUtilsKt.getDefaultType(annotationClass))));
        ((IrFunction)irAnnotationContainer2).setBody(this_$iv$iv.doBuild());
    }

    @Override
    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
        this.implementor.implementAnnotationPropertiesAndConstructor(annotationClass, this.getAnnotationProperties(annotationClass), implClass, generatedConstructor, this);
    }

    @Override
    public void generateFunctionBodies(@NotNull IrClass annotationClass, @NotNull IrClass implClass, @NotNull IrSimpleFunction eqFun, @NotNull IrSimpleFunction hcFun, @NotNull IrSimpleFunction toStringFun, @NotNull AnnotationImplementationMemberGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
        Intrinsics.checkNotNullParameter((Object)eqFun, (String)"eqFun");
        Intrinsics.checkNotNullParameter((Object)hcFun, (String)"hcFun");
        Intrinsics.checkNotNullParameter((Object)toStringFun, (String)"toStringFun");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        List<IrProperty> properties2 = this.getAnnotationProperties(annotationClass);
        List<IrProperty> implProperties = this.getAnnotationProperties(implClass);
        generator.generateEqualsUsingGetters(eqFun, IrUtilsKt.getDefaultType(annotationClass), properties2);
        generator.generateHashCodeMethod(hcFun, implProperties);
        generator.generateToStringMethod(toStringFun, implProperties);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001dH\u0002J\u0014\u0010 \u001a\u00020\u0019*\u00020\u001a2\u0006\u0010!\u001a\u00020\u0019H\u0002J6\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020%2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor;", "", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "javaLangClassSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "kClassJavaPropertyGetterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "originForProp", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrFactory;Lorg/jetbrains/kotlin/ir/IrBuiltIns;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;)V", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getJavaLangClassSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getKClassJavaPropertyGetterSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getOriginForProp", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "kClassArrayToJClassArray", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "kClassArray", "kClassToJClassIfNeeded", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isKClassArray", "", "kClassToJClass", "irExpression", "implementAnnotationPropertiesAndConstructor", "", "annotationClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "annotationProperties", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "implClass", "generatedConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "defaultValueTransformer", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "backend.jvm.lower"})
    @SourceDebugExtension(value={"SMAP\nJvmAnnotationImplementationTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmAnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor\n+ 2 IrUtils.kt\norg/jetbrains/kotlin/ir/util/IrUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 5 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 9 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 10 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,325:1\n436#2:326\n1#3:327\n1#3:342\n379#4,13:328\n379#4,13:379\n418#4,10:435\n133#5:341\n133#5,2:392\n134#5:394\n351#6,12:343\n351#6,12:355\n351#6,12:367\n1220#7,2:395\n1249#7,4:397\n1915#7:401\n1916#7:447\n75#8,4:402\n128#8:415\n122#8,10:416\n134#8,9:426\n25#9,9:406\n76#10,2:445\n*S KotlinDebug\n*F\n+ 1 JvmAnnotationImplementationTransformer.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor\n*L\n161#1:326\n161#1:327\n163#1:328,13\n185#1:379,13\n316#1:435,10\n163#1:341\n185#1:392,2\n163#1:394\n180#1:343,12\n181#1:355,12\n182#1:367,12\n249#1:395,2\n249#1:397,4\n251#1:401\n251#1:447\n255#1:402,4\n291#1:415\n291#1:416,10\n304#1:426,9\n278#1:406,9\n316#1:445,2\n*E\n"})
    public static final class AnnotationPropertyImplementor {
        @NotNull
        private final IrFactory irFactory;
        @NotNull
        private final IrBuiltIns irBuiltIns;
        @NotNull
        private final IrClassSymbol javaLangClassSymbol;
        @NotNull
        private final IrSimpleFunctionSymbol kClassJavaPropertyGetterSymbol;
        @NotNull
        private final IrDeclarationOrigin originForProp;

        public AnnotationPropertyImplementor(@NotNull IrFactory irFactory, @NotNull IrBuiltIns irBuiltIns, @NotNull IrClassSymbol javaLangClassSymbol, @NotNull IrSimpleFunctionSymbol kClassJavaPropertyGetterSymbol, @NotNull IrDeclarationOrigin originForProp) {
            Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
            Intrinsics.checkNotNullParameter((Object)irBuiltIns, (String)"irBuiltIns");
            Intrinsics.checkNotNullParameter((Object)javaLangClassSymbol, (String)"javaLangClassSymbol");
            Intrinsics.checkNotNullParameter((Object)kClassJavaPropertyGetterSymbol, (String)"kClassJavaPropertyGetterSymbol");
            Intrinsics.checkNotNullParameter((Object)originForProp, (String)"originForProp");
            this.irFactory = irFactory;
            this.irBuiltIns = irBuiltIns;
            this.javaLangClassSymbol = javaLangClassSymbol;
            this.kClassJavaPropertyGetterSymbol = kClassJavaPropertyGetterSymbol;
            this.originForProp = originForProp;
        }

        @NotNull
        public final IrFactory getIrFactory() {
            return this.irFactory;
        }

        @NotNull
        public final IrBuiltIns getIrBuiltIns() {
            return this.irBuiltIns;
        }

        @NotNull
        public final IrClassSymbol getJavaLangClassSymbol() {
            return this.javaLangClassSymbol;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getKClassJavaPropertyGetterSymbol() {
            return this.kClassJavaPropertyGetterSymbol;
        }

        @NotNull
        public final IrDeclarationOrigin getOriginForProp() {
            return this.originForProp;
        }

        /*
         * Unable to fully structure code
         */
        private final IrExpression kClassArrayToJClassArray(IrBuilderWithScope $this$kClassArrayToJClassArray, IrExpression kClassArray) {
            block13: {
                javaLangClassType = IrTypesKt.getStarProjectedType(this.javaLangClassSymbol);
                var5_4 = new IrType[]{javaLangClassType};
                jlcArray = IrTypesKt.typeWith((IrClassifierSymbol)this.irBuiltIns.getArrayClass(), var5_4);
                arrayClass = (IrClass)this.irBuiltIns.getArrayClass().getOwner();
                arrayOfNulls = this.irBuiltIns.getArrayOfNulls();
                $this$findDeclaration$iv = arrayClass;
                $i$f$findDeclaration = false;
                for (T var11_12 : (Iterable)$this$findDeclaration$iv.getDeclarations()) {
                    it$iv = (IrDeclaration)var11_12;
                    $i$a$-find-IrUtilsKt$findDeclaration$1$iv = false;
                    if (!(it$iv instanceof IrProperty)) ** GOTO lbl-1000
                    it = (IrProperty)it$iv;
                    $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$arraySizeSymbol$1 = false;
                    if (Intrinsics.areEqual((Object)it.getName().asString(), (Object)"size")) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    if (!v0) continue;
                    v1 = var11_12;
                    break block13;
                }
                v1 = v2 = null;
            }
            if (!(v1 instanceof IrProperty)) {
                v2 = null;
            }
            v3 = v2;
            Intrinsics.checkNotNull((Object)v3);
            v4 = ((IrProperty)v3).getGetter();
            Intrinsics.checkNotNull((Object)v4);
            arraySizeSymbol = v4;
            $this$irBlock_u24default$iv = $this$kClassArrayToJClassArray;
            startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            origin$iv = null;
            resultType$iv = null;
            $i$f$irBlock = false;
            $i$a$-findDeclaration-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$arraySizeSymbol$1 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            $i$f$block = false;
            $this$kClassArrayToJClassArray_u24lambda_u241 = this_$iv$iv;
            $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1 = false;
            sourceArray = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, kClassArray, "src", false, null, null, 24, null);
            index = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, ExpressionHelpersKt.irInt$default((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, 0, null, 2, null), "i", true, null, null, 24, null);
            var22_28 = var21_27 = ExpressionHelpersKt.irCall((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, arraySizeSymbol);
            var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u241;
            $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$size$1 = false;
            $this$kClassArrayToJClassArray_u24lambda_u241_u240.setDispatchReceiver(ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, sourceArray));
            size = IrBuilderKt.createTmpVariable$default(var23_29, var21_27, "size", false, null, null, 24, null);
            $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$size$1 = $this$kClassArrayToJClassArray_u24lambda_u241_u240 = ExpressionHelpersKt.irCall$default((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, arrayOfNulls, jlcArray, 0, null, 12, null);
            var23_29 = (IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u241;
            $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$result$1 = false;
            $this$kClassArrayToJClassArray_u24lambda_u241_u241.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, size));
            result = IrBuilderKt.createTmpVariable$default(var23_29, $this$kClassArrayToJClassArray_u24lambda_u241_u240, null, false, null, null, 30, null);
            v5 = $this$kClassArrayToJClassArray_u24lambda_u241.getStartOffset();
            v6 = $this$kClassArrayToJClassArray_u24lambda_u241.getEndOffset();
            v7 = $this$kClassArrayToJClassArray_u24lambda_u241.getContext().getIrBuiltIns().getLessFunByOperandType().get(IrTypesKt.getClassifierOrFail($this$kClassArrayToJClassArray_u24lambda_u241.getContext().getIrBuiltIns().getIntType()));
            Intrinsics.checkNotNull((Object)v7);
            comparison = PrimitivesKt.primitiveOp2(v5, v6, v7, $this$kClassArrayToJClassArray_u24lambda_u241.getContext().getIrBuiltIns().getBooleanType(), IrStatementOrigin.Companion.getLT(), ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, index), ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, size));
            $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                $i$a$-single-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$setArraySymbol$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.SET)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            setArraySymbol = single$iv;
            $this$single$iv = IrUtilsKt.getFunctions(arrayClass);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (Object element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                $i$a$-single-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$getArraySymbol$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.GET)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            getArraySymbol = single$iv;
            v8 = IrTypesKt.getClass($this$kClassArrayToJClassArray_u24lambda_u241.getContext().getIrBuiltIns().getIntType());
            Intrinsics.checkNotNull((Object)v8);
            $this$single$iv = IrUtilsKt.getFunctions(v8);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (E element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                $i$a$-single-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$inc$1 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.INC)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            inc = single$iv;
            $i$f$single = var28_39 = IrBuilderKt.irWhile$default((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u241, null, 1, null);
            var23_29 = $this$kClassArrayToJClassArray_u24lambda_u241;
            $i$a$-also-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$1 = false;
            loop.setCondition(comparison);
            $this$irBlock_u24default$iv = (IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u241;
            startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            origin$iv = null;
            resultType$iv = null;
            $i$f$irBlock = false;
            var37_63 = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            $i$f$block = false;
            var39_65 = this_$iv$iv;
            var40_66 = loop;
            $i$a$-irBlock$default-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$1$1 = false;
            tempIndex = IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, index), null, false, null, null, 30, null);
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u240 = var43_69 = ExpressionHelpersKt.irCall((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, getArraySymbol);
            $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$1$1$getArray$1 = false;
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, sourceArray));
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u240.getArguments().set(1, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, tempIndex));
            getArray = var43_69;
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u240 = var43_69 = ExpressionHelpersKt.irCall((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, setArraySymbol);
            var47_73 = $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240;
            $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$kClassArrayToJClassArray$block$1$1$1$1 = false;
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u241.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, result));
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u241.getArguments().set(1, ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, tempIndex));
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240_u241.getArguments().set(2, this.kClassToJClass((IrBuilderWithScope)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, getArray));
            var47_73.unaryPlus(var43_69);
            $this$kClassArrayToJClassArray_u24lambda_u241_u245_u240.unaryPlus(ExpressionHelpersKt.irSet$default((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, index.getSymbol(), (IrExpression)ExpressionHelpersKt.irCallOp$default((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, inc.getSymbol(), index.getType(), ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241_u245_u240, index), null, null, 24, null), null, 4, null));
            var40_66.setBody((IrExpression)this_$iv$iv.doBuild());
            var23_29.unaryPlus(var28_39);
            $this$kClassArrayToJClassArray_u24lambda_u241.unaryPlus(ExpressionHelpersKt.irGet((IrBuilder)$this$kClassArrayToJClassArray_u24lambda_u241, result));
            block = this_$iv$iv.doBuild();
            return (IrExpression)block;
        }

        private final IrType kClassToJClassIfNeeded(IrType $this$kClassToJClassIfNeeded) {
            IrType irType;
            if (IrTypePredicatesKt.isKClass($this$kClassToJClassIfNeeded)) {
                irType = IrTypesKt.getStarProjectedType(this.javaLangClassSymbol);
            } else if (this.isKClassArray($this$kClassToJClassIfNeeded)) {
                IrType[] irTypeArray = new IrType[]{IrTypesKt.getStarProjectedType(this.javaLangClassSymbol)};
                irType = IrTypesKt.typeWith((IrClassifierSymbol)this.irBuiltIns.getArrayClass(), irTypeArray);
            } else {
                irType = $this$kClassToJClassIfNeeded;
            }
            return irType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isKClassArray(IrType $this$isKClassArray) {
            if (!($this$isKClassArray instanceof IrSimpleType)) return false;
            if (!IrTypePredicatesKt.isArray($this$isKClassArray)) return false;
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)$this$isKClassArray).getArguments()));
            if (irType == null) return false;
            if (!IrTypePredicatesKt.isKClass(irType)) return false;
            return true;
        }

        private final IrExpression kClassToJClass(IrBuilderWithScope $this$kClassToJClass, IrExpression irExpression) {
            IrCall irCall;
            IrCall $this$kClassToJClass_u24lambda_u240 = irCall = ExpressionHelpersKt.irGet($this$kClassToJClass, IrTypesKt.getStarProjectedType(this.javaLangClassSymbol), null, this.kClassJavaPropertyGetterSymbol);
            boolean bl = false;
            $this$kClassToJClass_u24lambda_u240.getArguments().set(0, irExpression);
            return irCall;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public final void implementAnnotationPropertiesAndConstructor(@NotNull IrClass annotationClass, @NotNull List<? extends IrProperty> annotationProperties, @NotNull IrClass implClass, @NotNull IrConstructor generatedConstructor, @Nullable IrElementTransformerVoid defaultValueTransformer) {
            Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
            Intrinsics.checkNotNullParameter(annotationProperties, (String)"annotationProperties");
            Intrinsics.checkNotNullParameter((Object)implClass, (String)"implClass");
            Intrinsics.checkNotNullParameter((Object)generatedConstructor, (String)"generatedConstructor");
            ctorBodyBuilder = LowerUtilsKt.createIrBuilder(this.irBuiltIns, (IrSymbol)generatedConstructor.getSymbol(), -2, -2);
            ctorBody = IrFactoryHelpersKt.createBlockBody(this.irFactory, -2, -2, CollectionsKt.listOf((Object)BuildersKt.IrDelegatingConstructorCallImpl$default(-2, -2, this.irBuiltIns.getUnitType(), (IrConstructorSymbol)SequencesKt.single(IrUtilsKt.getConstructors(this.irBuiltIns.getAnyClass())), 0, null, 32, null)));
            generatedConstructor.setBody(ctorBody);
            v0 = IrUtilsKt.getPrimaryConstructor(annotationClass);
            if (v0 != null && (v0 = v0.getParameters()) != null) {
                $this$associateBy$iv = (Iterable)v0;
                $i$f$associateBy = false;
                capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                var14_13 = $this$associateBy$iv;
                destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    var19_21 = (IrValueParameter)element$iv$iv;
                    var37_19 = destination$iv$iv;
                    $i$a$-associateBy-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$fallbackPrimaryCtorParamsMap$1 = false;
                    var37_19.put(it.getName(), element$iv$iv);
                }
                v1 = destination$iv$iv;
            } else {
                v1 = v2 = null;
            }
            if (v1 == null) {
                v2 = MapsKt.emptyMap();
            }
            fallbackPrimaryCtorParamsMap = v2;
            $this$forEach$iv = annotationProperties;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                property = (IrProperty)element$iv;
                $i$a$-forEach-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1 = false;
                v3 = property.getGetter();
                Intrinsics.checkNotNull((Object)v3);
                propType = v3.getReturnType();
                storedFieldType = this.kClassToJClassIfNeeded(propType);
                propName = property.getName();
                $this$buildField$iv = this.irFactory;
                $i$f$buildField = false;
                $this$buildField_u24lambda_u241$iv = new IrFieldBuilder();
                $i$a$-run-DeclarationBuildersKt$buildField$2$iv = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240 = $this$buildField_u24lambda_u241$iv;
                $i$a$-buildField-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$field$1 = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setStartOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setEndOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setName(propName);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setType(storedFieldType);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setOrigin(this.originForProp);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setFinal(true);
                v4 = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"PRIVATE");
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u240.setVisibility(v4);
                it = $this$buildField$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, $this$buildField_u24lambda_u241$iv);
                $i$a$-also-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$field$2 = false;
                it.setParent(implClass);
                field = $this$buildField$iv;
                v5 = generatedConstructor;
                v6 = propName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"asString(...)");
                parameter = DeclarationBuildersKt.addValueParameter$default(v5, v6, propType, null, 4, null);
                v7 = property.getBackingField();
                defaultExpression = v7 != null && (v7 = v7.getInitializer()) != null ? v7.getExpression() : null;
                if (defaultExpression instanceof IrGetValue && ((IrGetValue)defaultExpression).getSymbol().getOwner() instanceof IrValueParameter) {
                    v8 = ((IrGetValue)defaultExpression).getSymbol().getOwner();
                    Intrinsics.checkNotNull((Object)v8, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrValueParameter");
                    v9 /* !! */  = ((IrValueParameter)v8).getDefaultValue();
                } else if (defaultExpression != null) {
                    v10 = property.getBackingField();
                    Intrinsics.checkNotNull((Object)v10);
                    v9 /* !! */  = v10.getInitializer();
                } else if (fallbackPrimaryCtorParamsMap.containsKey(propName)) {
                    v11 = (IrValueParameter)fallbackPrimaryCtorParamsMap.get(propName);
                    if (v11 != null && (v11 = v11.getDefaultValue()) != null) {
                        it = $i$a$-buildField-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$field$1 = v11;
                        $i$a$-takeIf-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$newDefaultValue$1 = false;
                        v9 /* !! */  = it.getExpression() instanceof IrErrorExpression == false ? $i$a$-buildField-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$field$1 : null;
                    } else {
                        v9 /* !! */  = null;
                    }
                } else {
                    v9 /* !! */  = null;
                }
                newDefaultValue = v9 /* !! */ ;
                v12 = parameter;
                if (newDefaultValue == null) ** GOTO lbl-1000
                $this$deepCopyWithoutPatchingParents$iv = newDefaultValue;
                $i$f$deepCopyWithoutPatchingParents = false;
                $this$deepCopyImpl$iv$iv = $this$deepCopyWithoutPatchingParents$iv;
                $i$f$deepCopyImpl = false;
                symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                p0$iv = symbolRemapper$iv$iv;
                $i$a$-deepCopyImpl-DeepCopyIrTreeWithSymbolsKt$deepCopyWithoutPatchingParents$1$iv = false;
                typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0$iv);
                v13 = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (v13 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpressionBody");
                }
                $i$a$-run-DeclarationBuildersKt$buildField$2$iv = (IrExpressionBody)((IrElement)((IrExpressionBody)v13));
                if ($i$a$-run-DeclarationBuildersKt$buildField$2$iv != null) {
                    $i$f$deepCopyWithoutPatchingParents = $this$deepCopyWithoutPatchingParents$iv = $i$a$-run-DeclarationBuildersKt$buildField$2$iv;
                    var30_60 = v12;
                    $i$a$-also-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$1 = false;
                    if (defaultValueTransformer != null) {
                        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)it, defaultValueTransformer);
                    }
                    v12 = var30_60;
                    v14 = $this$deepCopyWithoutPatchingParents$iv;
                } else lbl-1000:
                // 2 sources

                {
                    v14 = null;
                }
                v12.setDefaultValue((IrExpressionBody)v14);
                $i$a$-run-DeclarationBuildersKt$buildField$2$iv = ctorBody.getStatements();
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244 = ctorBodyBuilder;
                $i$a$-with-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$2 = false;
                param = ExpressionHelpersKt.irGet((IrBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244, parameter);
                fieldValue = IrTypePredicatesKt.isKClass(propType) != false ? this.kClassToJClass((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244, param) : (this.isKClassArray(propType) != false ? this.kClassArrayToJClassArray((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244, param) : (IrExpression)param);
                v15 = (IrBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244;
                v16 = (IrBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244;
                v17 = implClass.getThisReceiver();
                Intrinsics.checkNotNull((Object)v17);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244 = ExpressionHelpersKt.irSetField$default(v15, ExpressionHelpersKt.irGet(v16, v17), (IrField)field, fieldValue, null, 8, null);
                $i$a$-run-DeclarationBuildersKt$buildField$2$iv.add($this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u244);
                $this$addProperty$iv = implClass;
                $i$f$addProperty = false;
                $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
                $i$f$buildProperty = false;
                $this$buildProperty_u24lambda_u241$iv$iv = new IrPropertyBuilder();
                $i$a$-run-DeclarationBuildersKt$buildProperty$2$iv$iv = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245 = $this$buildProperty_u24lambda_u241$iv$iv;
                $i$a$-addProperty-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$prop$1 = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245.setStartOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245.setEndOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245.setName(propName);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245.setVar(false);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245.setOrigin(this.originForProp);
                property$iv = $this$buildProperty$iv$iv = DeclarationBuildersKt.buildProperty((IrFactory)$this$buildProperty$iv$iv, $this$buildProperty_u24lambda_u241$iv$iv);
                $i$a$-also-DeclarationBuildersKt$addProperty$1$iv = false;
                $this$addProperty$iv.getDeclarations().add((IrDeclaration)property$iv);
                property$iv.setParent((IrDeclarationParent)$this$addProperty$iv);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u246 = $this$addProperty$iv = $this$buildProperty$iv$iv;
                $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$prop$2 = false;
                field.setCorrespondingPropertySymbol($this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u246.getSymbol());
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u246.setBackingField((IrField)field);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u246.setParent(implClass);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u246.setOverriddenSymbols(CollectionsKt.listOf((Object)property.getSymbol()));
                $this$addGetter$iv = prop = $this$addProperty$iv;
                $i$f$addGetter = false;
                $this$addGetter_u24lambda_u240$iv = new IrFunctionBuilder();
                $i$a$-run-DeclarationBuildersKt$addGetter$2$iv = false;
                v18 = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
                Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"special(...)");
                $this$addGetter_u24lambda_u240$iv.setName(v18);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247 = $this$addGetter_u24lambda_u240$iv;
                $i$a$-addGetter-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$3 = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setStartOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setEndOffset(-2);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setName(propName);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setReturnType(this.kClassToJClassIfNeeded(propType));
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setOrigin(this.originForProp);
                v19 = DescriptorVisibilities.PUBLIC;
                Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"PUBLIC");
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setVisibility(v19);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u247.setModality(Modality.FINAL);
                getter$iv = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245 = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), $this$addGetter_u24lambda_u240$iv);
                $i$a$-also-DeclarationBuildersKt$addGetter$2$1$iv = false;
                $this$addGetter$iv.setGetter((IrSimpleFunction)getter$iv);
                getter$iv.setCorrespondingPropertySymbol($this$addGetter$iv.getSymbol());
                getter$iv.setParent($this$addGetter$iv.getParent());
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248 = var22_33 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u245;
                $i$a$-apply-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$4 = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248.setCorrespondingPropertySymbol(prop.getSymbol());
                v20 = implClass.getThisReceiver();
                Intrinsics.checkNotNull((Object)v20);
                dispatchReceiverParameter = IrUtilsKt.copyTo$default(v20, (IrFunction)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248, null, 0, 0, null, null, null, null, null, false, false, false, IrParameterKind.DispatchReceiver, null, 12286, null);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248.setParameters(CollectionsKt.listOf((Object)dispatchReceiverParameter));
                $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder(this.irBuiltIns, (IrSymbol)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248.getSymbol(), -2, -2);
                startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                $i$f$irBlockBody = false;
                $i$a$-also-DeclarationBuildersKt$addGetter$2$1$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                $i$f$blockBody = false;
                var34_66 = this_$iv$iv;
                var35_67 = $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248;
                $i$a$-irBlockBody$default-JvmAnnotationImplementationTransformer$AnnotationPropertyImplementor$implementAnnotationPropertiesAndConstructor$1$4$1 = false;
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248_u240.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248_u240, ExpressionHelpersKt.irGetField$default((IrBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248_u240, ExpressionHelpersKt.irGet((IrBuilder)$this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248_u240, dispatchReceiverParameter), (IrField)field, null, 4, null)));
                var35_67.setBody(this_$iv$iv.doBuild());
                v21 = property.getGetter();
                Intrinsics.checkNotNull((Object)v21);
                $this$implementAnnotationPropertiesAndConstructor_u24lambda_u241_u248.setOverriddenSymbols(CollectionsKt.listOf((Object)v21.getSymbol()));
            }
        }
    }
}

