/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.IrBuildingTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmIrLowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBranchImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrRawFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0003rstB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\fH\u0002J\f\u0010\u0018\u001a\u00020\u0013*\u00020\u0019H\u0002J*\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#H\u0002J\u0014\u0010$\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010)\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u001dH\u0016J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020\bH\u0002J\b\u00100\u001a\u00020-H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u001e\u00105\u001a\u00020\b2\u0006\u00106\u001a\u0002042\f\u00107\u001a\b\u0012\u0004\u0012\u0002080#H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000208H\u0002J\u001c\u0010<\u001a\u00020\f*\u00020\u001e2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020:H\u0002J\u001c\u0010A\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\fH\u0002J%\u0010D\u001a\u00020\f*\u00020\u001e2\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0F\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010GJ\u001c\u0010H\u001a\u00020\f*\u00020\u001e2\u0006\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u000208H\u0002J\u0010\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020\u001dH\u0002JB\u0010K\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010L\u001a\u00020\u001b2\u0006\u0010M\u001a\u00020&2\u0006\u0010N\u001a\u00020&2\u0006\u0010O\u001a\u00020\u00132\f\u0010P\u001a\b\u0012\u0004\u0012\u00020R0Q2\u0006\u0010\u001f\u001a\u00020\u001dH\u0002J,\u0010S\u001a\b\u0012\u0004\u0012\u00020R0Q2\u0006\u0010T\u001a\u00020R2\u0006\u0010U\u001a\u00020R2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020R0#H\u0002J \u0010W\u001a\u00020\u001d2\u0006\u0010X\u001a\u00020Y2\u0006\u0010U\u001a\u00020R2\u0006\u0010Z\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\f2\u0006\u0010*\u001a\u00020]H\u0016J\u0016\u0010^\u001a\u0004\u0018\u00010_*\u00020`2\u0006\u0010a\u001a\u00020]H\u0002J\u0011\u0010b\u001a\u00070_\u00a2\u0006\u0002\bc*\u00020_H\u0002J\f\u0010d\u001a\u00020\u0013*\u00020eH\u0002J\u001c\u0010f\u001a\u00020\u0013*\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020iH\u0002J\u0018\u0010k\u001a\u000e\u0012\u0004\u0012\u00020i\u0012\u0004\u0012\u00020i0l*\u00020mH\u0002J\u0012\u0010n\u001a\u0004\u0018\u00010g2\u0006\u00103\u001a\u00020oH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/lower/IrBuildingTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformVoid", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lowerInstanceOf", "argument", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "lowerCast", "isCompatibleArrayType", "", "actualType", "expectedType", "getArrayElementLowerType", "isDefinitelyNotNull", "isDefinitelyNotNullVal", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "jvmIndyLambdaMetafactoryIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jvmInvokeDynamic", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;", "dynamicCall", "bootstrapMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "bootstrapMethodArguments", "", "jvmOriginalMethodType", "methodSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "jdkMetafactoryHandle", "jdkAltMetafactoryHandle", "visitCall", "expression", "classContextStack", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$ClassContext;", "enterClass", "leaveClass", "getClassContext", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateDeserializeLambdaMethod", "irClass", "serializableMethodRefInfos", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "mapDeserializedLambda", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$DeserializedLambdaInfo;", "info", "generateSerializedLambdaEquals", "lambdaParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "deserializedLambdaInfo", "equalsAny", "irObjectEquals", "receiver", "arg", "irAndAnd", "args", "", "(Lorg/jetbrains/kotlin/backend/jvm/ir/JvmIrBuilder;[Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateCreateDeserializedMethodRef", "rewriteIndyLambdaMetafactoryCall", "call", "createLambdaMetafactoryCall", "samMethodSymbol", "implFunSymbol", "instanceMethodSymbol", "shouldBeSerializable", "requiredBridges", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getOverriddenMethodsRequiringBridges", "instanceMethod", "samMethod", "extraOverriddenMethods", "wrapClosureInDynamicCall", "erasedSamType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "targetRef", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "computeNotNullAssertionText", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "typeOperatorCall", "trimForRuntimeAssertion", "Lorg/jetbrains/annotations/NotNull;", "isDelegated", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "validSourcePosition", "", "startOffset", "", "endOffset", "extents", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/IrElement;", "sourceViewFor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "throwTypeCastException", "checkExpressionValueIsNotNull", "SerializableMethodRefInfo", "ClassContext", "DeserializedLambdaInfo", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 7 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,814:1\n19#2,26:815\n19#2,17:841\n379#2,13:858\n36#2,9:873\n418#2,10:893\n404#2,13:944\n19#2,26:959\n19#2,17:985\n404#2,13:1002\n36#2,9:1017\n133#3,2:871\n133#3,2:957\n133#3,2:1015\n383#4,7:882\n269#5,4:889\n269#5,4:921\n363#5,4:936\n76#6:903\n77#6:912\n1586#7:904\n1661#7,2:905\n1586#7:907\n1661#7,3:908\n1663#7:911\n1586#7:913\n1661#7,3:914\n1586#7:917\n1661#7,3:918\n1642#7,10:925\n1915#7:935\n1916#7:941\n1652#7:942\n1#8:940\n1#8:943\n*S KotlinDebug\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n*L\n75#1:815,26\n100#1:841,17\n107#1:858,13\n100#1:873,9\n320#1:893,10\n678#1:944,13\n699#1:959,26\n727#1:985,17\n728#1:1002,13\n727#1:1017,9\n107#1:871,2\n678#1:957,2\n728#1:1015,2\n307#1:882,7\n311#1:889,4\n605#1:921,4\n646#1:936,4\n320#1:903\n320#1:912\n328#1:904\n328#1:905,2\n333#1:907\n333#1:908,3\n328#1:911\n482#1:913\n482#1:914,3\n543#1:917\n543#1:918,3\n617#1:925,10\n617#1:935\n617#1:941\n617#1:942\n617#1:940\n*E\n"})
public final class TypeOperatorLowering
extends IrBuildingTransformer
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext backendContext;
    @NotNull
    private final IrSimpleFunctionSymbol jvmIndyLambdaMetafactoryIntrinsic;
    @NotNull
    private final Handle jdkMetafactoryHandle;
    @NotNull
    private final Handle jdkAltMetafactoryHandle;
    @NotNull
    private final ArrayDeque<ClassContext> classContextStack;
    @NotNull
    private final IrSimpleFunctionSymbol equalsAny;
    @NotNull
    private final IrSimpleFunctionSymbol throwTypeCastException;
    @NotNull
    private final IrSimpleFunctionSymbol checkExpressionValueIsNotNull;

    public TypeOperatorLowering(@NotNull JvmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        super(backendContext);
        this.backendContext = backendContext;
        this.jvmIndyLambdaMetafactoryIntrinsic = this.backendContext.getSymbols().getIndyLambdaMetafactoryIntrinsic();
        this.jdkMetafactoryHandle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        this.jdkAltMetafactoryHandle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false);
        this.classContextStack = new ArrayDeque();
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(this.backendContext.getIrBuiltIns().getAnyClass(), "equals");
        Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
        this.equalsAny = irSimpleFunctionSymbol;
        this.throwTypeCastException = this.backendContext.getSymbols().getThrowTypeCastException();
        this.checkExpressionValueIsNotNull = this.backendContext.getConfig().getUnifiedNullChecks() ? this.backendContext.getSymbols().getCheckNotNullExpressionValue() : this.backendContext.getSymbols().getCheckExpressionValueIsNotNull();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid(irFile);
    }

    private final IrExpression transformVoid(IrExpression $this$transformVoid) {
        return $this$transformVoid.transform((IrTransformer)this, (Object)null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrExpression argument, IrType type) {
        IrExpression irExpression;
        IrBuilderWithScope $this$lowerInstanceOf_u24lambda_u240 = this.getBuilder();
        boolean bl = false;
        if (IrTypeUtilsKt.isReifiedTypeParameter(type)) {
            irExpression = ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u240, argument, type);
        } else if (IrTypeUtilsKt.isNullable(argument.getType()) && IrTypeUtilsKt.isNullable(type)) {
            void $this$irLetS_u24default$iv;
            void value$iv;
            IrBuilderWithScope irBuilderWithScope = $this$lowerInstanceOf_u24lambda_u240;
            IrExpression irExpression2 = argument;
            IrType irType$iv = $this$lowerInstanceOf_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, false, null, irType$iv, 0, 0, false, 236, null);
                valueSymbol$iv = irTemporary$iv.getSymbol();
            }
            IrValueSymbol valueSymbol = valueSymbol$iv;
            boolean bl2 = false;
            IrExpression irResult$iv = PrimitivesKt.oror$default($this$lowerInstanceOf_u24lambda_u240.getContext(), ExpressionHelpersKt.irEqualsNull($this$lowerInstanceOf_u24lambda_u240, ExpressionHelpersKt.irGet($this$lowerInstanceOf_u24lambda_u240, valueSymbol.getOwner())), ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u240, ExpressionHelpersKt.irGet($this$lowerInstanceOf_u24lambda_u240, valueSymbol.getOwner()), IrTypesKt.makeNotNull(type)), null, 4, null);
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl3 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = irBlock$iv;
            }
        } else {
            irExpression = IrTypeUtilsKt.isNullable(argument.getType()) && !IrTypeUtilsKt.isNullable(type) && Intrinsics.areEqual((Object)IrTypeErasureUtilsKt.getErasedUpperBound(argument.getType()), (Object)IrTypeErasureUtilsKt.getErasedUpperBound(type)) ? ExpressionHelpersKt.irNotEquals($this$lowerInstanceOf_u24lambda_u240, argument, ExpressionHelpersKt.irNull($this$lowerInstanceOf_u24lambda_u240)) : (IrExpression)ExpressionHelpersKt.irIs($this$lowerInstanceOf_u24lambda_u240, argument, IrTypesKt.makeNotNull(type));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrExpression argument, IrType type) {
        IrExpression irExpression;
        if (IrTypeUtilsKt.isReifiedTypeParameter(type)) {
            irExpression = ExpressionHelpersKt.irAs(this.getBuilder(), argument, type);
        } else if (JvmIrTypeUtilsKt.isInlineClassType(argument.getType()) && IrTypeUtilsKt.isSubtypeOfClass(argument.getType(), IrTypeErasureUtilsKt.getErasedUpperBound(type).getSymbol())) {
            irExpression = argument;
        } else if (this.isCompatibleArrayType(argument.getType(), type)) {
            irExpression = argument;
        } else if (IrTypeUtilsKt.isNullable(type) || this.isDefinitelyNotNull(argument)) {
            irExpression = ExpressionHelpersKt.irAs(this.getBuilder(), argument, type);
        } else {
            IrExpression irExpression2;
            void $this$irLetS_u24default$iv;
            void value$iv;
            IrBuilderWithScope $this$lowerCast_u24lambda_u240 = this.getBuilder();
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$lowerCast_u24lambda_u240;
            IrExpression irExpression3 = argument;
            IrType irType$iv = $this$lowerCast_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, false, null, irType$iv, 0, 0, false, 236, null);
                valueSymbol$iv = irTemporary$iv.getSymbol();
            }
            IrValueSymbol tmp = valueSymbol$iv;
            boolean bl2 = false;
            IrConstImpl message2 = ExpressionHelpersKt.irString($this$lowerCast_u24lambda_u240, "null cannot be cast to non-null type " + RenderIrElementKt.render$default(type, null, 1, null));
            if (this.backendContext.getConfig().getUnifiedNullChecks()) {
                void $this$lowerCast_u24lambda_u240_u240_u240_u240;
                IrCall irCall;
                void this_$iv$iv;
                void $this$irBlock_u24default$iv;
                IrBuilderWithScope irBuilderWithScope2 = $this$lowerCast_u24lambda_u240;
                IrType resultType$iv = type;
                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv2 = null;
                boolean $i$f$irBlock = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv2, resultType$iv, false, 64, null);
                boolean $i$f$block = false;
                void $this$lowerCast_u24lambda_u240_u240_u240 = this_$iv$iv;
                boolean bl3 = false;
                IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240, this.backendContext.getSymbols().getCheckNotNullWithMessage());
                void var28_31 = $this$lowerCast_u24lambda_u240_u240_u240;
                boolean bl4 = false;
                $this$lowerCast_u24lambda_u240_u240_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240, tmp.getOwner()));
                $this$lowerCast_u24lambda_u240_u240_u240_u240.getArguments().set(1, message2);
                var28_31.unaryPlus(irCall);
                $this$lowerCast_u24lambda_u240_u240_u240.unaryPlus(ExpressionHelpersKt.irAs((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240, ExpressionHelpersKt.irGet((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240, tmp.getOwner()), IrTypesKt.makeNullable(type)));
                irExpression2 = (IrExpression)this_$iv$iv.doBuild();
            } else {
                void $this$lowerCast_u24lambda_u240_u240_u241;
                IrCall irCall;
                IrCall startOffset$iv = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$lowerCast_u24lambda_u240, this.throwTypeCastException);
                IrExpression irExpression4 = ExpressionHelpersKt.irGet($this$lowerCast_u24lambda_u240, tmp.getOwner());
                IrType irType = type;
                IrBuilder irBuilder = $this$lowerCast_u24lambda_u240;
                boolean bl5 = false;
                $this$lowerCast_u24lambda_u240_u240_u241.getArguments().set(0, message2);
                Unit unit = Unit.INSTANCE;
                irExpression2 = ExpressionHelpersKt.irIfNull(irBuilder, irType, irExpression4, irCall, ExpressionHelpersKt.irAs($this$lowerCast_u24lambda_u240, ExpressionHelpersKt.irGet($this$lowerCast_u24lambda_u240, tmp.getOwner()), IrTypesKt.makeNullable(type)));
            }
            IrExpression irResult$iv = irExpression2;
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl6 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = irBlock$iv;
            }
        }
        return irExpression;
    }

    private final boolean isCompatibleArrayType(IrType actualType, IrType expectedType) {
        IrType actual = actualType;
        IrType expected = expectedType;
        while ((IrTypePredicatesKt.isArray(actual) || IrTypePredicatesKt.isNullableArray(actual)) && (IrTypePredicatesKt.isArray(expected) || IrTypePredicatesKt.isNullableArray(expected))) {
            actual = this.getArrayElementLowerType(actual);
            expected = this.getArrayElementLowerType(expected);
        }
        if (Intrinsics.areEqual((Object)actual, (Object)actualType) || Intrinsics.areEqual((Object)expected, (Object)expectedType)) {
            return false;
        }
        return IrTypeUtilsKt.isSubtypeOfClass(actual, IrTypeErasureUtilsKt.getErasedUpperBound(expected).getSymbol());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrType getArrayElementLowerType(IrType $this$getArrayElementLowerType) {
        IrType irType;
        if (IrTypeUtilsKt.isBoxedArray($this$getArrayElementLowerType) && $this$getArrayElementLowerType instanceof IrSimpleType) {
            Object object = CollectionsKt.singleOrNull(((IrSimpleType)$this$getArrayElementLowerType).getArguments());
            IrTypeProjection irTypeProjection = object instanceof IrTypeProjection ? (IrTypeProjection)object : null;
            if ((irTypeProjection != null ? irTypeProjection.getVariance() : null) == Variance.IN_VARIANCE) {
                irType = this.backendContext.getIrBuiltIns().getAnyNType();
                return irType;
            }
        }
        irType = IrTypeUtilsKt.getArrayElementType($this$getArrayElementLowerType, this.backendContext.getIrBuiltIns());
        return irType;
    }

    private final boolean isDefinitelyNotNull(IrExpression $this$isDefinitelyNotNull) {
        IrExpression irExpression = $this$isDefinitelyNotNull;
        return irExpression instanceof IrGetValue ? this.isDefinitelyNotNullVal(((IrGetValue)$this$isDefinitelyNotNull).getSymbol().getOwner()) : (irExpression instanceof IrGetClass || irExpression instanceof IrConstructorCall ? true : (irExpression instanceof IrCall ? Intrinsics.areEqual((Object)((IrCall)$this$isDefinitelyNotNull).getSymbol(), (Object)this.backendContext.getIrBuiltIns().getCheckNotNullSymbol()) : false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefinitelyNotNullVal(IrValueDeclaration $this$isDefinitelyNotNullVal) {
        if (!($this$isDefinitelyNotNullVal instanceof IrVariable)) return false;
        IrVariable irVariable = (IrVariable)$this$isDefinitelyNotNullVal;
        if (irVariable == null) {
            return false;
        }
        IrVariable irVariable2 = irVariable;
        if (irVariable2.isVar()) return false;
        IrExpression irExpression = irVariable2.getInitializer();
        if (irExpression == null) return false;
        if (!this.isDefinitelyNotNull(irExpression)) return false;
        return true;
    }

    private final IrCall jvmInvokeDynamic(JvmIrBuilder $this$jvmInvokeDynamic, IrCall dynamicCall, Handle bootstrapMethodHandle, List<? extends IrExpression> bootstrapMethodArguments) {
        IrCall irCall;
        IrCall $this$jvmInvokeDynamic_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall$default($this$jvmInvokeDynamic, $this$jvmInvokeDynamic.getBackendContext().getSymbols().getJvmIndyIntrinsic(), dynamicCall.getType(), 0, null, 12, null);
        boolean bl = false;
        $this$jvmInvokeDynamic_u24lambda_u240.getTypeArguments().set(0, dynamicCall.getType());
        $this$jvmInvokeDynamic_u24lambda_u240.getArguments().set(0, dynamicCall);
        $this$jvmInvokeDynamic_u24lambda_u240.getArguments().set(1, JvmIrLowerUtilsKt.jvmMethodHandle($this$jvmInvokeDynamic, bootstrapMethodHandle));
        $this$jvmInvokeDynamic_u24lambda_u240.getArguments().set(2, ExpressionHelpersKt.irVararg($this$jvmInvokeDynamic, $this$jvmInvokeDynamic.getContext().getIrBuiltIns().getAnyType(), bootstrapMethodArguments));
        return irCall;
    }

    private final IrCall jvmOriginalMethodType(JvmIrBuilder $this$jvmOriginalMethodType, IrFunctionSymbol methodSymbol) {
        IrCall irCall;
        IrCall $this$jvmOriginalMethodType_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall$default($this$jvmOriginalMethodType, $this$jvmOriginalMethodType.getBackendContext().getSymbols().getJvmOriginalMethodTypeIntrinsic(), $this$jvmOriginalMethodType.getContext().getIrBuiltIns().getAnyType(), 0, null, 12, null);
        boolean bl = false;
        $this$jvmOriginalMethodType_u24lambda_u240.getArguments().set(0, ExpressionHelpersKt.irRawFunctionReference($this$jvmOriginalMethodType, $this$jvmOriginalMethodType.getContext().getIrBuiltIns().getAnyType(), methodSymbol));
        return irCall;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.jvmIndyLambdaMetafactoryIntrinsic)) {
            this.transformChildrenVoid(expression2);
            irExpression = this.rewriteIndyLambdaMetafactoryCall(expression2);
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final ClassContext enterClass() {
        ClassContext classContext;
        ClassContext it = classContext = new ClassContext();
        boolean bl = false;
        UtilsKt.push((List)this.classContextStack, it);
        return classContext;
    }

    private final void leaveClass() {
        UtilsKt.pop((List)this.classContextStack);
    }

    private final ClassContext getClassContext() {
        if (this.classContextStack.isEmpty()) {
            throw new AssertionError((Object)"No class context");
        }
        return (ClassContext)this.classContextStack.last();
    }

    @Override
    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        ClassContext context2 = this.enterClass();
        IrStatement result2 = super.visitClass(declaration);
        if (!((Collection)context2.getSerializableMethodRefInfos()).isEmpty()) {
            this.generateDeserializeLambdaMethod(declaration, (List<SerializableMethodRefInfo>)context2.getSerializableMethodRefInfos());
        }
        this.leaveClass();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void generateDeserializeLambdaMethod(IrClass irClass, List<SerializableMethodRefInfo> serializableMethodRefInfos) {
        void ctorCall;
        Collection<IrBranchImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$generateDeserializeLambdaMethod_u24lambda_u242_u240_u240;
        void this_$iv$iv;
        void $this$generateDeserializeLambdaMethod_u24lambda_u242;
        Object answer$iv;
        HashMap groupedByImplMethodName = new HashMap();
        for (SerializableMethodRefInfo serializableMethodRefInfo : serializableMethodRefInfos) {
            Object object;
            void $this$getOrPut$iv;
            DeserializedLambdaInfo deserializedLambdaInfo = this.mapDeserializedLambda(serializableMethodRefInfo);
            String implMethodName = deserializedLambdaInfo.getImplMethodHandle().getName();
            Map map = groupedByImplMethodName;
            String key$iv = implMethodName;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            HashMap byDeserializedLambdaInfo = (HashMap)object;
            ((Map)byDeserializedLambdaInfo).put(deserializedLambdaInfo, serializableMethodRefInfo);
        }
        IrFactory $this$buildFun$iv = this.backendContext.getIrFactory();
        boolean $i$f$buildFun = false;
        Object $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$generateDeserializeLambdaMethod_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        Name name2 = Name.identifier("$deserializeLambda$");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$generateDeserializeLambdaMethod_u24lambda_u241.setName(name2);
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
        $this$generateDeserializeLambdaMethod_u24lambda_u241.setVisibility(descriptorVisibility);
        $this$generateDeserializeLambdaMethod_u24lambda_u241.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getDESERIALIZE_LAMBDA_FUN());
        IrSimpleFunction deserializeLambdaFun = DeclarationBuildersKt.buildFunction($this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
        deserializeLambdaFun.setParent(irClass);
        IrValueParameter lambdaParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)deserializeLambdaFun, "lambda", (IrType)this.backendContext.getSymbols().getSerializedLambda().getIrType(), null, 4, null);
        deserializeLambdaFun.setReturnType(this.backendContext.getIrBuiltIns().getAnyType());
        $this$buildFun_u24lambda_u240$iv = JvmIrBuilderKt.createJvmIrBuilder(this.backendContext, deserializeLambdaFun.getSymbol(), -1, -1);
        IrSimpleFunction irSimpleFunction = deserializeLambdaFun;
        boolean bl3 = false;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u242;
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        answer$iv = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void $this$generateDeserializeLambdaMethod_u24lambda_u242_u240 = this_$iv$iv;
        boolean bl4 = false;
        Object object = ExpressionHelpersKt.irCall((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, $this$generateDeserializeLambdaMethod_u24lambda_u242.getBackendContext().getSymbols().getSerializedLambda().getGetImplMethodName());
        IrFunctionAccessExpression irFunctionAccessExpression = object;
        IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
        boolean $i$a$-apply-TypeOperatorLowering$generateDeserializeLambdaMethod$1$1$tmp$22 = false;
        $this$generateDeserializeLambdaMethod_u24lambda_u242_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, lambdaParameter));
        IrVariable tmp = ExpressionHelpersKt.irTemporary$default(irStatementsBuilder, (IrExpression)object, null, null, false, null, 30, null);
        IrBuilder irBuilder = (IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
        IrType irType = $this$generateDeserializeLambdaMethod_u24lambda_u242.getBackendContext().getIrBuiltIns().getUnitType();
        Set set = groupedByImplMethodName.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        object = set;
        IrType irType2 = irType;
        IrBuilder irBuilder2 = irBuilder;
        irStatementsBuilder = $this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
        boolean $i$f$map22 = false;
        void $i$a$-apply-TypeOperatorLowering$generateDeserializeLambdaMethod$1$1$tmp$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<IrBranchImpl> collection2;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)entry);
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String implMethodName = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            HashMap infos = (HashMap)v;
            IrBuilder irBuilder3 = (IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
            IrExpression irExpression = ExpressionHelpersKt.irEquals$default((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, ExpressionHelpersKt.irGet((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, tmp), ExpressionHelpersKt.irString((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, implMethodName), null, 4, null);
            IrBuilder irBuilder4 = (IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
            IrType irType3 = $this$generateDeserializeLambdaMethod_u24lambda_u242.getBackendContext().getIrBuiltIns().getUnitType();
            Set set2 = infos.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-entries>(...)");
            Iterable iterable = set2;
            IrType irType4 = irType3;
            IrBuilder irBuilder5 = irBuilder4;
            IrExpression irExpression2 = irExpression;
            IrBuilder irBuilder6 = irBuilder3;
            boolean $i$f$map = false;
            void var39_49 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                Map.Entry entry2 = (Map.Entry)item$iv$iv2;
                collection2 = destination$iv$iv2;
                boolean bl6 = false;
                Intrinsics.checkNotNull((Object)entry2);
                Object k2 = entry2.getKey();
                Intrinsics.checkNotNullExpressionValue(k2, (String)"component1(...)");
                DeserializedLambdaInfo deserializedLambdaInfo = (DeserializedLambdaInfo)k2;
                Object v2 = entry2.getValue();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"component2(...)");
                SerializableMethodRefInfo serializedMethodRefInfo = (SerializableMethodRefInfo)v2;
                collection2.add(ExpressionHelpersKt.irBranch((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, this.generateSerializedLambdaEquals((JvmIrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242, lambdaParameter, deserializedLambdaInfo), ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, this.generateCreateDeserializedMethodRef((JvmIrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242, lambdaParameter, serializedMethodRefInfo))));
            }
            collection2 = (List)destination$iv$iv2;
            collection.add(ExpressionHelpersKt.irBranch(irBuilder6, irExpression2, ExpressionHelpersKt.irWhen(irBuilder5, irType4, (List<? extends IrBranch>)collection2)));
        }
        collection = (List)destination$iv$iv;
        irStatementsBuilder.unaryPlus(ExpressionHelpersKt.irWhen(irBuilder2, irType2, (List<? extends IrBranch>)collection));
        Object $i$f$map22 = object = ExpressionHelpersKt.irCall((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, $this$generateDeserializeLambdaMethod_u24lambda_u242.getBackendContext().getSymbols().getIllegalArgumentExceptionCtorString());
        irBuilder2 = (IrBuilderWithScope)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
        irStatementsBuilder = $this$generateDeserializeLambdaMethod_u24lambda_u242_u240;
        boolean bl7 = false;
        ctorCall.getArguments().set(0, ExpressionHelpersKt.irString((IrBuilder)$this$generateDeserializeLambdaMethod_u24lambda_u242_u240, "Invalid lambda deserialization"));
        irType2 = Unit.INSTANCE;
        irStatementsBuilder.unaryPlus(LowerUtilsKt.irThrow((IrBuilderWithScope)irBuilder2, (IrExpression)object));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        irClass.getDeclarations().add(deserializeLambdaFun);
    }

    private final DeserializedLambdaInfo mapDeserializedLambda(SerializableMethodRefInfo info) {
        String string = IrTypeMapper.mapType$default(this.backendContext.getDefaultTypeMapper(), info.getSamType(), null, null, false, 14, null).getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        return new DeserializedLambdaInfo(string, this.backendContext.getDefaultMethodSignatureMapper().mapToMethodHandle(info.getImplFunSymbol().getOwner()), this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod((IrFunction)info.getSamMethodSymbol().getOwner()));
    }

    private final IrExpression generateSerializedLambdaEquals(JvmIrBuilder $this$generateSerializedLambdaEquals, IrValueParameter lambdaParameter, DeserializedLambdaInfo deserializedLambdaInfo) {
        String functionalInterfaceClass = deserializedLambdaInfo.getFunctionalInterfaceClass();
        Handle implMethodHandle = deserializedLambdaInfo.getImplMethodHandle();
        Method samMethod = deserializedLambdaInfo.getFunctionalInterfaceMethod();
        IrExpression[] irExpressionArray = new IrExpression[6];
        irExpressionArray[0] = ExpressionHelpersKt.irEquals$default($this$generateSerializedLambdaEquals, TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetImplMethodKind()), ExpressionHelpersKt.irInt$default($this$generateSerializedLambdaEquals, implMethodHandle.getTag(), null, 2, null), null, 4, null);
        irExpressionArray[1] = this.irObjectEquals($this$generateSerializedLambdaEquals, TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetFunctionalInterfaceClass()), ExpressionHelpersKt.irString($this$generateSerializedLambdaEquals, functionalInterfaceClass));
        IrExpression irExpression = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetFunctionalInterfaceMethodName());
        IrBuilder irBuilder = $this$generateSerializedLambdaEquals;
        String string = samMethod.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        irExpressionArray[2] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression, ExpressionHelpersKt.irString(irBuilder, string));
        IrExpression irExpression2 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetFunctionalInterfaceMethodSignature());
        IrBuilder irBuilder2 = $this$generateSerializedLambdaEquals;
        String string2 = samMethod.getDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDescriptor(...)");
        irExpressionArray[3] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression2, ExpressionHelpersKt.irString(irBuilder2, string2));
        IrExpression irExpression3 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetImplClass());
        IrBuilder irBuilder3 = $this$generateSerializedLambdaEquals;
        String string3 = implMethodHandle.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getOwner(...)");
        irExpressionArray[4] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression3, ExpressionHelpersKt.irString(irBuilder3, string3));
        IrExpression irExpression4 = TypeOperatorLowering.generateSerializedLambdaEquals$irGetLambdaProperty($this$generateSerializedLambdaEquals, lambdaParameter, $this$generateSerializedLambdaEquals.getBackendContext().getSymbols().getSerializedLambda().getGetImplMethodSignature());
        IrBuilder irBuilder4 = $this$generateSerializedLambdaEquals;
        String string4 = implMethodHandle.getDesc();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getDesc(...)");
        irExpressionArray[5] = this.irObjectEquals($this$generateSerializedLambdaEquals, irExpression4, ExpressionHelpersKt.irString(irBuilder4, string4));
        return this.irAndAnd($this$generateSerializedLambdaEquals, irExpressionArray);
    }

    private final IrCall irObjectEquals(JvmIrBuilder $this$irObjectEquals, IrExpression receiver, IrExpression arg) {
        IrCall irCall;
        IrCall $this$irObjectEquals_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$irObjectEquals, this.equalsAny);
        boolean bl = false;
        $this$irObjectEquals_u24lambda_u240.getArguments().set(0, receiver);
        $this$irObjectEquals_u24lambda_u240.getArguments().set(1, arg);
        return irCall;
    }

    private final IrExpression irAndAnd(JvmIrBuilder $this$irAndAnd, IrExpression ... args) {
        if (args.length == 0) {
            throw new AssertionError((Object)"At least one argument expected");
        }
        IrExpression result2 = null;
        result2 = args[0];
        int n = args.length;
        for (int i = 1; i < n; ++i) {
            IrCall irCall;
            IrCall $this$irAndAnd_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$irAndAnd, $this$irAndAnd.getBackendContext().getIrBuiltIns().getAndandSymbol());
            boolean bl = false;
            $this$irAndAnd_u24lambda_u240.getArguments().set(0, result2);
            $this$irAndAnd_u24lambda_u240.getArguments().set(1, args[i]);
            result2 = irCall;
        }
        return result2;
    }

    private final IrExpression generateCreateDeserializedMethodRef(JvmIrBuilder $this$generateCreateDeserializedMethodRef, IrValueParameter lambdaParameter, SerializableMethodRefInfo info) {
        IrCall dynamicCall = ExpressionHelpersKt.irCall((IrBuilder)$this$generateCreateDeserializedMethodRef, info.getDynamicCallSymbol());
        Iterator iterator2 = ((Iterable)((IrSimpleFunction)info.getDynamicCallSymbol().getOwner()).getParameters()).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            IrExpression irExpression;
            IrFunctionAccessExpression irFunctionAccessExpression;
            int index = n++;
            IrValueParameter dynamicValueParameter = (IrValueParameter)iterator2.next();
            IrFunctionAccessExpression call = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this$generateCreateDeserializedMethodRef, $this$generateCreateDeserializedMethodRef.getBackendContext().getSymbols().getSerializedLambda().getGetCapturedArg());
            boolean bl = false;
            call.getArguments().set(0, ExpressionHelpersKt.irGet($this$generateCreateDeserializedMethodRef, lambdaParameter));
            call.getArguments().set(1, ExpressionHelpersKt.irInt$default($this$generateCreateDeserializedMethodRef, index, null, 2, null));
            IrFunctionAccessExpression capturedArg = irFunctionAccessExpression;
            IrType expectedType = dynamicValueParameter.getType();
            if (JvmIrTypeUtilsKt.isInlineClassType(expectedType)) {
                IrCall irCall;
                IrType unboxedType = InlineClassAbiKt.unboxInlineClass(expectedType);
                IrCall coercion = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$generateCreateDeserializedMethodRef, $this$generateCreateDeserializedMethodRef.getBackendContext().getSymbols().getUnsafeCoerceIntrinsic());
                boolean bl2 = false;
                coercion.getTypeArguments().set(0, unboxedType);
                coercion.getTypeArguments().set(1, expectedType);
                coercion.getArguments().set(0, capturedArg);
                irExpression = irCall;
            } else {
                irExpression = ExpressionHelpersKt.irAs($this$generateCreateDeserializedMethodRef, capturedArg, expectedType);
            }
            IrExpression downcastArg = irExpression;
            dynamicCall.getArguments().set(index, downcastArg);
        }
        return this.createLambdaMetafactoryCall($this$generateCreateDeserializedMethodRef, info.getSamMethodSymbol(), info.getImplFunSymbol(), info.getInstanceFunSymbol(), true, info.getRequiredBridges(), dynamicCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall rewriteIndyLambdaMetafactoryCall(IrCall call) {
        void $this$mapTo$iv$iv;
        int startOffset = call.getStartOffset();
        int endOffset = call.getEndOffset();
        IrType irType = call.getTypeArguments().get(0);
        IrSimpleType irSimpleType = irType instanceof IrSimpleType ? (IrSimpleType)irType : null;
        if (irSimpleType == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'samType' is expected to be a simple type");
            throw new KotlinNothingValueException();
        }
        IrSimpleType samType = irSimpleType;
        Object e = call.getArguments().get(0);
        IrRawFunctionReference irRawFunctionReference = e instanceof IrRawFunctionReference ? (IrRawFunctionReference)e : null;
        if (irRawFunctionReference == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'samMethodType' should be 'IrRawFunctionReference'");
            throw new KotlinNothingValueException();
        }
        IrRawFunctionReference samMethodRef = irRawFunctionReference;
        Object e2 = call.getArguments().get(1);
        IrFunctionReference irFunctionReference = e2 instanceof IrFunctionReference ? (IrFunctionReference)e2 : null;
        if (irFunctionReference == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'implMethodReference' is expected to be 'IrFunctionReference'");
            throw new KotlinNothingValueException();
        }
        IrFunctionReference implFunRef = irFunctionReference;
        IrFunctionSymbol implFunSymbol = (IrFunctionSymbol)implFunRef.getSymbol();
        Object e3 = call.getArguments().get(2);
        IrRawFunctionReference irRawFunctionReference2 = e3 instanceof IrRawFunctionReference ? (IrRawFunctionReference)e3 : null;
        if (irRawFunctionReference2 == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'instantiatedMethodType' is expected to be 'IrRawFunctionReference'");
            throw new KotlinNothingValueException();
        }
        IrRawFunctionReference instanceMethodRef = irRawFunctionReference2;
        TypeOperatorLowering $this$rewriteIndyLambdaMetafactoryCall_u24lambda_u240 = this;
        boolean bl = false;
        Object e4 = call.getArguments().get(3);
        IrVararg irVararg = e4 instanceof IrVararg ? (IrVararg)e4 : null;
        if (irVararg == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'extraOverriddenMethodTypes' is expected to be 'IrVararg'");
            throw new KotlinNothingValueException();
        }
        IrElementBase extraOverriddenMethodVararg = irVararg;
        Iterable $this$map$iv = extraOverriddenMethodVararg.getElements();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IrRawFunctionReference irRawFunctionReference3 = it instanceof IrRawFunctionReference ? (IrRawFunctionReference)it : null;
            if (irRawFunctionReference3 == null) {
                TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "'extraOverriddenMethodTypes' elements are expected to be 'IrRawFunctionReference'");
                throw new KotlinNothingValueException();
            }
            IrRawFunctionReference ref = irRawFunctionReference3;
            IrFunction irFunction = ref.getSymbol().getOwner();
            IrSimpleFunction irSimpleFunction = irFunction instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction : null;
            if (irSimpleFunction == null) {
                TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "Extra overridden method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(ref.getSymbol().getOwner(), null, 1, null));
                throw new KotlinNothingValueException();
            }
            collection.add(irSimpleFunction);
        }
        List extraOverriddenMethods = (List)destination$iv$iv;
        boolean shouldBeSerializable = JvmIrUtilsKt.getBooleanConstArgument(call, 4);
        IrFunction $i$f$map22 = samMethodRef.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = $i$f$map22 instanceof IrSimpleFunction ? (IrSimpleFunction)$i$f$map22 : null;
        if (irSimpleFunction == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "SAM method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(samMethodRef.getSymbol().getOwner(), null, 1, null));
            throw new KotlinNothingValueException();
        }
        IrSimpleFunction samMethod = irSimpleFunction;
        extraOverriddenMethodVararg = instanceMethodRef.getSymbol().getOwner();
        IrSimpleFunction irSimpleFunction2 = extraOverriddenMethodVararg instanceof IrSimpleFunction ? (IrSimpleFunction)extraOverriddenMethodVararg : null;
        if (irSimpleFunction2 == null) {
            TypeOperatorLowering.rewriteIndyLambdaMetafactoryCall$fail(call, "Instance method is expected to be 'IrSimpleFunction': " + RenderIrElementKt.render$default(instanceMethodRef.getSymbol().getOwner(), null, 1, null));
            throw new KotlinNothingValueException();
        }
        IrSimpleFunction instanceMethod = irSimpleFunction2;
        IrCall dynamicCall = this.wrapClosureInDynamicCall(samType, samMethod, implFunRef);
        Collection<IrSimpleFunction> requiredBridges = this.getOverriddenMethodsRequiringBridges(instanceMethod, samMethod, extraOverriddenMethods);
        if (shouldBeSerializable) {
            this.getClassContext().getSerializableMethodRefInfos().add(new SerializableMethodRefInfo(samType, samMethod.getSymbol(), implFunSymbol, instanceMethodRef.getSymbol(), requiredBridges, dynamicCall.getSymbol()));
        }
        return this.createLambdaMetafactoryCall(JvmIrBuilderKt.createJvmIrBuilder(this.backendContext, implFunSymbol, startOffset, endOffset), samMethod.getSymbol(), implFunSymbol, instanceMethodRef.getSymbol(), shouldBeSerializable, requiredBridges, dynamicCall);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall createLambdaMetafactoryCall(JvmIrBuilder $this$createLambdaMetafactoryCall, IrSimpleFunctionSymbol samMethodSymbol, IrFunctionSymbol implFunSymbol, IrFunctionSymbol instanceMethodSymbol, boolean shouldBeSerializable, Collection<? extends IrSimpleFunction> requiredBridges, IrCall dynamicCall) {
        IrCall samMethodType = this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, samMethodSymbol);
        IrRawFunctionReferenceImpl implFunRawRef = ExpressionHelpersKt.irRawFunctionReference($this$createLambdaMetafactoryCall, $this$createLambdaMetafactoryCall.getContext().getIrBuiltIns().getAnyType(), implFunSymbol);
        IrCall instanceMethodType = this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, instanceMethodSymbol);
        Handle bootstrapMethod = this.jdkMetafactoryHandle;
        Object[] objectArray = new IrExpression[]{samMethodType, implFunRawRef, instanceMethodType};
        ArrayList bootstrapMethodArguments = CollectionsKt.arrayListOf((Object[])objectArray);
        List bridgeMethodTypes = CollectionsKt.emptyList();
        int flags = 0;
        if (shouldBeSerializable) {
            ++flags;
        }
        if (!requiredBridges.isEmpty()) {
            void $this$mapTo$iv$iv;
            flags += 4;
            Iterable $this$map$iv = requiredBridges;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.jvmOriginalMethodType($this$createLambdaMetafactoryCall, it.getSymbol()));
            }
            bridgeMethodTypes = (List)destination$iv$iv;
        }
        if (flags != 0) {
            bootstrapMethod = this.jdkAltMetafactoryHandle;
            bootstrapMethodArguments.add(ExpressionHelpersKt.irInt$default($this$createLambdaMetafactoryCall, flags, null, 2, null));
            if (!((Collection)bridgeMethodTypes).isEmpty()) {
                bootstrapMethodArguments.add(ExpressionHelpersKt.irInt$default($this$createLambdaMetafactoryCall, bridgeMethodTypes.size(), null, 2, null));
                bootstrapMethodArguments.addAll(bridgeMethodTypes);
            }
        }
        return this.jvmInvokeDynamic($this$createLambdaMetafactoryCall, dynamicCall, bootstrapMethod, bootstrapMethodArguments);
    }

    private final Collection<IrSimpleFunction> getOverriddenMethodsRequiringBridges(IrSimpleFunction instanceMethod, IrSimpleFunction samMethod, List<? extends IrSimpleFunction> extraOverriddenMethods) {
        Method jvmInstanceMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(instanceMethod);
        Method jvmSamMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(samMethod);
        LinkedHashMap signatureToNonFakeOverride = new LinkedHashMap();
        for (IrSimpleFunction irSimpleFunction : extraOverriddenMethods) {
            Method jvmOverriddenMethod = this.backendContext.getDefaultMethodSignatureMapper().mapAsmMethod(irSimpleFunction);
            if (Intrinsics.areEqual((Object)jvmOverriddenMethod, (Object)jvmInstanceMethod) || Intrinsics.areEqual((Object)jvmOverriddenMethod, (Object)jvmSamMethod)) continue;
            ((Map)signatureToNonFakeOverride).put(jvmOverriddenMethod, irSimpleFunction);
        }
        Collection<IrSimpleFunction> collection = signatureToNonFakeOverride.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall wrapClosureInDynamicCall(IrSimpleType erasedSamType, IrSimpleFunction samMethod, IrFunctionReference targetRef) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List dynamicCallArguments = new ArrayList();
        IrFactory $this$buildFun$iv = this.backendContext.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$wrapClosureInDynamicCall_u24lambda_u240 = $this$buildFun_u24lambda_u240$iv;
        boolean bl2 = false;
        $this$wrapClosureInDynamicCall_u24lambda_u240.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getINVOKEDYNAMIC_CALL_TARGET());
        $this$wrapClosureInDynamicCall_u24lambda_u240.setName(samMethod.getName());
        $this$wrapClosureInDynamicCall_u24lambda_u240.setReturnType(erasedSamType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u240$iv);
        IrSimpleFunction $this$wrapClosureInDynamicCall_u24lambda_u241 = irElementBase;
        boolean bl3 = false;
        $this$wrapClosureInDynamicCall_u24lambda_u241.setParent(this.backendContext.getSymbols().getKotlinJvmInternalInvokeDynamicPackage());
        IrFunction targetFun = ((IrFunctionSymbol)targetRef.getSymbol()).getOwner();
        int syntheticParameterIndex = 0;
        int argumentStart = 0;
        Iterable iterable = CollectionsKt.zip((Iterable)targetFun.getParameters(), (Iterable)targetRef.getArguments());
        IrSimpleFunction irSimpleFunction = $this$wrapClosureInDynamicCall_u24lambda_u241;
        boolean $i$f$mapNotNull = false;
        void var15_18 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrValueParameter irValueParameter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl5 = false;
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrExpression argument = (IrExpression)pair.component2();
            if (argument == null) {
                irValueParameter = null;
            } else {
                Pair pair2;
                switch (WhenMappings.$EnumSwitchMapping$0[parameter.getKind().ordinal()]) {
                    case 1: {
                        IrFunction irFunction = targetFun;
                        if (irFunction instanceof IrSimpleFunction) {
                            pair2 = TuplesKt.to((Object)IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(targetFun)), (Object)argument);
                            break;
                        }
                        if (irFunction instanceof IrConstructor) {
                            ++argumentStart;
                            pair2 = TuplesKt.to((Object)targetFun.getParameters().get(0).getType(), (Object)argument);
                            break;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case 2: 
                    case 3: {
                        ++argumentStart;
                        pair2 = TuplesKt.to((Object)parameter.getType(), (Object)argument);
                        break;
                    }
                    case 4: {
                        IrExpression capturedValueArgument;
                        if ((IrExpression)targetRef.getArguments().get(argumentStart) == null) {
                            TypeOperatorLowering.wrapClosureInDynamicCall$fail(targetRef, "Captured value argument #" + argumentStart + " (" + RenderIrElementKt.render$default(parameter, null, 1, null) + ") not provided");
                            throw new KotlinNothingValueException();
                        }
                        ++argumentStart;
                        pair2 = TuplesKt.to((Object)parameter.getType(), (Object)capturedValueArgument);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Pair pair3 = pair2;
                IrType newParameterType = (IrType)pair3.component1();
                IrExpression newArgument = (IrExpression)pair3.component2();
                dynamicCallArguments.add(newArgument);
                IrDeclaration declaration$iv = $this$wrapClosureInDynamicCall_u24lambda_u241;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u241$iv = new IrValueParameterBuilder();
                boolean bl6 = false;
                IrValueParameterBuilder $this$wrapClosureInDynamicCall_u24lambda_u241_u240_u240 = $this$buildValueParameter_u24lambda_u241$iv;
                boolean bl7 = false;
                int n = syntheticParameterIndex;
                syntheticParameterIndex = n + 1;
                Name name2 = Name.identifier("" + 'p' + n);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                $this$wrapClosureInDynamicCall_u24lambda_u241_u240_u240.setName(name2);
                $this$wrapClosureInDynamicCall_u24lambda_u241_u240_u240.setType(newParameterType);
                $this$wrapClosureInDynamicCall_u24lambda_u241_u240_u240.setKind(IrParameterKind.Regular);
                irValueParameter = DeclarationBuildersKt.buildValueParameter(declaration$iv.getFactory(), $this$buildValueParameter_u24lambda_u241$iv, (IrDeclarationParent)((Object)declaration$iv));
            }
            if (irValueParameter == null) continue;
            IrValueParameter it$iv$iv = irValueParameter;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        irSimpleFunction.setParameters((List)destination$iv$iv);
        IrSimpleFunction irDynamicCallTarget = irElementBase;
        if (dynamicCallArguments.size() != irDynamicCallTarget.getParameters().size()) {
            throw new AssertionError((Object)("Dynamic call target parameters (" + irDynamicCallTarget.getParameters().size() + ") don't match dynamic call arguments (" + dynamicCallArguments.size() + "):\nirDynamicCallTarget:\n" + DumpIrTreeKt.dump$default(irDynamicCallTarget, null, 1, null) + "dynamicCallArguments:\n" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.withIndex((Iterable)dynamicCallArguments), (CharSequence)"\n ", (CharSequence)"[\n ", (CharSequence)"\n]", (int)0, null, TypeOperatorLowering::wrapClosureInDynamicCall$lambda$2, (int)24, null)));
        }
        IrElementBase $this$wrapClosureInDynamicCall_u24lambda_u243 = irElementBase = ExpressionHelpersKt.irCall((IrBuilder)JvmIrBuilderKt.createJvmIrBuilder$default(this.backendContext, irDynamicCallTarget.getSymbol(), 0, 0, 6, null), irDynamicCallTarget.getSymbol());
        boolean bl9 = false;
        AddToStdlibKt.assignFrom(((IrMemberAccessExpression)$this$wrapClosureInDynamicCall_u24lambda_u243).getArguments(), dynamicCallArguments);
        return irElementBase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrBuilderWithScope $this$visitTypeOperator_u24lambda_u240 = this.getBuilder();
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)$this$visitTypeOperator_u24lambda_u240, expression2);
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                IrBuilderWithScope irBuilderWithScope = $this$visitTypeOperator_u24lambda_u240;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u240_u240 = this_$iv$iv;
                boolean bl2 = false;
                $this$visitTypeOperator_u24lambda_u240_u240.unaryPlus(this.transformVoid(expression2.getArgument()));
                if (!IrTypeUtilsKt.isSubtypeOf(expression2.getArgument().getType(), IrTypesKt.makeNullable(expression2.getType()), this.backendContext.getTypeSystem())) {
                    $this$visitTypeOperator_u24lambda_u240_u240.unaryPlus(BuildersKt.IrCompositeImpl$default(-1, -1, expression2.getType(), null, 8, null));
                }
                irExpression = (IrExpression)this_$iv$iv.doBuild();
                break;
            }
            case 2: {
                irExpression = ExpressionHelpersKt.irImplicitCast($this$visitTypeOperator_u24lambda_u240, this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 3: {
                irExpression = this.lowerCast(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 4: {
                void origin$iv;
                void $this$irLetS_u24default$iv;
                void value$iv2;
                if (IrTypeUtilsKt.isReifiedTypeParameter(expression2.getTypeOperand())) {
                    this.transformChildrenVoid(expression2);
                    irExpression = expression2;
                    break;
                }
                IrBuilderWithScope $this$irComposite_u24default$iv = $this$visitTypeOperator_u24lambda_u240;
                IrExpression startOffset$iv = this.transformVoid(expression2.getArgument());
                IrStatementOrigin endOffset$iv = IrStatementOrigin.Companion.getSAFE_CALL();
                IrType resultType$iv = $this$visitTypeOperator_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv2 instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv2).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv2).getSymbol();
                } else {
                    void irType$iv;
                    irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv2, nameHint$iv, false, null, (IrType)irType$iv, 0, 0, false, 236, null);
                    valueSymbol$iv = irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl3 = false;
                IrExpression thenPart = JvmIrTypeUtilsKt.isInlineClassType(valueSymbol.getOwner().getType()) ? this.lowerCast(ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u240, valueSymbol.getOwner()), expression2.getTypeOperand()) : (IrExpression)ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u240, valueSymbol.getOwner());
                IrExpression irResult$iv = ExpressionHelpersKt.irIfThenElse$default($this$visitTypeOperator_u24lambda_u240, expression2.getType(), this.lowerInstanceOf(ExpressionHelpersKt.irGet($this$visitTypeOperator_u24lambda_u240, valueSymbol.getOwner()), IrTypesKt.makeNotNull(expression2.getTypeOperand())), thenPart, ExpressionHelpersKt.irNull($this$visitTypeOperator_u24lambda_u240, expression2.getType()), null, 16, null);
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv;
                    break;
                }
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv.getType(), (IrStatementOrigin)origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl4 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv)).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = irBlock$iv;
                break;
            }
            case 5: {
                irExpression = this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 6: {
                irExpression = LowerUtilsKt.irNot($this$visitTypeOperator_u24lambda_u240, this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand()));
                break;
            }
            case 7: {
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                void $this$irLetS_u24default$iv;
                void value$iv;
                String text = this.computeNotNullAssertionText($this$visitTypeOperator_u24lambda_u240, expression2);
                IrBuilderWithScope value$iv2 = $this$visitTypeOperator_u24lambda_u240;
                IrExpression origin$iv = this.transformVoid(expression2.getArgument());
                IrType irType$iv = $this$visitTypeOperator_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
                IrStatementOrigin origin$iv2 = null;
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable(((IrGetValue)value$iv).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
                } else {
                    irTemporary$iv = Scope.createTemporaryVariable$default($this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, false, null, irType$iv, 0, 0, false, 236, null);
                    valueSymbol$iv = irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl5 = false;
                IrBuilderWithScope irResult$iv = $this$visitTypeOperator_u24lambda_u240;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv3 = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv3, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u240_u242_u240 = this_$iv$iv;
                boolean bl6 = false;
                if (text != null) {
                    void $this$visitTypeOperator_u24lambda_u240_u242_u240_u240;
                    IrCall irCall;
                    IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, this.checkExpressionValueIsNotNull);
                    void var27_51 = $this$visitTypeOperator_u24lambda_u240_u242_u240;
                    boolean bl7 = false;
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u240.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, valueSymbol.getOwner()));
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u240.getArguments().set(1, ExpressionHelpersKt.irString((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, this.trimForRuntimeAssertion(text)));
                    var27_51.unaryPlus(irCall);
                } else {
                    void $this$visitTypeOperator_u24lambda_u240_u242_u240_u241;
                    IrCall irCall;
                    IrCall $this$visitTypeOperator_u24lambda_u240_u242_u240_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, this.backendContext.getSymbols().getCheckNotNull());
                    void var27_52 = $this$visitTypeOperator_u24lambda_u240_u242_u240;
                    boolean bl8 = false;
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u241.getArguments().set(0, ExpressionHelpersKt.irGet((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, valueSymbol.getOwner()));
                    var27_52.unaryPlus(irCall);
                }
                $this$visitTypeOperator_u24lambda_u240_u242_u240.unaryPlus(ExpressionHelpersKt.irGet((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240, valueSymbol.getOwner()));
                IrExpression irResult$iv2 = (IrExpression)this_$iv$iv.doBuild();
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv2;
                    break;
                }
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl($this$irLetS_u24default$iv.getStartOffset(), $this$irLetS_u24default$iv.getEndOffset(), irResult$iv2.getType(), origin$iv2);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl9 = irResult$iv2 instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll((Collection<IrStatement>)((IrStatementContainer)((Object)irResult$iv2)).getStatements()) : irBlock$iv.getStatements().add(irResult$iv2);
                irExpression = irBlock$iv;
                break;
            }
            default: {
                this.transformChildrenVoid(expression2);
                irExpression = expression2;
            }
        }
        return irExpression;
    }

    private final String computeNotNullAssertionText(IrBuilderWithScope $this$computeNotNullAssertionText, IrTypeOperatorCall typeOperatorCall) {
        Object object;
        CharSequence charSequence;
        IrDeclaration declarationParent;
        if (this.backendContext.getConfig().getNoSourceCodeInNotNullAssertionExceptions()) {
            String string;
            IrExpression argument = typeOperatorCall.getArgument();
            if (argument instanceof IrCall) {
                string = ((IrSimpleFunction)((IrCall)argument).getSymbol().getOwner()).getName().asString() + "(...)";
            } else if (argument instanceof IrGetField) {
                String string2;
                IrField field = (IrField)((IrGetField)argument).getSymbol().getOwner();
                String it = string2 = field.getName().asString();
                boolean bl = false;
                string = !field.getOrigin().isSynthetic() ? string2 : null;
            } else {
                string = null;
            }
            return string;
        }
        IrSymbolOwner owner = $this$computeNotNullAssertionText.getScope().getScopeOwnerSymbol().getOwner();
        if (owner instanceof IrFunction && this.isDelegated((IrFunction)owner)) {
            return ((IrFunction)owner).getName().asString() + "(...)";
        }
        IrDeclarationParent irDeclarationParent = ExpressionHelpersKt.getParent($this$computeNotNullAssertionText);
        IrDeclaration irDeclaration = declarationParent = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)((Object)irDeclarationParent) : null;
        if (irDeclaration != null) {
            IrDeclaration p0 = irDeclaration;
            boolean bl = false;
            charSequence = this.sourceViewFor(p0);
        } else {
            charSequence = null;
        }
        CharSequence sourceView = charSequence;
        Pair<Integer, Integer> pair = this.extents(typeOperatorCall);
        int startOffset = ((Number)pair.component1()).intValue();
        int endOffset = ((Number)pair.component2()).intValue();
        CharSequence charSequence2 = sourceView;
        boolean bl = charSequence2 != null ? this.validSourcePosition(charSequence2, startOffset, endOffset) : false;
        if (bl) {
            object = ((Object)sourceView.subSequence(startOffset, endOffset)).toString();
        } else {
            object = declarationParent instanceof IrDeclarationWithName ? (IrDeclarationWithName)declarationParent : null;
            if (object == null || (object = object.getName()) == null || (object = ((Name)object).asString()) == null) {
                object = "Unknown Declaration";
            }
        }
        return object;
    }

    private final String trimForRuntimeAssertion(String $this$trimForRuntimeAssertion) {
        String string = StringUtil.trimMiddle($this$trimForRuntimeAssertion, 50);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimMiddle(...)");
        return string;
    }

    private final boolean isDelegated(IrFunction $this$isDelegated) {
        return Intrinsics.areEqual((Object)$this$isDelegated.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_PROPERTY_ACCESSOR()) || Intrinsics.areEqual((Object)$this$isDelegated.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER());
    }

    private final boolean validSourcePosition(CharSequence $this$validSourcePosition, int startOffset, int endOffset) {
        return (0 <= startOffset ? startOffset < endOffset : false) && endOffset < $this$validSourcePosition.length();
    }

    private final Pair<Integer, Integer> extents(IrElement $this$extents) {
        Ref.IntRef startOffset = new Ref.IntRef();
        startOffset.element = Integer.MAX_VALUE;
        Ref.IntRef endOffset = new Ref.IntRef();
        IrVisitorsKt.acceptVoid($this$extents, new IrVisitorVoid(startOffset, endOffset){
            final /* synthetic */ Ref.IntRef $startOffset;
            final /* synthetic */ Ref.IntRef $endOffset;
            {
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
                int n = element.getStartOffset();
                boolean bl = 0 <= n ? n < this.$startOffset.element : false;
                if (bl) {
                    this.$startOffset.element = element.getStartOffset();
                }
                if (this.$endOffset.element < element.getEndOffset()) {
                    this.$endOffset.element = element.getEndOffset();
                }
            }
        });
        return TuplesKt.to((Object)startOffset.element, (Object)endOffset.element);
    }

    private final CharSequence sourceViewFor(IrDeclaration declaration) {
        Cloneable cloneable = JvmIrUtilsKt.getKtFile(JvmIrUtilsKt.getFileParent(declaration));
        return cloneable != null && (cloneable = ((PsiFileImpl)cloneable).getViewProvider()) != null ? cloneable.getContents() : null;
    }

    private static final IrFunctionAccessExpression generateSerializedLambdaEquals$irGetLambdaProperty(JvmIrBuilder $this_generateSerializedLambdaEquals, IrValueParameter $lambdaParameter, IrSimpleFunction getter2) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$generateSerializedLambdaEquals_u24irGetLambdaProperty_u24lambda_u240 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilder)$this_generateSerializedLambdaEquals, getter2);
        boolean bl = false;
        $this$generateSerializedLambdaEquals_u24irGetLambdaProperty_u24lambda_u240.getArguments().set(0, ExpressionHelpersKt.irGet($this_generateSerializedLambdaEquals, $lambdaParameter));
        return irFunctionAccessExpression;
    }

    private static final Void rewriteIndyLambdaMetafactoryCall$fail(IrCall $call, String message2) {
        throw new AssertionError((Object)(message2 + ", call:\n" + DumpIrTreeKt.dump$default($call, null, 1, null)));
    }

    private static final Void wrapClosureInDynamicCall$fail(IrFunctionReference $targetRef, String message2) {
        throw new AssertionError((Object)(message2 + ", targetRef:\n" + DumpIrTreeKt.dump$default($targetRef, null, 1, null)));
    }

    private static final CharSequence wrapClosureInDynamicCall$lambda$2(IndexedValue indexedValue) {
        Intrinsics.checkNotNullParameter((Object)indexedValue, (String)"<destruct>");
        int index = indexedValue.component1();
        IrExpression irArg = (IrExpression)indexedValue.component2();
        return "" + '#' + index + ": " + DumpIrTreeKt.dump$default(irArg, null, 1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$ClassContext;", "", "<init>", "()V", "serializableMethodRefInfos", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "Lkotlin/collections/ArrayList;", "getSerializableMethodRefInfos", "()Ljava/util/ArrayList;", "backend.jvm.lower"})
    private static final class ClassContext {
        @NotNull
        private final ArrayList<SerializableMethodRefInfo> serializableMethodRefInfos = new ArrayList();

        @NotNull
        public final ArrayList<SerializableMethodRefInfo> getSerializableMethodRefInfos() {
            return this.serializableMethodRefInfos;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$DeserializedLambdaInfo;", "", "functionalInterfaceClass", "", "implMethodHandle", "Lorg/jetbrains/org/objectweb/asm/Handle;", "functionalInterfaceMethod", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/Handle;Lorg/jetbrains/org/objectweb/asm/commons/Method;)V", "getFunctionalInterfaceClass", "()Ljava/lang/String;", "getImplMethodHandle", "()Lorg/jetbrains/org/objectweb/asm/Handle;", "getFunctionalInterfaceMethod", "()Lorg/jetbrains/org/objectweb/asm/commons/Method;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm.lower"})
    private static final class DeserializedLambdaInfo {
        @NotNull
        private final String functionalInterfaceClass;
        @NotNull
        private final Handle implMethodHandle;
        @NotNull
        private final Method functionalInterfaceMethod;

        public DeserializedLambdaInfo(@NotNull String functionalInterfaceClass, @NotNull Handle implMethodHandle, @NotNull Method functionalInterfaceMethod) {
            Intrinsics.checkNotNullParameter((Object)functionalInterfaceClass, (String)"functionalInterfaceClass");
            Intrinsics.checkNotNullParameter((Object)implMethodHandle, (String)"implMethodHandle");
            Intrinsics.checkNotNullParameter((Object)functionalInterfaceMethod, (String)"functionalInterfaceMethod");
            this.functionalInterfaceClass = functionalInterfaceClass;
            this.implMethodHandle = implMethodHandle;
            this.functionalInterfaceMethod = functionalInterfaceMethod;
        }

        @NotNull
        public final String getFunctionalInterfaceClass() {
            return this.functionalInterfaceClass;
        }

        @NotNull
        public final Handle getImplMethodHandle() {
            return this.implMethodHandle;
        }

        @NotNull
        public final Method getFunctionalInterfaceMethod() {
            return this.functionalInterfaceMethod;
        }

        @NotNull
        public final String component1() {
            return this.functionalInterfaceClass;
        }

        @NotNull
        public final Handle component2() {
            return this.implMethodHandle;
        }

        @NotNull
        public final Method component3() {
            return this.functionalInterfaceMethod;
        }

        @NotNull
        public final DeserializedLambdaInfo copy(@NotNull String functionalInterfaceClass, @NotNull Handle implMethodHandle, @NotNull Method functionalInterfaceMethod) {
            Intrinsics.checkNotNullParameter((Object)functionalInterfaceClass, (String)"functionalInterfaceClass");
            Intrinsics.checkNotNullParameter((Object)implMethodHandle, (String)"implMethodHandle");
            Intrinsics.checkNotNullParameter((Object)functionalInterfaceMethod, (String)"functionalInterfaceMethod");
            return new DeserializedLambdaInfo(functionalInterfaceClass, implMethodHandle, functionalInterfaceMethod);
        }

        public static /* synthetic */ DeserializedLambdaInfo copy$default(DeserializedLambdaInfo deserializedLambdaInfo, String string, Handle handle, Method method, int n, Object object) {
            if ((n & 1) != 0) {
                string = deserializedLambdaInfo.functionalInterfaceClass;
            }
            if ((n & 2) != 0) {
                handle = deserializedLambdaInfo.implMethodHandle;
            }
            if ((n & 4) != 0) {
                method = deserializedLambdaInfo.functionalInterfaceMethod;
            }
            return deserializedLambdaInfo.copy(string, handle, method);
        }

        @NotNull
        public String toString() {
            return "DeserializedLambdaInfo(functionalInterfaceClass=" + this.functionalInterfaceClass + ", implMethodHandle=" + this.implMethodHandle + ", functionalInterfaceMethod=" + this.functionalInterfaceMethod + ')';
        }

        public int hashCode() {
            int result2 = this.functionalInterfaceClass.hashCode();
            result2 = result2 * 31 + this.implMethodHandle.hashCode();
            result2 = result2 * 31 + this.functionalInterfaceMethod.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeserializedLambdaInfo)) {
                return false;
            }
            DeserializedLambdaInfo deserializedLambdaInfo = (DeserializedLambdaInfo)other;
            if (!Intrinsics.areEqual((Object)this.functionalInterfaceClass, (Object)deserializedLambdaInfo.functionalInterfaceClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.implMethodHandle, (Object)deserializedLambdaInfo.implMethodHandle)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.functionalInterfaceMethod, (Object)deserializedLambdaInfo.functionalInterfaceMethod);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering$SerializableMethodRefInfo;", "", "samType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "samMethodSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "implFunSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "instanceFunSymbol", "requiredBridges", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "dynamicCallSymbol", "<init>", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Ljava/util/Collection;Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;)V", "getSamType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getSamMethodSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getImplFunSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getInstanceFunSymbol", "getRequiredBridges", "()Ljava/util/Collection;", "getDynamicCallSymbol", "backend.jvm.lower"})
    private static final class SerializableMethodRefInfo {
        @NotNull
        private final IrType samType;
        @NotNull
        private final IrSimpleFunctionSymbol samMethodSymbol;
        @NotNull
        private final IrFunctionSymbol implFunSymbol;
        @NotNull
        private final IrFunctionSymbol instanceFunSymbol;
        @NotNull
        private final Collection<IrSimpleFunction> requiredBridges;
        @NotNull
        private final IrSimpleFunctionSymbol dynamicCallSymbol;

        public SerializableMethodRefInfo(@NotNull IrType samType, @NotNull IrSimpleFunctionSymbol samMethodSymbol, @NotNull IrFunctionSymbol implFunSymbol, @NotNull IrFunctionSymbol instanceFunSymbol, @NotNull Collection<? extends IrSimpleFunction> requiredBridges, @NotNull IrSimpleFunctionSymbol dynamicCallSymbol) {
            Intrinsics.checkNotNullParameter((Object)samType, (String)"samType");
            Intrinsics.checkNotNullParameter((Object)samMethodSymbol, (String)"samMethodSymbol");
            Intrinsics.checkNotNullParameter((Object)implFunSymbol, (String)"implFunSymbol");
            Intrinsics.checkNotNullParameter((Object)instanceFunSymbol, (String)"instanceFunSymbol");
            Intrinsics.checkNotNullParameter(requiredBridges, (String)"requiredBridges");
            Intrinsics.checkNotNullParameter((Object)dynamicCallSymbol, (String)"dynamicCallSymbol");
            this.samType = samType;
            this.samMethodSymbol = samMethodSymbol;
            this.implFunSymbol = implFunSymbol;
            this.instanceFunSymbol = instanceFunSymbol;
            this.requiredBridges = requiredBridges;
            this.dynamicCallSymbol = dynamicCallSymbol;
        }

        @NotNull
        public final IrType getSamType() {
            return this.samType;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getSamMethodSymbol() {
            return this.samMethodSymbol;
        }

        @NotNull
        public final IrFunctionSymbol getImplFunSymbol() {
            return this.implFunSymbol;
        }

        @NotNull
        public final IrFunctionSymbol getInstanceFunSymbol() {
            return this.instanceFunSymbol;
        }

        @NotNull
        public final Collection<IrSimpleFunction> getRequiredBridges() {
            return this.requiredBridges;
        }

        @NotNull
        public final IrSimpleFunctionSymbol getDynamicCallSymbol() {
            return this.dynamicCallSymbol;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrParameterKind.values().length];
            try {
                nArray[IrParameterKind.DispatchReceiver.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Context.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.ExtensionReceiver.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrParameterKind.Regular.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

