/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.checkers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ErrorReportingContextKt;
import org.jetbrains.kotlin.backend.konan.BinaryType;
import org.jetbrains.kotlin.backend.konan.IntrinsicType;
import org.jetbrains.kotlin.backend.konan.IrTypeInlineClassesSupportKt;
import org.jetbrains.kotlin.backend.konan.driver.PhaseContext;
import org.jetbrains.kotlin.backend.konan.ir.IntrinsicsKt;
import org.jetbrains.kotlin.backend.konan.ir.KonanSymbols;
import org.jetbrains.kotlin.backend.konan.ir.annotations.Escapes;
import org.jetbrains.kotlin.backend.konan.ir.annotations.EscapesKt;
import org.jetbrains.kotlin.backend.konan.ir.annotations.PointsTo;
import org.jetbrains.kotlin.backend.konan.ir.annotations.PointsToKind;
import org.jetbrains.kotlin.backend.konan.ir.annotations.PointsToKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NativeRuntimeNames;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u00015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u001e\u00100\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020 2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u0010\u00101\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020 H\u0002J\u0010\u00102\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020 H\u0016J\u0010\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\u00020\u0015*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\u0015*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0015*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0018\u0010\u001f\u001a\u00020\u0015*\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!R\u0018\u0010\"\u001a\u00020\u0015*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0018\u0010&\u001a\u00020\u0015*\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010%R\u000e\u0010(\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0**\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/backend/konan/checkers/EscapeAnalysisChecker;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/konan/driver/PhaseContext;", "symbols", "Lorg/jetbrains/kotlin/backend/konan/ir/KonanSymbols;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "<init>", "(Lorg/jetbrains/kotlin/backend/konan/driver/PhaseContext;Lorg/jetbrains/kotlin/backend/konan/ir/KonanSymbols;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "reportWarning", "", "location", "Lorg/jetbrains/kotlin/ir/IrElement;", "message", "", "reportNonFatalError", "symbolsHandledByDFG", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "handledByDFG", "", "getHandledByDFG", "(Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;)Z", "mustBeLowered", "Lorg/jetbrains/kotlin/backend/konan/IntrinsicType;", "getMustBeLowered", "(Lorg/jetbrains/kotlin/backend/konan/IntrinsicType;)Z", "isSupportedPackageByEA", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "isLoweredIntrinsic", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "cannotEscape", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getCannotEscape", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "mustEscape", "getMustEscape", "returnValueName", "signatureElements", "", "Lorg/jetbrains/kotlin/backend/konan/checkers/EscapeAnalysisChecker$FunctionSignatureElement;", "getSignatureElements", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Ljava/util/List;", "checkEscapesAnnotation", "declaration", "checkPointsToAnnotation", "checkEscapeAnalysisAnnotations", "visitFunction", "visitElement", "element", "FunctionSignatureElement", "ir.backend.native"})
@SourceDebugExtension(value={"SMAP\nEscapeAnalysisChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EscapeAnalysisChecker.kt\norg/jetbrains/kotlin/backend/konan/checkers/EscapeAnalysisChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1661#2,3:225\n1924#2,3:228\n1786#2,3:231\n1807#2,3:234\n*S KotlinDebug\n*F\n+ 1 EscapeAnalysisChecker.kt\norg/jetbrains/kotlin/backend/konan/checkers/EscapeAnalysisChecker\n*L\n105#1:225,3\n119#1:228,3\n198#1:231,3\n208#1:234,3\n*E\n"})
public final class EscapeAnalysisChecker
extends IrVisitorVoid {
    @NotNull
    private final PhaseContext context;
    @NotNull
    private final IrFile irFile;
    @NotNull
    private final Set<IrSymbol> symbolsHandledByDFG;
    @NotNull
    private final String returnValueName;

    /*
     * WARNING - void declaration
     */
    public EscapeAnalysisChecker(@NotNull PhaseContext context2, @NotNull KonanSymbols symbols, @NotNull IrFile irFile) {
        void $this$symbolsHandledByDFG_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.context = context2;
        this.irFile = irFile;
        KonanSymbols konanSymbols = symbols;
        EscapeAnalysisChecker escapeAnalysisChecker = this;
        boolean bl = false;
        Object[] objectArray = new IrSimpleFunctionSymbol[]{$this$symbolsHandledByDFG_u24lambda_u240.getCreateUninitializedInstance(), $this$symbolsHandledByDFG_u24lambda_u240.getCreateUninitializedArray(), $this$symbolsHandledByDFG_u24lambda_u240.getCreateEmptyString(), $this$symbolsHandledByDFG_u24lambda_u240.getReinterpret(), $this$symbolsHandledByDFG_u24lambda_u240.getInitInstance()};
        escapeAnalysisChecker.symbolsHandledByDFG = SetsKt.setOf((Object[])objectArray);
        this.returnValueName = "<return>";
    }

    private final void reportWarning(IrElement location, String message2) {
        ErrorReportingContextKt.report(this.context, CompilerMessageSeverity.STRONG_WARNING, location, this.irFile, message2);
    }

    private final void reportNonFatalError(IrElement location, String message2) {
        ErrorReportingContextKt.report(this.context, CompilerMessageSeverity.ERROR, location, this.irFile, message2);
    }

    private final boolean getHandledByDFG(IrSymbol $this$handledByDFG) {
        return this.symbolsHandledByDFG.contains($this$handledByDFG);
    }

    private final boolean getMustBeLowered(IntrinsicType $this$mustBeLowered) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustBeLowered.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSupportedPackageByEA(FqName $this$isSupportedPackageByEA) {
        if (!$this$isSupportedPackageByEA.startsWith(IrTypeUtilsKt.getKotlinPackageFqn())) return false;
        FqName fqName = IrTypeUtilsKt.getKotlinPackageFqn();
        Name name2 = Name.identifier("concurrent");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        if ($this$isSupportedPackageByEA.startsWith(fqName.child(name2))) return false;
        FqName fqName2 = IrTypeUtilsKt.getKotlinPackageFqn();
        Name name3 = Name.identifier("native");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        FqName fqName3 = fqName2.child(name3);
        Name name4 = Name.identifier("concurrent");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        if ($this$isSupportedPackageByEA.startsWith(fqName3.child(name4))) return false;
        return true;
    }

    private final boolean isLoweredIntrinsic(IrFunction $this$isLoweredIntrinsic) {
        IntrinsicType intrinsicType = IntrinsicsKt.tryGetIntrinsicType($this$isLoweredIntrinsic);
        return intrinsicType != null ? this.getMustBeLowered(intrinsicType) : false;
    }

    private final boolean getCannotEscape(IrType $this$cannotEscape) {
        return IrTypePredicatesKt.isUnit($this$cannotEscape) || IrTypePredicatesKt.isNothing($this$cannotEscape) || IrTypeInlineClassesSupportKt.computeBinaryType($this$cannotEscape) instanceof BinaryType.Primitive;
    }

    private final boolean getMustEscape(IrType $this$mustEscape) {
        Object object = IrTypesKt.getClass($this$mustEscape);
        return object != null && (object = object.getAnnotations()) != null ? AdditionalIrUtilsKt.hasAnnotation((List<? extends IrConstructorCall>)object, NativeRuntimeNames.Annotations.INSTANCE.getHasFinalizer()) : false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FunctionSignatureElement> getSignatureElements(IrFunction $this$signatureElements) {
        void $this$mapTo$iv;
        List list;
        List $this$_get_signatureElements__u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = IrUtilsKt.getAllParameters($this$signatureElements);
        Collection destination$iv = $this$_get_signatureElements__u24lambda_u240;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            String string = it.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            collection.add(new FunctionSignatureElement(string, it.getType()));
        }
        $this$_get_signatureElements__u24lambda_u240.add(new FunctionSignatureElement(this.returnValueName, $this$signatureElements.getReturnType()));
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEscapesAnnotation(IrFunction declaration, List<FunctionSignatureElement> signatureElements) {
        Escapes escapes;
        String escapesName = NativeRuntimeNames.Annotations.INSTANCE.getEscapes().asFqNameString();
        try {
            escapes = EscapesKt.getEscapes(declaration);
        }
        catch (IllegalArgumentException e) {
            this.reportNonFatalError(declaration, '@' + escapesName + " value is invalid: " + e.getMessage());
            return;
        }
        Escapes escapes2 = escapes;
        if (escapes2 == null) {
            return;
        }
        int value2 = escapes2.unbox-impl();
        Iterable $this$forEachIndexed$iv = signatureElements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void element;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FunctionSignatureElement functionSignatureElement = (FunctionSignatureElement)item$iv;
            int index = n;
            boolean bl = false;
            if (Escapes.escapesAt-impl(value2, index)) {
                if (!this.getCannotEscape(element.getType())) continue;
                this.reportNonFatalError(declaration, element.getName() + " is marked as escaping by @" + escapesName + ", but the type cannot escape to the heap");
                continue;
            }
            if (!this.getMustEscape(element.getType())) continue;
            this.reportNonFatalError(declaration, element.getName() + " is not marked as escaping by @" + escapesName + ", but the type must always escape to the heap");
        }
    }

    private final void checkPointsToAnnotation(IrFunction declaration, List<FunctionSignatureElement> signatureElements) {
        int[] nArray;
        String pointsToName = NativeRuntimeNames.Annotations.INSTANCE.getPointsTo().asFqNameString();
        try {
            nArray = PointsToKt.getPointsTo(declaration);
        }
        catch (IllegalArgumentException e) {
            this.reportNonFatalError(declaration, '@' + pointsToName + " value is invalid: " + e.getMessage());
            return;
        }
        if (nArray == null) {
            return;
        }
        int[] annotation = nArray;
        int n = ((Collection)signatureElements).size();
        block4: for (int indexFrom = 0; indexFrom < n; ++indexFrom) {
            FunctionSignatureElement from2 = signatureElements.get(indexFrom);
            int n2 = ((Collection)signatureElements).size();
            for (int indexTo = 0; indexTo < n2; ++indexTo) {
                PointsToKind pointsToKind;
                FunctionSignatureElement to = signatureElements.get(indexTo);
                try {
                    pointsToKind = PointsTo.kind-s_dE6CA(annotation, indexFrom, indexTo);
                }
                catch (IllegalArgumentException e) {
                    this.reportNonFatalError(declaration, '@' + pointsToName + " value " + PointsTo.toString-impl(annotation) + " is invalid at index " + indexFrom + " nibble " + indexTo + ": " + e.getMessage());
                    pointsToKind = null;
                }
                PointsToKind pointsToKind2 = pointsToKind;
                if (pointsToKind2 == null) {
                    continue;
                }
                int kind = pointsToKind2.unbox-impl();
                if (PointsToKind.getSourceIsDirect-impl(kind) && PointsToKind.getDestinationIsDirect-impl(kind) && !Intrinsics.areEqual((Object)from2.getName(), (Object)this.returnValueName)) {
                    this.reportNonFatalError(declaration, from2.getName() + " is marked as pointing to " + to.getName() + " by @" + pointsToName + " with kind 1, but kind 1 is only allowed for the return value");
                }
                if (this.getCannotEscape(from2.getType())) {
                    this.reportNonFatalError(declaration, from2.getName() + " is marked as pointing to " + to.getName() + " by @" + pointsToName + ", but " + from2.getName() + "'s type cannot escape to the heap");
                    continue block4;
                }
                if (!this.getCannotEscape(to.getType())) continue;
                this.reportNonFatalError(declaration, from2.getName() + " is marked as pointing to " + to.getName() + " by @" + pointsToName + ", but " + to.getName() + "'s type cannot escape to the heap");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEscapeAnalysisAnnotations(IrFunction declaration) {
        boolean bl;
        boolean bl2;
        EscapeAnalysisChecker escapeAnalysisChecker;
        IrFunction irFunction;
        String string;
        boolean bl3;
        String string2;
        boolean bl4;
        String string3;
        List<FunctionSignatureElement> signatureElements;
        String pointsToName;
        boolean hasPointsTo;
        String escapesNothingName;
        boolean hasEscapesNothing;
        String escapesName;
        boolean hasEscapes;
        block15: {
            boolean bl5;
            void $this$all$iv;
            hasEscapes = AdditionalIrUtilsKt.hasAnnotation(declaration.getAnnotations(), NativeRuntimeNames.Annotations.INSTANCE.getEscapes());
            if (EscapeAnalysisChecker.checkEscapeAnalysisAnnotations$warnUnusedIf(hasEscapes, this, declaration, escapesName = NativeRuntimeNames.Annotations.INSTANCE.getEscapes().asFqNameString(), hasEscapesNothing = AdditionalIrUtilsKt.hasAnnotation(declaration.getAnnotations(), NativeRuntimeNames.Annotations.INSTANCE.getEscapesNothing()), escapesNothingName = NativeRuntimeNames.Annotations.INSTANCE.getEscapesNothing().asFqNameString(), hasPointsTo = AdditionalIrUtilsKt.hasAnnotation(declaration.getAnnotations(), NativeRuntimeNames.Annotations.INSTANCE.getPointsTo()), pointsToName = NativeRuntimeNames.Annotations.INSTANCE.getPointsTo().asFqNameString(), !declaration.isExternal(), (Function0<String>)((Function0)EscapeAnalysisChecker::checkEscapeAnalysisAnnotations$lambda$0)) == null) {
                return;
            }
            if (EscapeAnalysisChecker.checkEscapeAnalysisAnnotations$warnUnusedIf(hasEscapes, this, declaration, escapesName, hasEscapesNothing, escapesNothingName, hasPointsTo, pointsToName, !this.isSupportedPackageByEA(AdditionalIrUtilsKt.getFqNameForIrSerialization(declaration.getParent())), (Function0<String>)((Function0)EscapeAnalysisChecker::checkEscapeAnalysisAnnotations$lambda$1)) == null) {
                return;
            }
            if (EscapeAnalysisChecker.checkEscapeAnalysisAnnotations$warnUnusedIf(hasEscapes, this, declaration, escapesName, hasEscapesNothing, escapesNothingName, hasPointsTo, pointsToName, this.getHandledByDFG(declaration.getSymbol()), (Function0<String>)((Function0)EscapeAnalysisChecker::checkEscapeAnalysisAnnotations$lambda$2)) == null) {
                return;
            }
            if (EscapeAnalysisChecker.checkEscapeAnalysisAnnotations$warnUnusedIf(hasEscapes, this, declaration, escapesName, hasEscapesNothing, escapesNothingName, hasPointsTo, pointsToName, this.isLoweredIntrinsic(declaration), (Function0<String>)((Function0)EscapeAnalysisChecker::checkEscapeAnalysisAnnotations$lambda$3)) == null) {
                return;
            }
            signatureElements = this.getSignatureElements(declaration);
            Iterable iterable = signatureElements;
            string3 = pointsToName;
            bl4 = hasPointsTo;
            string2 = escapesNothingName;
            bl3 = hasEscapesNothing;
            string = escapesName;
            irFunction = declaration;
            escapeAnalysisChecker = this;
            bl2 = hasEscapes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl5 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FunctionSignatureElement it = (FunctionSignatureElement)element$iv;
                    boolean bl6 = false;
                    if (this.getCannotEscape(it.getType())) continue;
                    bl5 = false;
                    break block15;
                }
                bl5 = bl = true;
            }
        }
        if (EscapeAnalysisChecker.checkEscapeAnalysisAnnotations$warnUnusedIf(bl2, escapeAnalysisChecker, irFunction, string, bl3, string2, bl4, string3, bl, (Function0<String>)((Function0)EscapeAnalysisChecker::checkEscapeAnalysisAnnotations$lambda$5)) == null) {
            return;
        }
        if (hasEscapes && hasEscapesNothing) {
            this.reportNonFatalError(declaration, "Conflicting @" + escapesName + " and @" + escapesNothingName);
        }
        if (!(hasEscapes || hasEscapesNothing || hasPointsTo)) {
            this.reportNonFatalError(declaration, "External function with parameters that may escape requires @" + escapesName + " or @" + escapesNothingName + " or @" + pointsToName);
        }
        if (!hasEscapes) {
            boolean bl7;
            block16: {
                Iterable $this$any$iv = signatureElements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunctionSignatureElement it = (FunctionSignatureElement)element$iv;
                        boolean bl8 = false;
                        if (!this.getMustEscape(it.getType())) continue;
                        bl7 = true;
                        break block16;
                    }
                    bl7 = false;
                }
            }
            if (bl7) {
                this.reportNonFatalError(declaration, "External function with parameters that must always escape is not marked by @" + escapesName);
            }
        }
        this.checkEscapesAnnotation(declaration, signatureElements);
        this.checkPointsToAnnotation(declaration, signatureElements);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkEscapeAnalysisAnnotations(declaration);
        super.visitFunction(declaration);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    private static final Object checkEscapeAnalysisAnnotations$warnUnusedIf(boolean hasEscapes, EscapeAnalysisChecker this$0, IrFunction $declaration, String escapesName, boolean hasEscapesNothing, String escapesNothingName, boolean hasPointsTo, String pointsToName, boolean condition, Function0<String> message2) {
        if (!condition) {
            return Unit.INSTANCE;
        }
        if (hasEscapes) {
            this$0.reportWarning($declaration, "Unused @" + escapesName + ": " + (String)message2.invoke());
        }
        if (hasEscapesNothing) {
            this$0.reportWarning($declaration, "Unused @" + escapesNothingName + ": " + (String)message2.invoke());
        }
        if (hasPointsTo) {
            this$0.reportWarning($declaration, "Unused @" + pointsToName + ": " + (String)message2.invoke());
        }
        return null;
    }

    private static final String checkEscapeAnalysisAnnotations$lambda$0() {
        return "non-external function";
    }

    private static final String checkEscapeAnalysisAnnotations$lambda$1() {
        return "package outside EA annotation checks";
    }

    private static final String checkEscapeAnalysisAnnotations$lambda$2() {
        return "function handled manually in DFGBuilder";
    }

    private static final String checkEscapeAnalysisAnnotations$lambda$3() {
        return "function is lowered in the compiler";
    }

    private static final String checkEscapeAnalysisAnnotations$lambda$5() {
        return "all of function parameters, receivers and the return value types cannot escape to the heap";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/konan/checkers/EscapeAnalysisChecker$FunctionSignatureElement;", "", "name", "", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getName", "()Ljava/lang/String;", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.backend.native"})
    private static final class FunctionSignatureElement {
        @NotNull
        private final String name;
        @NotNull
        private final IrType type;

        public FunctionSignatureElement(@NotNull String name2, @NotNull IrType type) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name2;
            this.type = type;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final IrType getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final IrType component2() {
            return this.type;
        }

        @NotNull
        public final FunctionSignatureElement copy(@NotNull String name2, @NotNull IrType type) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new FunctionSignatureElement(name2, type);
        }

        public static /* synthetic */ FunctionSignatureElement copy$default(FunctionSignatureElement functionSignatureElement, String string, IrType irType, int n, Object object) {
            if ((n & 1) != 0) {
                string = functionSignatureElement.name;
            }
            if ((n & 2) != 0) {
                irType = functionSignatureElement.type;
            }
            return functionSignatureElement.copy(string, irType);
        }

        @NotNull
        public String toString() {
            return "FunctionSignatureElement(name=" + this.name + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FunctionSignatureElement)) {
                return false;
            }
            FunctionSignatureElement functionSignatureElement = (FunctionSignatureElement)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)functionSignatureElement.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)functionSignatureElement.type);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IntrinsicType.values().length];
            try {
                nArray[IntrinsicType.ATOMIC_GET_FIELD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.ATOMIC_SET_FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.GET_CONTINUATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.RETURN_IF_SUSPENDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.SAVE_COROUTINE_STATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.RESTORE_COROUTINE_STATE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_BITS_TO_FLOAT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_BITS_TO_DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_SIGN_EXTEND.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_NARROW.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_STATIC_C_FUNCTION.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_FUNPTR_INVOKE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.INTEROP_CONVERT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.ENUM_VALUES.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.ENUM_VALUE_OF.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.ENUM_ENTRIES.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.WORKER_EXECUTE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.COMPARE_AND_SET_FIELD.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.COMPARE_AND_EXCHANGE_FIELD.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.GET_AND_SET_FIELD.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntrinsicType.GET_AND_ADD_FIELD.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

