/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/SerializedFileReference;", "", "fqName", "", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getFqName", "()Ljava/lang/String;", "getPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "ir.serialization.native"})
public final class SerializedFileReference {
    @NotNull
    private final String fqName;
    @NotNull
    private final String path;

    public SerializedFileReference(@NotNull String fqName, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.fqName = fqName;
        this.path = path;
    }

    @NotNull
    public final String getFqName() {
        return this.fqName;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public SerializedFileReference(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this(irFile.getPackageFqName().asString(), IrDeclarationsKt.getPath(irFile));
    }

    @NotNull
    public final String component1() {
        return this.fqName;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final SerializedFileReference copy(@NotNull String fqName, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SerializedFileReference(fqName, path);
    }

    public static /* synthetic */ SerializedFileReference copy$default(SerializedFileReference serializedFileReference, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = serializedFileReference.fqName;
        }
        if ((n & 2) != 0) {
            string2 = serializedFileReference.path;
        }
        return serializedFileReference.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "SerializedFileReference(fqName=" + this.fqName + ", path=" + this.path + ')';
    }

    public int hashCode() {
        int result2 = this.fqName.hashCode();
        result2 = result2 * 31 + this.path.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SerializedFileReference)) {
            return false;
        }
        SerializedFileReference serializedFileReference = (SerializedFileReference)other;
        if (!Intrinsics.areEqual((Object)this.fqName, (Object)serializedFileReference.fqName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.path, (Object)serializedFileReference.path);
    }
}

