/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import org.jetbrains.kotlin.ir.builders.IrSingleStatementBuilder;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/EraseVirtualDispatchReceiverParametersTypes;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nEraseVirtualDispatchReceiverParametersTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EraseVirtualDispatchReceiverParametersTypes.kt\norg/jetbrains/kotlin/backend/wasm/lower/EraseVirtualDispatchReceiverParametersTypes\n+ 2 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n*L\n1#1,105:1\n210#2:106\n*S KotlinDebug\n*F\n+ 1 EraseVirtualDispatchReceiverParametersTypes.kt\norg/jetbrains/kotlin/backend/wasm/lower/EraseVirtualDispatchReceiverParametersTypes\n*L\n83#1:106\n*E\n"})
public final class EraseVirtualDispatchReceiverParametersTypes
implements FileLoweringPass {
    @NotNull
    private final CommonBackendContext context;

    public EraseVirtualDispatchReceiverParametersTypes(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptChildrenVoid((IrElement)irFile, new IrVisitorVoid(this){
            final /* synthetic */ EraseVirtualDispatchReceiverParametersTypes this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            public void visitFunction(IrFunction declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                this.this$0.lower(declaration);
                super.visitFunction(declaration);
            }
        });
    }

    public final void lower(@NotNull IrFunction irFunction) {
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        if (!(irFunction instanceof IrSimpleFunction)) {
            return;
        }
        if (!IrUtilsKt.isOverridableOrOverrides(irFunction)) {
            return;
        }
        IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameter dispatchReceiver = irValueParameter;
        IrType originalReceiverType = dispatchReceiver.getType();
        if (IrTypeUtilsKt.isInterface(originalReceiverType) || IrTypePredicatesKt.isAny(originalReceiverType)) {
            return;
        }
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default(this.context, (IrSymbol)((IrSimpleFunction)irFunction).getSymbol(), 0, 0, 6, null);
        dispatchReceiver.setType(this.context.getIrBuiltIns().getAnyType());
        IrBody irBody = irFunction.getBody();
        IrBlockBody irBlockBody = irBody instanceof IrBlockBody ? (IrBlockBody)irBody : null;
        if (irBlockBody == null) {
            return;
        }
        IrBlockBody blockBody = irBlockBody;
        IrValueParameter irValueParameter2 = IrUtilsKt.getParentAsClass(irFunction).getThisReceiver();
        IrValueParameterSymbol classThisReceiverSymbol = irValueParameter2 != null ? irValueParameter2.getSymbol() : null;
        Lazy lazyCastedThis = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> EraseVirtualDispatchReceiverParametersTypes.lower$lambda$0(builder2, dispatchReceiver, originalReceiverType));
        IrElementTransformerVoidKt.transformChildrenVoid(irFunction, new IrElementTransformerVoid(dispatchReceiver, classThisReceiverSymbol, builder2, (Lazy<? extends IrVariable>)lazyCastedThis){
            final /* synthetic */ IrValueParameter $dispatchReceiver;
            final /* synthetic */ IrValueParameterSymbol $classThisReceiverSymbol;
            final /* synthetic */ DeclarationIrBuilder $builder;
            final /* synthetic */ Lazy<IrVariable> $lazyCastedThis;
            {
                this.$dispatchReceiver = $dispatchReceiver;
                this.$classThisReceiverSymbol = $classThisReceiverSymbol;
                this.$builder = $builder;
                this.$lazyCastedThis = $lazyCastedThis;
            }

            public IrExpression visitGetValue(IrGetValue expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (IrTypePredicatesKt.isAny(expression2.getType())) {
                    return expression2;
                }
                if (!Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$dispatchReceiver.getSymbol()) && !Intrinsics.areEqual((Object)expression2.getSymbol(), (Object)this.$classThisReceiverSymbol)) {
                    return expression2;
                }
                return ExpressionHelpersKt.irGet(this.$builder, (IrValueDeclaration)this.$lazyCastedThis.getValue());
            }
        });
        if (lazyCastedThis.isInitialized()) {
            blockBody.getStatements().add(0, (IrStatement)lazyCastedThis.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final IrVariable lower$lambda$0(DeclarationIrBuilder $builder, IrValueParameter $dispatchReceiver, IrType $originalReceiverType) {
        void startOffset$iv;
        void $this$buildStatement$iv;
        IrGeneratorWithScope irGeneratorWithScope = $builder;
        int n = -1;
        int endOffset$iv = -1;
        boolean $i$f$buildStatement = false;
        IrSingleStatementBuilder $this$lower_u24lambda_u240_u240 = new IrSingleStatementBuilder($this$buildStatement$iv.getContext(), $this$buildStatement$iv.getScope(), (int)startOffset$iv, endOffset$iv, null, 16, null);
        boolean bl = false;
        return (IrVariable)((IrElement)Scope.createTemporaryVariable$default($this$lower_u24lambda_u240_u240.getScope(), ExpressionHelpersKt.irImplicitCast($builder, ExpressionHelpersKt.irGet($builder, $dispatchReceiver), $originalReceiverType), $dispatchReceiver.getName().asString(), false, null, null, 0, 0, false, 252, null));
    }
}

