/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.lower.FieldInitializersLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/FieldInitializersLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nFieldInitializersLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldInitializersLowering.kt\norg/jetbrains/kotlin/backend/wasm/lower/FieldInitializersLowering\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class FieldInitializersLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;

    public FieldInitializersLowering(@NotNull WasmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        Ref.ObjectRef nonConstantFieldInitializer = new Ref.ObjectRef();
        Ref.ObjectRef objectInstanceFieldInitializer = new Ref.ObjectRef();
        IrVisitorsKt.acceptVoid((IrElement)irFile, new IrVisitorVoid(this, irFile, (Ref.ObjectRef<IrSimpleFunction>)objectInstanceFieldInitializer, (Ref.ObjectRef<IrSimpleFunction>)nonConstantFieldInitializer){
            final /* synthetic */ FieldInitializersLowering this$0;
            final /* synthetic */ IrFile $irFile;
            final /* synthetic */ Ref.ObjectRef<IrSimpleFunction> $objectInstanceFieldInitializer;
            final /* synthetic */ Ref.ObjectRef<IrSimpleFunction> $nonConstantFieldInitializer;
            {
                this.this$0 = $receiver;
                this.$irFile = $irFile;
                this.$objectInstanceFieldInitializer = $objectInstanceFieldInitializer;
                this.$nonConstantFieldInitializer = $nonConstantFieldInitializer;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid(element, this);
            }

            private final IrSimpleFunction createInitializerFunction() {
                IrFactory irFactory = this.this$0.getContext().getIrFactory();
                IrDeclarationOrigin irDeclarationOrigin = JsIrBuilder.INSTANCE.getSYNTHESIZED_DECLARATION();
                Name name2 = Name.identifier("fieldInitializer");
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
                IrSimpleFunction newFunction = IrFactory.createSimpleFunction$default(irFactory, -1, -1, irDeclarationOrigin, name2, descriptorVisibility, false, false, this.this$0.getContext().getIrBuiltIns().getUnitType(), Modality.FINAL, new IrSimpleFunctionSymbolImpl(null, null, 3, null), false, false, false, false, false, null, false, 114688, null);
                newFunction.setParent(this.$irFile);
                newFunction.setBody(this.this$0.getContext().getIrFactory().createBlockBody(-1, -1));
                return newFunction;
            }

            public void visitField(IrField declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                super.visitField(declaration);
                if (declaration.isExternal()) {
                    return;
                }
                if (!declaration.isStatic()) {
                    return;
                }
                IrElementBase irElementBase = declaration.getInitializer();
                if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
                    return;
                }
                IrElementBase initializer = irElementBase;
                if (initializer instanceof IrConst && !(((IrConst)initializer).getKind() instanceof IrConstKind.String)) {
                    return;
                }
                IrSimpleFunction initializeFunction = IrJsUtilsKt.isObjectInstanceField(declaration) ? (IrSimpleFunction)this.$objectInstanceFieldInitializer.element : (IrSimpleFunction)this.$nonConstantFieldInitializer.element;
                IrSimpleFunction irSimpleFunction = initializeFunction;
                if (irSimpleFunction == null) {
                    lower.1 var5_4 = this;
                    FieldInitializersLowering fieldInitializersLowering2 = this.this$0;
                    Ref.ObjectRef<IrSimpleFunction> objectRef = this.$objectInstanceFieldInitializer;
                    Ref.ObjectRef<IrSimpleFunction> objectRef2 = this.$nonConstantFieldInitializer;
                    lower.1 $this$visitField_u24lambda_u240 = var5_4;
                    boolean bl = false;
                    T t = fieldInitializersLowering2.getContext().getIrFactory().getStageController().restrictTo(declaration, () -> lower.1.visitField$lambda$0$0($this$visitField_u24lambda_u240));
                    IrSimpleFunction it = (IrSimpleFunction)t;
                    boolean bl2 = false;
                    if (IrJsUtilsKt.isObjectInstanceField(declaration)) {
                        objectRef.element = it;
                    } else {
                        objectRef2.element = it;
                    }
                    irSimpleFunction = (IrSimpleFunction)t;
                }
                IrSimpleFunction currentFunction = irSimpleFunction;
                IrSetFieldImpl initializerStatement = ExpressionHelpersKt.irSetField$default(LowerUtilsKt.at((IrBuilder)LowerUtilsKt.createIrBuilder$default(this.this$0.getContext(), (IrSymbol)currentFunction.getSymbol(), 0, 0, 6, null), initializer), null, declaration, (IrExpression)initializer, null, 8, null);
                IrBody irBody = currentFunction.getBody();
                Intrinsics.checkNotNull((Object)irBody, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
                ((IrBlockBody)irBody).getStatements().add(initializerStatement);
                declaration.setInitializer(null);
            }

            private static final IrSimpleFunction visitField$lambda$0$0(lower.1 $this_run) {
                return $this_run.createInitializerFunction();
            }
        });
        if (objectInstanceFieldInitializer.element != null || nonConstantFieldInitializer.element != null) {
            IrSimpleFunction irSimpleFunction;
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction it;
            WasmBackendContext.CrossFileContext crossFileContext;
            IrSimpleFunction irSimpleFunction3;
            WasmBackendContext.CrossFileContext $this$lower_u24lambda_u240 = this.context.getFileContext(irFile);
            boolean bl = false;
            WasmBackendContext.CrossFileContext crossFileContext2 = $this$lower_u24lambda_u240;
            IrSimpleFunction irSimpleFunction4 = (IrSimpleFunction)objectInstanceFieldInitializer.element;
            if (irSimpleFunction4 != null) {
                IrSimpleFunction irSimpleFunction5 = irSimpleFunction3 = irSimpleFunction4;
                crossFileContext = crossFileContext2;
                boolean bl2 = false;
                irFile.getDeclarations().add(it);
                crossFileContext2 = crossFileContext;
                irSimpleFunction2 = irSimpleFunction3;
            } else {
                irSimpleFunction2 = null;
            }
            crossFileContext2.setObjectInstanceFieldInitializer(irSimpleFunction2);
            WasmBackendContext.CrossFileContext crossFileContext3 = $this$lower_u24lambda_u240;
            IrSimpleFunction irSimpleFunction6 = (IrSimpleFunction)nonConstantFieldInitializer.element;
            if (irSimpleFunction6 != null) {
                it = irSimpleFunction3 = irSimpleFunction6;
                crossFileContext = crossFileContext3;
                boolean bl3 = false;
                irFile.getDeclarations().add(it);
                crossFileContext3 = crossFileContext;
                irSimpleFunction = irSimpleFunction3;
            } else {
                irSimpleFunction = null;
            }
            crossFileContext3.setNonConstantFieldInitializer(irSimpleFunction);
        }
    }
}

