/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg.pseudocode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.BlockInfo;
import org.jetbrains.kotlin.cfg.BreakableBlockInfo;
import org.jetbrains.kotlin.cfg.ControlFlowBuilder;
import org.jetbrains.kotlin.cfg.ControlFlowBuilderAdapter;
import org.jetbrains.kotlin.cfg.GenerationTrigger;
import org.jetbrains.kotlin.cfg.Label;
import org.jetbrains.kotlin.cfg.LoopInfo;
import org.jetbrains.kotlin.cfg.SubroutineInfo;
import org.jetbrains.kotlin.cfg.pseudocode.ControlFlowInstructionsGenerator;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValue;
import org.jetbrains.kotlin.cfg.pseudocode.PseudoValueFactoryImpl;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeLabel;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.BlockScope;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.AccessTarget;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.CallInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.InstructionWithValue;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.LoadUnitValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MergeInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.OperationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.ReadValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.WriteValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ThrowExceptionInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.InlinedLocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.MarkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.VariableDeclarationInstruction;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\u00060\u0017R\u00020\u0000H\u0002J\u001a\u0010!\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001a\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0017R\u00020\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator;", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilderAdapter;", "<init>", "()V", "builder", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "delegateBuilder", "getDelegateBuilder", "()Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "loopInfo", "Lorg/jetbrains/kotlin/com/intellij/util/containers/Stack;", "Lorg/jetbrains/kotlin/cfg/LoopInfo;", "blockScopes", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "elementToLoopInfo", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "elementToSubroutineInfo", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/cfg/SubroutineInfo;", "labelCount", "", "builders", "Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker;", "allBlocks", "Lorg/jetbrains/kotlin/cfg/BlockInfo;", "pushBuilder", "", "scopingElement", "subroutine", "shouldInline", "", "popBuilder", "enterSubroutine", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "exitSubroutine", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "ControlFlowInstructionsGeneratorWorker", "TryFinallyBlockInfo", "cfg"})
public final class ControlFlowInstructionsGenerator
extends ControlFlowBuilderAdapter {
    @Nullable
    private ControlFlowBuilder builder;
    @NotNull
    private final Stack<LoopInfo> loopInfo = new Stack();
    @NotNull
    private final Stack<BlockScope> blockScopes = new Stack();
    @NotNull
    private final HashMap<KtLoopExpression, LoopInfo> elementToLoopInfo = new HashMap();
    @NotNull
    private final HashMap<KtElement, SubroutineInfo> elementToSubroutineInfo = new HashMap();
    private int labelCount;
    @NotNull
    private final Stack<ControlFlowInstructionsGeneratorWorker> builders = new Stack();
    @NotNull
    private final Stack<BlockInfo> allBlocks = new Stack();

    @Override
    @NotNull
    protected ControlFlowBuilder getDelegateBuilder() {
        ControlFlowBuilder controlFlowBuilder = this.builder;
        if (controlFlowBuilder == null) {
            throw new AssertionError((Object)"Builder stack is empty in ControlFlowInstructionsGenerator!");
        }
        return controlFlowBuilder;
    }

    private final void pushBuilder(KtElement scopingElement, KtElement subroutine, boolean shouldInline) {
        ControlFlowInstructionsGeneratorWorker worker = new ControlFlowInstructionsGeneratorWorker(scopingElement, subroutine, shouldInline);
        this.builders.push(worker);
        this.builder = worker;
    }

    private final ControlFlowInstructionsGeneratorWorker popBuilder() {
        ControlFlowInstructionsGeneratorWorker worker = this.builders.pop();
        this.builder = !this.builders.isEmpty() ? (ControlFlowBuilder)this.builders.peek() : null;
        Intrinsics.checkNotNull((Object)worker);
        return worker;
    }

    @Override
    public void enterSubroutine(@NotNull KtElement subroutine, @Nullable EventOccurrencesRange eventOccurrencesRange) {
        boolean shouldInlnie;
        Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
        ControlFlowBuilder builder2 = this.builder;
        boolean bl = shouldInlnie = eventOccurrencesRange != null;
        if (builder2 != null && subroutine instanceof KtFunctionLiteral) {
            this.pushBuilder(subroutine, builder2.getReturnSubroutine(), shouldInlnie);
        } else {
            this.pushBuilder(subroutine, subroutine, shouldInlnie);
        }
        this.getDelegateBuilder().enterBlockScope(subroutine);
        ControlFlowBuilder.enterSubroutine$default(this.getDelegateBuilder(), subroutine, null, 2, null);
    }

    @Override
    @NotNull
    public Pseudocode exitSubroutine(@NotNull KtElement subroutine, @Nullable EventOccurrencesRange eventOccurrencesRange) {
        Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
        super.exitSubroutine(subroutine, eventOccurrencesRange);
        this.getDelegateBuilder().exitBlockScope(subroutine);
        ControlFlowInstructionsGeneratorWorker worker = this.popBuilder();
        if (!this.builders.empty()) {
            ControlFlowInstructionsGeneratorWorker builder2 = this.builders.peek();
            if (eventOccurrencesRange == null) {
                builder2.declareFunction(subroutine, worker.getPseudocode());
            } else {
                builder2.declareInlinedFunction(subroutine, worker.getPseudocode(), eventOccurrencesRange);
            }
        }
        return worker.getPseudocode();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009d\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0013\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u00102\u0006\u0010,\u001a\u00020\u001fH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\u00102\u0006\u0010,\u001a\u00020\u001fH\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u00102\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0010\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0003H\u0016J\u0010\u00106\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0003H\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\u0010H\u0002J\u001a\u00109\u001a\u00020:2\u0006\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010;\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0014\u0010=\u001a\u0004\u0018\u00010>2\b\u0010<\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020>2\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0012\u0010A\u001a\u00020>2\b\u0010<\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020D2\u0006\u0010B\u001a\u00020>2\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0018\u0010E\u001a\u00020\u00162\u0006\u0010C\u001a\u00020F2\u0006\u0010&\u001a\u00020\u0003H\u0016J<\u0010G\u001a\u00020\u00162\u0006\u0010H\u001a\u00020\u00032\u0006\u0010I\u001a\u00020\u00032\u0006\u0010J\u001a\u00020>2\u0006\u0010K\u001a\u00020L2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020O0NH\u0016J\u0010\u0010P\u001a\u00020\u00162\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u00162\u0006\u0010T\u001a\u00020UH\u0016J\u0018\u0010V\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020:H\u0016J \u0010W\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020:2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010X\u001a\u00020\u00162\u0006\u0010Y\u001a\u00020ZH\u0016J\u0010\u0010[\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020DH\u0016J\u0018\u0010\\\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0003H\u0016J\"\u0010^\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00032\b\u0010_\u001a\u0004\u0018\u00010>H\u0016J\"\u0010`\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00032\b\u0010_\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010a\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u0010H\u0016J\"\u0010b\u001a\u00020\u00162\u0006\u0010]\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00032\b\u0010c\u001a\u0004\u0018\u00010>H\u0016J\u001e\u0010b\u001a\u00020\u00162\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00100d2\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0010\u0010e\u001a\u00020\u00162\u0006\u0010<\u001a\u00020\u0003H\u0016J\u0010\u0010f\u001a\u00020\u00162\u0006\u0010g\u001a\u00020hH\u0016J\u0018\u0010i\u001a\u00020\u00162\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020>H\u0016J\b\u0010m\u001a\u00020\u0016H\u0016J\u0018\u0010n\u001a\u00020\u00162\u0006\u0010o\u001a\u00020\u00102\u0006\u0010p\u001a\u00020\u0010H\u0016J\u001e\u0010q\u001a\u00020r2\u0006\u0010\u001e\u001a\u00020D2\f\u0010s\u001a\b\u0012\u0002\b\u0003\u0018\u00010tH\u0016J\u0010\u0010u\u001a\u00020r2\u0006\u0010\u001e\u001a\u00020vH\u0016J\u0010\u0010w\u001a\u00020r2\u0006\u0010\u001e\u001a\u00020xH\u0016J\u001e\u0010y\u001a\u00020z2\u0006\u0010\u001e\u001a\u00020{2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020>0dH\u0016J3\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020\u00032\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00032\f\u0010|\u001a\b\u0012\u0004\u0012\u00020>0d2\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001H\u0016J \u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0006\u0010\u001e\u001a\u00020D2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020>0dH\u0016J3\u0010\u0085\u0001\u001a\u00020r2\u0006\u0010\u001e\u001a\u00020D2\f\u0010\u0086\u0001\u001a\u0007\u0012\u0002\b\u00030\u0087\u00012\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020O0NH\u0016JK\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u0080\u0001\u001a\u00020\u00032\f\u0010\u0086\u0001\u001a\u0007\u0012\u0002\b\u00030\u0087\u00012\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020O0N2\u0014\u0010\u008a\u0001\u001a\u000f\u0012\u0004\u0012\u00020>\u0012\u0005\u0012\u00030\u008b\u00010NH\u0016J*\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0006\u0010\u001e\u001a\u00020D2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\f\u0010|\u001a\b\u0012\u0004\u0012\u00020>0dH\u0016J\u0014\u0010\u0090\u0001\u001a\u00030\u0082\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0002J-\u0010\u0091\u0001\u001a\u00020r2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010K\u001a\u00020L2\u0012\u0010M\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020O0NH\u0016J9\u0010\u0091\u0001\u001a\u00020r2\u0006\u0010\u001e\u001a\u00020D2\u0010\b\u0002\u0010\u0086\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u0087\u00012\u0014\b\u0002\u0010M\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020O0NH\u0002R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0016\u0010\"\u001a\u0004\u0018\u00010\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010)\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u0014\u00100\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006\u0092\u0001"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker;", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder;", "scopingElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "returnSubroutine", "shouldInline", "", "<init>", "(Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtElement;Z)V", "getReturnSubroutine", "()Lorg/jetbrains/kotlin/psi/KtElement;", "pseudocode", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "getPseudocode", "()Lorg/jetbrains/kotlin/cfg/pseudocode/PseudocodeImpl;", "error", "Lorg/jetbrains/kotlin/cfg/Label;", "sink", "valueFactory", "org/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$valueFactory$1", "Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker$valueFactory$1;", "add", "", "instruction", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/Instruction;", "createUnboundLabel", "name", "", "enterLoop", "Lorg/jetbrains/kotlin/cfg/LoopInfo;", "expression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "enterLoopBody", "exitLoopBody", "currentLoop", "getCurrentLoop", "()Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "enterSubroutine", "subroutine", "eventOccurrencesRange", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "currentSubroutine", "getCurrentSubroutine", "getLoopConditionEntryPoint", "loop", "getLoopExitPoint", "getSubroutineExitPoint", "labelElement", "currentScope", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "getCurrentScope", "()Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/BlockScope;", "enterBlockScope", "block", "exitBlockScope", "handleJumpInsideTryFinally", "jumpTarget", "exitSubroutine", "Lorg/jetbrains/kotlin/cfg/pseudocode/Pseudocode;", "mark", "element", "getBoundValue", "Lorg/jetbrains/kotlin/cfg/pseudocode/PseudoValue;", "bindValue", "value", "newValue", "returnValue", "returnExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "returnNoValue", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "write", "assignment", "lValue", "rValue", "target", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/AccessTarget;", "receiverValues", "", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "declareParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "declareVariable", "property", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "declareFunction", "declareInlinedFunction", "declareEntryOrObject", "entryOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "loadUnit", "jump", "label", "jumpOnFalse", "conditionValue", "jumpOnTrue", "bindLabel", "nondeterministicJump", "inputValue", "", "jumpToError", "enterTryFinally", "trigger", "Lorg/jetbrains/kotlin/cfg/GenerationTrigger;", "throwException", "throwExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "thrownValue", "exitTryFinally", "repeatPseudocode", "startLabel", "finishLabel", "loadConstant", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/ReadValueInstruction;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "createAnonymousObject", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "createLambda", "Lorg/jetbrains/kotlin/psi/KtFunction;", "loadStringTemplate", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/InstructionWithValue;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "inputValues", "magic", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicInstruction;", "instructionElement", "valueElement", "kind", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MagicKind;", "merge", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/MergeInstruction;", "readVariable", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "call", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/CallInstruction;", "arguments", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "predefinedOperation", "Lorg/jetbrains/kotlin/cfg/pseudocode/instructions/eval/OperationInstruction;", "operation", "Lorg/jetbrains/kotlin/cfg/ControlFlowBuilder$PredefinedOperation;", "getMagicKind", "read", "cfg"})
    @SourceDebugExtension(value={"SMAP\nControlFlowInstructionsGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlFlowInstructionsGenerator.kt\norg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$ControlFlowInstructionsGeneratorWorker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n1#2:433\n*E\n"})
    private final class ControlFlowInstructionsGeneratorWorker
    implements ControlFlowBuilder {
        @NotNull
        private final KtElement returnSubroutine;
        @NotNull
        private final PseudocodeImpl pseudocode;
        @NotNull
        private final Label error;
        @NotNull
        private final Label sink;
        @NotNull
        private final valueFactory.1 valueFactory;

        public ControlFlowInstructionsGeneratorWorker(@NotNull KtElement scopingElement, KtElement returnSubroutine, boolean shouldInline) {
            Intrinsics.checkNotNullParameter((Object)scopingElement, (String)"scopingElement");
            Intrinsics.checkNotNullParameter((Object)returnSubroutine, (String)"returnSubroutine");
            this.returnSubroutine = returnSubroutine;
            this.pseudocode = new PseudocodeImpl(scopingElement, shouldInline);
            this.error = this.pseudocode.createLabel("error", null);
            this.sink = this.pseudocode.createLabel("sink", null);
            this.valueFactory = new PseudoValueFactoryImpl(this){
                final /* synthetic */ ControlFlowInstructionsGeneratorWorker this$0;
                {
                    this.this$0 = $receiver;
                }

                public PseudoValue newValue(KtElement element, InstructionWithValue instruction) {
                    PseudoValue value2 = super.newValue(element, instruction);
                    if (element != null) {
                        this.this$0.bindValue(value2, element);
                    }
                    return value2;
                }
            };
        }

        @Override
        @NotNull
        public KtElement getReturnSubroutine() {
            return this.returnSubroutine;
        }

        @NotNull
        public final PseudocodeImpl getPseudocode() {
            return this.pseudocode;
        }

        private final void add(Instruction instruction) {
            this.pseudocode.addInstruction(instruction);
        }

        @Override
        @NotNull
        public Label createUnboundLabel() {
            StringBuilder stringBuilder = new StringBuilder().append('L');
            int n = ControlFlowInstructionsGenerator.this.labelCount;
            ControlFlowInstructionsGenerator.this.labelCount = n + 1;
            return this.pseudocode.createLabel(stringBuilder.append(n).toString(), null);
        }

        @Override
        @NotNull
        public Label createUnboundLabel(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            StringBuilder stringBuilder = new StringBuilder().append('L');
            int n = ControlFlowInstructionsGenerator.this.labelCount;
            ControlFlowInstructionsGenerator.this.labelCount = n + 1;
            return this.pseudocode.createLabel(stringBuilder.append(n).toString(), name2);
        }

        @Override
        @NotNull
        public LoopInfo enterLoop(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (expression2 instanceof KtDoWhileExpression) {
                Pseudocode pseudocode = this.pseudocode.getRootPseudocode();
                Intrinsics.checkNotNull((Object)pseudocode, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl");
                ((PseudocodeImpl)pseudocode).setContainsDoWhile$cfg(true);
            }
            LoopInfo info = new LoopInfo(expression2, this.createUnboundLabel("loop entry point"), this.createUnboundLabel("loop exit point"), this.createUnboundLabel("body entry point"), this.createUnboundLabel("body exit point"), this.createUnboundLabel("condition entry point"));
            this.bindLabel(info.getEntryPoint());
            ControlFlowInstructionsGenerator.this.elementToLoopInfo.put(expression2, info);
            return info;
        }

        @Override
        public void enterLoopBody(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Object v = ControlFlowInstructionsGenerator.this.elementToLoopInfo.get(expression2);
            Intrinsics.checkNotNull(v);
            LoopInfo info = (LoopInfo)v;
            this.bindLabel(info.getBodyEntryPoint());
            ControlFlowInstructionsGenerator.this.loopInfo.push(info);
            ControlFlowInstructionsGenerator.this.allBlocks.push(info);
        }

        @Override
        public void exitLoopBody(@NotNull KtLoopExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            LoopInfo info = (LoopInfo)ControlFlowInstructionsGenerator.this.loopInfo.pop();
            ControlFlowInstructionsGenerator.this.elementToLoopInfo.remove(expression2);
            ControlFlowInstructionsGenerator.this.allBlocks.pop();
            this.bindLabel(info.getBodyExitPoint());
        }

        @Override
        @Nullable
        public KtLoopExpression getCurrentLoop() {
            return ControlFlowInstructionsGenerator.this.loopInfo.empty() ? null : ((LoopInfo)ControlFlowInstructionsGenerator.this.loopInfo.peek()).getElement();
        }

        @Override
        public void enterSubroutine(@NotNull KtElement subroutine, @Nullable EventOccurrencesRange eventOccurrencesRange) {
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            SubroutineInfo blockInfo = new SubroutineInfo(subroutine, this.createUnboundLabel(), this.createUnboundLabel());
            ControlFlowInstructionsGenerator.this.elementToSubroutineInfo.put(subroutine, blockInfo);
            ControlFlowInstructionsGenerator.this.allBlocks.push(blockInfo);
            this.bindLabel(blockInfo.getEntryPoint());
            this.add(new SubroutineEnterInstruction(subroutine, this.getCurrentScope()));
        }

        @Override
        @NotNull
        public KtElement getCurrentSubroutine() {
            return this.pseudocode.getCorrespondingElement();
        }

        @Override
        @Nullable
        public Label getLoopConditionEntryPoint(@NotNull KtLoopExpression loop) {
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            LoopInfo loopInfo = (LoopInfo)ControlFlowInstructionsGenerator.this.elementToLoopInfo.get(loop);
            return loopInfo != null ? loopInfo.getConditionEntryPoint() : null;
        }

        @Override
        @Nullable
        public Label getLoopExitPoint(@NotNull KtLoopExpression loop) {
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            LoopInfo loopInfo = (LoopInfo)ControlFlowInstructionsGenerator.this.elementToLoopInfo.get(loop);
            return loopInfo != null ? loopInfo.getExitPoint() : null;
        }

        @Override
        @Nullable
        public Label getSubroutineExitPoint(@NotNull KtElement labelElement) {
            Intrinsics.checkNotNullParameter((Object)labelElement, (String)"labelElement");
            SubroutineInfo subroutineInfo = (SubroutineInfo)ControlFlowInstructionsGenerator.this.elementToSubroutineInfo.get(labelElement);
            return subroutineInfo != null ? subroutineInfo.getExitPoint() : null;
        }

        private final BlockScope getCurrentScope() {
            Object t = ControlFlowInstructionsGenerator.this.blockScopes.peek();
            Intrinsics.checkNotNullExpressionValue(t, (String)"peek(...)");
            return (BlockScope)t;
        }

        @Override
        public void enterBlockScope(@NotNull KtElement block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            BlockScope current = ControlFlowInstructionsGenerator.this.blockScopes.isEmpty() ? null : this.getCurrentScope();
            BlockScope scope2 = new BlockScope(current, block);
            ControlFlowInstructionsGenerator.this.blockScopes.push(scope2);
        }

        @Override
        public void exitBlockScope(@NotNull KtElement block) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            BlockScope currentScope = this.getCurrentScope();
            boolean bl2 = bl = currentScope.getBlock() == block;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Exit from not the current block scope.\nCurrent scope is for a block: " + currentScope.getBlock().getText() + ".\nExit from the scope for: " + block.getText();
                throw new AssertionError((Object)string);
            }
            ControlFlowInstructionsGenerator.this.blockScopes.pop();
        }

        private final void handleJumpInsideTryFinally(Label jumpTarget) {
            ArrayList<BlockInfo> finallyBlocks = new ArrayList<BlockInfo>();
            for (BlockInfo blockInfo : CollectionsKt.asReversedMutable((List)ControlFlowInstructionsGenerator.this.allBlocks)) {
                BlockInfo blockInfo2 = blockInfo;
                if (blockInfo2 instanceof BreakableBlockInfo) {
                    if (!((BreakableBlockInfo)blockInfo).getReferablePoints().contains(jumpTarget) && jumpTarget != this.error) continue;
                    Iterator iterator2 = finallyBlocks.iterator();
                    Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                    Iterator iterator3 = iterator2;
                    while (iterator3.hasNext()) {
                        Object e = iterator3.next();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        TryFinallyBlockInfo finallyBlockInfo = (TryFinallyBlockInfo)e;
                        finallyBlockInfo.generateFinallyBlock();
                    }
                    return;
                }
                if (!(blockInfo2 instanceof TryFinallyBlockInfo)) continue;
                finallyBlocks.add(blockInfo);
            }
        }

        @Override
        @NotNull
        public Pseudocode exitSubroutine(@NotNull KtElement subroutine, @Nullable EventOccurrencesRange eventOccurrencesRange) {
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            Label label = this.getSubroutineExitPoint(subroutine);
            if (label != null) {
                Label it = label;
                boolean bl = false;
                this.bindLabel(it);
            }
            this.pseudocode.addExitInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), false));
            this.bindLabel(this.error);
            this.pseudocode.addErrorInstruction(new SubroutineExitInstruction(subroutine, this.getCurrentScope(), true));
            this.bindLabel(this.sink);
            this.pseudocode.addSinkInstruction(new SubroutineSinkInstruction(subroutine, this.getCurrentScope(), "<SINK>"));
            ControlFlowInstructionsGenerator.this.elementToSubroutineInfo.remove(subroutine);
            ControlFlowInstructionsGenerator.this.allBlocks.pop();
            return this.pseudocode;
        }

        @Override
        public void mark(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.add(new MarkInstruction(element, this.getCurrentScope()));
        }

        @Override
        @Nullable
        public PseudoValue getBoundValue(@Nullable KtElement element) {
            return this.pseudocode.getElementValue(element);
        }

        @Override
        public void bindValue(@NotNull PseudoValue value2, @NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.pseudocode.bindElementToValue(element, value2);
        }

        @Override
        @NotNull
        public PseudoValue newValue(@Nullable KtElement element) {
            return this.valueFactory.newValue(element, null);
        }

        @Override
        public void returnValue(@NotNull KtExpression returnExpression, @NotNull PseudoValue returnValue, @NotNull KtElement subroutine) {
            Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
            Intrinsics.checkNotNullParameter((Object)returnValue, (String)"returnValue");
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            Label label = this.getSubroutineExitPoint(subroutine);
            if (label == null) {
                return;
            }
            Label exitPoint = label;
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnValueInstruction(returnExpression, this.getCurrentScope(), exitPoint, returnValue, subroutine));
        }

        @Override
        public void returnNoValue(@NotNull KtReturnExpression returnExpression, @NotNull KtElement subroutine) {
            Intrinsics.checkNotNullParameter((Object)returnExpression, (String)"returnExpression");
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            Label label = this.getSubroutineExitPoint(subroutine);
            if (label == null) {
                return;
            }
            Label exitPoint = label;
            this.handleJumpInsideTryFinally(exitPoint);
            this.add(new ReturnNoValueInstruction(returnExpression, this.getCurrentScope(), exitPoint, subroutine));
        }

        @Override
        public void write(@NotNull KtElement assignment, @NotNull KtElement lValue, @NotNull PseudoValue rValue, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
            Intrinsics.checkNotNullParameter((Object)lValue, (String)"lValue");
            Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter(receiverValues, (String)"receiverValues");
            this.add(new WriteValueInstruction(assignment, this.getCurrentScope(), target, receiverValues, lValue, rValue));
        }

        @Override
        public void declareParameter(@NotNull KtParameter parameter) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            this.add(new VariableDeclarationInstruction(parameter, this.getCurrentScope()));
        }

        @Override
        public void declareVariable(@NotNull KtVariableDeclaration property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            this.add(new VariableDeclarationInstruction(property2, this.getCurrentScope()));
        }

        @Override
        public void declareFunction(@NotNull KtElement subroutine, @NotNull Pseudocode pseudocode) {
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            Intrinsics.checkNotNullParameter((Object)pseudocode, (String)"pseudocode");
            this.add(new LocalFunctionDeclarationInstruction(subroutine, pseudocode, this.getCurrentScope()));
        }

        @Override
        public void declareInlinedFunction(@NotNull KtElement subroutine, @NotNull Pseudocode pseudocode, @NotNull EventOccurrencesRange eventOccurrencesRange) {
            Intrinsics.checkNotNullParameter((Object)subroutine, (String)"subroutine");
            Intrinsics.checkNotNullParameter((Object)pseudocode, (String)"pseudocode");
            Intrinsics.checkNotNullParameter((Object)((Object)eventOccurrencesRange), (String)"eventOccurrencesRange");
            this.add(new InlinedLocalFunctionDeclarationInstruction(subroutine, pseudocode, this.getCurrentScope(), eventOccurrencesRange));
        }

        @Override
        public void declareEntryOrObject(@NotNull KtClassOrObject entryOrObject) {
            Intrinsics.checkNotNullParameter((Object)entryOrObject, (String)"entryOrObject");
            this.add(new VariableDeclarationInstruction(entryOrObject, this.getCurrentScope()));
        }

        @Override
        public void loadUnit(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.add(new LoadUnitValueInstruction(expression2, this.getCurrentScope()));
        }

        @Override
        public void jump(@NotNull Label label, @NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new UnconditionalJumpInstruction(element, label, this.getCurrentScope()));
        }

        @Override
        public void jumpOnFalse(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue conditionValue) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, false, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void jumpOnTrue(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue conditionValue) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new ConditionalJumpInstruction(element, true, this.getCurrentScope(), label, conditionValue));
        }

        @Override
        public void bindLabel(@NotNull Label label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            this.pseudocode.bindLabel((PseudocodeLabel)label);
        }

        @Override
        public void nondeterministicJump(@NotNull Label label, @NotNull KtElement element, @Nullable PseudoValue inputValue) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.handleJumpInsideTryFinally(label);
            this.add(new NondeterministicJumpInstruction(element, CollectionsKt.listOf((Object)label), this.getCurrentScope(), inputValue));
        }

        @Override
        public void nondeterministicJump(@NotNull List<? extends Label> label, @NotNull KtElement element) {
            Intrinsics.checkNotNullParameter(label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.add(new NondeterministicJumpInstruction(element, label, this.getCurrentScope(), null));
        }

        @Override
        public void jumpToError(@NotNull KtElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.handleJumpInsideTryFinally(this.error);
            this.add(new UnconditionalJumpInstruction(element, this.error, this.getCurrentScope()));
        }

        @Override
        public void enterTryFinally(@NotNull GenerationTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            ControlFlowInstructionsGenerator.this.allBlocks.push(new TryFinallyBlockInfo(trigger));
        }

        @Override
        public void throwException(@NotNull KtThrowExpression throwExpression, @NotNull PseudoValue thrownValue) {
            Intrinsics.checkNotNullParameter((Object)throwExpression, (String)"throwExpression");
            Intrinsics.checkNotNullParameter((Object)thrownValue, (String)"thrownValue");
            this.handleJumpInsideTryFinally(this.error);
            this.add(new ThrowExceptionInstruction(throwExpression, this.getCurrentScope(), this.error, thrownValue));
        }

        @Override
        public void exitTryFinally() {
            BlockInfo pop = (BlockInfo)ControlFlowInstructionsGenerator.this.allBlocks.pop();
            boolean bl = pop instanceof TryFinallyBlockInfo;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @Override
        public void repeatPseudocode(@NotNull Label startLabel, @NotNull Label finishLabel) {
            Intrinsics.checkNotNullParameter((Object)startLabel, (String)"startLabel");
            Intrinsics.checkNotNullParameter((Object)finishLabel, (String)"finishLabel");
            ControlFlowInstructionsGenerator.this.labelCount = this.pseudocode.repeatPart(startLabel, finishLabel, ControlFlowInstructionsGenerator.this.labelCount);
        }

        @Override
        @NotNull
        public ReadValueInstruction loadConstant(@NotNull KtExpression expression2, @Nullable CompileTimeConstant<?> constant) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null);
        }

        @Override
        @NotNull
        public ReadValueInstruction createAnonymousObject(@NotNull KtObjectLiteralExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null);
        }

        @Override
        @NotNull
        public ReadValueInstruction createLambda(@NotNull KtFunction expression2) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (expression2 instanceof KtFunctionLiteral) {
                PsiElement psiElement = ((KtFunctionLiteral)expression2).getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtLambdaExpression");
                ktExpression = (KtLambdaExpression)psiElement;
            } else {
                ktExpression = expression2;
            }
            return ControlFlowInstructionsGeneratorWorker.read$default(this, ktExpression, null, null, 6, null);
        }

        @Override
        @NotNull
        public InstructionWithValue loadStringTemplate(@NotNull KtStringTemplateExpression expression2, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(inputValues, (String)"inputValues");
            return inputValues.isEmpty() ? (InstructionWithValue)ControlFlowInstructionsGeneratorWorker.read$default(this, expression2, null, null, 6, null) : (InstructionWithValue)this.magic(expression2, expression2, inputValues, MagicKind.STRING_TEMPLATE);
        }

        @Override
        @NotNull
        public MagicInstruction magic(@NotNull KtElement instructionElement, @Nullable KtElement valueElement, @NotNull List<? extends PseudoValue> inputValues, @NotNull MagicKind kind) {
            Intrinsics.checkNotNullParameter((Object)instructionElement, (String)"instructionElement");
            Intrinsics.checkNotNullParameter(inputValues, (String)"inputValues");
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            MagicInstruction instruction = new MagicInstruction(instructionElement, valueElement, this.getCurrentScope(), inputValues, kind, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public MergeInstruction merge(@NotNull KtExpression expression2, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(inputValues, (String)"inputValues");
            MergeInstruction instruction = new MergeInstruction(expression2, this.getCurrentScope(), inputValues, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public ReadValueInstruction readVariable(@NotNull KtExpression expression2, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter(receiverValues, (String)"receiverValues");
            return this.read(expression2, resolvedCall2, receiverValues);
        }

        @Override
        @NotNull
        public CallInstruction call(@NotNull KtElement valueElement, @NotNull ResolvedCall<?> resolvedCall2, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues, @NotNull Map<PseudoValue, ? extends ValueParameterDescriptor> arguments) {
            Intrinsics.checkNotNullParameter((Object)valueElement, (String)"valueElement");
            Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter(receiverValues, (String)"receiverValues");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            CallInstruction instruction = new CallInstruction(valueElement, this.getCurrentScope(), resolvedCall2, receiverValues, arguments, this.valueFactory);
            this.add(instruction);
            return instruction;
        }

        @Override
        @NotNull
        public OperationInstruction predefinedOperation(@NotNull KtExpression expression2, @NotNull ControlFlowBuilder.PredefinedOperation operation, @NotNull List<? extends PseudoValue> inputValues) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
            Intrinsics.checkNotNullParameter(inputValues, (String)"inputValues");
            return this.magic(expression2, expression2, inputValues, this.getMagicKind(operation));
        }

        private final MagicKind getMagicKind(ControlFlowBuilder.PredefinedOperation operation) {
            MagicKind magicKind;
            switch (WhenMappings.$EnumSwitchMapping$0[operation.ordinal()]) {
                case 1: {
                    magicKind = MagicKind.AND;
                    break;
                }
                case 2: {
                    magicKind = MagicKind.OR;
                    break;
                }
                case 3: {
                    magicKind = MagicKind.NOT_NULL_ASSERTION;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return magicKind;
        }

        @Override
        @NotNull
        public ReadValueInstruction read(@NotNull KtElement element, @NotNull AccessTarget target, @NotNull Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            ReadValueInstruction readValueInstruction;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter(receiverValues, (String)"receiverValues");
            ReadValueInstruction $this$read_u24lambda_u240 = readValueInstruction = new ReadValueInstruction(element, this.getCurrentScope(), target, receiverValues, this.valueFactory);
            boolean bl = false;
            this.add($this$read_u24lambda_u240);
            return readValueInstruction;
        }

        private final ReadValueInstruction read(KtExpression expression2, ResolvedCall<?> resolvedCall2, Map<PseudoValue, ? extends ReceiverValue> receiverValues) {
            return this.read((KtElement)expression2, resolvedCall2 != null ? (AccessTarget)new AccessTarget.Call(resolvedCall2) : (AccessTarget)AccessTarget.BlackBox.INSTANCE, receiverValues);
        }

        static /* synthetic */ ReadValueInstruction read$default(ControlFlowInstructionsGeneratorWorker controlFlowInstructionsGeneratorWorker, KtExpression ktExpression, ResolvedCall resolvedCall2, Map map, int n, Object object) {
            if ((n & 2) != 0) {
                resolvedCall2 = null;
            }
            if ((n & 4) != 0) {
                map = MapsKt.emptyMap();
            }
            return controlFlowInstructionsGeneratorWorker.read(ktExpression, resolvedCall2, (Map<PseudoValue, ? extends ReceiverValue>)map);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ControlFlowBuilder.PredefinedOperation.values().length];
                try {
                    nArray[ControlFlowBuilder.PredefinedOperation.AND.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlFlowBuilder.PredefinedOperation.OR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ControlFlowBuilder.PredefinedOperation.NOT_NULL_ASSERTION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cfg/pseudocode/ControlFlowInstructionsGenerator$TryFinallyBlockInfo;", "Lorg/jetbrains/kotlin/cfg/BlockInfo;", "finallyBlock", "Lorg/jetbrains/kotlin/cfg/GenerationTrigger;", "<init>", "(Lorg/jetbrains/kotlin/cfg/GenerationTrigger;)V", "generateFinallyBlock", "", "cfg"})
    private static final class TryFinallyBlockInfo
    extends BlockInfo {
        @NotNull
        private final GenerationTrigger finallyBlock;

        public TryFinallyBlockInfo(@NotNull GenerationTrigger finallyBlock) {
            Intrinsics.checkNotNullParameter((Object)finallyBlock, (String)"finallyBlock");
            this.finallyBlock = finallyBlock;
        }

        public final void generateFinallyBlock() {
            this.finallyBlock.generate();
        }
    }
}

