/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.jvm;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.backend.common.actualizer.IrActualizedResult;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.common.modules.ModuleChunk;
import org.jetbrains.kotlin.cli.jvm.compiler.CliCompilerUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmBackendPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmFir2IrPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmPipelineUtilsKt;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmBackendClassResolver;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmBackendExtension;
import org.jetbrains.kotlin.fir.backend.utils.VariousUtilsKt;
import org.jetbrains.kotlin.fir.pipeline.Fir2IrActualizedResult;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrModuleFragmentImpl;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmBackendPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmFir2IrPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmBackendPipelineArtifact;", "<init>", "()V", "executePhase", "input", "cli"})
@SourceDebugExtension(value={"SMAP\nJvmBackendPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/jvm/JvmBackendPipelinePhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n873#2,2:103\n*S KotlinDebug\n*F\n+ 1 JvmBackendPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/jvm/JvmBackendPipelinePhase\n*L\n63#1:103,2\n*E\n"})
public final class JvmBackendPipelinePhase
extends PipelinePhase<JvmFir2IrPipelineArtifact, JvmBackendPipelineArtifact> {
    @NotNull
    public static final JvmBackendPipelinePhase INSTANCE = new JvmBackendPipelinePhase();

    private JvmBackendPipelinePhase() {
        super("JvmBackendPipelineStep", null, SetsKt.setOf((Object)CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE), 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public JvmBackendPipelineArtifact executePhase(@NotNull JvmFir2IrPipelineArtifact input) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Fir2IrActualizedResult fir2IrResult = input.component1();
        CompilerConfiguration configuration = input.component2();
        VfsBasedProjectEnvironment environment = input.component3();
        BaseDiagnosticsCollector diagnosticCollector = input.component4();
        List<KtSourceFile> allSourceFiles = input.component5();
        FqName mainClassFqName = input.component6();
        ModuleDescriptor moduleDescriptor = fir2IrResult.getIrModuleFragment().getDescriptor();
        Project project = environment.getProject();
        FirJvmBackendClassResolver classResolver = new FirJvmBackendClassResolver(fir2IrResult.getComponents());
        FirJvmBackendExtension jvmBackendExtension = new FirJvmBackendExtension(fir2IrResult.getComponents(), (object = fir2IrResult.getIrActualizedResult()) != null && (object = ((IrActualizedResult)object).getActualizedExpectDeclarations()) != null ? VariousUtilsKt.extractFirDeclarations((List<? extends IrDeclaration>)object) : null);
        JvmIrCodegenFactory.BackendInput baseBackendInput = KotlinToJVMBytecodeCompiler.INSTANCE.toBackendInput$cli(fir2IrResult, configuration, jvmBackendExtension);
        JvmIrCodegenFactory codegenFactory = new JvmIrCodegenFactory(configuration, null, null, null, null, null, 62, null);
        ModuleChunk moduleChunk = CLIConfigurationKeysKt.getModuleChunk(configuration);
        Intrinsics.checkNotNull((Object)moduleChunk);
        List<Module> list = moduleChunk.getModules();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getModules(...)");
        List<Module> chunk = list;
        VirtualFileSystem localFileSystem = VirtualFileManager.getInstance().getFileSystem("file");
        ArrayList codegenInputs = new ArrayList(chunk.size());
        File buildFile = CLIConfigurationKeysKt.getBuildFile(configuration);
        for (Module module2 : chunk) {
            JvmIrCodegenFactory.BackendInput backendInput;
            CompilerConfiguration compilerConfiguration;
            if (chunk.size() == 1) {
                compilerConfiguration = configuration;
            } else {
                Intrinsics.checkNotNull((Object)module2);
                compilerConfiguration = CoreEnvironmentUtilsKt.createConfigurationForModule(configuration, module2, buildFile);
            }
            CompilerConfiguration configurationForModule = compilerConfiguration;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            boolean bl = CommonConfigurationKeysKt.getUseLightTree(configurationForModule);
            if (bl) {
                if (chunk.size() == 1) {
                    backendInput = baseBackendInput;
                } else {
                    void $this$filterTo$iv;
                    IrModuleFragment wholeModule = baseBackendInput.getIrModuleFragment();
                    IrModuleFragmentImpl moduleCopy = new IrModuleFragmentImpl(wholeModule.getDescriptor());
                    Iterable iterable = wholeModule.getFiles();
                    Collection destination$iv = moduleCopy.getFiles();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv : $this$filterTo$iv) {
                        IrFile file = (IrFile)element$iv;
                        boolean bl2 = false;
                        if (!module2.getSourceFiles().contains(file.getFileEntry().getName())) continue;
                        destination$iv.add(element$iv);
                    }
                    backendInput = JvmIrCodegenFactory.BackendInput.copy$default(baseBackendInput, moduleCopy, null, null, null, null, null, null, 126, null);
                }
            } else if (!bl) {
                Intrinsics.checkNotNull((Object)module2);
                List<KtFile> sourceFiles = CliCompilerUtilsKt.getSourceFiles(module2, JvmPipelineUtilsKt.asKtFilesList(allSourceFiles), localFileSystem, chunk.size() > 1, buildFile);
                backendInput = codegenFactory.getModuleChunkBackendInput(baseBackendInput, (Collection<? extends KtFile>)sourceFiles);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JvmIrCodegenFactory.BackendInput backendInput2 = backendInput;
            ((Collection)codegenInputs).add(KotlinToJVMBytecodeCompiler.INSTANCE.runLowerings$cli(project, configurationForModule, moduleDescriptor, module2, codegenFactory, backendInput2, diagnosticCollector, classResolver));
        }
        ArrayList outputs = new ArrayList(chunk.size());
        Iterator iterator2 = codegenInputs.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            JvmIrCodegenFactory.CodegenInput input2 = (JvmIrCodegenFactory.CodegenInput)e;
            ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
            ((Collection)outputs).add(KotlinToJVMBytecodeCompiler.INSTANCE.runCodegen$cli(input2, input2.getState(), codegenFactory, diagnosticCollector, input2.getState().getConfiguration(), false));
        }
        return new JvmBackendPipelineArtifact(configuration, environment, diagnosticCollector, mainClassFqName, outputs);
    }
}

