/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassInitializer;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceListElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTemplateExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiThrowStatement;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.JavaPsiConstructorUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class UnhandledExceptions {
    public static final UnhandledExceptions EMPTY = new UnhandledExceptions(Collections.emptySet(), false);
    public static final UnhandledExceptions UNKNOWN = new UnhandledExceptions(Collections.emptySet(), true);
    private final Set<PsiClassType> exceptions;
    private final boolean hasUnresolvedCalls;

    private UnhandledExceptions(@NotNull Set<PsiClassType> exceptions, boolean hasUnresolvedCalls) {
        if (exceptions == null) {
            UnhandledExceptions.$$$reportNull$$$0(0);
        }
        this.exceptions = exceptions;
        this.hasUnresolvedCalls = hasUnresolvedCalls;
    }

    public Set<PsiClassType> exceptions() {
        return this.exceptions;
    }

    public boolean hasUnresolvedCalls() {
        return this.hasUnresolvedCalls;
    }

    @NotNull
    static UnhandledExceptions from(@Nullable Collection<PsiClassType> exceptions, boolean hasUnresolvedCalls) {
        if (exceptions == null || exceptions.isEmpty()) {
            UnhandledExceptions unhandledExceptions = hasUnresolvedCalls ? UNKNOWN : EMPTY;
            if (unhandledExceptions == null) {
                UnhandledExceptions.$$$reportNull$$$0(1);
            }
            return unhandledExceptions;
        }
        return new UnhandledExceptions((Set<PsiClassType>)(exceptions instanceof Set ? (Set<Object>)exceptions : new HashSet<PsiClassType>(exceptions)), hasUnresolvedCalls);
    }

    @NotNull
    private UnhandledExceptions withUnresolvedCalls(boolean unresolvedCalls) {
        return unresolvedCalls == this.hasUnresolvedCalls ? this : new UnhandledExceptions(this.exceptions, unresolvedCalls);
    }

    @NotNull
    public UnhandledExceptions merge(@NotNull UnhandledExceptions other) {
        boolean unresolvedCalls;
        if (other == null) {
            UnhandledExceptions.$$$reportNull$$$0(2);
        }
        boolean bl = unresolvedCalls = this.hasUnresolvedCalls || other.hasUnresolvedCalls;
        if (this.exceptions.isEmpty()) {
            return other.withUnresolvedCalls(unresolvedCalls);
        }
        if (other.exceptions.isEmpty()) {
            return this.withUnresolvedCalls(unresolvedCalls);
        }
        return new UnhandledExceptions(ContainerUtil.union(this.exceptions, other.exceptions), unresolvedCalls);
    }

    @NotNull
    static UnhandledExceptions collect(@NotNull PsiElement element, @Nullable PsiElement topElement, @NotNull Predicate<? super PsiCall> callFilter) {
        if (element == null) {
            UnhandledExceptions.$$$reportNull$$$0(3);
        }
        if (callFilter == null) {
            UnhandledExceptions.$$$reportNull$$$0(4);
        }
        Collection<PsiClassType> unhandledExceptions = null;
        boolean hasUnresolvedCalls = false;
        if (element instanceof PsiCallExpression) {
            PsiCallExpression expression2 = (PsiCallExpression)element;
            unhandledExceptions = ExceptionUtil.getUnhandledExceptions(expression2, topElement, callFilter);
            if (!MethodCandidateInfo.isOverloadCheck() && expression2.resolveMethodGenerics() == JavaResolveResult.EMPTY && !UnhandledExceptions.isNonMethodNewExpression(expression2)) {
                hasUnresolvedCalls = true;
            }
        } else if (element instanceof PsiTemplateExpression) {
            unhandledExceptions = ExceptionUtil.getUnhandledProcessorExceptions((PsiTemplateExpression)element, topElement);
        } else {
            List<PsiClassType> unhandled;
            if (element instanceof PsiMethodReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiMethodReferenceExpression)element).getQualifierExpression();
                UnhandledExceptions unhandledExceptions2 = qualifierExpression != null ? UnhandledExceptions.collect((PsiElement)qualifierExpression, topElement, callFilter) : EMPTY;
                if (unhandledExceptions2 == null) {
                    UnhandledExceptions.$$$reportNull$$$0(5);
                }
                return unhandledExceptions2;
            }
            if (element instanceof PsiLambdaExpression) {
                UnhandledExceptions unhandledExceptions3 = EMPTY;
                if (unhandledExceptions3 == null) {
                    UnhandledExceptions.$$$reportNull$$$0(6);
                }
                return unhandledExceptions3;
            }
            if (element instanceof PsiThrowStatement) {
                PsiThrowStatement statement = (PsiThrowStatement)element;
                unhandledExceptions = ExceptionUtil.getUnhandledExceptions(statement, topElement);
            } else if (element instanceof PsiCodeBlock && element.getParent() instanceof PsiMethod && ((PsiMethod)element.getParent()).isConstructor() && JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)element.getParent()) == null) {
                PsiMethod constructor = (PsiMethod)element.getParent();
                PsiClass aClass = constructor.getContainingClass();
                PsiClass superClass = aClass == null ? null : aClass.getSuperClass();
                PsiMethod[] superConstructors = superClass == null ? PsiMethod.EMPTY_ARRAY : superClass.getConstructors();
                HashSet<PsiClassType> unhandled2 = new HashSet<PsiClassType>();
                for (PsiMethod superConstructor : superConstructors) {
                    PsiClassType[] exceptionTypes;
                    if (superConstructor.hasModifierProperty("private") || !superConstructor.getParameterList().isEmpty()) continue;
                    for (PsiClassType exceptionType : exceptionTypes = superConstructor.getThrowsList().getReferencedTypes()) {
                        if (ExceptionUtil.isUncheckedException(exceptionType) || ExceptionUtil.getHandlePlace(element, exceptionType, topElement) != ExceptionUtil.HandlePlace.UNHANDLED) continue;
                        unhandled2.add(exceptionType);
                    }
                    break;
                }
                if (aClass != null) {
                    PsiClassInitializer[] initializers;
                    for (PsiClassInitializer initializer : initializers = aClass.getInitializers()) {
                        if (initializer.hasModifierProperty("static")) continue;
                        UnhandledExceptions byInitializer = UnhandledExceptions.collect((PsiElement)initializer.getBody(), (PsiElement)initializer, callFilter);
                        for (PsiClassType thrown : byInitializer.exceptions()) {
                            if (ExceptionUtil.getHandlePlace(constructor.getBody(), thrown, topElement) != ExceptionUtil.HandlePlace.UNHANDLED) continue;
                            unhandled2.add(thrown);
                        }
                        hasUnresolvedCalls |= byInitializer.hasUnresolvedCalls();
                    }
                }
                unhandledExceptions = unhandled2;
            } else if (element instanceof PsiResourceListElement && !(unhandled = ExceptionUtil.getUnhandledCloserExceptions((PsiResourceListElement)element, topElement)).isEmpty()) {
                unhandledExceptions = new HashSet<PsiClassType>(unhandled);
            }
        }
        UnhandledExceptions exceptions = UnhandledExceptions.from(unhandledExceptions, hasUnresolvedCalls);
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            UnhandledExceptions foundInChild = UnhandledExceptions.collect(child, topElement, callFilter);
            exceptions = exceptions.merge(foundInChild);
        }
        UnhandledExceptions unhandledExceptions4 = exceptions;
        if (unhandledExceptions4 == null) {
            UnhandledExceptions.$$$reportNull$$$0(7);
        }
        return unhandledExceptions4;
    }

    private static boolean isNonMethodNewExpression(PsiCallExpression expression2) {
        if (!(expression2 instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression2;
        if (newExpression.isArrayCreation()) {
            return true;
        }
        PsiExpressionList list = newExpression.getArgumentList();
        if (list == null || !list.isEmpty()) {
            return false;
        }
        PsiJavaCodeReferenceElement reference2 = newExpression.getClassReference();
        return reference2 != null && reference2.resolve() instanceof PsiClass;
    }

    @NotNull
    static UnhandledExceptions collect(@NotNull PsiElement element, @Nullable PsiElement topElement, boolean includeSelfCalls) {
        if (element == null) {
            UnhandledExceptions.$$$reportNull$$$0(10);
        }
        @NotNull Predicate<PsiCall> callFilter = includeSelfCalls ? c -> false : expression2 -> {
            PsiMethod method = expression2.resolveMethod();
            if (method == null) {
                return false;
            }
            return method == PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class);
        };
        return UnhandledExceptions.collect(element, topElement, callFilter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/UnhandledExceptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/UnhandledExceptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "fromTryStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ofMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fromTryStatement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

