/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.ide.plugins.BrokenPluginFileKt;
import org.jetbrains.kotlin.com.intellij.ide.plugins.DisabledPluginsState;
import org.jetbrains.kotlin.com.intellij.ide.plugins.ExpiredPluginsState;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import org.jetbrains.kotlin.com.intellij.ide.plugins.MyXmlInterner;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginDescriptorsDebugData;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.ide.plugins.ReadModuleContext;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;
import org.jetbrains.kotlin.com.intellij.util.xml.dom.XmlInterner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u0083\u0001\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u001e\b\u0002\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u0018\u00010\t\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010%\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0$0&H\u0000\u00a2\u0006\u0002\b'J\u001f\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\b\u0010:\u001a\u0004\u0018\u00010;H\u0000\u00a2\u0006\u0002\b<J\u000e\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0006J\u0016\u0010?\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u00062\u0006\u0010@\u001a\u00020AJ\u000e\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020AJ\b\u0010F\u001a\u000207H\u0016J\u0016\u0010J\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\n2\u0006\u0010@\u001a\u00020LR\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0015R\u0010\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001c\u0010\u0018R/\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00050\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001a\u001a\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0$0#8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010+0*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010,\u001aF\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010+ .*\f\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010*0* .*\"\u0012\u001c\u0012\u001a\u0012\u0006\u0012\u0004\u0018\u00010+ .*\f\u0012\u0006\u0012\u0004\u0018\u00010+\u0018\u00010*0*\u0018\u00010-0-X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010/R$\u00101\u001a\u0004\u0018\u00010\n2\b\u00100\u001a\u0004\u0018\u00010\n8F@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001c\u00104\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0006\u0018\u000105X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\u00020C8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0&8F\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0012\u0010M\u001a\u0004\u0018\u00010N8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/DescriptorListLoadingContext;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/ReadModuleContext;", "customDisabledPlugins", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "customExpiredPlugins", "customBrokenPluginVersions", "", "", "productBuildNumber", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/BuildNumber;", "isMissingIncludeIgnored", "", "isMissingSubDescriptorIgnored", "checkOptionalConfigFileUniqueness", "transient", "<init>", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;Lkotlin/jvm/functions/Function0;ZZZZ)V", "()Z", "disabledPlugins", "getDisabledPlugins", "()Ljava/util/Set;", "disabledPlugins$delegate", "Lkotlin/Lazy;", "expiredPlugins", "getExpiredPlugins", "expiredPlugins$delegate", "brokenPluginVersions", "getBrokenPluginVersions", "()Ljava/util/Map;", "brokenPluginVersions$delegate", "globalErrors", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/util/function/Supplier;", "copyGlobalErrors", "", "copyGlobalErrors$intellij_platform_core_impl", "toDispose", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/MyXmlInterner;", "threadLocalXmlFactory", "Ljava/lang/ThreadLocal;", "kotlin.jvm.PlatformType", "Ljava/lang/ThreadLocal;", "value", "defaultVersion", "getDefaultVersion", "()Ljava/lang/String;", "optionalConfigNames", "", "reportCannotLoad", "", "file", "Ljava/nio/file/Path;", "e", "", "reportCannotLoad$intellij_platform_core_impl", "isPluginDisabled", "id", "isBroken", "descriptor", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptorImpl;", "interner", "Lorg/jetbrains/kotlin/com/intellij/util/xml/dom/XmlInterner;", "getInterner", "()Lcom/intellij/util/xml/dom/XmlInterner;", "close", "visitedFiles", "getVisitedFiles", "()Ljava/util/List;", "checkOptionalConfigShortName", "configFile", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "debugData", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginDescriptorsDebugData;", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class DescriptorListLoadingContext
implements ReadModuleContext,
AutoCloseable {
    @Nullable
    private final Set<PluginId> customDisabledPlugins;
    @Nullable
    private final Set<PluginId> customExpiredPlugins;
    @Nullable
    private final Map<PluginId, Set<String>> customBrokenPluginVersions;
    @JvmField
    @NotNull
    public final Function0<BuildNumber> productBuildNumber;
    private final boolean isMissingIncludeIgnored;
    @JvmField
    public final boolean isMissingSubDescriptorIgnored;
    @JvmField
    public final boolean transient;
    @NotNull
    private final Lazy disabledPlugins$delegate;
    @NotNull
    private final Lazy expiredPlugins$delegate;
    @NotNull
    private final Lazy brokenPluginVersions$delegate;
    @JvmField
    @NotNull
    public final CopyOnWriteArrayList<Supplier<String>> globalErrors;
    @NotNull
    private final ConcurrentLinkedQueue<MyXmlInterner[]> toDispose;
    private final ThreadLocal<MyXmlInterner[]> threadLocalXmlFactory;
    @Nullable
    private volatile String defaultVersion;
    @Nullable
    private final Map<String, PluginId> optionalConfigNames;
    @JvmField
    @Nullable
    public final PluginDescriptorsDebugData debugData;

    public DescriptorListLoadingContext(@Nullable Set<PluginId> customDisabledPlugins, @Nullable Set<PluginId> customExpiredPlugins, @Nullable Map<PluginId, ? extends Set<String>> customBrokenPluginVersions, @NotNull Function0<BuildNumber> productBuildNumber, boolean isMissingIncludeIgnored, boolean isMissingSubDescriptorIgnored, boolean checkOptionalConfigFileUniqueness, boolean bl) {
        Intrinsics.checkNotNullParameter(productBuildNumber, (String)"productBuildNumber");
        this.customDisabledPlugins = customDisabledPlugins;
        this.customExpiredPlugins = customExpiredPlugins;
        this.customBrokenPluginVersions = customBrokenPluginVersions;
        this.productBuildNumber = productBuildNumber;
        this.isMissingIncludeIgnored = isMissingIncludeIgnored;
        this.isMissingSubDescriptorIgnored = isMissingSubDescriptorIgnored;
        this.transient = bl;
        this.disabledPlugins$delegate = LazyKt.lazy(() -> DescriptorListLoadingContext.disabledPlugins_delegate$lambda$1(this));
        this.expiredPlugins$delegate = LazyKt.lazy(() -> DescriptorListLoadingContext.expiredPlugins_delegate$lambda$2(this));
        this.brokenPluginVersions$delegate = LazyKt.lazy(() -> DescriptorListLoadingContext.brokenPluginVersions_delegate$lambda$3(this));
        this.globalErrors = new CopyOnWriteArrayList();
        this.toDispose = new ConcurrentLinkedQueue();
        this.threadLocalXmlFactory = ThreadLocal.withInitial(() -> DescriptorListLoadingContext.threadLocalXmlFactory$lambda$4(this));
        this.optionalConfigNames = checkOptionalConfigFileUniqueness ? (Map)new ConcurrentHashMap() : null;
        this.debugData = Boolean.parseBoolean(System.getProperty("intellij.platform.plugins.record.debug.data.for.descriptors")) ? new PluginDescriptorsDebugData() : null;
    }

    public /* synthetic */ DescriptorListLoadingContext(Set set, Set set2, Map map, Function0 function0, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = null;
        }
        if ((n & 2) != 0) {
            set2 = null;
        }
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 8) != 0) {
            function0 = DescriptorListLoadingContext::_init_$lambda$0;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            bl3 = false;
        }
        if ((n & 0x80) != 0) {
            bl4 = false;
        }
        this(set, set2, map, (Function0<BuildNumber>)function0, bl, bl2, bl3, bl4);
    }

    @Override
    public boolean isMissingIncludeIgnored() {
        return this.isMissingIncludeIgnored;
    }

    @NotNull
    public final Set<PluginId> getDisabledPlugins() {
        Lazy lazy = this.disabledPlugins$delegate;
        return (Set)lazy.getValue();
    }

    private final Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Lazy lazy = this.brokenPluginVersions$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String getDefaultVersion() {
        String result2 = this.defaultVersion;
        if (result2 == null) {
            this.defaultVersion = result2 = ((BuildNumber)this.productBuildNumber.invoke()).asStringWithoutProductCode();
        }
        return result2;
    }

    public final void reportCannotLoad$intellij_platform_core_impl(@NotNull Path file, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PluginManagerCore.getLogger().warn("Cannot load " + file, e);
        this.globalErrors.add(() -> DescriptorListLoadingContext.reportCannotLoad$lambda$5(file));
    }

    public final boolean isPluginDisabled(@NotNull PluginId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return !Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)id) && this.getDisabledPlugins().contains(id);
    }

    public final boolean isBroken(@NotNull IdeaPluginDescriptorImpl descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Set<String> set = this.getBrokenPluginVersions().get(descriptor.getPluginId());
        if (set == null) {
            return false;
        }
        return set.contains(descriptor.getVersion());
    }

    @Override
    @NotNull
    public XmlInterner getInterner() {
        MyXmlInterner myXmlInterner = this.threadLocalXmlFactory.get()[0];
        Intrinsics.checkNotNull((Object)myXmlInterner);
        return myXmlInterner;
    }

    @Override
    public void close() {
        Iterator<MyXmlInterner[]> iterator2 = this.toDispose.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<MyXmlInterner[]> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            MyXmlInterner[] ref = iterator3.next();
            ref[0] = null;
        }
    }

    @NotNull
    public final List<String> getVisitedFiles() {
        MyXmlInterner myXmlInterner = this.threadLocalXmlFactory.get()[0];
        Intrinsics.checkNotNull((Object)myXmlInterner);
        return myXmlInterner.visitedFiles;
    }

    public final boolean checkOptionalConfigShortName(@NotNull String configFile, @NotNull IdeaPluginDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Map<String, PluginId> configNames = this.optionalConfigNames;
        if (configNames == null || StringsKt.startsWith$default((String)configFile, (String)"intellij.", (boolean)false, (int)2, null)) {
            return false;
        }
        PluginId pluginId = descriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        PluginId pluginId2 = pluginId;
        PluginId oldPluginId = configNames.put(configFile, pluginId2);
        if (oldPluginId == null || Intrinsics.areEqual((Object)oldPluginId, (Object)pluginId2)) {
            return false;
        }
        PluginManagerCore.getLogger().error("Optional config file with name " + configFile + " already registered by " + oldPluginId + ". Please rename to ensure that lookup in the classloader by short name returns correct optional config. Current plugin: " + descriptor + '.');
        return true;
    }

    private static final BuildNumber _init_$lambda$0() {
        return PluginManagerCore.getBuildNumber();
    }

    private static final Set disabledPlugins_delegate$lambda$1(DescriptorListLoadingContext this$0) {
        Set<PluginId> set = this$0.customDisabledPlugins;
        if (set == null) {
            set = DisabledPluginsState.Companion.getDisabledIds();
        }
        return set;
    }

    private static final Set expiredPlugins_delegate$lambda$2(DescriptorListLoadingContext this$0) {
        Set<PluginId> set = this$0.customExpiredPlugins;
        if (set == null) {
            set = ExpiredPluginsState.Companion.getExpiredPluginIds();
        }
        return set;
    }

    private static final Map brokenPluginVersions_delegate$lambda$3(DescriptorListLoadingContext this$0) {
        Map<PluginId, Set<String>> map = this$0.customBrokenPluginVersions;
        if (map == null) {
            map = BrokenPluginFileKt.getBrokenPluginVersions();
        }
        return map;
    }

    private static final MyXmlInterner[] threadLocalXmlFactory$lambda$4(DescriptorListLoadingContext this$0) {
        MyXmlInterner factory = new MyXmlInterner();
        MyXmlInterner[] myXmlInternerArray = new MyXmlInterner[]{factory};
        MyXmlInterner[] ref = myXmlInternerArray;
        this$0.toDispose.add(ref);
        return ref;
    }

    private static final String reportCannotLoad$lambda$5(Path $file) {
        Object[] objectArray = new Object[]{IdeaPluginDescriptorImplKt.pluginPathToUserString($file)};
        return CoreBundle.message("plugin.loading.error.text.file.contains.invalid.plugin.descriptor", objectArray);
    }

    public DescriptorListLoadingContext() {
        this(null, null, null, null, false, false, false, false, 255, null);
    }
}

