/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginEnabler;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCoreKt;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.kotlin.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.EarlyAccessRegistryManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/DisabledPluginsState;", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/PluginEnabler$Headless;", "<init>", "()V", "isIgnoredDisabledPlugins", "", "setIgnoredDisabledPlugins", "", "ignoredDisabledPlugins", "isDisabled", "pluginId", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "enable", "descriptors", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "disable", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class DisabledPluginsState
implements PluginEnabler.Headless {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String DISABLED_PLUGINS_CUSTOM_FILE_PATH = System.getProperty("disabled.plugins.file.path");
    @Nullable
    private static volatile Set<PluginId> disabledPlugins;
    @NotNull
    private static final CopyOnWriteArrayList<Runnable> ourDisabledPluginListeners;
    private static volatile boolean isDisabledStateIgnored;

    @Override
    public boolean isIgnoredDisabledPlugins() {
        return isDisabledStateIgnored;
    }

    @Override
    public void setIgnoredDisabledPlugins(boolean ignoredDisabledPlugins) {
        isDisabledStateIgnored = ignoredDisabledPlugins;
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList();
        isDisabledStateIgnored = EarlyAccessRegistryManager.INSTANCE.getBoolean("idea.ignore.disabled.plugins");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000fJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010!\u001a\u00020\u0013J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010$\u001a\u00020\u00112\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u0011H\u0001J#\u0010$\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010(\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b*J\u0014\u0010+\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001e\u0010,\u001a\u00020\u00112\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010-\u001a\u00020\u0011H\u0002J \u0010+\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00132\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0007J\u0006\u0010-\u001a\u00020\u001cJ\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00101\u001a\u00020\u0005H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0018\u0010\u0003\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/DisabledPluginsState$Companion;", "", "<init>", "()V", "DISABLED_PLUGINS_CUSTOM_FILE_PATH", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "DISABLED_PLUGINS_FILENAME", "Lorg/jetbrains/annotations/NonNls;", "disabledPlugins", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId;", "ourDisabledPluginListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "isDisabledStateIgnored", "", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "logger", "Lorg/jetbrains/kotlin/com/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "addDisablePluginListener", "", "listener", "removeDisablePluginListener", "getRequiredPlugins", "loadDisabledPlugins", "path", "getSuppressedPluginsSet", "getDisabledIds", "setEnabledState", "descriptors", "", "Lorg/jetbrains/kotlin/com/intellij/ide/plugins/IdeaPluginDescriptor;", "enabled", "pluginIds", "setEnabledStateForIds", "saveDisabledPluginsAndInvalidate", "trySaveDisabledPlugins", "invalidate", "configPath", "", "splitByComma", "key", "intellij.platform.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDisabledPluginsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n1#3:197\n*S KotlinDebug\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n*L\n87#1:194\n87#1:195,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            if (DISABLED_PLUGINS_CUSTOM_FILE_PATH != null) {
                Path path = Paths.get(DISABLED_PLUGINS_CUSTOM_FILE_PATH, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return path;
            }
            Path path = PathManager.getConfigDir().resolve("disabled_plugins.txt");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @NotNull
        public final Set<PluginId> getRequiredPlugins() {
            return this.splitByComma("idea.required.plugins.id");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Set<PluginId> loadDisabledPlugins(@NotNull Path path) {
            Set<PluginId> suppressedPluginsSet;
            Set<PluginId> suppressedPluginIds;
            Set<PluginId> pluginIdsFromFile;
            boolean updateFile;
            Set<PluginId> requiredPlugins;
            LinkedHashSet<PluginId> disabledPlugins;
            block9: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                disabledPlugins = new LinkedHashSet<PluginId>();
                requiredPlugins = this.getRequiredPlugins();
                updateFile = false;
                pluginIdsFromFile = PluginManagerCoreKt.tryReadPluginIdsFromFile(path, this.getLogger());
                suppressedPluginIds = this.splitByComma("idea.suppressed.plugins.id");
                suppressedPluginsSet = this.getSuppressedPluginsSet();
                if (!pluginIdsFromFile.isEmpty() || !suppressedPluginIds.isEmpty() || !suppressedPluginsSet.isEmpty()) break block9;
                Set set = SetsKt.emptySet();
                return set;
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
                ApplicationInfoEx applicationInfo = applicationInfoEx;
                for (PluginId id : pluginIdsFromFile) {
                    if (!requiredPlugins.contains(id) && !applicationInfo.isEssentialPlugin(id)) {
                        disabledPlugins.add(id);
                        continue;
                    }
                    updateFile = true;
                }
                for (PluginId suppressedPluginId : suppressedPluginIds) {
                    if (applicationInfo.isEssentialPlugin(suppressedPluginId) || !disabledPlugins.add(suppressedPluginId)) continue;
                    updateFile = true;
                }
                Object object = suppressedPluginsSet;
                Set set = disabledPlugins;
                boolean $i$f$filter = false;
                void var11_15 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginId it = (PluginId)element$iv$iv;
                    boolean bl = false;
                    if (!(!applicationInfo.isEssentialPlugin(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
                return object;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (updateFile) {
                    this.trySaveDisabledPlugins((Set<PluginId>)disabledPlugins, false);
                }
            }
        }

        private final Set<PluginId> getSuppressedPluginsSet() {
            String string = System.getProperty("idea.suppressed.plugins.set.selector");
            if (string == null) {
                return SetsKt.emptySet();
            }
            String selector = string;
            return this.splitByComma("idea.suppressed.plugins.set." + selector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<PluginId> getDisabledIds() {
            Set set = disabledPlugins;
            if (set != null) {
                Set it = set;
                boolean bl = false;
                return it;
            }
            if (isDisabledStateIgnored) {
                Set<PluginId> set2 = Collections.emptySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"emptySet(...)");
                return set2;
            }
            Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
            synchronized (clazz) {
                boolean bl = false;
                Set<PluginId> result2 = disabledPlugins;
                if (result2 == null) {
                    Set<PluginId> set3 = Collections.unmodifiableSet(Companion.loadDisabledPlugins(Companion.getDefaultFilePath()));
                    Intrinsics.checkNotNull(set3);
                    result2 = set3;
                    disabledPlugins = result2;
                }
                Set<PluginId> set4 = result2;
                return set4;
            }
        }

        private final boolean trySaveDisabledPlugins(Set<PluginId> pluginIds, boolean invalidate) {
            if (!PluginManagerCore.tryWritePluginIdsToFile$default(PluginManagerCore.INSTANCE, this.getDefaultFilePath(), pluginIds, this.getLogger(), null, 8, null)) {
                return false;
            }
            if (invalidate) {
                this.invalidate();
            }
            Iterator iterator2 = ourDisabledPluginListeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Runnable listener = (Runnable)iterator3.next();
                listener.run();
            }
            return true;
        }

        public final void invalidate() {
            disabledPlugins = null;
        }

        private final Set<PluginId> splitByComma(String key) {
            Set<PluginId> set;
            String property2 = System.getProperty(key, "");
            Intrinsics.checkNotNull((Object)property2);
            if (((CharSequence)property2).length() == 0) {
                set = SetsKt.emptySet();
            } else {
                char[] cArray = new char[]{','};
                set = PluginManagerCore.toPluginIds(StringsKt.split$default((CharSequence)property2, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

