/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.ide.plugins;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.plugins.IdeaPluginDescriptorImplKt;
import org.jetbrains.kotlin.com.intellij.ide.plugins.PluginManagerCore;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.BuildNumber;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/com/intellij/ide/plugins/UntilBuildDeprecation;", "", "<init>", "()V", "MINIMAL_API_VERSION", "", "forceHonorUntilBuild", "", "nullizeIfTargets243OrLater", "", "untilBuild", "diagnosticId", "intellij.platform.core.impl"})
final class UntilBuildDeprecation {
    @NotNull
    public static final UntilBuildDeprecation INSTANCE = new UntilBuildDeprecation();
    private static final boolean forceHonorUntilBuild = Boolean.parseBoolean(System.getProperty("idea.plugins.honor.until.build", "false"));

    private UntilBuildDeprecation() {
    }

    @Nullable
    public final String nullizeIfTargets243OrLater(@Nullable String untilBuild, @Nullable String diagnosticId) {
        if (forceHonorUntilBuild || untilBuild == null) {
            return untilBuild;
        }
        try {
            BuildNumber untilBuildNumber = BuildNumber.fromStringOrNull(untilBuild);
            if (untilBuildNumber != null && untilBuildNumber.getBaselineVersion() >= 251) {
                if (untilBuildNumber.compareTo(PluginManagerCore.getBuildNumber()) < 0) {
                    Logger logger = IdeaPluginDescriptorImplKt.access$getLOG();
                    StringBuilder stringBuilder = new StringBuilder().append("Plugin ");
                    String string = diagnosticId;
                    if (string == null) {
                        string = "<no name>";
                    }
                    logger.info(stringBuilder.append(string).append(" has until-build set to ").append(untilBuild).append(". Until-build _from plugin configuration file (plugin.xml)_ for plugins targeting 251+ is ignored. Effective until-build value can be set via the Marketplace.").toString());
                }
                return null;
            }
        }
        catch (Throwable e) {
            IdeaPluginDescriptorImplKt.access$getLOG().warn("failed to parse until-build number", e);
        }
        return untilBuild;
    }
}

