/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.l10n;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.DynamicBundle;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.l10n.LocalizationStateService;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtilRt;
import org.jetbrains.kotlin.com.intellij.util.PathUtilRt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u0004\u0018\u00010\bJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0007J \u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\"\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J(\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\"\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u001e2\u0006\u0010\u001b\u001a\u00020\u00052\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\bH\u0007J\u0014\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0007J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0007J\u0010\u0010)\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0007J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020%0\u001eH\u0002J&\u0010+\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050-0,H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/com/intellij/l10n/LocalizationUtil;", "", "<init>", "()V", "LOCALIZATION_FOLDER_NAME", "", "LOCALIZATION_KEY", "defaultLocale", "Ljava/util/Locale;", "getDefaultLocale", "()Ljava/util/Locale;", "getLocale", "ignoreRestartRequired", "", "getLocaleOrNullForDefault", "getPluginClassLoader", "Ljava/lang/ClassLoader;", "defaultLoader", "locale", "convertToLocalizationFolderUsage", "p", "withRegion", "convertPathToLocaleSuffixUsage", "file", "getResourceAsStream", "Ljava/io/InputStream;", "classLoader", "path", "specialLocale", "getLocalizedPathsWithDefault", "", "getLocalizedPaths", "", "getLocalizationSuffixes", "getFolderLocalizedPaths", "getSuffixLocalizedPaths", "findLanguageBundle", "Lorg/jetbrains/kotlin/com/intellij/DynamicBundle$LanguageBundleEP;", "isLocalizationPluginDescriptor", "pluginDescriptor", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginDescriptor;", "isCurrentLocalizationPluginDescriptor", "getAllLanguageBundleExtensions", "getAllAvailableLocales", "Lkotlin/Pair;", "", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nLocalizationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n1#2:239\n25#3:240\n15#3:252\n1557#4:241\n1628#4,3:242\n1557#4:245\n1628#4,3:246\n1755#4,3:249\n1053#4:253\n*S KotlinDebug\n*F\n+ 1 LocalizationUtil.kt\ncom/intellij/l10n/LocalizationUtil\n*L\n102#1:240\n213#1:252\n173#1:241\n173#1:242,3\n188#1:245\n188#1:246,3\n188#1:249,3\n235#1:253\n*E\n"})
public final class LocalizationUtil {
    @NotNull
    public static final LocalizationUtil INSTANCE = new LocalizationUtil();
    @ApiStatus.Internal
    @NotNull
    private static final Locale defaultLocale;

    private LocalizationUtil() {
    }

    @JvmOverloads
    @NotNull
    public final Locale getLocale(boolean ignoreRestartRequired) {
        LocalizationStateService localizationStateService = LocalizationStateService.getInstance();
        if (localizationStateService == null) {
            return defaultLocale;
        }
        String string = !ignoreRestartRequired && localizationStateService.isRestartRequired() != false ? localizationStateService.getLastSelectedLocale() : localizationStateService.getSelectedLocale();
        Intrinsics.checkNotNull((Object)string);
        String languageTag = string;
        Locale locale = Locale.forLanguageTag(languageTag);
        if (!Intrinsics.areEqual((Object)locale.getLanguage(), (Object)defaultLocale.getLanguage())) {
            Intrinsics.checkNotNull((Object)locale);
            if (this.findLanguageBundle(locale) == null) {
                return defaultLocale;
            }
        }
        Intrinsics.checkNotNull((Object)locale);
        return locale;
    }

    public static /* synthetic */ Locale getLocale$default(LocalizationUtil localizationUtil, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return localizationUtil.getLocale(bl);
    }

    @Nullable
    public final Locale getLocaleOrNullForDefault() {
        Locale locale;
        Locale it = locale = LocalizationUtil.getLocale$default(this, false, 1, null);
        boolean bl = false;
        return !Intrinsics.areEqual((Object)it.getLanguage(), (Object)defaultLocale.getLanguage()) ? locale : null;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final ClassLoader getPluginClassLoader(@Nullable ClassLoader defaultLoader, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (Intrinsics.areEqual((Object)locale, (Object)defaultLocale) || Intrinsics.areEqual((Object)locale, (Object)Locale.ROOT)) {
            return null;
        }
        DynamicBundle.LanguageBundleEP languageBundleEP = this.findLanguageBundle(locale);
        if (languageBundleEP == null) {
            return null;
        }
        DynamicBundle.LanguageBundleEP langBundle = languageBundleEP;
        Object object = langBundle.pluginDescriptor;
        if (object == null || (object = object.getClassLoader()) == null) {
            object = defaultLoader;
        }
        return object;
    }

    private final String convertToLocalizationFolderUsage(String p, Locale locale, boolean withRegion) {
        StringBuilder result2 = new StringBuilder().append("localization").append('/').append(locale.getLanguage());
        if (withRegion) {
            String string = locale.getCountry();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCountry(...)");
            if (((CharSequence)string).length() > 0) {
                result2.append('/').append(locale.getCountry());
            }
        }
        result2.append('/').append(p);
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String convertPathToLocaleSuffixUsage(String file, Locale locale, boolean withRegion) {
        if (locale == null) {
            return file;
        }
        String string = PathUtilRt.getFileName(file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String pathFileName = string;
        StringBuilder fileName = new StringBuilder().append(PathUtilRt.getParentPath(file)).append('/').append(FileUtilRt.getNameWithoutExtension(pathFileName));
        String string2 = FileUtilRt.getExtension(pathFileName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
        String extension = string2;
        String language = locale.getLanguage();
        Intrinsics.checkNotNull((Object)language);
        if (!(((CharSequence)language).length() == 0)) {
            fileName.append('_').append(language);
            String country = locale.getCountry();
            Intrinsics.checkNotNull((Object)country);
            if (((CharSequence)country).length() > 0 && withRegion) {
                fileName.append('_').append(country);
            }
        }
        if (((CharSequence)extension).length() > 0) {
            fileName.append('.').append(extension);
        }
        String string3 = fileName.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return string3;
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getLocalizedPathsWithDefault(@NotNull String path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)CollectionsKt.toMutableList(this.getLocalizedPaths(path, specialLocale)), (Object)path));
    }

    @ApiStatus.Internal
    @NotNull
    public final Collection<String> getLocalizedPaths(@NotNull String path, @Nullable Locale specialLocale) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale2 = specialLocale;
        if (locale2 == null) {
            locale2 = this.getLocaleOrNullForDefault();
        }
        if ((locale = locale2) == null || Intrinsics.areEqual((Object)locale, (Object)Locale.ROOT)) {
            return CollectionsKt.emptyList();
        }
        Object[] objectArray = new String[]{this.convertToLocalizationFolderUsage(path, locale, true), this.convertPathToLocaleSuffixUsage(path, locale, true), this.convertToLocalizationFolderUsage(path, locale, false), this.convertPathToLocaleSuffixUsage(path, locale, false)};
        return SetsKt.linkedSetOf((Object[])objectArray);
    }

    @ApiStatus.Internal
    @JvmOverloads
    @NotNull
    public final List<String> getFolderLocalizedPaths(@NotNull String path, @Nullable Locale specialLocale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Locale locale = specialLocale;
        if (locale == null && (locale = this.getLocaleOrNullForDefault()) == null) {
            return CollectionsKt.emptyList();
        }
        Locale locale2 = locale;
        Object[] objectArray = new String[]{this.convertToLocalizationFolderUsage(path, locale2, true), this.convertToLocalizationFolderUsage(path, locale2, false)};
        return CollectionsKt.distinct((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @ApiStatus.Internal
    @JvmOverloads
    @Nullable
    public final DynamicBundle.LanguageBundleEP findLanguageBundle(@NotNull Locale locale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Iterable iterable = this.getAllLanguageBundleExtensions();
            for (Object t : iterable) {
                DynamicBundle.LanguageBundleEP it = (DynamicBundle.LanguageBundleEP)t;
                boolean bl = false;
                Locale extensionLocale = Locale.forLanguageTag(it.locale);
                if (!Intrinsics.areEqual((Object)extensionLocale, (Object)locale)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final List<DynamicBundle.LanguageBundleEP> getAllLanguageBundleExtensions() {
        try {
            block8: {
                block7: {
                    if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
                        return CollectionsKt.emptyList();
                    }
                    Application app = ApplicationManager.getApplication();
                    if (app == null) break block7;
                    ExtensionsArea extensionsArea = app.getExtensionArea();
                    ExtensionPointName<DynamicBundle.LanguageBundleEP> extensionPointName = DynamicBundle.LanguageBundleEP.EP_NAME;
                    Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"EP_NAME");
                    if (extensionsArea.hasExtensionPoint(extensionPointName)) break block8;
                }
                return CollectionsKt.emptyList();
            }
            return DynamicBundle.LanguageBundleEP.EP_NAME.getExtensionList();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LocalizationUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(e);
            return CollectionsKt.emptyList();
        }
    }

    @JvmOverloads
    @NotNull
    public final Locale getLocale() {
        return LocalizationUtil.getLocale$default(this, false, 1, null);
    }

    static {
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        defaultLocale = locale;
    }
}

