/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ITokenTypeRemapper;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.WhitespaceSkippedCallback;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public interface SyntaxTreeBuilder {
    @NotNull
    public CharSequence getOriginalText();

    public void advanceLexer();

    @Nullable
    public IElementType getTokenType();

    public void setTokenTypeRemapper(@Nullable ITokenTypeRemapper var1);

    public void remapCurrentToken(@NotNull IElementType var1);

    public void setWhitespaceSkippedCallback(@Nullable WhitespaceSkippedCallback var1);

    @Nullable
    public IElementType lookAhead(int var1);

    @Nullable
    public IElementType rawLookup(int var1);

    public int rawTokenTypeStart(int var1);

    public int rawTokenIndex();

    @NonNls
    @Nullable
    public String getTokenText();

    default public void rawAdvanceLexer(int steps) {
        if (steps < 0) {
            throw new IllegalArgumentException("Steps must be a positive integer - lexer can only be advanced. Use Marker.rollbackTo if you want to rollback PSI building.");
        }
        if (steps == 0) {
            return;
        }
        int offset = this.rawTokenTypeStart(steps);
        while (!this.eof() && this.getCurrentOffset() < offset) {
            this.advanceLexer();
        }
    }

    public int getCurrentOffset();

    public void error(@NotNull String var1);

    public boolean eof();

    public void setDebugMode(boolean var1);

    public void enforceCommentTokens(@NotNull TokenSet var1);

    @Nullable
    public LighterASTNode getLatestDoneMarker();

    @NotNull
    default public List<? extends Production> getProductions() {
        throw new UnsupportedOperationException("not implemented for this kind of Builder");
    }

    default public boolean isWhitespaceOrComment(@NotNull IElementType elementType) {
        if (elementType == null) {
            SyntaxTreeBuilder.$$$reportNull$$$0(0);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/kotlin/com/intellij/lang/SyntaxTreeBuilder", "isWhitespaceOrComment"));
    }

    public static interface Marker
    extends Production {
        public void drop();

        public void rollbackTo();

        public void done(@NotNull IElementType var1);

        public void collapse(@NotNull IElementType var1);

        public void error(@NotNull String var1);

        public void setCustomEdgeTokenBinders(@Nullable WhitespacesAndCommentsBinder var1, @Nullable WhitespacesAndCommentsBinder var2);
    }

    public static interface Production
    extends LighterASTNode {
        @Override
        default public IElementType getTokenType() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @Override
        default public int getStartOffset() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @Override
        default public int getEndOffset() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        default public int getStartIndex() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        default public int getEndIndex() {
            throw new UnsupportedOperationException("not implemented for this kind of markers");
        }

        @Nullable
        default public String getErrorMessage() {
            return null;
        }
    }
}

