/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.lexer;

import org.jetbrains.kotlin.com.intellij.lang.java.lexer.BasicJavaLexer;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.lexer.MergeFunction;
import org.jetbrains.kotlin.com.intellij.lexer.MergingLexerAdapterBase;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class JavaTypeEscapeLexer
extends MergingLexerAdapterBase {
    private final MergeFunction myMergeFunction = new EscapeMarkdownFunction();

    public JavaTypeEscapeLexer(BasicJavaLexer original) {
        super(original);
    }

    @Override
    public MergeFunction getMergeFunction() {
        return this.myMergeFunction;
    }

    private static class EscapeMarkdownFunction
    implements MergeFunction {
        private EscapeMarkdownFunction() {
        }

        @Override
        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (type != TokenType.BAD_CHARACTER) {
                return type;
            }
            IElementType tokenType = originalLexer.getTokenType();
            if (tokenType != JavaTokenType.LBRACKET && tokenType != JavaTokenType.RBRACKET) {
                return type;
            }
            originalLexer.advance();
            return tokenType;
        }
    }
}

