/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.concurrency.ThreadContext;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.CoroutinesKt;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public final class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance(TransactionGuardImpl.class);
    private final Map<ModalityState, Boolean> myWriteSafeModalities = CollectionFactory.createConcurrentWeakMap();
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.nonModal(), true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @Override
    public boolean isWriteSafeModality(@NotNull ModalityState state) {
        if (state == null) {
            TransactionGuardImpl.$$$reportNull$$$0(4);
        }
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state));
    }

    public void assertWriteActionAllowed() {
        Application app = ApplicationManager.getApplication();
        if (CoroutinesKt.isBackgroundWriteAction(ThreadContext.currentThreadContext()) && app.isWriteAccessAllowed()) {
            return;
        }
        app.assertWriteIntentLockAcquired();
        if (!this.myWritingAllowed && TransactionGuardImpl.areAssertionsEnabled() && !this.myErrorReported) {
            LOG.error(TransactionGuardImpl.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    @NonNls
    private static String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(5);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality;
    }

    private static boolean areAssertionsEnabled() {
        return LoadingState.COMPONENTS_LOADED.isOccurred() && Registry.is("ide.require.transaction.for.model.changes", false);
    }

    public void enteredModality(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(9);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    public String toString() {
        return "TransactionGuardImpl{myWritingAllowed=" + this.myWritingAllowed + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransaction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransactionAndWait";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isWriteSafeModality";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reportWriteUnsafeContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "assertWriteSafeContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "submitTransactionLater";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "enteredModality";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapLaterInvocation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapCoroutineInvocation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithWritingAllowed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

