/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.diagnostic;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;

@ApiStatus.Internal
public final class ThrottledLogger {
    @NotNull
    private final Logger logger;
    private final long ignoreRepeatedMessagesInMs;
    private final AtomicLong lastLoggedAtMsHolder;

    public ThrottledLogger(@NotNull Logger logger, long ignoreRepeatedMessagesInMs) {
        if (logger == null) {
            ThrottledLogger.$$$reportNull$$$0(0);
        }
        this.lastLoggedAtMsHolder = new AtomicLong(0L);
        this.logger = Objects.requireNonNull(logger, "logger");
        if (ignoreRepeatedMessagesInMs < 0L) {
            throw new IllegalArgumentException("ignoreRepeatedMessagesInMs(=" + ignoreRepeatedMessagesInMs + ") must be >=0");
        }
        this.ignoreRepeatedMessagesInMs = ignoreRepeatedMessagesInMs;
    }

    public void info(String message2) {
        this.info(message2, null);
    }

    public void info(String message2, @Nullable Throwable t) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.info(message2, t);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    private void forwardLastLogged(long nowMs, long lastLoggedAt) {
        while (!this.lastLoggedAtMsHolder.compareAndSet(lastLoggedAt, nowMs) && (lastLoggedAt = this.lastLoggedAtMsHolder.get()) < nowMs) {
        }
    }

    public String toString() {
        return "ThrottledLogger[ignoreRepeatedMessagesInMs: " + this.ignoreRepeatedMessagesInMs + ", lastLoggedAtMs:" + this.lastLoggedAtMsHolder.get() + ", wrapped logger:" + this.logger + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/ThrottledLogger";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/diagnostic/ThrottledLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrappedLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

