/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.editor.markup;

import java.awt.Color;
import java.util.Collections;
import java.util.Objects;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.markup.AttributesFlyweight;
import org.jetbrains.kotlin.com.intellij.openapi.editor.markup.EffectType;

public class TextAttributes
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TextAttributes.class);
    private static final AttributesFlyweight DEFAULT_FLYWEIGHT = AttributesFlyweight.create(null, null, 0, null, EffectType.BOXED, Collections.emptyMap(), null);
    public static final TextAttributes ERASE_MARKER = new TextAttributes(){

        @Override
        public String toString() {
            return "[ERASE_MARKER]";
        }
    };
    @NotNull
    private AttributesFlyweight attrs;

    public TextAttributes() {
        this(DEFAULT_FLYWEIGHT);
    }

    private TextAttributes(@NotNull AttributesFlyweight attributesFlyweight) {
        if (attributesFlyweight == null) {
            TextAttributes.$$$reportNull$$$0(0);
        }
        this.attrs = attributesFlyweight;
    }

    public Color getForegroundColor() {
        return this.attrs.getForeground();
    }

    public Color getBackgroundColor() {
        return this.attrs.getBackground();
    }

    public Color getEffectColor() {
        return this.attrs.getEffectColor();
    }

    public Color getErrorStripeColor() {
        return this.attrs.getErrorStripeColor();
    }

    @Nullable
    public EffectType getEffectType() {
        return this.attrs.getEffectType();
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.attrs.getFontType();
    }

    public TextAttributes clone() {
        return new TextAttributes(this.attrs);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextAttributes)) {
            return false;
        }
        return Objects.equals(this.attrs, ((TextAttributes)obj).attrs);
    }

    public int hashCode() {
        return this.attrs.hashCode();
    }

    public String toString() {
        return "[fore=" + this.getForegroundColor() + ", back=" + this.getBackgroundColor() + ", type=" + this.getFontType() + (this.getEffectType() == null ? "" : ", effect=" + (Object)((Object)this.getEffectType())) + (this.getEffectColor() == null ? "" : ", effect color=" + this.getEffectColor()) + (this.attrs.getAdditionalEffects().isEmpty() ? "" : ", additional=" + this.attrs.getAdditionalEffects()) + (this.getErrorStripeColor() == null ? "" : ", stripe=" + this.getErrorStripeColor()) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesFlyweight";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flyweight";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectsMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/editor/markup/TextAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlyweight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromFlyweight";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalEffects";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withAdditionalEffect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachAdditionalEffect";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forEachEffect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

