/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl.FileDocumentBindingListener;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.NonPhysicalFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;

public abstract class FileDocumentManagerBase
extends FileDocumentManager {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create("HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Boolean> TRACK_NON_PHYSICAL = Key.create("TRACK_NON_PHYSICAL");
    private static final Key<VirtualFile> FILE_KEY = Key.create("FILE_KEY");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create("BIG_FILE_PREVIEW");
    private static final Object lock = new Object();

    private static void fireFileBindingChanged(Document document, @Nullable VirtualFile oldFile, @Nullable VirtualFile newFile) {
        ApplicationManager.getApplication().getMessageBus().syncPublisher(FileDocumentBindingListener.TOPIC).fileDocumentBindingChanged(document, oldFile, newFile);
    }

    @ApiStatus.Internal
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(8);
        }
        FileDocumentManagerBase.registerDocument(document, virtualFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile, boolean fireBindingChangedEvent) {
        VirtualFile oldFile;
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(10);
        }
        if (!(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem)) {
            throw new IllegalArgumentException("Hard-coding file<->document association is permitted for non-physical files only (see FileViewProvider.isPhysical()) to avoid memory leaks. virtualFile=" + virtualFile);
        }
        Object object = lock;
        synchronized (object) {
            oldFile = document.getUserData(FILE_KEY);
            document.putUserData(FILE_KEY, virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, document);
        }
        if (fireBindingChangedEvent) {
            FileDocumentManagerBase.fireFileBindingChanged(document, oldFile, virtualFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTrackable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDocumentTooLarge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rebindDocument";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reloadFileTypes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

