/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.fileTypes;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.LanguageFileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;

public final class CharsetUtil {
    private static final Map<String, Boolean> ourSupportsCharsetDetection = new ConcurrentHashMap<String, Boolean>();

    private static boolean overridesExtractCharsetFromContent(@NotNull LanguageFileType fileType) {
        if (fileType == null) {
            CharsetUtil.$$$reportNull$$$0(0);
        }
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class<?> declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, CharSequence.class);
        if (!LanguageFileType.class.equals(declaring2)) {
            return true;
        }
        Class<?> declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, String.class);
        return !LanguageFileType.class.equals(declaring1);
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (text == null) {
            CharsetUtil.$$$reportNull$$$0(1);
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.computeIfAbsent(fileType.getClass().getName(), __ -> CharsetUtil.overridesExtractCharsetFromContent((LanguageFileType)fileType)).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteBuffer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decodedBuffer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/fileTypes/CharsetUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "overridesExtractCharsetFromContent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractCharsetFromFileContent";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnmappableCharacters";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findUnmappableRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

