/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import java.util.concurrent.TimeUnit;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.concurrency.ThreadContext;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.util.ThrowableComputable;
import org.jetbrains.kotlin.com.intellij.util.DebugAttachDetectorArgs;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<DebugNonCancellableState> debugIsInNonCancelableSection = new ThreadLocal();

    @ApiStatus.Obsolete
    public static boolean isInNonCancelableSection() {
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return true;
        }
        if (!DebugNonCancellableState.isDebugEnabled) {
            return false;
        }
        if (!DebugNonCancellableState.isAttached()) {
            return false;
        }
        DebugNonCancellableState state = debugIsInNonCancelableSection.get();
        return state != null && state.inNonCancelableSection;
    }

    private static boolean isInNonCancelableSectionInternal() {
        CoroutineContext context2 = ThreadContext.currentThreadContext();
        Job job = (Job)context2.get((CoroutineContext.Key)Job.Key);
        return job != null && Cancellation.checkIfCurrentJobIsNonCancellable(job);
    }

    private static boolean checkIfCurrentJobIsNonCancellable(@NotNull Job job) {
        if (job == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        return job == NonCancellable.INSTANCE;
    }

    public static <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            Cancellation.$$$reportNull$$$0(1);
        }
        if (Cancellation.isInNonCancelableSectionInternal()) {
            return computable.compute();
        }
        try (@NotNull AccessToken ignored = ThreadContext.installThreadContext(ThreadContext.currentThreadContext().plus((CoroutineContext)NonCancellable.INSTANCE), true);){
            T t = computable.compute();
            return t;
        }
    }

    public static void executeInNonCancelableSection(@NotNull Runnable runnable) {
        if (runnable == null) {
            Cancellation.$$$reportNull$$$0(2);
        }
        Cancellation.computeInNonCancelableSection(() -> {
            runnable.run();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Cancellation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Cancellation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withNonCancelableSection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initThreadNonCancellableState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkIfCurrentJobIsNonCancellable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeInNonCancelableSection";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeInNonCancelableSection";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forceNonCancellableSectionInClassInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DebugNonCancellableState {
        private static final boolean isDebugEnabled = DebugAttachDetectorArgs.isDebugEnabled();
        private static volatile long lastUpdateNs = System.nanoTime();
        private static volatile boolean isDebugAttached = DebugAttachDetectorArgs.isAttached();
        private volatile boolean inNonCancelableSection = false;

        private DebugNonCancellableState() {
        }

        private static boolean isAttached() {
            long current = System.nanoTime();
            if (TimeUnit.NANOSECONDS.toSeconds(current - lastUpdateNs) > 2L) {
                lastUpdateNs = current;
                isDebugAttached = DebugAttachDetectorArgs.isAttached();
            }
            return isDebugAttached;
        }
    }
}

