/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.CheckedDisposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.ObjectTree;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public final class Disposer {
    private static final ObjectTree ourTree = new ObjectTree();
    private static boolean ourDebugMode;

    @Contract(pure=true, value="->new")
    @NotNull
    public static Disposable newDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return "newDisposable";
            }
        };
    }

    @Contract(pure=true, value="_->new")
    @NotNull
    public static Disposable newDisposable(final @NotNull @NonNls String debugName) {
        if (debugName == null) {
            Disposer.$$$reportNull$$$0(0);
        }
        return new Disposable(){

            @Override
            public void dispose() {
            }

            public String toString() {
                return debugName;
            }
        };
    }

    public static void register(@NotNull Disposable parent2, @NotNull Disposable child) throws IncorrectOperationException {
        if (parent2 == null) {
            Disposer.$$$reportNull$$$0(12);
        }
        if (child == null) {
            Disposer.$$$reportNull$$$0(13);
        }
        ourTree.register(parent2, child);
    }

    public static void dispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(17);
        }
        Disposer.dispose(disposable, true);
    }

    public static void dispose(@NotNull Disposable disposable, boolean processUnregistered) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(20);
        }
        ourTree.executeAll(disposable, processUnregistered);
    }

    @ApiStatus.Internal
    @VisibleForTesting
    @NotNull
    public static ObjectTree getTree() {
        ObjectTree objectTree = ourTree;
        if (objectTree == null) {
            Disposer.$$$reportNull$$$0(21);
        }
        return objectTree;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static Throwable getDisposalTrace(@NotNull Disposable disposable) {
        if (disposable == null) {
            Disposer.$$$reportNull$$$0(22);
        }
        return Disposer.getTree().getDisposalTrace(disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/Disposer";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Disposer";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newDisposable";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newCheckedDisposable";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newDisposable";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newCheckedDisposable";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 21: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryRegister";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDisposed";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "disposeChildren";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDisposalTrace";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRegistrationTrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CheckedDisposableImpl
    implements CheckedDisposable {
        volatile boolean isDisposed;

        CheckedDisposableImpl() {
        }

        @Override
        public boolean isDisposed() {
            return this.isDisposed;
        }

        @Override
        public void dispose() {
            this.isDisposed = true;
        }

        public String toString() {
            return "CheckedDisposableImpl{isDisposed=" + this.isDisposed + "} " + super.toString();
        }
    }
}

