/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.concurrency.SequentialTaskExecutor;

@ApiStatus.Internal
public final class LowMemoryWatcherManager {
    private final AtomicLong lastGcTime;
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final Future<?> myMemoryPoolMXBeansFuture;
    private final Consumer<Boolean> myJanitor;
    private final GcTracker gcTracker;
    private final NotificationListener myLowMemoryListener;

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(LowMemoryWatcherManager.class);
        if (logger == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        return logger;
    }

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        this.lastGcTime = new AtomicLong();
        this.myJanitor = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager$1", "accept"));
            }
        };
        this.gcTracker = new GcTracker();
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if (LowMemoryWatcher.notificationsSuppressed()) {
                    return;
                }
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    long currentGcTime = LowMemoryWatcherManager.getMajorGcTime();
                    long previousGcTimeValue = LowMemoryWatcherManager.this.lastGcTime.getAndSet(currentGcTime);
                    long recentGcTime = LowMemoryWatcherManager.this.gcTracker.trackGcAndGetRecentTime(currentGcTime, previousGcTimeValue);
                    Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.accept(recentGcTime > 10000L));
                            if (LowMemoryWatcherManager.this.mySubmitted.isDone()) {
                                LowMemoryWatcherManager.this.mySubmitted = null;
                            }
                        }
                    }
                }
            }
        };
        this.myExecutorService = Boolean.getBoolean("low.memory.watcher.sync") ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.myMemoryPoolMXBeansFuture = this.initializeMXBeanListenersLater(backendExecutorService);
        this.lastGcTime.set(LowMemoryWatcherManager.getMajorGcTime());
    }

    private static long getMajorGcTime() {
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!gc.getName().toLowerCase().contains("g1 old generation")) continue;
            return gc.getCollectionTime();
        }
        return 0L;
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        Future<?> future = backendExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                        long max;
                        long threshold;
                        if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((float)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                        bean.setUsageThreshold(threshold);
                        bean.setCollectionUsageThreshold(threshold);
                    }
                    ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(LowMemoryWatcherManager.this.myLowMemoryListener, null, null);
                }
                catch (Throwable e) {
                    LowMemoryWatcherManager.getLogger().info("Errors initializing LowMemoryWatcher: ", e);
                }
            }

            public String toString() {
                return "initializeMXBeanListeners runnable";
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(3);
        }
        return future;
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GcTracker {
        private final Queue<GcPeriod> gcPeriods = new LinkedList<GcPeriod>();

        private GcTracker() {
        }

        public synchronized long trackGcAndGetRecentTime(long currentGcTime, long previousGcTimeValue) {
            long currentTime = System.currentTimeMillis();
            if (currentGcTime > previousGcTimeValue) {
                this.gcPeriods.offer(new GcPeriod(currentTime, currentGcTime - previousGcTimeValue));
            }
            while (!this.gcPeriods.isEmpty() && this.gcPeriods.peek().timestamp < currentTime - 60000L) {
                this.gcPeriods.poll();
            }
            return this.gcPeriods.stream().mapToLong(period -> period.gcTime).sum();
        }

        private static class GcPeriod {
            final long timestamp;
            final long gcTime;

            GcPeriod(long timestamp, long gcTime) {
                this.timestamp = timestamp;
                this.gcTime = gcTime;
            }
        }
    }
}

