/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.UnknownNullability;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyWithDefaultValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderEx;
import org.jetbrains.kotlin.com.intellij.util.keyFMap.KeyFMap;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.Transient;

@Transient
public class UserDataHolderBase
extends AtomicReference<KeyFMap>
implements UserDataHolderEx {
    private static final Key<KeyFMap> COPYABLE_USER_MAP_KEY = Key.create("COPYABLE_USER_MAP_KEY");

    public UserDataHolderBase() {
        this.set(KeyFMap.EMPTY_MAP);
    }

    protected Object clone() {
        try {
            UserDataHolderBase clone = (UserDataHolderBase)super.clone();
            clone.setUserMap(KeyFMap.EMPTY_MAP);
            this.copyCopyableDataTo(clone);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @TestOnly
    public String getUserDataString() {
        KeyFMap userMap = this.getUserMap();
        KeyFMap copyableMap = this.getUserData(COPYABLE_USER_MAP_KEY);
        return userMap + (copyableMap == null ? "" : copyableMap.toString());
    }

    public void copyUserDataTo(@NotNull UserDataHolderBase other) {
        if (other == null) {
            UserDataHolderBase.$$$reportNull$$$0(0);
        }
        other.setUserMap(this.getUserMap());
    }

    @Override
    public <T> T getUserData(@NotNull Key<T> key) {
        T t;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(1);
        }
        if ((t = this.getUserMap().get(key)) == null && key instanceof KeyWithDefaultValue) {
            t = this.putUserDataIfAbsent(key, ((KeyWithDefaultValue)key).getDefaultValue());
        }
        return t;
    }

    @NotNull
    protected KeyFMap getUserMap() {
        KeyFMap keyFMap = (KeyFMap)this.get();
        if (keyFMap == null) {
            UserDataHolderBase.$$$reportNull$$$0(2);
        }
        return keyFMap;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        KeyFMap map;
        KeyFMap newMap2;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(3);
        }
        do {
            map = this.getUserMap();
            KeyFMap keyFMap = newMap2 = value2 == null ? map.minus(key) : map.plus(key, value2);
        } while (newMap2 != map && !this.changeUserMap(map, newMap2));
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap2, @NotNull KeyFMap newMap2) {
        if (oldMap2 == null) {
            UserDataHolderBase.$$$reportNull$$$0(4);
        }
        if (newMap2 == null) {
            UserDataHolderBase.$$$reportNull$$$0(5);
        }
        return this.compareAndSet(oldMap2, newMap2);
    }

    public <T> @UnknownNullability T getCopyableUserData(@NotNull Key<T> key) {
        KeyFMap map;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(6);
        }
        return (map = this.getUserData(COPYABLE_USER_MAP_KEY)) == null ? null : (T)map.get(key);
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, T value2) {
        KeyFMap map;
        KeyFMap newMap2;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(7);
        }
        do {
            KeyFMap copyableMap;
            if ((copyableMap = (map = this.getUserMap()).get(COPYABLE_USER_MAP_KEY)) == null) {
                copyableMap = KeyFMap.EMPTY_MAP;
            }
            KeyFMap newCopyableMap = value2 == null ? copyableMap.minus(key) : copyableMap.plus(key, value2);
            KeyFMap keyFMap = newMap2 = newCopyableMap.isEmpty() ? map.minus(COPYABLE_USER_MAP_KEY) : map.plus(COPYABLE_USER_MAP_KEY, newCopyableMap);
        } while (newMap2 != map && !this.changeUserMap(map, newMap2));
    }

    @Override
    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        KeyFMap map;
        KeyFMap newMap2;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(8);
        }
        do {
            if ((map = this.getUserMap()).get(key) != oldValue) {
                return false;
            }
            KeyFMap keyFMap = newMap2 = newValue == null ? map.minus(key) : map.plus(key, newValue);
        } while (newMap2 != map && !this.changeUserMap(map, newMap2));
        return true;
    }

    @Override
    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value2) {
        KeyFMap map;
        KeyFMap newMap2;
        if (key == null) {
            UserDataHolderBase.$$$reportNull$$$0(9);
        }
        if (value2 == null) {
            UserDataHolderBase.$$$reportNull$$$0(10);
        }
        do {
            T oldValue;
            if ((oldValue = (map = this.getUserMap()).get(key)) == null) continue;
            T t = oldValue;
            if (t == null) {
                UserDataHolderBase.$$$reportNull$$$0(11);
            }
            return t;
        } while ((newMap2 = map.plus(key, value2)) != map && !this.changeUserMap(map, newMap2));
        T t = value2;
        if (t == null) {
            UserDataHolderBase.$$$reportNull$$$0(12);
        }
        return t;
    }

    public void copyCopyableDataTo(@NotNull UserDataHolderBase clone) {
        if (clone == null) {
            UserDataHolderBase.$$$reportNull$$$0(13);
        }
        clone.putUserData(COPYABLE_USER_MAP_KEY, this.getUserData(COPYABLE_USER_MAP_KEY));
    }

    @ApiStatus.Experimental
    protected boolean isCopyableDataEqual(@NotNull UserDataHolderBase other) {
        if (other == null) {
            UserDataHolderBase.$$$reportNull$$$0(14);
        }
        return Objects.equals(this.getUserData(COPYABLE_USER_MAP_KEY), other.getUserData(COPYABLE_USER_MAP_KEY));
    }

    protected void clearUserData() {
        this.setUserMap(KeyFMap.EMPTY_MAP);
    }

    protected void setUserMap(@NotNull KeyFMap map) {
        if (map == null) {
            UserDataHolderBase.$$$reportNull$$$0(15);
        }
        this.set(map);
    }

    public boolean isUserDataEmpty() {
        return this.getUserMap().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clone";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/UserDataHolderBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyUserDataTo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCopyableUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putCopyableUserData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableDataTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCopyableDataEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

