/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.LoggerRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.NullAppendable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;

public final class FileUtilRt {
    @Deprecated
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    @Deprecated
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final boolean TRY_GC_IF_FILE_DELETE_FAILS = "true".equals(System.getProperty("idea.fs.try-gc-if-file-delete-fails", "true"));
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    private static String ourCanonicalTempPathCache;
    private static final Random RANDOM;

    public static boolean isJarOrZip(@NotNull File file, boolean isCheckIsDirectory) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(1);
        }
        if (isCheckIsDirectory && file.isDirectory()) {
            return false;
        }
        String path = file.getPath();
        return StringUtilRt.endsWithIgnoreCase(path, ".jar") || StringUtilRt.endsWithIgnoreCase(path, ".zip");
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path, char separatorChar) {
        int nextSeparator;
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(2);
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((nextSeparator = path.indexOf(separatorChar, index)) != -1) {
            list.add(path.substring(index, nextSeparator));
            index = nextSeparator + 1;
        }
        list.add(path.substring(index));
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            FileUtilRt.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Contract(value="null, _, _ -> null; !null,_,_->!null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        return FileUtilRt.toCanonicalPath(path, separatorChar, removeLastSlash, null);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash, @Nullable SymlinkResolver resolver) {
        char next;
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/' || c == separatorChar) {
                path = path.substring(2);
            }
        }
        if (separatorChar != '/') {
            path = path.replace(separatorChar, '/');
        }
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            if (removeLastSlash) {
                int start = FileUtilRt.processRoot(path, NullAppendable.INSTANCE);
                int slashIndex = path.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start && slashIndex == path.length() - 1 ? path.substring(0, path.length() - 1) : path;
            }
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = FileUtilRt.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtilRt.processDots(result2, dots, start, resolver)) {
                        return resolver.resolveSymlinksAndCanonicalize(path, separatorChar, removeLastSlash);
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtilRt.processDots(result2, dots, start, resolver)) {
            return resolver.resolveSymlinksAndCanonicalize(path, separatorChar, removeLastSlash);
        }
        int lastChar = result2.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result2.charAt(lastChar) == '/' && lastChar > start) {
            result2.deleteCharAt(lastChar);
        }
        return result2.toString();
    }

    private static int processRoot(@NotNull String path, @NotNull Appendable result2) {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(6);
        }
        try {
            if (SystemInfoRt.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result2.append("//");
                for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path.length()) {
                    return hostStart;
                }
                int hostEnd = path.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path.length();
                }
                result2.append(path, hostStart, hostEnd);
                result2.append('/');
                for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path.length()) {
                    return shareStart;
                }
                int shareEnd = path.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path.length();
                }
                result2.append(path, shareStart, shareEnd);
                result2.append('/');
                return shareEnd;
            }
            if (!path.isEmpty() && path.charAt(0) == '/') {
                result2.append('/');
                return 1;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
                result2.append(path, 0, 3);
                return 3;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="_, _, _, null -> true")
    private static boolean processDots(@NotNull StringBuilder result2, int dots, int start, @Nullable SymlinkResolver symlinkResolver) {
        if (result2 == null) {
            FileUtilRt.$$$reportNull$$$0(7);
        }
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = StringUtilRt.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (symlinkResolver != null && symlinkResolver.isSymlink(result2)) {
                    return false;
                }
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result2.append('.');
            }
            result2.append('/');
        }
        return true;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(8);
        }
        if ((index = fileName.lastIndexOf(46)) < 0) {
            return "";
        }
        String string = fileName.substring(index + 1);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(10);
        }
        CharSequence charSequence = FileUtilRt.getExtension(fileName, "");
        if (charSequence == null) {
            FileUtilRt.$$$reportNull$$$0(11);
        }
        return charSequence;
    }

    @Contract(value="_,!null -> !null")
    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue) {
        int index;
        if (fileName == null) {
            FileUtilRt.$$$reportNull$$$0(12);
        }
        if ((index = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length())) < 0) {
            return defaultValue;
        }
        return fileName.subSequence(index + 1, fileName.length());
    }

    public static boolean extensionEquals(@NotNull @NonNls String filePath, @NotNull @NonNls String extension) {
        int extLen;
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(13);
        }
        if (extension == null) {
            FileUtilRt.$$$reportNull$$$0(14);
        }
        if ((extLen = extension.length()) == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String path) {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(19);
        }
        return FileUtilRt.toSystemDependentName(path, File.separatorChar);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String path, char separatorChar) {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(20);
        }
        String string = path.replace('/', separatorChar).replace('\\', separatorChar);
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String toSystemIndependentName(@NotNull String path) {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(22);
        }
        String string = path.replace('\\', '/');
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(23);
        }
        return string;
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        if (basePath == null) {
            FileUtilRt.$$$reportNull$$$0(24);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(25);
        }
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        if (basePath == null) {
            FileUtilRt.$$$reportNull$$$0(26);
        }
        if (filePath == null) {
            FileUtilRt.$$$reportNull$$$0(27);
        }
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    @NotNull
    @Contract(pure=true)
    private static String ensureEnds(@NotNull String s, char endsWith) {
        if (s == null) {
            FileUtilRt.$$$reportNull$$$0(28);
        }
        String string = StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name2) {
        int i;
        if (name2 == null) {
            FileUtilRt.$$$reportNull$$$0(30);
        }
        CharSequence charSequence = (i = StringUtilRt.lastIndexOf(name2, '.', 0, name2.length())) < 0 ? name2 : name2.subSequence(0, i);
        if (charSequence == null) {
            FileUtilRt.$$$reportNull$$$0(31);
        }
        return charSequence;
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name2) {
        if (name2 == null) {
            FileUtilRt.$$$reportNull$$$0(32);
        }
        String string = FileUtilRt.getNameWithoutExtension((CharSequence)name2).toString();
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(34);
        }
        return FileUtilRt.createTempDirectory(prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(35);
        }
        File dir2 = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempDirectory(dir2, prefix, suffix, deleteOnExit);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(36);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(37);
        }
        return FileUtilRt.createTempDirectory(dir2, prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(38);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(39);
        }
        File file = FileUtilRt.doCreateTempFile(dir2, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file.getPath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create a directory: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(40);
        }
        return file2;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @Nullable String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(41);
        }
        return FileUtilRt.createTempFile(prefix, suffix, false);
    }

    @NotNull
    public static File createTempFile(@NonNls @NotNull String prefix, @NonNls @Nullable String suffix, boolean deleteOnExit) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(42);
        }
        File dir2 = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempFile(dir2, prefix, suffix, true, deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(43);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(44);
        }
        return FileUtilRt.createTempFile(dir2, prefix, suffix, true, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix, boolean create2) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(45);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(46);
        }
        return FileUtilRt.createTempFile(dir2, prefix, suffix, create2, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix, boolean create2, boolean deleteOnExit) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(47);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(48);
        }
        File file = FileUtilRt.doCreateTempFile(dir2, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create2 && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete a file: " + file);
        }
        File file2 = file;
        if (file2 == null) {
            FileUtilRt.$$$reportNull$$$0(49);
        }
        return file2;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir2, @NotNull String prefix, @Nullable String suffix, boolean isDirectory) throws IOException {
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(50);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(51);
        }
        dir2.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int attempts = 0;
        int i = 0;
        int maxFileNumber = 10;
        IOException exception = null;
        while (true) {
            File f = null;
            try {
                boolean success;
                f = FileUtilRt.calcName(dir2, prefix, suffix, i);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (success) {
                    return FileUtilRt.normalizeFile(f);
                }
            }
            catch (IOException e) {
                exception = e;
            }
            int MAX_ATTEMPTS = 100;
            if (++attempts > maxFileNumber / 2 || attempts > MAX_ATTEMPTS) {
                Object[] children = dir2.list();
                int size = children == null ? 0 : children.length;
                maxFileNumber = Math.max(10, size * 10);
                if (attempts > MAX_ATTEMPTS) {
                    throw exception != null ? exception : new IOException("Unable to create a temporary file " + f + "\nDirectory '" + dir2 + "' list (" + size + " children): " + Arrays.toString(children));
                }
            }
            if (++i <= 2) continue;
            i = 2 + RANDOM.nextInt(maxFileNumber);
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir2, @NotNull String prefix, @NotNull String suffix, int i) throws IOException {
        File f;
        String name2;
        if (dir2 == null) {
            FileUtilRt.$$$reportNull$$$0(52);
        }
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(53);
        }
        if (suffix == null) {
            FileUtilRt.$$$reportNull$$$0(54);
        }
        String string = prefix = i == 0 ? prefix : prefix + i;
        if (prefix.endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name2 = prefix + suffix).equals((f = new File(dir2, name2)).getName())) {
            throw new IOException("A generated name is malformed: '" + name2 + "' (" + f + ")");
        }
        File file = f;
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(55);
        }
        return file;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        if (temp == null) {
            FileUtilRt.$$$reportNull$$$0(56);
        }
        File canonical = temp.getCanonicalFile();
        File file = SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(57);
        }
        return file;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        String string = ourCanonicalTempPathCache;
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file;
        block4: {
            String string;
            file = new File(System.getProperty("java.io.tmpdir"));
            try {
                String canonical = file.getCanonicalPath();
                if (SystemInfoRt.isWindows && canonical.contains(" ")) break block4;
                string = canonical;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                FileUtilRt.$$$reportNull$$$0(59);
            }
            return string;
        }
        String string = file.getAbsolutePath();
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(60);
        }
        return string;
    }

    @TestOnly
    static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        if (tempPath == null) {
            FileUtilRt.$$$reportNull$$$0(61);
        }
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        return FileUtilRt.generateRandomTemporaryPath("", "");
    }

    @NotNull
    public static File generateRandomTemporaryPath(@NotNull String prefix, @NotNull String suffix) throws IOException {
        if (prefix == null) {
            FileUtilRt.$$$reportNull$$$0(62);
        }
        if (suffix == null) {
            FileUtilRt.$$$reportNull$$$0(63);
        }
        File file = new File(FileUtilRt.getTempDirectory(), prefix + UUID.randomUUID() + suffix);
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), prefix + UUID.randomUUID() + suffix);
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        return FileUtilRt.normalizeFile(file);
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(64);
        }
        return FileUtilRt.loadFile(file, null, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(65);
        }
        return FileUtilRt.loadFile(file, null, convertLineSeparators);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(66);
        }
        return FileUtilRt.loadFile(file, encoding, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(67);
        }
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        String string = convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
        if (string == null) {
            FileUtilRt.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(69);
        }
        return FileUtilRt.loadFileText(file, (String)null);
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable String encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block7: {
            if (file == null) {
                FileUtilRt.$$$reportNull$$$0(70);
            }
            FileInputStream stream = new FileInputStream(file);
            reader = encoding == null ? new InputStreamReader((InputStream)stream, Charset.defaultCharset()) : new InputStreamReader((InputStream)stream, encoding);
            cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray != null) break block7;
            FileUtilRt.$$$reportNull$$$0(71);
        }
        return cArray;
        finally {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file, @NotNull Charset encoding) throws IOException {
        char[] cArray;
        InputStreamReader reader;
        block7: {
            if (file == null) {
                FileUtilRt.$$$reportNull$$$0(72);
            }
            if (encoding == null) {
                FileUtilRt.$$$reportNull$$$0(73);
            }
            reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
            cArray = FileUtilRt.loadText(reader, (int)file.length());
            if (cArray != null) break block7;
            FileUtilRt.$$$reportNull$$$0(74);
        }
        return cArray;
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(75);
        }
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            if (chars == null) {
                FileUtilRt.$$$reportNull$$$0(76);
            }
            return chars;
        }
        char[] cArray = Arrays.copyOf(chars, count);
        if (cArray == null) {
            FileUtilRt.$$$reportNull$$$0(77);
        }
        return cArray;
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(78);
        }
        return FileUtilRt.loadLines(file.getPath());
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable String encoding) throws IOException {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(79);
        }
        return FileUtilRt.loadLines(file.getPath(), encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(80);
        }
        return FileUtilRt.loadLines(path, null);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(81);
        }
        FileInputStream stream = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(encoding == null ? new InputStreamReader((InputStream)stream, Charset.defaultCharset()) : new InputStreamReader((InputStream)stream, encoding));
        List<String> list = FileUtilRt.loadLines(reader);
        List<String> list2 = list;
        if (list2 == null) {
            FileUtilRt.$$$reportNull$$$0(82);
        }
        return list2;
        finally {
            reader.close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        if (reader == null) {
            FileUtilRt.$$$reportNull$$$0(83);
        }
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            FileUtilRt.$$$reportNull$$$0(84);
        }
        return arrayList;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            FileUtilRt.$$$reportNull$$$0(85);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        byte[] byArray = buffer.toByteArray();
        if (byArray == null) {
            FileUtilRt.$$$reportNull$$$0(86);
        }
        return byArray;
    }

    @Deprecated
    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (stream == null) {
            FileUtilRt.$$$reportNull$$$0(87);
        }
        if (length == 0) {
            if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
                FileUtilRt.$$$reportNull$$$0(88);
            }
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        if (bytes == null) {
            FileUtilRt.$$$reportNull$$$0(89);
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(90);
        }
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(91);
        }
        try {
            FileUtilRt.deleteRecursively(file.toPath());
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static void deleteRecursively(@NotNull Path path) throws IOException {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(92);
        }
        FileUtilRt.deleteRecursively(path, null);
    }

    static void deleteRecursively(@NotNull Path path, final @Nullable DeleteRecursivelyCallback callback) throws IOException {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(93);
        }
        if (!Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) throws IOException {
                    if (SystemInfoRt.isWindows && attrs.isOther()) {
                        FileUtilRt.doDelete(dir2);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (callback != null) {
                        callback.beforeDeleting(file);
                    }
                    FileUtilRt.doDelete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir2, IOException exc) throws IOException {
                    try {
                        if (callback != null) {
                            callback.beforeDeleting(dir2);
                        }
                        FileUtilRt.doDelete(dir2);
                        return FileVisitResult.CONTINUE;
                    }
                    catch (IOException e) {
                        if (exc != null) {
                            exc.addSuppressed(e);
                            throw exc;
                        }
                        throw e;
                    }
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    if (SystemInfoRt.isWindows && exc instanceof NoSuchFileException) {
                        FileUtilRt.doDelete(file);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private static void doDelete(Path path) throws IOException {
        for (int attemptsLeft = 10; attemptsLeft > 0; --attemptsLeft) {
            try {
                Files.deleteIfExists(path);
                return;
            }
            catch (IOException e) {
                if (!SystemInfoRt.isWindows || attemptsLeft == 1) {
                    if (e instanceof DirectoryNotEmptyException) {
                        DirectoryNotEmptyException replacingEx = FileUtilRt.directoryNotEmptyExceptionWithMoreDiagnostic(path);
                        replacingEx.addSuppressed(e);
                        throw replacingEx;
                    }
                    throw e;
                }
                if (e instanceof AccessDeniedException) {
                    try {
                        File file = path.toFile();
                        if (file.delete() || !file.exists()) {
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (attemptsLeft == 5 && TRY_GC_IF_FILE_DELETE_FAILS) {
                        System.gc();
                        System.runFinalization();
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    private static DirectoryNotEmptyException directoryNotEmptyExceptionWithMoreDiagnostic(@NotNull Path path) throws IOException {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(94);
        }
        DirectoryStream.Filter<Path> alwaysTrue = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return true;
            }
        };
        try (DirectoryStream<Path> children = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)alwaysTrue);){
            StringBuilder sb = new StringBuilder();
            for (Path child : children) {
                sb.append(child.getFileName()).append(", ");
            }
            DirectoryNotEmptyException directoryNotEmptyException = new DirectoryNotEmptyException(path.toAbsolutePath() + " (children: " + sb + ")");
            return directoryNotEmptyException;
        }
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        if (ioTask == null) {
            FileUtilRt.$$$reportNull$$$0(95);
        }
        for (int i = 10; i > 0; --i) {
            T result2 = ioTask.execute(i == 1);
            if (result2 != null) {
                return result2;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(97);
        }
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(98);
        }
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentPath;
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(99);
        }
        return (parentPath = file.getParentFile()) == null || FileUtilRt.createDirectory(parentPath);
    }

    public static boolean createDirectory(@NotNull File path) {
        if (path == null) {
            FileUtilRt.$$$reportNull$$$0(100);
        }
        return path.isDirectory() || path.mkdirs();
    }

    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block16: {
            int read2;
            if (inputStream == null) {
                FileUtilRt.$$$reportNull$$$0(103);
            }
            if (outputStream == null) {
                FileUtilRt.$$$reportNull$$$0(104);
            }
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                try (FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                     FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();){
                    fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                    break block16;
                }
            }
            byte[] buffer = new byte[8192];
            while ((read2 = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read2);
            }
        }
    }

    public static int getUserFileSizeLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.intellisense.filesize", 2560000);
    }

    public static int getUserContentLoadLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.filesize", 0x1400000);
    }

    private static int getLargeFilePreviewSize() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.large.preview.size", 2560000);
    }

    private static int parseKilobyteProperty(String key, int defaultValue) {
        try {
            long i = Integer.parseInt(System.getProperty(key, String.valueOf(defaultValue / 1024)));
            if (i < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.min(i * 1024L, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    @NotNull
    public static URI fileToUri(@NotNull File file) {
        if (file == null) {
            FileUtilRt.$$$reportNull$$$0(105);
        }
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.startsWith("//")) {
            path = "//" + path;
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    public static int pathHashCode(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return 0;
        }
        path = FileUtilRt.toCanonicalPath(path, File.separatorChar, true);
        return SystemInfoRt.isFileSystemCaseSensitive ? path.hashCode() : StringUtilRt.stringHashCodeInsensitive(path);
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtilRt.toCanonicalPath(path1, File.separatorChar, true);
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return path1.equals(path2);
        }
        return path1.equalsIgnoreCase(path2);
    }

    static {
        RANDOM = new Random();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 19: 
            case 20: 
            case 22: 
            case 80: 
            case 81: 
            case 92: 
            case 93: 
            case 94: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 16: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedName";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 46: 
            case 48: 
            case 51: 
            case 53: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 36: 
            case 38: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 54: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temp";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempPath";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 75: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ioTask";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromFile";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFile";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemIndependentName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureEnds";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFile";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "calcName";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFile";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirectory";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCanonicalTempPath";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 71: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileText";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLines";
                break;
            }
            case 86: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "loadBytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isJarOrZip";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFilePathAcceptable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processRoot";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processDots";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extensionEquals";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fileNameEquals";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "toSystemIndependentName";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureEnds";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTempDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createTempFile";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "doCreateTempFile";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "calcName";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFile";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "resetCanonicalTempPathCache";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "generateRandomTemporaryPath";
                break;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "loadFileText";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "loadLines";
                break;
            }
            case 85: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "loadBytes";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "deleteRecursively";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "directoryNotEmptyExceptionWithMoreDiagnostic";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "doIOOperation";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "ensureCanCreateFile";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "createIfNotExists";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirs";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "fileToUri";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 11: 
            case 21: 
            case 23: 
            case 29: 
            case 31: 
            case 33: 
            case 40: 
            case 49: 
            case 55: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 68: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 82: 
            case 84: 
            case 86: 
            case 88: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface SymlinkResolver {
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String var1, char var2, boolean var3);

        public boolean isSymlink(@NotNull CharSequence var1);
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        @NotNull
        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                @Override
                public void run() {
                    String name2;
                    while ((name2 = (String)queue.poll()) != null) {
                        FileUtilRt.delete(new File(name2));
                    }
                }
            });
            ConcurrentLinkedQueue<String> concurrentLinkedQueue = queue;
            if (concurrentLinkedQueue == null) {
                FilesToDeleteHolder.$$$reportNull$$$0(0);
            }
            return concurrentLinkedQueue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileUtilRt$FilesToDeleteHolder", "createFilesToDelete"));
        }
    }

    @ApiStatus.Internal
    public static interface DeleteRecursivelyCallback {
        public void beforeDeleting(Path var1);
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }
}

