/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValueListener;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.ValueWithSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\u0018\u0000 -2\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u001b\u001a\u00020\n2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u001a\u0010 \u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b!2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001dJ)\u0010\"\u001a\u00070\u0006\u00a2\u0006\u0002\b!2\u000b\u0010\u001c\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001d2\b\u0010#\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0002\b$J\b\u0010%\u001a\u00020&H\u0007J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070(H\u0007J\u0014\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060(H\u0007J\b\u0010*\u001a\u00020\u001fH\u0007R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0011R\u0011\u0010,\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0011\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry;", "", "<init>", "()V", "userProperties", "Ljava/util/LinkedHashMap;", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/ValueWithSource;", "values", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue;", "contributedKeys", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryKeyDescriptor;", "value", "", "isLoaded", "()Z", "loadFuture", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValueListener;", "valueChangeListener", "getValueChangeListener", "()Lcom/intellij/openapi/util/registry/RegistryValueListener;", "valueProducer", "Ljava/util/function/Function;", "resolveValue", "key", "Lorg/jetbrains/annotations/NonNls;", "reset", "", "getBundleValueOrNull", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/NlsSafe;", "getBundleValue", "keyDescriptor", "getBundleValue$intellij_platform_util", "getState", "Lorg/jetbrains/kotlin/org/jdom/Element;", "getStoredProperties", "", "getUserProperties", "restoreDefaults", "isInDefaultState", "isRestartNeeded", "Companion", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n462#2:428\n412#2:429\n1246#3,4:430\n*S KotlinDebug\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry\n*L\n401#1:428\n401#1:429\n401#1:430,4\n*E\n"})
public final class Registry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, ValueWithSource> userProperties = new LinkedHashMap();
    @NotNull
    private final ConcurrentHashMap<String, RegistryValue> values = new ConcurrentHashMap();
    @NotNull
    private Map<String, RegistryKeyDescriptor> contributedKeys = MapsKt.emptyMap();
    private volatile boolean isLoaded;
    @NotNull
    private volatile CompletableFuture<Void> loadFuture = new CompletableFuture();
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;
    @NotNull
    private final Function<String, RegistryValue> valueProducer = arg_0 -> Registry.valueProducer$lambda$0(this, arg_0);
    @Nullable
    private static Reference<Map<String, String>> bundledRegistry;
    @NotNull
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    @NotNull
    private static final Registry registry;

    public final boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    public final RegistryValueListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    private final RegistryValue resolveValue(String key) {
        RegistryValue registryValue = this.values.computeIfAbsent(key, this.valueProducer);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"computeIfAbsent(...)");
        return registryValue;
    }

    @Nullable
    public final String getBundleValueOrNull(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = this.contributedKeys.get(key);
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            Map map = Registry.Companion.loadFromBundledConfig();
            object = map != null ? (String)map.get(key) : null;
        }
        return object;
    }

    @NotNull
    public final String getBundleValue$intellij_platform_util(@NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) throws MissingResourceException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object object = keyDescriptor;
        if (object == null || (object = ((RegistryKeyDescriptor)object).getDefaultValue()) == null) {
            RegistryKeyDescriptor registryKeyDescriptor = this.contributedKeys.get(key);
            object = registryKeyDescriptor != null ? registryKeyDescriptor.getDefaultValue() : null;
            if (object == null) {
                Map map = Registry.Companion.loadFromBundledConfig();
                object = map != null ? (String)map.get(key) : null;
                if (object == null) {
                    throw new MissingResourceException("Registry key " + key + " is not defined", "misc.registry", key);
                }
            }
        }
        return object;
    }

    @ApiStatus.Internal
    @NotNull
    public final Map<String, ValueWithSource> getStoredProperties() {
        return this.userProperties;
    }

    private static final RegistryValue valueProducer$lambda$0(Registry this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RegistryValue(this$0, it, this$0.contributedKeys.get(it));
    }

    @JvmStatic
    @NotNull
    public static final RegistryValue get(@NotNull String key) {
        return Companion.get(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key) throws MissingResourceException {
        return Companion.is(key);
    }

    @JvmStatic
    public static final boolean is(@NotNull String key, boolean defaultValue) {
        return Companion.is(key, defaultValue);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key) throws MissingResourceException {
        return Companion.intValue(key);
    }

    @JvmStatic
    public static final int intValue(@NotNull String key, int defaultValue) {
        return Companion.intValue(key, defaultValue);
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        registry = new Registry();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000e\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\b\u0002\u0010\u0014\u001a\u00020\u0013H\u0007J\u0015\u0010\u0015\u001a\u00020\u000f2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010\u0016\u001a\u00020\u00132\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010\u0016\u001a\u00020\u00132\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0015\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u001d\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u0018H\u0007J\u001d\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u001aH\u0007J\u0015\u0010\u0019\u001a\u00020\u001a2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J\u0015\u0010\u001b\u001a\u00020\u00072\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\tH\u0007J!\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001dH\u0007J\u0016\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002J$\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00072\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\"H\u0002J\b\u0010#\u001a\u00020\rH\u0007J-\u0010\u0017\u001a\u00020\u00182\u000b\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\u0014\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0018H\u0007J\u001c\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0\u00062\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J4\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0\u00062\b\u0010(\u001a\u0004\u0018\u00010)2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0007J\b\u0010-\u001a\u00020.H\u0007J\u000e\u0010/\u001a\u00020.H\u0087@\u00a2\u0006\u0002\u00100J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f02H\u0007J\u001c\u00103\u001a\u00020\u00132\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0\u0006H\u0002J\u001c\u00105\u001a\u00020.2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002070\u0006H\u0007J4\u00108\u001a\u00020.2*\u00109\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002070\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002070\u00060:H\u0007J\u0012\u0010;\u001a\u00020.2\b\u0010<\u001a\u0004\u0018\u00010\u000bH\u0007J<\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010)2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>\u00b2\u0006\n\u0010?\u001a\u00020\u000fX\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry$Companion;", "", "<init>", "()V", "bundledRegistry", "Ljava/lang/ref/Reference;", "", "", "REGISTRY_BUNDLE", "Lorg/jetbrains/annotations/NonNls;", "EMPTY_VALUE_LISTENER", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValueListener;", "registry", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry;", "get", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryValue;", "key", "booleanValueHotSupplier", "Lkotlin/Function0;", "", "defaultValue", "_getWithoutStateCheck", "is", "intValue", "", "doubleValue", "", "stringValue", "getColor", "Ljava/awt/Color;", "loadFromBundledConfig", "loadFromResource", "sourceResourceName", "targetMap", "", "getInstance", "minValue", "maxValue", "fromState", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/ValueWithSource;", "state", "Lorg/jetbrains/kotlin/org/jdom/Element;", "updateStateInternal", "loadState", "earlyAccess", "markAsLoaded", "", "awaitLoad", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAll", "", "isRestartNeeded", "map", "setContributedKeys", "descriptors", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/registry/RegistryKeyDescriptor;", "mutateContributedKeys", "mutator", "Lkotlin/Function1;", "setValueChangeListener", "listener", "loadStateInternal", "intellij.platform.util", "valueHandle"})
    @SourceDebugExtension(value={"SMAP\nRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,427:1\n462#2:428\n412#2:429\n1246#3,4:430\n*S KotlinDebug\n*F\n+ 1 Registry.kt\ncom/intellij/openapi/util/registry/Registry$Companion\n*L\n338#1:428\n338#1:429\n338#1:430,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RegistryValue get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key);
        }

        @JvmStatic
        public final boolean is(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asBoolean();
        }

        @JvmStatic
        public final boolean is(@NotNull String key, boolean defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                return defaultValue;
            }
            try {
                return registry.resolveValue(key).asBoolean();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        @JvmStatic
        public final int intValue(@NotNull String key) throws MissingResourceException {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.getInstance().resolveValue(key).asInteger();
        }

        @JvmStatic
        public final int intValue(@NotNull String key, int defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
                LoadingState.COMPONENTS_REGISTERED.checkOccurred();
                return defaultValue;
            }
            try {
                return registry.resolveValue(key).asInteger();
            }
            catch (MissingResourceException missingResourceException) {
                return defaultValue;
            }
        }

        private final Map<String, String> loadFromBundledConfig() throws IOException {
            Map map;
            Reference reference2 = bundledRegistry;
            if (reference2 != null && (map = (Map)reference2.get()) != null) {
                Map it = map;
                boolean bl = false;
                return it;
            }
            LinkedHashMap map2 = new LinkedHashMap(1800);
            boolean mainFound = this.loadFromResource("misc/registry.properties", map2);
            boolean overrideFound = this.loadFromResource("misc/registry.override.properties", map2);
            if (!mainFound && !overrideFound) {
                return null;
            }
            bundledRegistry = new SoftReference(map2);
            return map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean loadFromResource(String sourceResourceName, Map<String, String> targetMap) {
            InputStream inputStream = Registry.class.getClassLoader().getResourceAsStream(sourceResourceName);
            if (inputStream == null) {
                return false;
            }
            InputStream stream = inputStream;
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                new Properties(targetMap){
                    final /* synthetic */ Map<String, String> $targetMap;
                    {
                        this.$targetMap = $targetMap;
                    }

                    public Object put(Object key, Object value2) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        return this.$targetMap.put((String)key, (String)value2);
                    }
                }.load(stream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }

        @JvmStatic
        @NotNull
        public final Registry getInstance() {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            return registry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

