/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    private static final Key<String> INVALIDATION_REASON = Key.create("INVALIDATION_REASON");
    private static final Key<Throwable> INVALIDATION_TRACE = Key.create("INVALIDATION_TRACE");

    public InvalidVirtualFileAccessException(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(0);
        }
        super(InvalidVirtualFileAccessException.composeMessage(file));
        this.initCause(InvalidVirtualFileAccessException.getInvalidationTrace(file));
    }

    @NonNls
    private static String composeMessage(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(2);
        }
        String url = file.getUrl();
        @NonNls String message2 = "Accessing invalid virtual file: " + url;
        String reason = InvalidVirtualFileAccessException.getInvalidationReason(file);
        if (reason != null) {
            message2 = message2 + "; reason: " + reason;
        }
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message2 = message2 + "; original:" + InvalidVirtualFileAccessException.hashCode(file) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file.isInLocalFileSystem()) {
                boolean physicalExists = new File(file.getPath()).exists();
                message2 = message2 + "; File.exists()=" + physicalExists;
            } else {
                message2 = message2 + "; file system=" + file.getFileSystem();
            }
        }
        catch (Throwable t) {
            message2 = message2 + "; lookup failed: " + t.getMessage();
        }
        return message2;
    }

    private static String hashCode(Object o) {
        return o == null ? "-" : String.valueOf(o.hashCode());
    }

    @Nullable
    private static Throwable getInvalidationTrace(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(5);
        }
        return file.getUserData(INVALIDATION_TRACE);
    }

    @ApiStatus.Internal
    @Nullable
    public static String getInvalidationReason(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(6);
        }
        return file.getUserData(INVALIDATION_REASON);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/InvalidVirtualFileAccessException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "composeMessage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "appendInvalidationReason";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidationTrace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInvalidationReason";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

