/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public abstract class ArchiveHandler {
    public static final FileAttributes DIRECTORY_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, -1L, false, FileAttributes.CaseSensitivity.SENSITIVE);
    private final Path myPath;
    private final Object myLock;
    private volatile Reference<Map<String, EntryInfo>> myEntries;
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries;
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){};

    protected ArchiveHandler(@NotNull String path) {
        if (path == null) {
            ArchiveHandler.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myEntries = new SoftReference<Object>(null);
        this.myChildrenEntries = new SoftReference<Object>(null);
        this.myPath = Paths.get(path, new String[0]);
    }

    @NotNull
    public Path getPath() {
        Path path = this.myPath;
        if (path == null) {
            ArchiveHandler.$$$reportNull$$$0(1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.OverrideOnly
    public void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        if (relativePath == null) {
            ArchiveHandler.$$$reportNull$$$0(9);
        }
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.getPath(), e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference<Map<String, EntryInfo>>(map);
                    this.myChildrenEntries = new SoftReference<Object>(null);
                }
            }
        }
        Map<String, EntryInfo> map2 = map;
        if (map2 == null) {
            ArchiveHandler.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @ApiStatus.Internal
    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map, @Nullable Logger logger, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        String normalizedName;
        if (map == null) {
            ArchiveHandler.$$$reportNull$$$0(13);
        }
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(14);
        }
        if ((normalizedName = this.normalizeName(entryName)).isEmpty() || normalizedName.contains("..") && ArrayUtil.contains("..", normalizedName.split("/"))) {
            if (logger != null) {
                logger.trace("invalid entry: " + this.getPath() + "!/" + entryName);
            }
            return;
        }
        if (entryFun == null) {
            this.directoryEntry(map, logger, normalizedName);
            return;
        }
        EntryInfo existing = map.get(normalizedName);
        if (existing != null) {
            if (logger != null) {
                logger.trace("duplicate entry: " + this.getPath() + "!/" + normalizedName);
            }
            return;
        }
        Pair<String, String> path = ArchiveHandler.split(normalizedName);
        EntryInfo parent2 = this.directoryEntry(map, logger, (String)path.first);
        map.put(normalizedName, entryFun.apply(parent2, (String)path.second));
    }

    @NotNull
    protected String normalizeName(@NotNull String entryName) {
        if (entryName == null) {
            ArchiveHandler.$$$reportNull$$$0(15);
        }
        String string = StringUtil.trimTrailing(StringUtil.trimLeading(FileUtil.normalize(entryName), '/'), '/');
        if (string == null) {
            ArchiveHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    private EntryInfo directoryEntry(Map<String, EntryInfo> map, @Nullable Logger logger, String normalizedName) {
        EntryInfo entry = map.get(normalizedName);
        if (entry == null || !entry.isDirectory) {
            if (logger != null && entry != null) {
                logger.trace("duplicate entry: " + this.getPath() + "!/" + normalizedName);
            }
            if (normalizedName.isEmpty()) {
                entry = this.createRootEntry();
            } else {
                Pair<String, String> path = ArchiveHandler.split(normalizedName);
                EntryInfo parent2 = this.directoryEntry(map, logger, (String)path.first);
                entry = new EntryInfo((CharSequence)path.second, true, 0L, -1L, parent2);
            }
            map.put(normalizedName, entry);
        }
        return entry;
    }

    private static Pair<String, String> split(String normalizedName) {
        int p = normalizedName.lastIndexOf(47);
        String parentPath = p > 0 ? normalizedName.substring(0, p) : "";
        String shortName = p > 0 ? normalizedName.substring(p + 1) : normalizedName;
        return new Pair<String, String>(parentPath, shortName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntriesMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEntryInfo";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processEntry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "normalizeName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        /*
         * WARNING - void declaration
         */
        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo entryInfo) {
            void parent2;
            if (shortName == null) {
                EntryInfo.$$$reportNull$$$0(0);
            }
            this.parent = parent2;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortName", "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/ArchiveHandler$EntryInfo", "<init>"));
        }
    }
}

