/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.impl;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationManagerEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileCopyEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManagerListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileMoveEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.CachingVirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

public class VirtualFileManagerImpl
extends VirtualFileManager
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VirtualFileManagerImpl.class);
    private static final ExtensionPointImpl<VirtualFileManagerListener> MANAGER_LISTENER_EP = ((ExtensionsAreaImpl)ApplicationManager.getApplication().getExtensionArea()).getExtensionPoint("org.jetbrains.kotlin.com.intellij.virtualFileManagerListener");
    private final List<? extends VirtualFileSystem> myPreCreatedFileSystems;
    private final KeyedExtensionCollector<VirtualFileSystem, String> myCollector;
    private final EventDispatcher<VirtualFileListener> myVirtualFileListenerMulticaster;
    private final List<VirtualFileManagerListener> virtualFileManagerListeners;
    private final List<Object> asyncFileListeners;

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems) {
        if (preCreatedFileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(0);
        }
        this(preCreatedFileSystems, ApplicationManager.getApplication().getMessageBus());
    }

    public VirtualFileManagerImpl(@NotNull List<? extends VirtualFileSystem> preCreatedFileSystems, @NotNull MessageBus bus) {
        if (preCreatedFileSystems == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(1);
        }
        if (bus == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(2);
        }
        this.myCollector = new KeyedExtensionCollector(VirtualFileSystem.EP_NAME);
        this.myVirtualFileListenerMulticaster = EventDispatcher.create(VirtualFileListener.class);
        this.virtualFileManagerListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.asyncFileListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myPreCreatedFileSystems = new ArrayList<VirtualFileSystem>(preCreatedFileSystems);
        for (VirtualFileSystem virtualFileSystem : preCreatedFileSystems) {
            this.myCollector.addExplicitExtension(virtualFileSystem.getProtocol(), virtualFileSystem);
            if (virtualFileSystem instanceof CachingVirtualFileSystem) continue;
            virtualFileSystem.addVirtualFileListener(this.myVirtualFileListenerMulticaster.getMulticaster());
        }
        this.addVirtualFileListener(new LoggingListener());
        bus.connect().subscribe(VFS_CHANGES, new BulkVirtualFileListenerAdapter(this.myVirtualFileListenerMulticaster.getMulticaster()));
    }

    @Override
    public void dispose() {
    }

    @Override
    public long getStructureModificationCount() {
        return 0L;
    }

    @Override
    @Nullable
    public VirtualFileSystem getFileSystem(@Nullable String protocol) {
        if (protocol == null) {
            return null;
        }
        List<? extends VirtualFileSystem> candidates = this.getFileSystemsForProtocol(protocol);
        int size = candidates.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            LOG.error(">1 file system registered for protocol [" + protocol + "]: " + candidates);
        }
        return candidates.get(0);
    }

    @NotNull
    protected List<? extends VirtualFileSystem> getFileSystemsForProtocol(@NotNull String protocol) {
        if (protocol == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(4);
        }
        List<VirtualFileSystem> list = this.myCollector.forKey(protocol);
        if (list == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener) {
        if (listener == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(6);
        }
        this.myVirtualFileListenerMulticaster.addListener(listener);
    }

    @Override
    public void notifyPropertyChanged(@NotNull VirtualFile virtualFile, @NotNull String property2, Object oldValue, Object newValue) {
        if (virtualFile == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(17);
        }
        if (property2 == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(18);
        }
        Application app = ApplicationManager.getApplication();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (virtualFile.isValid()) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    List<VFilePropertyChangeEvent> events = Collections.singletonList(new VFilePropertyChangeEvent(this, virtualFile, property2, oldValue, newValue));
                    BulkFileListener listener = (BulkFileListener)app.getMessageBus().syncPublisher(VFS_CHANGES);
                    listener.before(events);
                    listener.after(events);
                });
            }
        }, ModalityState.nonModal());
    }

    @Override
    public long getModificationCount() {
        return 0L;
    }

    @Override
    @NotNull
    public CharSequence getVFileName(int nameId) {
        throw new AbstractMethodError();
    }

    @Override
    public VirtualFile findFileByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(20);
        }
        return this.findByUrl(url, false);
    }

    @Nullable
    private VirtualFile findByUrl(@NotNull String url, boolean refresh) {
        int protocolSepIndex;
        VirtualFileSystem fileSystem;
        if (url == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(22);
        }
        VirtualFileSystem virtualFileSystem = fileSystem = (protocolSepIndex = url.indexOf("://")) < 0 ? null : this.getFileSystem(url.substring(0, protocolSepIndex));
        if (fileSystem == null) {
            return null;
        }
        String path = url.substring(protocolSepIndex + "://".length());
        return refresh ? fileSystem.refreshAndFindFileByPath(path) : fileSystem.findFileByPath(path);
    }

    @Override
    @Nullable
    public VirtualFile findFileByNioPath(@NotNull Path path) {
        if (path == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(23);
        }
        return this.findByNioPath(path, false);
    }

    @Nullable
    private VirtualFile findByNioPath(@NotNull Path nioPath, boolean refresh) {
        if (nioPath == null) {
            VirtualFileManagerImpl.$$$reportNull$$$0(25);
        }
        if (!FileSystems.getDefault().equals(nioPath.getFileSystem())) {
            return null;
        }
        VirtualFileSystem fileSystem = this.getFileSystem("file");
        if (fileSystem == null) {
            return null;
        }
        String path = nioPath.toString();
        return refresh ? fileSystem.refreshAndFindFileByPath(path) : fileSystem.findFileByPath(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preCreatedFileSystems";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nioPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhysicalFileSystems";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystemsForProtocol";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "withAsyncFileListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystemsForProtocol";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileManagerListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileManagerListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAsyncFileListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withAsyncFileListeners";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyPropertyChanged";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "storeName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFileByUrl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByUrl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findByUrl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileByNioPath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByNioPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findByNioPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LoggingListener
    implements VirtualFileListener {
        private LoggingListener() {
        }

        @Override
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(0);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("propertyChanged: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(1);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("contentsChanged: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(2);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("fileCreated: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(3);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("fileDeleted: file = " + event.getFile() + ", parent = " + event.getParent() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(4);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("fileMoved: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(5);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("fileCopied: file = " + event.getFile() + ", originalFile = " + event.getOriginalFile() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void beforeContentsChange(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(6);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("beforeContentsChange: file = " + event.getFile() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void beforePropertyChange(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(7);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("beforePropertyChange: file = " + event.getFile() + ", propertyName = " + event.getPropertyName() + ", oldValue = " + event.getOldValue() + ", newValue = " + event.getNewValue() + ", requestor = " + event.getRequestor());
            }
        }

        @Override
        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(8);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("beforeFileDeletion: file = " + event.getFile() + ", requestor = " + event.getRequestor());
                LOG.assertTrue(event.getFile().isValid());
            }
        }

        @Override
        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                LoggingListener.$$$reportNull$$$0(9);
            }
            if (LoggingListener.shouldLog()) {
                LOG.debug("beforeFileMovement: file = " + event.getFile() + ", oldParent = " + event.getOldParent() + ", newParent = " + event.getNewParent() + ", requestor = " + event.getRequestor());
            }
        }

        private static boolean shouldLog() {
            return LOG.isDebugEnabled() && !ApplicationManagerEx.isInStressTest();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/impl/VirtualFileManagerImpl$LoggingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeContentsChange";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforePropertyChange";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

