/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.pom.tree.events.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;

public class ChangeInfoImpl {
    @Nullable
    private final ASTNode myOldChild;
    @Nullable
    private final ASTNode myNewChild;
    private final int myOffset;
    private final int myOldLength;
    private final int myNewLength;

    ChangeInfoImpl(@Nullable ASTNode oldChild, @Nullable ASTNode newChild, int offset, int oldLength) {
        this.myOldChild = oldChild;
        this.myNewChild = newChild;
        this.myOffset = offset;
        this.myOldLength = oldLength;
        this.myNewLength = newChild != null ? newChild.getTextLength() : 0;
    }

    public int getOffsetInParent() {
        return this.myOffset;
    }

    public int getOldLength() {
        return this.myOldLength;
    }

    @Nullable
    public ASTNode getNewChild() {
        return this.myNewChild;
    }

    public String toString() {
        return this.myOldChild + "(" + this.myOldLength + ")->" + this.myNewChild + "(" + this.myNewLength + ") at " + this.myOffset;
    }

    int getLengthDelta() {
        return this.myNewLength - this.myOldLength;
    }

    ASTNode getAffectedChild() {
        return this.myNewChild != null ? this.myNewChild : this.myOldChild;
    }

    void fireEvent(int parentStart, PsiFile file, ASTNode parent2) {
        PsiTreeChangeEventImpl e = ChangeInfoImpl.createEvent(file, this.myOffset + parentStart);
        if (this.myOldChild == this.myNewChild && this.myNewChild != null) {
            ChangeInfoImpl.childrenChanged(e, this.myNewChild, this.myOldLength);
        } else if (this.myOldChild != null && this.myNewChild != null) {
            this.childReplaced(e, this.myOldChild, this.myNewChild, parent2);
        } else if (this.myOldChild != null) {
            this.childRemoved(e, this.myOldChild, parent2);
        } else if (this.myNewChild != null) {
            ChangeInfoImpl.childAdded(e, this.myNewChild, parent2);
        }
    }

    @NotNull
    static PsiTreeChangeEventImpl createEvent(PsiFile file, int offset) {
        PsiTreeChangeEventImpl e = new PsiTreeChangeEventImpl(file.getManager());
        e.setFile(file);
        e.setOffset(offset);
        PsiTreeChangeEventImpl psiTreeChangeEventImpl = e;
        if (psiTreeChangeEventImpl == null) {
            ChangeInfoImpl.$$$reportNull$$$0(0);
        }
        return psiTreeChangeEventImpl;
    }

    boolean hasNoPsi() {
        return this.myOldChild != null && this.myOldChild.getPsi() == null || this.myNewChild != null && this.myNewChild.getPsi() == null;
    }

    private static void childAdded(PsiTreeChangeEventImpl e, ASTNode child, ASTNode parent2) {
        e.setParent(parent2.getPsi());
        e.setChild(child.getPsi());
        ChangeInfoImpl.getPsiManagerImpl(e).childAdded(e);
    }

    private void childRemoved(PsiTreeChangeEventImpl e, ASTNode child, ASTNode parent2) {
        e.setParent(parent2.getPsi());
        e.setChild(child.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childRemoved(e);
    }

    private void childReplaced(PsiTreeChangeEventImpl e, ASTNode oldChild, ASTNode newChild, ASTNode parent2) {
        e.setParent(parent2.getPsi());
        e.setOldChild(oldChild.getPsi());
        e.setChild(newChild.getPsi());
        e.setNewChild(newChild.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childReplaced(e);
    }

    static void childrenChanged(PsiTreeChangeEventImpl e, ASTNode parent2, int oldLength) {
        e.setParent(parent2.getPsi());
        e.setOldLength(oldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childrenChanged(e);
    }

    private static PsiManagerImpl getPsiManagerImpl(PsiTreeChangeEventImpl e) {
        return (PsiManagerImpl)e.getSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/pom/tree/events/impl/ChangeInfoImpl", "createEvent"));
    }
}

