/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.PlainTextLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.kotlin.com.intellij.openapi.util.Couple;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileUtil;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeFragment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.DiffLog;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ASTShallowComparator;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ASTStructure;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.ITemplateDataElementType;
import org.jetbrains.kotlin.com.intellij.psi.text.BlockSupport;
import org.jetbrains.kotlin.com.intellij.psi.tree.ICustomParsingType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IReparseableElementTypeBase;
import org.jetbrains.kotlin.com.intellij.psi.tree.IReparseableLeafElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.OuterLanguageElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTree;
import org.jetbrains.kotlin.com.intellij.util.diff.DiffTreeChangeBuilder;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.com.intellij.util.diff.ShallowNodeComparator;

@ApiStatus.Internal
public final class BlockSupportImpl
extends BlockSupport {
    private static final Logger LOG = Logger.getInstance(BlockSupportImpl.class);

    @Override
    public void reparseRange(@NotNull PsiFile file, int startOffset, int endOffset, @NotNull CharSequence newText) throws IncorrectOperationException {
        if (file == null) {
            BlockSupportImpl.$$$reportNull$$$0(0);
        }
        if (newText == null) {
            BlockSupportImpl.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(file.isValid());
        PsiFileImpl psiFile = (PsiFileImpl)file;
        Document document = psiFile.getViewProvider().getDocument();
        assert (document != null);
        document.replaceString(startOffset, endOffset, newText);
        PsiDocumentManager.getInstance(psiFile.getProject()).commitDocument(document);
    }

    @Override
    @NotNull
    public DiffLog reparseRange(@NotNull PsiFile file, @NotNull FileASTNode oldFileNode, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (file == null) {
            BlockSupportImpl.$$$reportNull$$$0(2);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(3);
        }
        if (changedPsiRange == null) {
            BlockSupportImpl.$$$reportNull$$$0(4);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(6);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(7);
        }
        DiffLog diffLog = BlockSupportImpl.reparse((PsiFile)file, (FileASTNode)oldFileNode, (TextRange)changedPsiRange, (CharSequence)newFileText, (ProgressIndicator)indicator, (CharSequence)lastCommittedText).log;
        if (diffLog == null) {
            BlockSupportImpl.$$$reportNull$$$0(8);
        }
        return diffLog;
    }

    @ApiStatus.Internal
    @NotNull
    public static ReparseResult reparse(@NotNull PsiFile file, @NotNull FileASTNode oldFileNode, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        PsiFileImpl fileImpl;
        Couple<ASTNode> rawReparseResult;
        if (file == null) {
            BlockSupportImpl.$$$reportNull$$$0(9);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(10);
        }
        if (changedPsiRange == null) {
            BlockSupportImpl.$$$reportNull$$$0(11);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(13);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(14);
        }
        if ((rawReparseResult = BlockSupportImpl.findReparseableNodeAndReparseIt(fileImpl = (PsiFileImpl)file, oldFileNode, changedPsiRange, newFileText)) == null) {
            return BlockSupportImpl.makeFullParse(fileImpl, oldFileNode, newFileText, indicator, lastCommittedText);
        }
        ASTNode oldRoot = (ASTNode)rawReparseResult.first;
        ASTNode newRoot = (ASTNode)rawReparseResult.second;
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldRoot, newRoot, indicator, lastCommittedText);
        return new ReparseResult(diffLog, oldRoot, newRoot);
    }

    @VisibleForTesting
    @Nullable
    public static Couple<ASTNode> findReparseableNodeAndReparseIt(@NotNull PsiFileImpl file, @NotNull FileASTNode oldFileNode, @NotNull TextRange changedPsiRange, @NotNull CharSequence newFileText) {
        Couple<ASTNode> reparseResult;
        Couple<ASTNode> reparseResult2;
        if (file == null) {
            BlockSupportImpl.$$$reportNull$$$0(15);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(16);
        }
        if (changedPsiRange == null) {
            BlockSupportImpl.$$$reportNull$$$0(17);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(18);
        }
        if (BlockSupportImpl.isTooDeep(file)) {
            return null;
        }
        Reparser reparser = new Reparser(file, oldFileNode, newFileText);
        boolean isTemplateFile = oldFileNode.getElementType() instanceof ITemplateDataElementType;
        ASTNode leafAtStart = oldFileNode.findLeafElementAt(Math.max(0, changedPsiRange.getStartOffset() - 1));
        ASTNode leafAtEnd = oldFileNode.findLeafElementAt(Math.min(changedPsiRange.getEndOffset(), oldFileNode.getTextLength() - 1));
        TextRange startLeafRange = leafAtStart == null ? null : leafAtStart.getTextRange();
        TextRange endLeafRange = leafAtEnd == null ? null : leafAtEnd.getTextRange();
        IElementType startLeafType = PsiUtilCore.getElementType(leafAtStart);
        if (startLeafType instanceof IReparseableLeafElementType && startLeafRange.getEndOffset() == changedPsiRange.getEndOffset() && (!isTemplateFile || startLeafType instanceof OuterLanguageElementType) && (reparseResult2 = reparser.reparseNode(leafAtStart)) != null && reparseResult2.first != null) {
            return reparseResult2;
        }
        IElementType endLeafType = PsiUtilCore.getElementType(leafAtEnd);
        if (endLeafType instanceof IReparseableLeafElementType && endLeafRange.getStartOffset() == changedPsiRange.getStartOffset() && (!isTemplateFile || endLeafType instanceof OuterLanguageElementType) && (reparseResult = reparser.reparseNode(leafAtEnd)) != null && reparseResult.first != null) {
            return reparseResult;
        }
        for (ASTNode node = leafAtStart != null && leafAtEnd != null ? TreeUtil.findCommonParent(leafAtStart, leafAtEnd) : oldFileNode; node != null && !(node instanceof FileElement); node = node.getTreeParent()) {
            if (isTemplateFile && !(PsiUtilCore.getElementType(node) instanceof OuterLanguageElementType)) {
                return null;
            }
            Couple<ASTNode> couple = reparser.reparseNode(node);
            if (couple == null) continue;
            if (couple.first == null) {
                return null;
            }
            return couple;
        }
        return null;
    }

    @Nullable
    private static ASTNode tryReparseNode(@NotNull IReparseableElementTypeBase reparseable, @NotNull ASTNode node, @NotNull CharSequence newTextStr, @NotNull PsiManager manager, @NotNull Language baseLanguage, @NotNull CharTable charTable) {
        ASTNode chameleon;
        if (reparseable == null) {
            BlockSupportImpl.$$$reportNull$$$0(19);
        }
        if (node == null) {
            BlockSupportImpl.$$$reportNull$$$0(20);
        }
        if (newTextStr == null) {
            BlockSupportImpl.$$$reportNull$$$0(21);
        }
        if (manager == null) {
            BlockSupportImpl.$$$reportNull$$$0(22);
        }
        if (baseLanguage == null) {
            BlockSupportImpl.$$$reportNull$$$0(23);
        }
        if (charTable == null) {
            BlockSupportImpl.$$$reportNull$$$0(24);
        }
        if (!reparseable.isReparseable(node, newTextStr, baseLanguage, manager.getProject())) {
            return null;
        }
        if (reparseable instanceof ICustomParsingType) {
            chameleon = ((ICustomParsingType)((Object)reparseable)).parse(newTextStr, SharedImplUtil.findCharTableByTree(node));
        } else if (reparseable instanceof ILazyParseableElementType) {
            chameleon = ((ILazyParseableElementType)((Object)reparseable)).createNode(newTextStr);
        } else {
            throw new AssertionError((Object)(reparseable.getClass() + " must either implement ICustomParsingType or extend ILazyParseableElementType"));
        }
        if (chameleon == null) {
            return null;
        }
        DummyHolder holder = DummyHolderFactory.createHolder(manager, null, node.getPsi(), charTable);
        holder.getTreeElement().rawAddChildren((TreeElement)chameleon);
        if (!reparseable.isValidReparse(node, chameleon)) {
            return null;
        }
        return chameleon;
    }

    @Nullable
    private static ASTNode tryReparseLeaf(@NotNull IReparseableLeafElementType reparseable, @NotNull ASTNode node, @NotNull CharSequence newTextStr) {
        if (reparseable == null) {
            BlockSupportImpl.$$$reportNull$$$0(25);
        }
        if (node == null) {
            BlockSupportImpl.$$$reportNull$$$0(26);
        }
        if (newTextStr == null) {
            BlockSupportImpl.$$$reportNull$$$0(27);
        }
        return reparseable.reparseLeaf(node, newTextStr);
    }

    private static void reportInconsistentLength(PsiFile file, CharSequence newFileText, ASTNode node, int start, int end) {
        @NonNls String message2 = "Index out of bounds: type=" + node.getElementType() + "; file=" + file + "; file.class=" + file.getClass() + "; start=" + start + "; end=" + end + "; length=" + node.getTextLength();
        String newTextBefore = newFileText.subSequence(0, start).toString();
        String oldTextBefore = file.getText().subSequence(0, start).toString();
        if (oldTextBefore.equals(newTextBefore)) {
            message2 = message2 + "; oldTextBefore==newTextBefore";
        }
        LOG.error(message2, new Attachment(file.getName() + "_oldNodeText.txt", node.getText()), new Attachment(file.getName() + "_oldFileText.txt", file.getText()), new Attachment(file.getName() + "_newFileText.txt", newFileText.toString()));
    }

    @NotNull
    static ReparseResult makeFullParse(@NotNull PsiFileImpl fileImpl, @NotNull FileASTNode oldFileNode, @NotNull CharSequence newFileText, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (fileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(28);
        }
        if (oldFileNode == null) {
            BlockSupportImpl.$$$reportNull$$$0(29);
        }
        if (newFileText == null) {
            BlockSupportImpl.$$$reportNull$$$0(30);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(31);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(32);
        }
        if (fileImpl instanceof PsiCodeFragment) {
            FileElement parent2 = fileImpl.getTreeElement();
            PsiElement context2 = fileImpl.getContext();
            DummyHolder dummyHolder = new DummyHolder(fileImpl.getManager(), context2 != null && context2.isValid() ? context2 : null);
            FileElement holderElement = dummyHolder.getTreeElement();
            holderElement.rawAddChildren(fileImpl.createContentLeafElement(holderElement.getCharTable().intern(newFileText, 0, newFileText.length())));
            DiffLog diffLog = new DiffLog();
            diffLog.appendReplaceFileElement(parent2, (FileElement)holderElement.getFirstChildNode());
            return new ReparseResult(diffLog, oldFileNode, holderElement);
        }
        FileViewProvider viewProvider = fileImpl.getViewProvider();
        viewProvider.getLanguages();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        FileType fileType = virtualFile.getFileType();
        String fileName = fileImpl.getName();
        LightVirtualFile lightFile = new LightVirtualFile(fileName, fileType, newFileText, virtualFile.getCharset(), viewProvider.getModificationStamp());
        lightFile.setOriginalFile(virtualFile);
        FileViewProvider providerCopy = viewProvider.createCopy(lightFile);
        if (providerCopy.isEventSystemEnabled()) {
            throw new AssertionError((Object)("Copied view provider must be non-physical for reparse to deliver correct events: " + viewProvider));
        }
        providerCopy.getLanguages();
        SingleRootFileViewProvider.doNotCheckFileSizeLimit(lightFile);
        PsiFileImpl newFile = BlockSupportImpl.getFileCopy(fileImpl, providerCopy);
        newFile.setOriginalFile(fileImpl);
        FileASTNode newFileElement = newFile.getNode();
        if (lastCommittedText.length() != oldFileNode.getTextLength()) {
            throw new IncorrectOperationException(viewProvider.toString());
        }
        DiffLog diffLog = BlockSupportImpl.mergeTrees(fileImpl, oldFileNode, newFileElement, indicator, lastCommittedText);
        return new ReparseResult(diffLog, oldFileNode, newFileElement);
    }

    @NotNull
    public static PsiFileImpl getFileCopy(@NotNull PsiFileImpl originalFile, @NotNull FileViewProvider providerCopy) {
        if (originalFile == null) {
            BlockSupportImpl.$$$reportNull$$$0(33);
        }
        if (providerCopy == null) {
            BlockSupportImpl.$$$reportNull$$$0(34);
        }
        FileViewProvider viewProvider = originalFile.getViewProvider();
        Language language = originalFile.getLanguage();
        PsiFile file = providerCopy.getPsi(language);
        if (file != null && !(file instanceof PsiFileImpl)) {
            throw new RuntimeException("View provider " + viewProvider + " refused to provide PsiFileImpl for " + language + BlockSupportImpl.details(providerCopy, viewProvider) + " and returned this strange thing instead of PsiFileImpl: " + file + " (" + file.getClass() + ")");
        }
        PsiFileImpl newFile = (PsiFileImpl)file;
        if (newFile == null && language == PlainTextLanguage.INSTANCE && originalFile == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            newFile = (PsiFileImpl)providerCopy.getPsi(providerCopy.getBaseLanguage());
        }
        if (newFile == null) {
            throw new RuntimeException("View provider " + viewProvider + " refused to parse text with " + language + BlockSupportImpl.details(providerCopy, viewProvider));
        }
        PsiFileImpl psiFileImpl = newFile;
        if (psiFileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(35);
        }
        return psiFileImpl;
    }

    @NonNls
    private static String details(@NotNull FileViewProvider providerCopy, @NotNull FileViewProvider viewProvider) {
        if (providerCopy == null) {
            BlockSupportImpl.$$$reportNull$$$0(36);
        }
        if (viewProvider == null) {
            BlockSupportImpl.$$$reportNull$$$0(37);
        }
        return "; languages: " + viewProvider.getLanguages() + "; base: " + viewProvider.getBaseLanguage() + "; copy: " + providerCopy + "; copy.base: " + providerCopy.getBaseLanguage() + "; vFile: " + viewProvider.getVirtualFile() + "; copy.vFile: " + providerCopy.getVirtualFile() + "; fileType: " + viewProvider.getVirtualFile().getFileType() + "; copy.original(): " + VirtualFileUtil.originalFile(providerCopy.getVirtualFile());
    }

    @NotNull
    private static DiffLog replaceElementWithEvents(@NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(38);
        }
        if (newRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(39);
        }
        DiffLog diffLog = new DiffLog();
        if (oldRoot instanceof CompositeElement) {
            diffLog.appendReplaceElementWithEvents((CompositeElement)oldRoot, (CompositeElement)newRoot);
        } else {
            diffLog.nodeReplaced(oldRoot, newRoot);
        }
        DiffLog diffLog2 = diffLog;
        if (diffLog2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(40);
        }
        return diffLog2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static DiffLog mergeTrees(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        block17: {
            DiffLog diffLog;
            block16: {
                FileElement fileImplElement;
                if (fileImpl == null) {
                    BlockSupportImpl.$$$reportNull$$$0(41);
                }
                if (oldRoot == null) {
                    BlockSupportImpl.$$$reportNull$$$0(42);
                }
                if (newRoot == null) {
                    BlockSupportImpl.$$$reportNull$$$0(43);
                }
                if (indicator == null) {
                    BlockSupportImpl.$$$reportNull$$$0(44);
                }
                if (lastCommittedText == null) {
                    BlockSupportImpl.$$$reportNull$$$0(45);
                }
                PsiUtilCore.ensureValid(fileImpl);
                if (newRoot instanceof FileElement && (fileImplElement = fileImpl.getTreeElement()) != null) {
                    ((FileElement)newRoot).setCharTable(fileImplElement.getCharTable());
                }
                try {
                    newRoot.putUserData(TREE_TO_BE_REPARSED, Pair.create(oldRoot, lastCommittedText));
                    if (BlockSupportImpl.isReplaceWholeNode(fileImpl, newRoot)) {
                        DiffLog treeChangeEvent = BlockSupportImpl.replaceElementWithEvents(oldRoot, newRoot);
                        fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
                        DiffLog diffLog2 = treeChangeEvent;
                        diffLog = diffLog2;
                        break block16;
                    }
                    newRoot.getFirstChildNode();
                    break block17;
                }
                catch (BlockSupport.ReparsedSuccessfullyException e) {
                    DiffLog diffLog3 = e.getDiffLog();
                    DiffLog diffLog4 = diffLog3;
                    if (diffLog4 == null) {
                        BlockSupportImpl.$$$reportNull$$$0(47);
                    }
                    return diffLog4;
                }
            }
            if (diffLog == null) {
                BlockSupportImpl.$$$reportNull$$$0(46);
            }
            return diffLog;
            finally {
                newRoot.putUserData(TREE_TO_BE_REPARSED, null);
            }
        }
        ASTShallowComparator comparator = new ASTShallowComparator(indicator);
        ASTStructure treeStructure = BlockSupportImpl.createInterruptibleASTStructure(newRoot, indicator);
        DiffLog diffLog = new DiffLog();
        BlockSupportImpl.diffTrees(oldRoot, diffLog, comparator, treeStructure, indicator, lastCommittedText);
        DiffLog diffLog5 = diffLog;
        if (diffLog5 == null) {
            BlockSupportImpl.$$$reportNull$$$0(48);
        }
        return diffLog5;
    }

    public static <T> void diffTrees(@NotNull ASTNode oldRoot, @NotNull DiffTreeChangeBuilder<ASTNode, T> builder2, @NotNull ShallowNodeComparator<ASTNode, T> comparator, @NotNull FlyweightCapableTreeStructure<T> newTreeStructure, @NotNull ProgressIndicator indicator, @NotNull CharSequence lastCommittedText) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(49);
        }
        if (builder2 == null) {
            BlockSupportImpl.$$$reportNull$$$0(50);
        }
        if (comparator == null) {
            BlockSupportImpl.$$$reportNull$$$0(51);
        }
        if (newTreeStructure == null) {
            BlockSupportImpl.$$$reportNull$$$0(52);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(53);
        }
        if (lastCommittedText == null) {
            BlockSupportImpl.$$$reportNull$$$0(54);
        }
        DiffTree.diff(BlockSupportImpl.createInterruptibleASTStructure(oldRoot, indicator), newTreeStructure, comparator, builder2, lastCommittedText);
    }

    @NotNull
    private static ASTStructure createInterruptibleASTStructure(@NotNull ASTNode oldRoot, final @NotNull ProgressIndicator indicator) {
        if (oldRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(55);
        }
        if (indicator == null) {
            BlockSupportImpl.$$$reportNull$$$0(56);
        }
        return new ASTStructure(oldRoot){

            @Override
            public int getChildren(@NotNull ASTNode astNode, @NotNull Ref<ASTNode[]> into) {
                if (astNode == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (into == null) {
                    1.$$$reportNull$$$0(1);
                }
                indicator.checkCanceled();
                return super.getChildren(astNode, into);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "astNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "into";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/BlockSupportImpl$1";
                objectArray[2] = "getChildren";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isReplaceWholeNode(@NotNull PsiFileImpl fileImpl, @NotNull ASTNode newRoot) throws BlockSupport.ReparsedSuccessfullyException {
        boolean explicitlyMarkedDeep;
        Boolean data;
        if (fileImpl == null) {
            BlockSupportImpl.$$$reportNull$$$0(57);
        }
        if (newRoot == null) {
            BlockSupportImpl.$$$reportNull$$$0(58);
        }
        if ((data = (Boolean)fileImpl.getUserData(DO_NOT_REPARSE_INCREMENTALLY)) != null) {
            fileImpl.putUserData(DO_NOT_REPARSE_INCREMENTALLY, null);
        }
        if ((explicitlyMarkedDeep = Boolean.TRUE.equals(data)) || BlockSupportImpl.isTooDeep(fileImpl)) {
            return true;
        }
        ASTNode childNode = newRoot.getFirstChildNode();
        boolean childTooDeep = BlockSupportImpl.isTooDeep(childNode);
        if (childTooDeep) {
            childNode.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, null);
            fileImpl.putUserData(TREE_DEPTH_LIMIT_EXCEEDED, Boolean.TRUE);
        }
        return childTooDeep;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 35: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 35: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 3: 
            case 10: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileNode";
                break;
            }
            case 4: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedPsiRange";
                break;
            }
            case 5: 
            case 12: 
            case 18: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileText";
                break;
            }
            case 6: 
            case 13: 
            case 31: 
            case 44: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 7: 
            case 14: 
            case 32: 
            case 45: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastCommittedText";
                break;
            }
            case 8: 
            case 35: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/BlockSupportImpl";
                break;
            }
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reparseable";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTextStr";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLanguage";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charTable";
                break;
            }
            case 28: 
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileImpl";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerCopy";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 38: 
            case 42: 
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoot";
                break;
            }
            case 39: 
            case 43: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoot";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/BlockSupportImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "reparseRange";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCopy";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceElementWithEvents";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTrees";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reparseRange";
                break;
            }
            case 8: 
            case 35: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reparse";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findReparseableNodeAndReparseIt";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryReparseNode";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "tryReparseLeaf";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "makeFullParse";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFileCopy";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "details";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "replaceElementWithEvents";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "mergeTrees";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "diffTrees";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createInterruptibleASTStructure";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isReplaceWholeNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 35: 
            case 40: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class ReparseResult {
        @NotNull
        public final DiffLog log;
        @NotNull
        public final ASTNode oldRoot;
        @NotNull
        public final ASTNode newRoot;

        ReparseResult(@NotNull DiffLog log2, @NotNull ASTNode oldRoot, @NotNull ASTNode newRoot) {
            if (log2 == null) {
                ReparseResult.$$$reportNull$$$0(0);
            }
            if (oldRoot == null) {
                ReparseResult.$$$reportNull$$$0(1);
            }
            if (newRoot == null) {
                ReparseResult.$$$reportNull$$$0(2);
            }
            this.log = log2;
            this.oldRoot = oldRoot;
            this.newRoot = newRoot;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "log";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newRoot";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/BlockSupportImpl$ReparseResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Reparser {
        @NotNull
        private final PsiFileImpl myFile;
        private final CharTable myCharTable;
        private final Language myBaseLanguage;
        @NotNull
        private final CharSequence myNewFileText;
        private final int myLengthShift;

        Reparser(@NotNull PsiFileImpl file, @NotNull FileASTNode oldFileNode, @NotNull CharSequence newFileText) {
            if (file == null) {
                Reparser.$$$reportNull$$$0(0);
            }
            if (oldFileNode == null) {
                Reparser.$$$reportNull$$$0(1);
            }
            if (newFileText == null) {
                Reparser.$$$reportNull$$$0(2);
            }
            this.myLengthShift = newFileText.length() - oldFileNode.getTextLength();
            this.myBaseLanguage = file.getViewProvider().getBaseLanguage();
            this.myNewFileText = newFileText;
            this.myFile = file;
            this.myCharTable = oldFileNode.getCharTable();
        }

        @Nullable
        Couple<ASTNode> reparseNode(@NotNull ASTNode node) {
            ASTNode newNode;
            IElementType elementType;
            if (node == null) {
                Reparser.$$$reportNull$$$0(3);
            }
            if (!((elementType = node.getElementType()) instanceof IReparseableElementTypeBase) && !(elementType instanceof IReparseableLeafElementType)) {
                return null;
            }
            TextRange textRange = node.getTextRange();
            if (textRange.getLength() + this.myLengthShift <= 0 || !this.myBaseLanguage.isKindOf(elementType.getLanguage()) && !(elementType instanceof IReparseableLeafElementType) && TreeUtil.containsOuterLanguageElements(node)) {
                return null;
            }
            int start = textRange.getStartOffset();
            int end = start + textRange.getLength() + this.myLengthShift;
            if (end > this.myNewFileText.length()) {
                BlockSupportImpl.reportInconsistentLength(this.myFile, this.myNewFileText, node, start, end);
                return Couple.of(null, null);
            }
            CharSequence newTextStr = this.myNewFileText.subSequence(start, end);
            if (elementType instanceof IReparseableElementTypeBase) {
                newNode = BlockSupportImpl.tryReparseNode((IReparseableElementTypeBase)((Object)elementType), node, newTextStr, this.myFile.getManager(), this.myBaseLanguage, this.myCharTable);
            } else {
                assert (elementType instanceof IReparseableLeafElementType);
                newNode = BlockSupportImpl.tryReparseLeaf((IReparseableLeafElementType)((Object)elementType), node, newTextStr);
            }
            if (newNode == null) {
                return null;
            }
            if (newNode.getTextLength() != newTextStr.length()) {
                String details = ApplicationManager.getApplication().isInternal() ? "text=" + newTextStr + "; treeText=" + newNode.getText() + ";" : "";
                LOG.error("Inconsistent reparse: " + details + " type=" + elementType);
            }
            return Couple.of(node, newNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldFileNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFileText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/BlockSupportImpl$Reparser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reparseNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

