/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.FileIconUtil;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.INativeFileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.UnknownFileType;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Iconable;
import org.jetbrains.kotlin.com.intellij.openapi.util.LastComputedIconCache;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolderBase;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.SmartPointerManager;
import org.jetbrains.kotlin.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.ui.CoreAwareIconManager;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.PlatformIcons;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.AstLoadingFilter;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.PsiIconUtil;
import org.jetbrains.kotlin.com.intellij.util.ui.EDT;

public abstract class ElementBase
extends UserDataHolderBase
implements Iconable {
    private static final Logger LOG = Logger.getInstance(ElementBase.class);
    public static final int FLAGS_LOCKED = 2048;
    private static final Function1<ElementIconRequest, Icon> ICON_COMPUTE = request -> {
        Object element = ((ElementIconRequest)request).myPointer.getElement();
        if (element == null) {
            return null;
        }
        Icon icon = ElementBase.computeIconNow(element, ((ElementIconRequest)request).myFlags);
        LastComputedIconCache.put(element, icon, ((ElementIconRequest)request).myFlags);
        return icon;
    };
    private static final NotNullLazyValue<Icon> VISIBILITY_ICON_PLACEHOLDER = NotNullLazyValue.createValue(() -> {
        IconManager iconManager = IconManager.getInstance();
        return iconManager.createEmptyIcon(iconManager.getPlatformIcon(PlatformIcons.Public));
    });

    @Override
    @Nullable
    public Icon getIcon(int flags) {
        if (!(this instanceof PsiElement)) {
            return null;
        }
        try {
            return this.computeIcon(flags);
        }
        catch (ProcessCanceledException | IndexNotReadyException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error(e);
            return null;
        }
    }

    @Nullable
    private Icon computeIcon(int flags) {
        PsiElement psiElement = (PsiElement)((Object)this);
        if (!psiElement.isValid()) {
            return null;
        }
        if (Registry.is("psi.deferIconLoading", true) && EDT.isCurrentThreadEdt()) {
            Icon baseIcon = LastComputedIconCache.get(psiElement, flags);
            if (baseIcon == null) {
                baseIcon = AstLoadingFilter.disallowTreeLoading(() -> this.computeBaseIcon(flags));
            }
            if (baseIcon == null) {
                return null;
            }
            return IconManager.getInstance().createDeferredIcon(baseIcon, new ElementIconRequest(psiElement, psiElement.getProject(), flags), ICON_COMPUTE);
        }
        return ElementBase.computeIconNow(psiElement, flags);
    }

    @Nullable
    private static Icon computeIconNow(@NotNull PsiElement element, int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(0);
        }
        return AstLoadingFilter.disallowTreeLoading(() -> ElementBase.doComputeIconNow(element, flags));
    }

    private static Icon doComputeIconNow(@NotNull PsiElement element, int flags) {
        if (element == null) {
            ElementBase.$$$reportNull$$$0(1);
        }
        if (!(element instanceof ElementBase)) {
            throw new AssertionError((Object)(element.getClass().getName() + " is not ElementBase"));
        }
        Icon icon = PsiIconUtil.getIconFromProviders(element, flags);
        if (element instanceof PsiFileSystemItem) {
            VirtualFile file = PsiUtilCore.getVirtualFile(element);
            if (file != null && icon == null) {
                icon = FileIconUtil.INSTANCE.getIconFromProviders(file, flags, element.getProject());
            }
            if (file != null && icon != null) {
                icon = FileIconUtil.INSTANCE.patchIconByIconPatchers(icon, file, flags, element.getProject());
            }
            if (icon instanceof RowIcon) {
                return icon;
            }
            if (icon != null) {
                return IconManager.getInstance().createLayeredIcon(element, icon, flags);
            }
            return ((ElementBase)((Object)element)).getElementIcon(flags);
        }
        if (icon == null) {
            return ((ElementBase)((Object)element)).getElementIcon(flags);
        }
        if (icon instanceof RowIcon) {
            return icon;
        }
        return IconManager.getInstance().createLayeredIcon(element, icon, flags);
    }

    @Nullable
    protected Icon computeBaseIcon(int flags) {
        PsiFile file;
        Icon baseIcon;
        Icon icon = baseIcon = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
        if (baseIcon != null && this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null) {
            return IconManager.getInstance().createLayeredIcon(file, baseIcon, flags);
        }
        return baseIcon;
    }

    @Nullable
    protected Icon getBaseIcon() {
        PsiFile file;
        if (this instanceof PsiElement && (file = ((PsiElement)((Object)this)).getContainingFile()) != null && !ElementBase.isNativeFileType(file.getFileType())) {
            try {
                return file.getFileType().getIcon();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.NodePlaceholder);
    }

    public static boolean isNativeFileType(FileType fileType) {
        return fileType instanceof INativeFileType && ((INativeFileType)fileType).useNativeIcon() || fileType instanceof UnknownFileType;
    }

    protected Icon getAdjustedBaseIcon(@Nullable Icon icon, int flags) {
        if (icon != null && BitUtil.isSet(flags, 1)) {
            return IconManager.getInstance().createRowIcon(icon, VISIBILITY_ICON_PLACEHOLDER.getValue());
        }
        return icon;
    }

    protected boolean isVisibilitySupported() {
        return false;
    }

    @NotNull
    public static RowIcon buildRowIcon(Icon baseIcon, Icon visibilityIcon) {
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(baseIcon, visibilityIcon);
        if (rowIcon == null) {
            ElementBase.$$$reportNull$$$0(2);
        }
        return rowIcon;
    }

    public static Icon iconWithVisibilityIfNeeded(int flags, Icon baseIcon, Icon visibility) {
        return BitUtil.isSet(flags, 1) ? ElementBase.buildRowIcon(baseIcon, visibility) : baseIcon;
    }

    @Nullable
    protected Icon getElementIcon(int flags) {
        Icon baseIcon;
        int elementFlags;
        PsiElement element = (PsiElement)((Object)this);
        if (!element.isValid()) {
            return null;
        }
        boolean isLocked = BitUtil.isSet(flags, 2) && !element.isWritable();
        int n = elementFlags = isLocked ? 2048 : 0;
        if (element instanceof ItemPresentation && (baseIcon = ((ItemPresentation)((Object)element)).getIcon(false)) != null) {
            return IconManager.getInstance().createLayeredIcon(this, baseIcon, elementFlags);
        }
        if (element instanceof PsiFileSystemItem) {
            VirtualFile file = PsiUtilCore.getVirtualFile(element);
            Icon baseIcon2 = null;
            if (file == null && element instanceof PsiFile) {
                baseIcon2 = ((PsiFile)element).getFileType().getIcon();
            } else if (file != null) {
                IconManager iconManager = IconManager.getInstance();
                if (iconManager instanceof CoreAwareIconManager) {
                    baseIcon2 = ((CoreAwareIconManager)((Object)iconManager)).getIcon(file, flags & 0xFFFFFFFD, element.getProject());
                } else {
                    Icon icon = baseIcon2 = this.isVisibilitySupported() ? this.getAdjustedBaseIcon(this.getBaseIcon(), flags) : this.getBaseIcon();
                }
            }
            if (baseIcon2 == null) {
                return null;
            }
            return IconManager.getInstance().createLayeredIcon(this, baseIcon2, elementFlags);
        }
        return null;
    }

    public static int transformFlags(PsiElement element, int _flags) {
        boolean isLocked;
        int flags = BitUtil.clear(_flags, 2);
        boolean bl = isLocked = BitUtil.isSet(_flags, 2) && !element.isWritable();
        if (isLocked) {
            flags |= 0x800;
        }
        return flags;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRowIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeIconNow";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doComputeIconNow";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementIconRequest {
        private final SmartPsiElementPointer<?> myPointer;
        private final int myFlags;

        private ElementIconRequest(@NotNull PsiElement element, @NotNull Project project, int flags) {
            if (element == null) {
                ElementIconRequest.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ElementIconRequest.$$$reportNull$$$0(1);
            }
            this.myPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(element);
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ElementIconRequest)) {
                return false;
            }
            ElementIconRequest request = (ElementIconRequest)o;
            if (this.myFlags != request.myFlags) {
                return false;
            }
            return this.myPointer == request.myPointer;
        }

        public int hashCode() {
            int result2 = System.identityHashCode(this.myPointer);
            result2 = 31 * result2 + this.myFlags;
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/ElementBase$ElementIconRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

