/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmClass;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmTypeDeclaration;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacade;
import org.jetbrains.kotlin.com.intellij.lang.jvm.facade.JvmFacadeImpl;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.IndexNotReadyException;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.ProjectRootModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.Predicates;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JvmPsiConversionHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.IsConstantExpressionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiFacadeEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiJavaModuleModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.FileContextUtil;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBus;

@ApiStatus.NonExtendable
public final class JavaPsiFacadeImpl
extends JavaPsiFacadeEx {
    private static final Logger LOG = Logger.getInstance(JavaPsiFacadeImpl.class);
    private final PsiConstantEvaluationHelper myConstantEvaluationHelper;
    private final ConcurrentMap<String, PsiPackage> myPackageCache;
    private final ConcurrentMap<GlobalSearchScope, Map<String, Optional<PsiClass>>> myClassCache;
    private final Project myProject;
    private final JavaFileManager myFileManager;
    private final NotNullLazyValue<JvmFacadeImpl> myJvmFacade;
    private final JvmPsiConversionHelper myConversionHelper;

    public JavaPsiFacadeImpl(@NotNull Project project, @Nullable CoroutineScope coroutineScope) {
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myPackageCache = ContainerUtil.createConcurrentSoftValueMap();
        this.myClassCache = ContainerUtil.createConcurrentSoftKeySoftValueMap();
        this.myProject = project;
        this.myFileManager = JavaFileManager.getInstance(this.myProject);
        this.myConstantEvaluationHelper = new PsiConstantEvaluationHelperImpl();
        this.myJvmFacade = NotNullLazyValue.atomicLazy(() -> (JvmFacadeImpl)JvmFacade.getInstance(project));
        this.myConversionHelper = JvmPsiConversionHelper.getInstance(this.myProject);
        MessageBus bus = project.getMessageBus();
        (coroutineScope == null ? bus.simpleConnect() : bus.connect(coroutineScope)).subscribe(PsiModificationTracker.TOPIC, () -> {
            this.myClassCache.clear();
            this.myPackageCache.clear();
        });
        DummyHolderFactory.setFactory(new JavaDummyHolderFactory());
    }

    @Deprecated
    public JavaPsiFacadeImpl(@NotNull Project project) {
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(1);
        }
        this(project, null);
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(2);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(3);
        }
        ProgressIndicatorProvider.checkCanceled();
        Map map = this.myClassCache.computeIfAbsent(scope2, scope1 -> CollectionFactory.createConcurrentWeakValueMap());
        Optional<PsiClass> result2 = (Optional<PsiClass>)map.get(qualifiedName);
        if (result2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            result2 = Optional.ofNullable(this.doFindClass(qualifiedName, scope2));
            if (stamp.mayCacheNow()) {
                map.put(qualifiedName, result2);
            }
        }
        return result2.orElse(null);
    }

    @Nullable
    private PsiClass doFindClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(4);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(5);
        }
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes = this.findClassesInDumbMode(qualifiedName, scope2);
            if (classes.length != 0) {
                return classes[0];
            }
            return null;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        PsiClass bestClass = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass candidateClass = finder.findClass(qualifiedName, scope2);
                if (candidateClass == null || classesFilter != null && !classesFilter.test(candidateClass) || bestClass != null && PsiClassUtil.createScopeComparator(scope2).compare(candidateClass, bestClass) >= 0) continue;
                bestClass = candidateClass;
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return bestClass;
    }

    private PsiClass @NotNull [] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(7);
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope2);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(8);
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(10);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className, scope2);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    private boolean hasClassInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(12);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(13);
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName);
        String className = StringUtil.getShortName(qualifiedName);
        if (pkg != null) {
            return pkg.hasClassWithShortName(className, scope2);
        }
        if (packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses;
            for (PsiClass containingClass : containingClasses = this.findClassesInDumbMode(packageName, scope2)) {
                if (!ContainerUtil.exists(containingClass.getInnerClasses(), innerClass -> className.equals(innerClass.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PsiClass @NotNull [] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        List<PsiClass> allClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(14);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(15);
        }
        PsiClass[] psiClassArray = (allClasses = this.findClassesWithJvmFacade(qualifiedName, scope2)).isEmpty() ? PsiClass.EMPTY_ARRAY : allClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(16);
        }
        return psiClassArray;
    }

    @Override
    public boolean hasClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(17);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(18);
        }
        if (this.shouldUseSlowResolve()) {
            return this.hasClassInDumbMode(qualifiedName, scope2);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        if (classesFilter == null) {
            classesFilter = Predicates.alwaysTrue();
        }
        for (PsiElementFinder finder : finders) {
            if (!finder.hasClass(qualifiedName, scope2, classesFilter)) continue;
            return true;
        }
        return !this.myJvmFacade.getValue().findClassesWithoutJavaFacade(qualifiedName, scope2).isEmpty();
    }

    @NotNull
    private List<PsiClass> findClassesWithJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        List<JvmClass> jvmClasses;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(19);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(20);
        }
        ArrayList<PsiClass> result2 = null;
        List<PsiClass> ownClasses = this.findClassesWithoutJvmFacade(qualifiedName, scope2);
        if (!ownClasses.isEmpty()) {
            result2 = new ArrayList<PsiClass>(ownClasses);
        }
        if (!(jvmClasses = this.myJvmFacade.getValue().findClassesWithoutJavaFacade(qualifiedName, scope2)).isEmpty()) {
            List<PsiClass> jvmPsiClasses = ContainerUtil.map(jvmClasses, it -> this.myConversionHelper.convertTypeDeclaration((JvmTypeDeclaration)it));
            if (result2 == null) {
                result2 = new ArrayList<PsiClass>(jvmPsiClasses);
            } else {
                result2.addAll(jvmPsiClasses);
            }
        }
        List<PsiClass> list = result2 == null ? Collections.emptyList() : result2;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public List<PsiClass> findClassesWithoutJvmFacade(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope2) {
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(22);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(23);
        }
        if (this.shouldUseSlowResolve()) {
            List<PsiClass> list = Arrays.asList(this.findClassesInDumbMode(qualifiedName, scope2));
            if (list == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass[] finderClasses = finder.findClasses(qualifiedName, scope2);
                if (finderClasses.length == 0) continue;
                if (result2 == null) {
                    result2 = new ArrayList(finderClasses.length);
                }
                JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, finderClasses, result2);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        List<PsiClass> list = result2 == null ? Collections.emptyList() : result2;
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    private static Predicate<PsiClass> getFilterFromFinders(@NotNull GlobalSearchScope scope2, @NotNull List<? extends PsiElementFinder> finders) {
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(26);
        }
        if (finders == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(27);
        }
        Predicate<PsiClass> filter = null;
        for (PsiElementFinder psiElementFinder : finders) {
            try {
                Predicate<PsiClass> finderFilter = psiElementFinder.getClassesFilter(scope2);
                if (finderFilter == null) continue;
                filter = filter == null ? finderFilter : filter.and(finderFilter);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return filter;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isAlternativeResolveEnabled();
    }

    @Override
    @NotNull
    public PsiConstantEvaluationHelper getConstantEvaluationHelper() {
        PsiConstantEvaluationHelper psiConstantEvaluationHelper = this.myConstantEvaluationHelper;
        if (psiConstantEvaluationHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(28);
        }
        return psiConstantEvaluationHelper;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage aPackage;
        if (qualifiedName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(29);
        }
        if ((aPackage = (PsiPackage)this.myPackageCache.get(qualifiedName)) != null) {
            return aPackage;
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                aPackage = finder.findPackage(qualifiedName);
                if (aPackage == null) continue;
                return ConcurrencyUtil.cacheOrGet(this.myPackageCache, qualifiedName, aPackage);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return null;
    }

    @Override
    public PsiJavaModule findModule(@NotNull String moduleName2, @NotNull GlobalSearchScope scope2) {
        Collection<PsiJavaModule> modules;
        if (moduleName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(30);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(31);
        }
        return (modules = this.findModules(moduleName2, scope2)).size() == 1 ? modules.iterator().next() : null;
    }

    @Override
    @NotNull
    public Collection<PsiJavaModule> findModules(@NotNull String moduleName2, @NotNull GlobalSearchScope scope2) {
        if (moduleName2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(32);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(33);
        }
        JavaFileManager javaFileManager = JavaFileManager.getInstance(this.myProject);
        if (DumbService.isDumb(this.myProject)) {
            if (DumbUtil.getInstance(this.myProject).mayUseIndices()) {
                Collection<PsiJavaModule> collection = javaFileManager.findModules(moduleName2, scope2);
                if (collection == null) {
                    JavaPsiFacadeImpl.$$$reportNull$$$0(34);
                }
                return collection;
            }
            List<PsiJavaModule> list = Collections.emptyList();
            if (list == null) {
                JavaPsiFacadeImpl.$$$reportNull$$$0(35);
            }
            return list;
        }
        Collection collection = (Collection)((Map)((Map)CachedValuesManager.getManager(this.myProject).getCachedValue(this.myProject, () -> {
            ConcurrentMap<GlobalSearchScope, Map> scope2ModulesMap = ConcurrentFactoryMap.create(searchScope -> ConcurrentFactoryMap.create(name2 -> javaFileManager.findModules((String)name2, (GlobalSearchScope)searchScope), () -> CollectionFactory.createConcurrentWeakValueMap()), () -> ContainerUtil.createConcurrentSoftKeySoftValueMap());
            return new CachedValueProvider.Result<ConcurrentMap<GlobalSearchScope, Map>>(scope2ModulesMap, PsiJavaModuleModificationTracker.getInstance(this.myProject), ProjectRootModificationTracker.getInstance(this.myProject));
        })).get(scope2)).get(moduleName2);
        if (collection == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(36);
        }
        return collection;
    }

    @NotNull
    private List<PsiElementFinder> filteredFinders() {
        List<PsiElementFinder> list = DumbService.getInstance(this.getProject()).filterByDumbAwareness(PsiElementFinder.EP.getPoint(this.myProject).getExtensionList());
        if (list == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiJavaParserFacade getParserFacade() {
        PsiElementFactory psiElementFactory = this.getElementFactory();
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(38);
        }
        return psiElementFactory;
    }

    @Override
    @NotNull
    public PsiResolveHelper getResolveHelper() {
        PsiResolveHelper psiResolveHelper = PsiResolveHelper.getInstance(this.myProject);
        if (psiResolveHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(39);
        }
        return psiResolveHelper;
    }

    @Override
    @NotNull
    public PsiNameHelper getNameHelper() {
        PsiNameHelper psiNameHelper = PsiNameHelper.getInstance(this.myProject);
        if (psiNameHelper == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(40);
        }
        return psiNameHelper;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(41);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(42);
        }
        HashSet<String> result2 = new HashSet<String>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                result2.addAll(finder.getClassNames(psiPackage, scope2));
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(43);
        }
        return hashSet;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(44);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(45);
        }
        List<PsiElementFinder> finders = this.filteredFinders();
        Predicate<PsiClass> classesFilter = JavaPsiFacadeImpl.getFilterFromFinders(scope2, finders);
        ArrayList result2 = null;
        for (PsiElementFinder finder : finders) {
            try {
                PsiClass[] classes = finder.getClasses(psiPackage, scope2);
                if (classes.length == 0) continue;
                if (result2 == null) {
                    result2 = new ArrayList(classes.length);
                }
                JavaPsiFacadeImpl.filterClassesAndAppend(finder, classesFilter, classes, result2);
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        PsiClass[] psiClassArray = result2 == null ? PsiClass.EMPTY_ARRAY : result2.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(46);
        }
        return psiClassArray;
    }

    private static void filterClassesAndAppend(PsiElementFinder finder, @Nullable Predicate<? super PsiClass> classesFilter, PsiClass @NotNull [] classes, @NotNull List<? super PsiClass> result2) {
        if (result2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(47);
        }
        if (classes == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(48);
        }
        for (PsiClass psiClass : classes) {
            if (psiClass == null) {
                LOG.error("Finder " + finder + " returned null PsiClass");
                continue;
            }
            if (classesFilter != null && !classesFilter.test(psiClass)) continue;
            result2.add(psiClass);
        }
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(49);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(50);
        }
        Condition<PsiFile> filter = null;
        for (PsiElementFinder finder : this.filteredFinders()) {
            Condition<PsiFile> finderFilter = finder.getPackageFilesFilter(psiPackage, scope2);
            if (finderFilter == null) continue;
            if (filter == null) {
                filter = finderFilter;
                continue;
            }
            filter = Conditions.and(filter, finderFilter);
        }
        LinkedHashSet<PsiFile> result2 = new LinkedHashSet<PsiFile>();
        PsiDirectory[] directories = psiPackage.getDirectories(scope2);
        for (PsiDirectory directory : directories) {
            for (PsiFile file : directory.getFiles()) {
                if (filter != null && !filter.value(file)) continue;
                result2.add(file);
            }
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                Collections.addAll(result2, finder.getPackageFiles(psiPackage, scope2));
            }
            catch (IndexNotReadyException indexNotReadyException) {}
        }
        PsiFile[] psiFileArray = result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(51);
        }
        return psiFileArray;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(52);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(53);
        }
        if (consumer == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(54);
        }
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                if (finder.processPackageDirectories(psiPackage, scope2, consumer, includeLibrarySources)) continue;
                return false;
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        return true;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope2) {
        if (psiPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(55);
        }
        if (scope2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(56);
        }
        LinkedHashMap<String, PsiPackage> result2 = new LinkedHashMap<String, PsiPackage>();
        for (PsiElementFinder finder : this.filteredFinders()) {
            try {
                PsiPackage[] packages;
                for (PsiPackage aPackage : packages = finder.getSubPackages(psiPackage, scope2)) {
                    result2.putIfAbsent(aPackage.getName(), aPackage);
                }
            }
            catch (IndexNotReadyException ex) {
                JavaPsiFacadeImpl.handleIndexNotReadyException(ex);
            }
        }
        PsiPackage[] psiPackageArray = result2.values().toArray(PsiPackage.EMPTY_ARRAY);
        if (psiPackageArray == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(57);
        }
        return psiPackageArray;
    }

    private static void handleIndexNotReadyException(@NotNull IndexNotReadyException ex) {
        if (ex == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(58);
        }
        if (Registry.is("ide.dumb.mode.check.awareness")) {
            throw ex;
        }
    }

    @Override
    public boolean isPartOfPackagePrefix(@NotNull String packageName) {
        if (packageName == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(59);
        }
        Collection<String> packagePrefixes = this.myFileManager.getNonTrivialPackagePrefixes();
        for (String subpackageName : packagePrefixes) {
            if (!PsiNameHelper.isSubpackageOf(subpackageName, packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInPackage(@NotNull PsiElement element, @NotNull PsiPackage aPackage) {
        PsiFile file;
        if (element == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(60);
        }
        if (aPackage == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(61);
        }
        if ((file = FileContextUtil.getContextFile(element)) instanceof JavaDummyHolder) {
            return ((JavaDummyHolder)file).isInPackage(aPackage);
        }
        if (file instanceof PsiJavaFile) {
            String packageName = ((PsiJavaFile)file).getPackageName();
            return packageName.equals(aPackage.getQualifiedName());
        }
        return false;
    }

    @Override
    public boolean arePackagesTheSame(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        PsiFile file2;
        PsiFile file1;
        if (element1 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(62);
        }
        if (element2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(63);
        }
        if (Comparing.equal(file1 = FileContextUtil.getContextFile(element1), file2 = FileContextUtil.getContextFile(element2))) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder && file2 instanceof JavaDummyHolder) {
            return true;
        }
        if (file1 instanceof JavaDummyHolder || file2 instanceof JavaDummyHolder) {
            JavaDummyHolder dummyHolder = (JavaDummyHolder)(file1 instanceof JavaDummyHolder ? file1 : file2);
            PsiFile other = file1 instanceof JavaDummyHolder ? file2 : file1;
            return dummyHolder.isSamePackage(other);
        }
        if (!(file1 instanceof PsiClassOwner)) {
            return false;
        }
        if (!(file2 instanceof PsiClassOwner)) {
            return false;
        }
        String package1 = ((PsiClassOwner)file1).getPackageName();
        String package2 = ((PsiClassOwner)file2).getPackageName();
        return Objects.equals(package1, package2);
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(64);
        }
        return project;
    }

    @Override
    public boolean isConstantExpression(@NotNull PsiExpression expression2) {
        if (expression2 == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(65);
        }
        IsConstantExpressionVisitor visitor2 = new IsConstantExpressionVisitor();
        expression2.accept(visitor2);
        return visitor2.isConstant();
    }

    @Override
    @NotNull
    public PsiElementFactory getElementFactory() {
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance(this.myProject);
        if (psiElementFactory == null) {
            JavaPsiFacadeImpl.$$$reportNull$$$0(66);
        }
        return psiElementFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 57: 
            case 64: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 57: 
            case 64: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 31: 
            case 33: 
            case 42: 
            case 45: 
            case 50: 
            case 53: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 57: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finders";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 41: 
            case 44: 
            case 49: 
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/JavaPsiFacadeImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesInDumbMode";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithJvmFacade";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findClassesWithoutJvmFacade";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantEvaluationHelper";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "filteredFinders";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getParserFacade";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveHelper";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameHelper";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doFindClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findClassesInDumbMode";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 57: 
            case 64: 
            case 66: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasClassInDumbMode";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findClasses";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithJvmFacade";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findClassesWithoutJvmFacade";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getFilterFromFinders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "filterClassesAndAppend";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "handleIndexNotReadyException";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isPartOfPackagePrefix";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isInPackage";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "arePackagesTheSame";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isConstantExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 21: 
            case 24: 
            case 25: 
            case 28: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 51: 
            case 57: 
            case 64: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

