/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;

public interface PsiFileEx
extends PsiFile {
    public static final Key<Boolean> BATCH_REFERENCE_PROCESSING = Key.create("BATCH_REFERENCE_PROCESSING");

    public boolean isContentsLoaded();

    public void onContentReload();

    public void markInvalidated();

    @ApiStatus.Experimental
    public static boolean isBatchReferenceProcessingEnabled(@NotNull PsiFile file) {
        if (file == null) {
            PsiFileEx.$$$reportNull$$$0(0);
        }
        if (file.getUserData(BATCH_REFERENCE_PROCESSING) != Boolean.TRUE) {
            return false;
        }
        return BatchReferenceProcessingSuppressor.EP_NAME.findFirstSafe(suppressor -> suppressor.isSuppressed(file)) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/PsiFileEx", "isBatchReferenceProcessingEnabled"));
    }

    @ApiStatus.Experimental
    public static interface BatchReferenceProcessingSuppressor {
        public static final ExtensionPointName<BatchReferenceProcessingSuppressor> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.psi.batchReferenceProcessingSuppressor");

        public boolean isSuppressed(@NotNull PsiFile var1);
    }
}

