/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaTokenImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsParsingUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

class ClsBinaryExpressionImpl
extends ClsElementImpl
implements PsiBinaryExpression {
    private final ClsElementImpl myParent;
    private final PsiJavaToken myOperator;
    private final PsiExpression myLOperand;
    private final PsiExpression myROperand;

    ClsBinaryExpressionImpl(ClsElementImpl parent2, PsiJavaToken sign, PsiExpression left, PsiExpression right) {
        this.myParent = parent2;
        this.myOperator = new ClsJavaTokenImpl(this, sign.getTokenType(), sign.getText());
        this.myLOperand = ClsParsingUtil.psiToClsExpression(left, this);
        this.myROperand = ClsParsingUtil.psiToClsExpression(right, this);
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(0);
        }
        buffer.append(this.getText());
    }

    @Override
    protected void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(1);
        }
        this.setMirrorCheckingType(element, null);
    }

    @Override
    public String getText() {
        return StringUtil.join(this.myLOperand.getText(), " ", this.myOperator.getText(), " ", this.myROperand.getText());
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myLOperand, this.myOperator, this.myROperand};
        if (psiElementArray == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement getParent() {
        return this.myParent;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBinaryExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiExpression getLOperand() {
        PsiExpression psiExpression = this.myLOperand;
        if (psiExpression == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(4);
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiExpression getROperand() {
        PsiExpression psiExpression = this.myROperand;
        if (psiExpression == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiExpression;
    }

    @Override
    @NotNull
    public PsiJavaToken getOperationSign() {
        PsiJavaToken psiJavaToken = this.myOperator;
        if (psiJavaToken == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiJavaToken;
    }

    @Override
    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.myOperator.getTokenType();
        if (iElementType == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(7);
        }
        return iElementType;
    }

    @Override
    public PsiJavaToken getTokenBeforeOperand(@NotNull PsiExpression operand) {
        if (operand == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(8);
        }
        return this.getOperationSign();
    }

    @Override
    public PsiType getType() {
        return this.myLOperand.getType();
    }

    @Override
    public PsiExpression @NotNull [] getOperands() {
        PsiExpression[] psiExpressionArray = new PsiExpression[]{this.getLOperand(), this.getROperand()};
        if (psiExpressionArray == null) {
            ClsBinaryExpressionImpl.$$$reportNull$$$0(9);
        }
        return psiExpressionArray;
    }

    @Override
    public String toString() {
        return "PsiBinaryExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsBinaryExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLOperand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getROperand";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationSign";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationTokenType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendMirrorText";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTokenBeforeOperand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

