/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.JavaParserUtil;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsAnnotationValueImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsArrayInitializerMemberValueImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsBinaryExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsClassObjectAccessExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsLiteralExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsReferenceExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.lang.JavaVersion;

public final class ClsParsingUtil {
    private static final Logger LOG = Logger.getInstance(ClsParsingUtil.class);
    private static final JavaParserUtil.ParserWrapper ANNOTATION_VALUE = builder2 -> JavaParser.INSTANCE.getDeclarationParser().parseAnnotationValue(builder2);

    private ClsParsingUtil() {
    }

    public static PsiExpression createExpressionFromText(@NotNull String exprText, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        if (exprText == null) {
            ClsParsingUtil.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(2);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(manager.getProject()).getParserFacade();
        try {
            PsiExpression expr = parserFacade.createExpressionFromText(exprText, null);
            return ClsParsingUtil.psiToClsExpression(expr, parent2);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
            return null;
        }
    }

    public static PsiAnnotationMemberValue createMemberValueFromText(@NotNull String text, @NotNull PsiManager manager, @NotNull ClsElementImpl parent2) {
        LanguageLevel level;
        DummyHolder holder;
        PsiElement element;
        if (text == null) {
            ClsParsingUtil.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            ClsParsingUtil.$$$reportNull$$$0(4);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(5);
        }
        if (!((element = SourceTreeToPsiMap.treeElementToPsi((holder = DummyHolderFactory.createHolder(manager, new JavaDummyElement(text, ANNOTATION_VALUE, level = PsiUtil.getLanguageLevel(parent2)), null)).getTreeElement().getFirstChildNode())) instanceof PsiAnnotationMemberValue)) {
            LOG.error("Could not parse initializer:'" + text + "'");
            return null;
        }
        return ClsParsingUtil.getMemberValue(element, parent2);
    }

    public static PsiAnnotationMemberValue getMemberValue(@NotNull PsiElement element, @NotNull ClsElementImpl parent2) {
        if (element == null) {
            ClsParsingUtil.$$$reportNull$$$0(6);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(7);
        }
        if (element instanceof PsiExpression) {
            return ClsParsingUtil.psiToClsExpression((PsiExpression)element, parent2);
        }
        if (element instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)element).getInitializers();
            PsiAnnotationMemberValue[] clsInitializers = new PsiAnnotationMemberValue[initializers.length];
            ClsArrayInitializerMemberValueImpl arrayValue = new ClsArrayInitializerMemberValueImpl(parent2, clsInitializers);
            for (int i = 0; i < initializers.length; ++i) {
                clsInitializers[i] = ClsParsingUtil.getMemberValue(initializers[i], arrayValue);
            }
            return arrayValue;
        }
        if (element instanceof PsiAnnotation) {
            final PsiAnnotation psiAnnotation = (PsiAnnotation)element;
            PsiJavaCodeReferenceElement referenceElement = psiAnnotation.getNameReferenceElement();
            assert (referenceElement != null) : psiAnnotation;
            final String canonicalText = referenceElement.getText();
            return new ClsAnnotationValueImpl(parent2){

                @Override
                protected ClsJavaCodeReferenceElementImpl createReference() {
                    return new ClsJavaCodeReferenceElementImpl(this, canonicalText);
                }

                @Override
                protected ClsAnnotationParameterListImpl createParameterList() {
                    PsiNameValuePair[] psiAttributes = psiAnnotation.getParameterList().getAttributes();
                    return new ClsAnnotationParameterListImpl(this, psiAttributes);
                }

                @Override
                public PsiAnnotationOwner getOwner() {
                    return (PsiAnnotationOwner)((Object)this.getParent());
                }
            };
        }
        LOG.error("Unexpected source element for annotation member value: " + element);
        return null;
    }

    static PsiExpression psiToClsExpression(@NotNull PsiExpression expr, @NotNull ClsElementImpl parent2) {
        String exprText;
        if (expr == null) {
            ClsParsingUtil.$$$reportNull$$$0(8);
        }
        if (parent2 == null) {
            ClsParsingUtil.$$$reportNull$$$0(9);
        }
        if (expr instanceof PsiLiteralExpression) {
            PsiFile file = parent2.getContainingFile();
            boolean forDecompiling = file instanceof ClsFileImpl && ((ClsFileImpl)file).isForDecompiling();
            PsiType type = forDecompiling ? (PsiPrimitiveType)PsiTypes.nullType() : expr.getType();
            Object value2 = forDecompiling ? null : ((PsiLiteralExpression)expr).getValue();
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), type, value2);
        }
        if (expr instanceof PsiPrefixExpression) {
            PsiJavaToken sign = ((PsiPrefixExpression)expr).getOperationSign();
            PsiExpression operand = ((PsiPrefixExpression)expr).getOperand();
            if (operand == null) {
                LOG.error("Invalid prefix expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsPrefixExpressionImpl(parent2, sign, operand);
        }
        if (expr instanceof PsiClassObjectAccessExpression && StringUtil.endsWith(exprText = expr.getText(), ".class")) {
            String classText = exprText.substring(0, exprText.length() - 6);
            return new ClsClassObjectAccessExpressionImpl(parent2, classText);
        }
        if (expr instanceof PsiReferenceExpression) {
            return new ClsReferenceExpressionImpl(parent2, (PsiReferenceExpression)expr);
        }
        if (expr instanceof PsiBinaryExpression) {
            PsiJavaToken sign = ((PsiBinaryExpression)expr).getOperationSign();
            PsiExpression left = ((PsiBinaryExpression)expr).getLOperand();
            PsiExpression right = ((PsiBinaryExpression)expr).getROperand();
            if (right == null) {
                LOG.error("Invalid binary expression: " + expr + " [" + expr.getText() + "]");
                return null;
            }
            return new ClsBinaryExpressionImpl(parent2, sign, left, right);
        }
        PsiFile file = parent2.getContainingFile();
        if (file instanceof ClsFileImpl && ((ClsFileImpl)file).isForDecompiling()) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), PsiTypes.nullType(), null);
        }
        PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance(expr.getProject()).getConstantEvaluationHelper();
        Object value3 = evaluator.computeConstantExpression(expr);
        if (value3 != null) {
            return new ClsLiteralExpressionImpl(parent2, expr.getText(), expr.getType(), value3);
        }
        LOG.error("Unable to compute expression value: " + expr + " [" + expr.getText() + "]");
        return null;
    }

    public static boolean isJavaIdentifier(@NotNull String identifier, @NotNull LanguageLevel level) {
        if (identifier == null) {
            ClsParsingUtil.$$$reportNull$$$0(10);
        }
        if (level == null) {
            ClsParsingUtil.$$$reportNull$$$0(11);
        }
        return StringUtil.isJavaIdentifier(identifier) && !PsiUtil.isKeyword(identifier, level);
    }

    @Nullable
    public static JavaSdkVersion getJdkVersionByBytecode(int major) {
        if (major >= 44) {
            JavaVersion version2 = JavaVersion.compose(major - 44);
            return JavaSdkVersion.fromJavaVersion(version2);
        }
        return null;
    }

    public static boolean isPreviewLevel(int minor) {
        return minor == 65535;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprText";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClsParsingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createExpressionFromText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberValueFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getMemberValue";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "psiToClsExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

