/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContext;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContextKt;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContextManager;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContextManagerImpl;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.FileViewProviderUtil;
import org.jetbrains.kotlin.com.intellij.injected.editor.VirtualFileWindow;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.injection.InjectedLanguageManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.StackOverflowPreventedException;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileTypeFileViewProviders;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProviderFactory;
import org.jetbrains.kotlin.com.intellij.psi.LanguageFileViewProviders;
import org.jetbrains.kotlin.com.intellij.psi.LanguageSubstitutors;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiLanguageInjectionHost;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiTreeChangeEventImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiDirectoryFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.ClassicFileViewProviderCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.ClassicTemporaryProviderStorage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.Entry;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileViewProviderCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.MultiverseFileViewProviderCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.MultiverseTemporaryProviderStorage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.TemporaryProviderStorage;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.concurrency.ThreadingAssertions;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;

@ApiStatus.Internal
public final class FileManagerImpl
implements FileManager {
    private static final Key<Boolean> IN_COMA = Key.create("IN_COMA");
    private static final Logger LOG = Logger.getInstance(FileManagerImpl.class);
    private final Key<FileViewProvider> myPsiHardRefKey;
    private final PsiManagerImpl myManager;
    private final NotNullLazyValue<? extends FileIndexFacade> myFileIndex;
    private final AtomicReference<ConcurrentMap<VirtualFile, PsiDirectory>> myVFileToPsiDirMap;
    private final FileViewProviderCache myVFileToViewProviderMap;
    private final TemporaryProviderStorage myTempProviders;
    private final MessageBusConnection myConnection;
    private boolean myProcessingFileTypesChange;

    public FileManagerImpl(@NotNull PsiManagerImpl manager, @NotNull NotNullLazyValue<? extends FileIndexFacade> fileIndex) {
        if (manager == null) {
            FileManagerImpl.$$$reportNull$$$0(0);
        }
        if (fileIndex == null) {
            FileManagerImpl.$$$reportNull$$$0(1);
        }
        this.myPsiHardRefKey = Key.create("HARD_REFERENCE_TO_PSI");
        this.myVFileToPsiDirMap = new AtomicReference();
        this.myManager = manager;
        this.myFileIndex = fileIndex;
        this.myConnection = manager.getProject().getMessageBus().connect(manager);
        LowMemoryWatcher.register(this::processQueue, manager);
        this.myConnection.subscribe(DumbService.DUMB_MODE, new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }

            public void exitDumbMode() {
                FileManagerImpl.this.processFileTypesChanged(false);
            }
        });
        this.myVFileToViewProviderMap = CodeInsightContextKt.isSharedSourceSupportEnabled(manager.getProject()) ? new MultiverseFileViewProviderCache() : new ClassicFileViewProviderCache();
        this.myTempProviders = CodeInsightContextKt.isSharedSourceSupportEnabled(manager.getProject()) ? new ClassicTemporaryProviderStorage() : new MultiverseTemporaryProviderStorage();
    }

    public void processQueue() {
        this.myVFileToViewProviderMap.processQueue();
    }

    @NotNull
    private ConcurrentMap<VirtualFile, PsiDirectory> getVFileToPsiDirMap() {
        ConcurrentMap<VirtualFile, PsiDirectory> map = this.myVFileToPsiDirMap.get();
        if (map == null) {
            map = ConcurrencyUtil.cacheOrGet(this.myVFileToPsiDirMap, ContainerUtil.createConcurrentSoftValueMap());
        }
        ConcurrentMap<VirtualFile, PsiDirectory> concurrentMap = map;
        if (concurrentMap == null) {
            FileManagerImpl.$$$reportNull$$$0(2);
        }
        return concurrentMap;
    }

    @TestOnly
    public void assertNoInjectedFragmentsStoredInMaps() {
        this.myVFileToViewProviderMap.forEach((file, __, provider) -> {
            if (file instanceof VirtualFileWindow) {
                throw new AssertionError(file);
            }
            PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance(this.myManager.getProject()).getInjectionHost(provider);
            if (injectionHost != null) {
                throw new AssertionError(injectionHost);
            }
        });
    }

    @ApiStatus.Internal
    @Nullable
    public CodeInsightContext trySetContext(@NotNull FileViewProvider viewProvider, @NotNull CodeInsightContext context2) {
        VirtualFile vFile;
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(4);
        }
        if ((vFile = viewProvider.getVirtualFile()) instanceof LightVirtualFile) {
            this.installContext(viewProvider, context2);
            return context2;
        }
        return this.myVFileToViewProviderMap.trySetContext(viewProvider, context2);
    }

    public static void clearPsiCaches(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(5);
        }
        ((AbstractFileViewProvider)viewProvider).getCachedPsiFiles().forEach(PsiFile::clearCaches);
    }

    public void forceReload(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(6);
        }
        LanguageSubstitutors.cancelReparsing(vFile);
        List<FileViewProvider> viewProviders = this.findCachedViewProviders(vFile);
        if (viewProviders.isEmpty()) {
            return;
        }
        if (!FileViewProviderUtil.isEventSystemEnabled(viewProviders)) {
            this.setViewProvider(vFile, null);
            return;
        }
        ThreadingAssertions.assertWriteAccess();
        VirtualFile dir2 = vFile.getParent();
        PsiDirectory parentDir = dir2 == null ? null : this.getCachedDirectory(dir2);
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        if (parentDir == null) {
            event.setPropertyName("propUnloadedPsi");
            this.myManager.beforePropertyChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.propertyChanged(event);
        } else {
            event.setParent(parentDir);
            this.myManager.beforeChildrenChange(event);
            this.setViewProvider(vFile, null);
            this.myManager.childrenChanged(event);
        }
    }

    public void firePropertyChangedForUnloadedPsi() {
        PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
        event.setPropertyName("propUnloadedPsi");
        this.myManager.beforePropertyChange(event);
        this.myManager.propertyChanged(event);
    }

    public void dispose() {
        this.clearViewProviders();
    }

    private void clearViewProviders() {
        ThreadingAssertions.assertWriteAccess();
        DebugUtil.performPsiModification("clearViewProviders", () -> {
            this.myVFileToViewProviderMap.forEach((__, ___, provider) -> this.markInvalidated(provider));
            this.myVFileToViewProviderMap.clear();
        });
    }

    @Override
    @TestOnly
    public void cleanupForNextTest() {
        ApplicationManager.getApplication().runWriteAction(this::clearViewProviders);
        this.myVFileToPsiDirMap.set(null);
        this.myManager.dropPsiCaches();
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(7);
        }
        FileViewProvider fileViewProvider = this.findViewProvider(vFile, CodeInsightContextKt.anyContext());
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(8);
        }
        return fileViewProvider;
    }

    @Override
    @NotNull
    public FileViewProvider findViewProvider(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(10);
        }
        assert (!vFile.isDirectory());
        FileViewProvider cachedViewProvider = this.findCachedViewProvider(vFile, context2);
        if (cachedViewProvider != null) {
            FileViewProvider fileViewProvider = cachedViewProvider;
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(11);
            }
            return fileViewProvider;
        }
        if (vFile instanceof VirtualFileWindow) {
            throw new IllegalStateException("File " + vFile + " is invalid");
        }
        if (this.myTempProviders.contains(vFile, context2)) {
            FileViewProvider fileViewProvider = Objects.requireNonNull(this.myTempProviders.get(vFile, context2), "Recursive file view provider creation");
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(12);
            }
            return fileViewProvider;
        }
        FileViewProvider viewProvider = this.createFileViewProvider(vFile, context2, !LightVirtualFile.shouldSkipEventSystem(vFile));
        if (vFile instanceof LightVirtualFile) {
            this.checkLightFileHasNoOtherPsi((LightVirtualFile)vFile);
            FileViewProvider fileViewProvider = vFile.putUserDataIfAbsent(this.myPsiHardRefKey, viewProvider);
            if (fileViewProvider == null) {
                FileManagerImpl.$$$reportNull$$$0(13);
            }
            return fileViewProvider;
        }
        FileViewProvider fileViewProvider = this.myVFileToViewProviderMap.cacheOrGet(vFile, context2, viewProvider);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(14);
        }
        return fileViewProvider;
    }

    @Override
    @NotNull
    public List<FileViewProvider> findCachedViewProviders(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(15);
        }
        List<FileViewProvider> providers = this.getRawCachedViewProviders(vFile);
        List<FileViewProvider> list = FileManagerImpl.mapNotNull(providers, viewProvider -> this.reanimateProviderIfNecessary(vFile, (FileViewProvider)viewProvider));
        if (list == null) {
            FileManagerImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private void checkLightFileHasNoOtherPsi(@NotNull LightVirtualFile vFile) {
        Project project;
        FileViewProvider viewProvider;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(17);
        }
        if ((viewProvider = FileDocumentManager.getInstance().findCachedPsiInAnyProject(vFile)) != null && (project = viewProvider.getManager().getProject()) != this.myManager.getProject()) {
            String psiFiles = viewProvider.getAllFiles().stream().map(f -> f.getClass() + " [" + f.getLanguage() + "]").collect(Collectors.joining(", "));
            LOG.error("Light files should have PSI only in one project, existing=" + viewProvider + " in " + project + ", requested in " + this.myManager.getProject() + "; psiFiles: " + psiFiles);
        }
    }

    @Override
    @Nullable
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(18);
        }
        return this.findCachedViewProvider(vFile, CodeInsightContextKt.anyContext());
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(20);
        }
        FileViewProvider viewProvider = this.getRawCachedViewProvider(vFile, context2);
        return this.reanimateProviderIfNecessary(vFile, viewProvider);
    }

    @Nullable
    private FileViewProvider reanimateProviderIfNecessary(@NotNull VirtualFile vFile, @Nullable FileViewProvider viewProvider) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(21);
        }
        if (viewProvider instanceof AbstractFileViewProvider && viewProvider.getUserData(IN_COMA) != null) {
            CodeInsightContext context2 = this.getRawContext(viewProvider);
            FileViewProvider temp = this.myTempProviders.get(vFile, context2);
            if (temp != null) {
                return temp;
            }
            if (!this.evaluateValidity((AbstractFileViewProvider)viewProvider)) {
                return null;
            }
        }
        return viewProvider;
    }

    @Nullable
    private FileViewProvider getRawCachedViewProvider(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        FileViewProvider viewProvider;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(23);
        }
        return (viewProvider = this.myVFileToViewProviderMap.get(vFile, context2)) == null ? vFile.getUserData(this.myPsiHardRefKey) : viewProvider;
    }

    @ApiStatus.Internal
    @Nullable
    public PsiFile getRawCachedFile(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        FileViewProvider viewProvider;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(24);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(25);
        }
        return (viewProvider = this.getRawCachedViewProvider(vFile, context2)) == null ? null : (viewProvider instanceof AbstractFileViewProvider ? ((AbstractFileViewProvider)viewProvider).getCachedPsi(viewProvider.getBaseLanguage()) : viewProvider.getPsi(viewProvider.getBaseLanguage()));
    }

    @NotNull
    private List<FileViewProvider> getRawCachedViewProviders(@NotNull VirtualFile vFile) {
        List<FileViewProvider> providers;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(26);
        }
        if (!(providers = this.myVFileToViewProviderMap.getAllProviders(vFile)).isEmpty()) {
            if (providers.size() == 1) {
                List<FileViewProvider> list = Collections.singletonList(providers.get(0));
                if (list == null) {
                    FileManagerImpl.$$$reportNull$$$0(27);
                }
                return list;
            }
            return new ArrayList<FileViewProvider>(providers);
        }
        FileViewProvider provider = vFile.getUserData(this.myPsiHardRefKey);
        List<FileViewProvider> list = ContainerUtil.createMaybeSingletonList(provider);
        if (list == null) {
            FileManagerImpl.$$$reportNull$$$0(28);
        }
        return list;
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile vFile, @Nullable FileViewProvider viewProvider) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(29);
        }
        if (viewProvider == null) {
            this.dropAllProviders(vFile);
        } else {
            this.changeFileProvider(vFile, viewProvider);
        }
    }

    private void changeFileProvider(@NotNull VirtualFile vFile, @NotNull FileViewProvider viewProvider) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(30);
        }
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(31);
        }
        if (vFile instanceof LightVirtualFile) {
            FileViewProvider prev = this.getRawCachedViewProvider(vFile, CodeInsightContextKt.anyContext());
            if (prev == viewProvider) {
                return;
            }
            if (prev != null) {
                DebugUtil.performPsiModification(null, () -> this.markInvalidated(prev));
            }
            this.checkLightFileHasNoOtherPsi((LightVirtualFile)vFile);
            vFile.putUserData(this.myPsiHardRefKey, viewProvider);
        } else {
            ThreadingAssertions.assertWriteAccess();
            List<FileViewProvider> prevProviders = this.getRawCachedViewProviders(vFile);
            if (prevProviders.size() == 1 && prevProviders.get(0) == viewProvider) {
                return;
            }
            DebugUtil.performPsiModification(null, () -> {
                for (FileViewProvider prevProvider : prevProviders) {
                    this.markInvalidated(prevProvider);
                }
            });
            this.myVFileToViewProviderMap.removeAllFileViewProvidersAndSet(vFile, viewProvider);
        }
    }

    private void dropAllProviders(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(32);
        }
        if (vFile instanceof LightVirtualFile) {
            FileViewProvider oldProvider = vFile.getUserData(this.myPsiHardRefKey);
            if (oldProvider != null) {
                DebugUtil.performPsiModification(null, () -> this.markInvalidated(oldProvider));
            }
            vFile.putUserData(this.myPsiHardRefKey, null);
        } else {
            Iterable<FileViewProvider> map = this.myVFileToViewProviderMap.remove(vFile);
            if (map != null) {
                for (FileViewProvider oldProvider : map) {
                    DebugUtil.performPsiModification(null, () -> this.markInvalidated(oldProvider));
                }
            }
        }
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile vFile, boolean eventSystemEnabled) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(33);
        }
        FileViewProvider fileViewProvider = this.createFileViewProvider(vFile, CodeInsightContextKt.anyContext(), eventSystemEnabled);
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(34);
        }
        return fileViewProvider;
    }

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2, boolean eventSystemEnabled) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(35);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(36);
        }
        FileType fileType = vFile.getFileType();
        Language language = LanguageUtil.getLanguageForPsi(this.myManager.getProject(), vFile, fileType);
        FileViewProviderFactory factory = language == null ? (FileViewProviderFactory)FileTypeFileViewProviders.INSTANCE.forFileType(fileType) : (FileViewProviderFactory)LanguageFileViewProviders.INSTANCE.forLanguage(language);
        FileViewProvider viewProvider = factory != null ? factory.createFileViewProvider(vFile, language, this.myManager, eventSystemEnabled) : new SingleRootFileViewProvider((PsiManager)this.myManager, vFile, eventSystemEnabled, fileType);
        this.installContext(viewProvider, context2);
        FileViewProvider fileViewProvider = viewProvider;
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(37);
        }
        return fileViewProvider;
    }

    private void installContext(@NotNull FileViewProvider viewProvider, @NotNull CodeInsightContext context2) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(38);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(39);
        }
        if (!CodeInsightContextKt.isSharedSourceSupportEnabled(this.myManager.getProject())) {
            return;
        }
        CodeInsightContextManagerImpl codeInsightContextManager = (CodeInsightContextManagerImpl)CodeInsightContextManager.getInstance(this.myManager.getProject());
        codeInsightContextManager.setCodeInsightContext(viewProvider, context2);
    }

    @ApiStatus.Internal
    public void processFileTypesChanged(boolean clearViewProviders) {
        if (this.myProcessingFileTypesChange) {
            return;
        }
        this.myProcessingFileTypesChange = true;
        DebugUtil.performPsiModification(null, () -> {
            try {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    PsiTreeChangeEventImpl event = new PsiTreeChangeEventImpl(this.myManager);
                    event.setPropertyName("propFileTypes");
                    this.myManager.beforePropertyChange(event);
                    this.possiblyInvalidatePhysicalPsi();
                    if (clearViewProviders) {
                        this.clearViewProviders();
                    }
                    this.myManager.propertyChanged(event);
                });
            }
            finally {
                this.myProcessingFileTypesChange = false;
            }
        });
    }

    @ApiStatus.Internal
    public void possiblyInvalidatePhysicalPsi() {
        ThreadingAssertions.assertWriteAccess();
        this.removeInvalidDirs();
        this.myVFileToViewProviderMap.forEach((__, ___, viewProvider) -> FileManagerImpl.markPossiblyInvalidated(viewProvider));
    }

    @ApiStatus.Internal
    public void dispatchPendingEvents() {
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.myConnection.deliverImmediately();
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(40);
        }
        ThreadingAssertions.softAssertReadAccess();
        CodeInsightContext context2 = CodeInsightContextKt.anyContext();
        return this.findFile(vFile, context2);
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(41);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(42);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (vFile.isDirectory()) {
            return null;
        }
        if (!vFile.isValid()) {
            LOG.error(new InvalidVirtualFileAccessException(vFile));
            return null;
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.findViewProvider(vFile, context2);
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(43);
        }
        ThreadingAssertions.softAssertReadAccess();
        return this.getCachedPsiFile(vFile, CodeInsightContextKt.anyContext());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(44);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(45);
        }
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.dispatchPendingEvents();
        return this.getCachedPsiFileInner(vFile, context2);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(46);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Access to psi files should not be performed after project disposal: " + project);
        }
        if (!vFile.isValid()) {
            LOG.error(new InvalidVirtualFileAccessException(vFile));
            return null;
        }
        if (!vFile.isDirectory()) {
            return null;
        }
        this.dispatchPendingEvents();
        return this.findDirectoryImpl(vFile, this.getVFileToPsiDirMap());
    }

    @Nullable
    private PsiDirectory findDirectoryImpl(@NotNull VirtualFile vFile, @NotNull ConcurrentMap<VirtualFile, PsiDirectory> psiDirMap) {
        PsiDirectory psiDir;
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(47);
        }
        if (psiDirMap == null) {
            FileManagerImpl.$$$reportNull$$$0(48);
        }
        if ((psiDir = (PsiDirectory)psiDirMap.get(vFile)) != null) {
            return psiDir;
        }
        if (this.isExcludedOrIgnored(vFile)) {
            return null;
        }
        VirtualFile parent2 = vFile.getParent();
        if (parent2 != null) {
            this.findDirectoryImpl(parent2, psiDirMap);
        }
        psiDir = PsiDirectoryFactory.getInstance(this.myManager.getProject()).createDirectory(vFile);
        return ConcurrencyUtil.cacheOrGet(psiDirMap, vFile, psiDir);
    }

    private boolean isExcludedOrIgnored(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(49);
        }
        if (this.myManager.getProject().isDefault()) {
            return false;
        }
        FileIndexFacade fileIndexFacade = this.myFileIndex.getValue();
        return Registry.is("ide.hide.excluded.files") ? fileIndexFacade.isExcludedFile(vFile) : fileIndexFacade.isUnderIgnored(vFile);
    }

    public PsiDirectory getCachedDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(50);
        }
        return (PsiDirectory)this.getVFileToPsiDirMap().get(vFile);
    }

    @ApiStatus.Internal
    public void removeFilesAndDirsRecursively(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(51);
        }
        DebugUtil.performPsiModification("removeFilesAndDirsRecursively", () -> VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file.isDirectory()) {
                    FileManagerImpl.this.getVFileToPsiDirMap().remove(file);
                } else {
                    Iterable<FileViewProvider> oldProviders = FileManagerImpl.this.myVFileToViewProviderMap.remove(file);
                    if (oldProviders != null) {
                        for (FileViewProvider viewProvider : oldProviders) {
                            FileManagerImpl.this.markInvalidated(viewProvider);
                        }
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl$2", "visitFile"));
            }
        }));
    }

    private void markInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(52);
        }
        viewProvider.putUserData(IN_COMA, null);
        ((AbstractFileViewProvider)viewProvider).markInvalidated();
        viewProvider.getVirtualFile().putUserData(this.myPsiHardRefKey, null);
    }

    public static void markPossiblyInvalidated(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(53);
        }
        LOG.assertTrue(!(viewProvider instanceof FreeThreadedFileViewProvider));
        viewProvider.putUserData(IN_COMA, true);
        ((AbstractFileViewProvider)viewProvider).markPossiblyInvalidated();
        FileManagerImpl.clearPsiCaches(viewProvider);
    }

    @Nullable
    @ApiStatus.Internal
    public PsiFile getCachedPsiFileInner(@NotNull VirtualFile file, @NotNull CodeInsightContext context2) {
        FileViewProvider viewProvider;
        if (file == null) {
            FileManagerImpl.$$$reportNull$$$0(54);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(55);
        }
        return (viewProvider = this.findCachedViewProvider(file, context2)) == null ? null : ((AbstractFileViewProvider)viewProvider).getCachedPsi(viewProvider.getBaseLanguage());
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        ArrayList<PsiFile> files2 = new ArrayList<PsiFile>();
        this.myVFileToViewProviderMap.forEach((file, codeInsightContext, __) -> {
            FileViewProvider updatedProvider = this.findCachedViewProvider(file, codeInsightContext);
            if (updatedProvider != null) {
                ContainerUtil.addAllNotNull(files2, ((AbstractFileViewProvider)updatedProvider).getCachedPsiFiles());
            }
        });
        ArrayList<PsiFile> arrayList = files2;
        if (arrayList == null) {
            FileManagerImpl.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    private void removeInvalidDirs() {
        ThreadingAssertions.assertWriteAccess();
        this.myVFileToPsiDirMap.set(null);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public void removeInvalidFilesAndDirs(boolean bl) {
        void useFind;
        ThreadingAssertions.assertWriteAccess();
        this.removeInvalidDirs();
        ArrayList<Entry> fileToPsiFileMap = new ArrayList<Entry>(this.myVFileToViewProviderMap.getAllEntries());
        List<Entry> originalFileToPsiFileMap = this.myVFileToViewProviderMap.getAllEntries();
        if (useFind != false) {
            this.myVFileToViewProviderMap.clear();
        }
        Iterator<Entry> iterator2 = fileToPsiFileMap.iterator();
        while (iterator2.hasNext()) {
            Entry entry = iterator2.next();
            VirtualFile vFile = entry.getFile();
            CodeInsightContext context2 = entry.getContext();
            if (!vFile.isValid()) {
                iterator2.remove();
                continue;
            }
            FileViewProvider viewProvider = entry.getProvider();
            if (useFind != false) {
                PsiFile psiFile1 = this.findFile(vFile, context2);
                if (psiFile1 == null) {
                    iterator2.remove();
                    continue;
                }
                if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, psiFile1.getViewProvider())) {
                    iterator2.remove();
                    continue;
                }
                FileManagerImpl.clearPsiCaches(viewProvider);
                continue;
            }
            if (this.evaluateValidity((AbstractFileViewProvider)viewProvider)) continue;
            iterator2.remove();
        }
        this.myVFileToViewProviderMap.replaceAll(fileToPsiFileMap);
        this.markInvalidations(originalFileToPsiFileMap);
    }

    @ApiStatus.Internal
    public static boolean areViewProvidersEquivalent(@NotNull FileViewProvider view1, @NotNull FileViewProvider view2) {
        if (view1 == null) {
            FileManagerImpl.$$$reportNull$$$0(57);
        }
        if (view2 == null) {
            FileManagerImpl.$$$reportNull$$$0(58);
        }
        if (view1.getClass() != view2.getClass() || view1.getFileType() != view2.getFileType()) {
            return false;
        }
        Language baseLanguage = view1.getBaseLanguage();
        if (baseLanguage != view2.getBaseLanguage()) {
            return false;
        }
        if (!view1.getLanguages().equals(view2.getLanguages())) {
            return false;
        }
        PsiFile psi1 = view1.getPsi(baseLanguage);
        PsiFile psi2 = view2.getPsi(baseLanguage);
        if (psi1 == null || psi2 == null) {
            return psi1 == psi2;
        }
        return psi1.getClass() == psi2.getClass();
    }

    private void markInvalidations(@NotNull List<Entry> originalFileToPsiFileMap) {
        if (originalFileToPsiFileMap == null) {
            FileManagerImpl.$$$reportNull$$$0(59);
        }
        if (!originalFileToPsiFileMap.isEmpty()) {
            DebugUtil.performPsiModification(null, () -> {
                for (Entry entry : originalFileToPsiFileMap) {
                    FileViewProvider viewProvider = entry.getProvider();
                    if (this.myVFileToViewProviderMap.get(entry.getFile(), entry.getContext()) == viewProvider) continue;
                    this.markInvalidated(viewProvider);
                }
            });
        }
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            FileManagerImpl.$$$reportNull$$$0(60);
        }
        ThreadingAssertions.assertWriteAccess();
        VirtualFile vFile = psiFile.getVirtualFile();
        assert (vFile != null);
        Document document = FileDocumentManager.getInstance().getCachedDocument(vFile);
        if (document != null) {
            FileDocumentManager.getInstance().reloadFromDisk(document, psiFile.getProject());
        } else {
            this.reloadPsiAfterTextChange(psiFile.getViewProvider(), vFile);
        }
    }

    @ApiStatus.Internal
    public void reloadPsiAfterTextChange(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile vFile) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(61);
        }
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(62);
        }
        if (!FileManagerImpl.areViewProvidersEquivalent(viewProvider, this.createFileViewProvider(vFile, false))) {
            this.forceReload(vFile);
            return;
        }
        ((AbstractFileViewProvider)viewProvider).onContentReload();
    }

    public boolean evaluateValidity(@NotNull PsiFile file) {
        AbstractFileViewProvider viewProvider;
        if (file == null) {
            FileManagerImpl.$$$reportNull$$$0(63);
        }
        return this.evaluateValidity(viewProvider = (AbstractFileViewProvider)file.getViewProvider()) && viewProvider.getCachedPsiFiles().contains(file);
    }

    private boolean evaluateValidity(@NotNull AbstractFileViewProvider viewProvider) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(64);
        }
        ThreadingAssertions.softAssertReadAccess();
        VirtualFile file = viewProvider.getVirtualFile();
        CodeInsightContext context2 = this.getRawContext(viewProvider);
        if (this.getRawCachedViewProvider(file, context2) != viewProvider) {
            return false;
        }
        if (viewProvider.getUserData(IN_COMA) == null) {
            return true;
        }
        if (this.shouldResurrect(viewProvider, file)) {
            viewProvider.putUserData(IN_COMA, null);
            FileViewProvider cachedProvider = this.getRawCachedViewProvider(file, context2);
            LOG.assertTrue(cachedProvider == viewProvider, "Cached: " + cachedProvider + ", expected: " + viewProvider);
            for (PsiFile psiFile : viewProvider.getCachedPsiFiles()) {
                if (psiFile.isValid()) continue;
                LOG.error(new PsiInvalidElementAccessException(psiFile));
            }
            return true;
        }
        this.myVFileToViewProviderMap.remove(file, context2, viewProvider);
        file.replace(this.myPsiHardRefKey, viewProvider, null);
        viewProvider.putUserData(IN_COMA, null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldResurrect(@NotNull FileViewProvider viewProvider, @NotNull VirtualFile file) {
        if (viewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(65);
        }
        if (file == null) {
            FileManagerImpl.$$$reportNull$$$0(66);
        }
        if (!file.isValid()) {
            return false;
        }
        CodeInsightContext context2 = this.getRawContext(viewProvider);
        if (this.myTempProviders.contains(file, context2)) {
            LOG.error(new StackOverflowPreventedException("isValid leads to endless recursion in " + viewProvider.getClass() + ": " + new ArrayList<Language>(viewProvider.getLanguages())));
        }
        this.myTempProviders.put(file, context2, null);
        try {
            FileViewProvider recreated = this.createFileViewProvider(file, true);
            this.myTempProviders.put(file, context2, recreated);
            boolean bl = FileManagerImpl.areViewProvidersEquivalent(viewProvider, recreated) && ContainerUtil.all(((AbstractFileViewProvider)viewProvider).getCachedPsiFiles(), FileManagerImpl::isValidOriginal);
            return bl;
        }
        finally {
            FileViewProvider temp = this.myTempProviders.remove(file, context2);
            if (temp != null) {
                DebugUtil.performPsiModification("invalidate temp view provider", ((AbstractFileViewProvider)temp)::markInvalidated);
            }
        }
    }

    private static boolean isValidOriginal(@NotNull PsiFile file) {
        PsiFile original;
        if (file == null) {
            FileManagerImpl.$$$reportNull$$$0(67);
        }
        return (original = file.getOriginalFile()) == file || original.isValid();
    }

    public PsiFile getFastCachedPsiFile(@NotNull VirtualFile vFile, @NotNull CodeInsightContext context2) {
        if (vFile == null) {
            FileManagerImpl.$$$reportNull$$$0(68);
        }
        if (context2 == null) {
            FileManagerImpl.$$$reportNull$$$0(69);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (!vFile.isValid()) {
            throw new InvalidVirtualFileAccessException(vFile);
        }
        Project project = this.myManager.getProject();
        if (project.isDisposed()) {
            LOG.error("Project is already disposed: " + project);
        }
        this.dispatchPendingEvents();
        FileViewProvider viewProvider = this.getRawCachedViewProvider(vFile, context2);
        if (viewProvider == null || viewProvider.getUserData(IN_COMA) != null) {
            return null;
        }
        return ((AbstractFileViewProvider)viewProvider).getCachedPsi(viewProvider.getBaseLanguage());
    }

    public void forEachCachedDocument(@NotNull @NotNull Consumer<? super @NotNull Document> consumer) {
        if (consumer == null) {
            FileManagerImpl.$$$reportNull$$$0(70);
        }
        this.myVFileToViewProviderMap.forEachKey(file -> {
            Document document = FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file);
            if (document != null) {
                consumer.accept(document);
            }
        });
    }

    @NotNull
    private CodeInsightContext getRawContext(@NotNull FileViewProvider fileViewProvider) {
        if (fileViewProvider == null) {
            FileManagerImpl.$$$reportNull$$$0(71);
        }
        if (CodeInsightContextKt.isSharedSourceSupportEnabled(this.myManager.getProject())) {
            CodeInsightContextManagerImpl manager = (CodeInsightContextManagerImpl)CodeInsightContextManager.getInstance(this.myManager.getProject());
            CodeInsightContext codeInsightContext = manager.getCodeInsightContextRaw(fileViewProvider);
            if (codeInsightContext == null) {
                FileManagerImpl.$$$reportNull$$$0(72);
            }
            return codeInsightContext;
        }
        CodeInsightContext codeInsightContext = CodeInsightContextKt.defaultContext();
        if (codeInsightContext == null) {
            FileManagerImpl.$$$reportNull$$$0(73);
        }
        return codeInsightContext;
    }

    private static <T, R> List<R> mapNotNull(@NotNull List<T> list, @NotNull Function<? super T, ? extends R> mapper) {
        if (list == null) {
            FileManagerImpl.$$$reportNull$$$0(74);
        }
        if (mapper == null) {
            FileManagerImpl.$$$reportNull$$$0(75);
        }
        if (list.size() == 1) {
            return ContainerUtil.createMaybeSingletonList(mapper.apply(list.get(0)));
        }
        return ContainerUtil.mapNotNull(list, mapper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 34: 
            case 37: 
            case 56: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 34: 
            case 37: 
            case 56: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 34: 
            case 37: 
            case 56: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 3: 
            case 5: 
            case 31: 
            case 38: 
            case 52: 
            case 53: 
            case 61: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 4: 
            case 10: 
            case 20: 
            case 23: 
            case 25: 
            case 36: 
            case 39: 
            case 42: 
            case 45: 
            case 55: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 62: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirMap";
                break;
            }
            case 54: 
            case 63: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view1";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view2";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFileToPsiFileMap";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVFileToPsiDirMap";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findViewProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findCachedViewProviders";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawCachedViewProviders";
                break;
            }
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewProvider";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCachedFiles";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 34: 
            case 37: 
            case 56: 
            case 72: 
            case 73: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trySetContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearPsiCaches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "forceReload";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findViewProvider";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProviders";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkLightFileHasNoOtherPsi";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findCachedViewProvider";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reanimateProviderIfNecessary";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedViewProvider";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRawCachedViewProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setViewProvider";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "changeFileProvider";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dropAllProviders";
                break;
            }
            case 33: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewProvider";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "installContext";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFile";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findDirectory";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDirectoryImpl";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedOrIgnored";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDirectory";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesAndDirsRecursively";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidated";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyInvalidated";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsiFileInner";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "areViewProvidersEquivalent";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "markInvalidations";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "reloadFromDisk";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "reloadPsiAfterTextChange";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "evaluateValidity";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "shouldResurrect";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isValidOriginal";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getFastCachedPsiFile";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "forEachCachedDocument";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getRawContext";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 27: 
            case 28: 
            case 34: 
            case 37: 
            case 56: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

