/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.file.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.multiverse.CodeInsightContext;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.AbstractFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileProviderMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileProviderMapKt;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.FileViewProviderCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.impl.MultiverseFileViewProviderCacheKt;
import org.jetbrains.kotlin.com.intellij.util.AtomicMapCache;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0016\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\rH\u0016J\u0018\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J \u0010\u001e\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\u001a\u0010#\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R0\u0010\u0004\u001a$\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\bj\u0002`\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/com/intellij/psi/impl/file/impl/MultiverseFileViewProviderCache;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileViewProviderCache;", "<init>", "()V", "cache", "Lorg/jetbrains/kotlin/com/intellij/util/AtomicMapCache;", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileProviderMap;", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FullCacheMap;", "clear", "", "cacheOrGet", "Lorg/jetbrains/kotlin/com/intellij/psi/FileViewProvider;", "file", "context", "Lorg/jetbrains/kotlin/com/intellij/codeInsight/multiverse/CodeInsightContext;", "provider", "getFileProviderMap", "forEachKey", "block", "Ljava/util/function/Consumer;", "forEach", "Lorg/jetbrains/kotlin/com/intellij/psi/impl/file/impl/FileViewProviderCache$Consumer;", "getAllProviders", "", "vFile", "get", "removeAllFileViewProvidersAndSet", "viewProvider", "remove", "", "", "Lorg/jetbrains/kotlin/com/intellij/psi/AbstractFileViewProvider;", "processQueue", "trySetContext", "intellij.platform.core.impl"})
@SourceDebugExtension(value={"SMAP\nMultiverseFileViewProviderCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiverseFileViewProviderCache.kt\ncom/intellij/psi/impl/file/impl/MultiverseFileViewProviderCache\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n216#2,2:110\n*S KotlinDebug\n*F\n+ 1 MultiverseFileViewProviderCache.kt\ncom/intellij/psi/impl/file/impl/MultiverseFileViewProviderCache\n*L\n49#1:110,2\n*E\n"})
public final class MultiverseFileViewProviderCache
implements FileViewProviderCache {
    @NotNull
    private final AtomicMapCache<VirtualFile, FileProviderMap, ConcurrentMap<VirtualFile, FileProviderMap>> cache = new AtomicMapCache(MultiverseFileViewProviderCache::cache$lambda$0);

    @Override
    public void clear() {
        this.cache.invalidate();
    }

    @Override
    @NotNull
    public FileViewProvider cacheOrGet(@NotNull VirtualFile file, @NotNull CodeInsightContext context2, @NotNull FileViewProvider provider) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        FileProviderMap map = this.getFileProviderMap(file);
        return map.cacheOrGet(context2, provider);
    }

    private final FileProviderMap getFileProviderMap(VirtualFile file) {
        return this.cache.getOrPut(file, (Function0<FileProviderMap>)((Function0)MultiverseFileViewProviderCache::getFileProviderMap$lambda$1));
    }

    @Override
    public void forEachKey(@NotNull Consumer<VirtualFile> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.cache.isInitialized()) {
            return;
        }
        ((ConcurrentMap)this.cache.getCache()).keySet().forEach(block);
    }

    @Override
    public void forEach(@NotNull FileViewProviderCache.Consumer block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!this.cache.isInitialized()) {
            return;
        }
        ConcurrentMap map = (ConcurrentMap)this.cache.getCache();
        Map $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileProviderMap map2 = (FileProviderMap)entry.getValue();
            Intrinsics.checkNotNull((Object)map2);
            FileProviderMapKt.forEach(map2, (Function2<? super CodeInsightContext, ? super FileViewProvider, Unit>)((Function2)(arg_0, arg_1) -> MultiverseFileViewProviderCache.forEach$lambda$3$lambda$2(block, file, arg_0, arg_1)));
        }
    }

    @Override
    @NotNull
    public List<FileViewProvider> getAllProviders(@NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        FileProviderMap fileProviderMap = this.cache.get(vFile);
        if (fileProviderMap == null) {
            return CollectionsKt.emptyList();
        }
        FileProviderMap map = fileProviderMap;
        return FileProviderMapKt.getAllProviders(map);
    }

    @Override
    @Nullable
    public FileViewProvider get(@NotNull VirtualFile file, @NotNull CodeInsightContext context2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FileProviderMap fileProviderMap = (FileProviderMap)((ConcurrentMap)this.cache.getCache()).get(file);
        return fileProviderMap != null ? fileProviderMap.get(context2) : null;
    }

    @Override
    public void removeAllFileViewProvidersAndSet(@NotNull VirtualFile vFile, @NotNull FileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        FileProviderMap fileMap = this.getFileProviderMap(vFile);
        fileMap.removeAllAndSetAny(viewProvider);
    }

    @Override
    @Nullable
    public Iterable<FileViewProvider> remove(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileProviderMap fileProviderMap = (FileProviderMap)((ConcurrentMap)this.cache.getCache()).remove(file);
        if (fileProviderMap == null) {
            return null;
        }
        FileProviderMap map = fileProviderMap;
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)map.getEntries()), MultiverseFileViewProviderCache::remove$lambda$4));
    }

    @Override
    public boolean remove(@NotNull VirtualFile file, @NotNull CodeInsightContext context2, @NotNull AbstractFileViewProvider viewProvider) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        if (!this.cache.isInitialized()) {
            return false;
        }
        FileProviderMap fileProviderMap = (FileProviderMap)((ConcurrentMap)this.cache.getCache()).get(file);
        if (fileProviderMap == null) {
            return false;
        }
        FileProviderMap map = fileProviderMap;
        return map.remove(context2, viewProvider);
    }

    @Override
    public void processQueue() {
        if (!this.cache.isInitialized()) {
            return;
        }
        ((ConcurrentMap)this.cache.getCache()).remove(MultiverseFileViewProviderCacheKt.access$getNULL$p());
    }

    @Override
    @Nullable
    public CodeInsightContext trySetContext(@NotNull FileViewProvider viewProvider, @NotNull CodeInsightContext context2) {
        Intrinsics.checkNotNullParameter((Object)viewProvider, (String)"viewProvider");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile vFile = virtualFile;
        FileProviderMap map = this.getFileProviderMap(vFile);
        return map.trySetContext(viewProvider, context2);
    }

    private static final ConcurrentMap cache$lambda$0() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        return concurrentMap;
    }

    private static final FileProviderMap getFileProviderMap$lambda$1() {
        return FileProviderMapKt.FileProviderMap();
    }

    private static final Unit forEach$lambda$3$lambda$2(FileViewProviderCache.Consumer $block, VirtualFile $file, CodeInsightContext context2, FileViewProvider provider) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNull((Object)$file);
        $block.consume($file, context2, provider);
        return Unit.INSTANCE;
    }

    private static final FileViewProvider remove$lambda$4(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (FileViewProvider)it.getValue();
    }
}

