/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModuleReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaImportStatementElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiImportStatementStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiImportStatementStubImpl
extends StubBase<PsiImportStatementBase>
implements PsiImportStatementStub {
    private final byte myFlags;
    private final String myText;
    private SoftReference<PsiJavaCodeReferenceElement> myReference;
    private SoftReference<PsiJavaModuleReferenceElement> myModuleReference;

    public PsiImportStatementStubImpl(StubElement parent2, String text, byte flags) {
        super(parent2, PsiImportStatementStubImpl.getImportType(flags));
        this.myText = text;
        this.myFlags = flags;
    }

    @NotNull
    private static JavaImportStatementElementType getImportType(byte flags) {
        if (PsiImportStatementStubImpl.isStatic(flags)) {
            JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_STATIC_STATEMENT;
            if (javaImportStatementElementType == null) {
                PsiImportStatementStubImpl.$$$reportNull$$$0(0);
            }
            return javaImportStatementElementType;
        }
        if (PsiImportStatementStubImpl.isModule(flags)) {
            JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_MODULE_STATEMENT;
            if (javaImportStatementElementType == null) {
                PsiImportStatementStubImpl.$$$reportNull$$$0(1);
            }
            return javaImportStatementElementType;
        }
        JavaImportStatementElementType javaImportStatementElementType = JavaStubElementTypes.IMPORT_STATEMENT;
        if (javaImportStatementElementType == null) {
            PsiImportStatementStubImpl.$$$reportNull$$$0(2);
        }
        return javaImportStatementElementType;
    }

    @Override
    public boolean isStatic() {
        return PsiImportStatementStubImpl.isStatic(this.myFlags);
    }

    private static boolean isStatic(byte flags) {
        return BitUtil.isSet((int)flags, 2);
    }

    @Override
    public boolean isModule() {
        return PsiImportStatementStubImpl.isModule(this.myFlags);
    }

    private static boolean isModule(byte flags) {
        return BitUtil.isSet((int)flags, 4);
    }

    @Override
    public boolean isOnDemand() {
        return BitUtil.isSet((int)this.myFlags, 1);
    }

    public byte getFlags() {
        return this.myFlags;
    }

    @Override
    public String getImportReferenceText() {
        return this.myText;
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getReference() {
        PsiJavaCodeReferenceElement ref = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myReference);
        if (ref == null && !this.isModule()) {
            ref = this.isStatic() ? this.getStaticReference() : this.getRegularReference();
            this.myReference = new SoftReference<PsiJavaCodeReferenceElement>(ref);
        }
        return ref;
    }

    @Override
    @Nullable
    public PsiJavaModuleReferenceElement getModuleReference() {
        if (!this.isModule()) {
            return null;
        }
        PsiJavaModuleReferenceElement ref = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myModuleReference);
        if (ref == null) {
            ref = this.createModuleReference();
            this.myModuleReference = new SoftReference<PsiJavaModuleReferenceElement>(ref);
        }
        return ref;
    }

    public static byte packFlags(boolean isOnDemand, boolean isStatic, boolean isModule) {
        byte flags = 0;
        if (isOnDemand) {
            flags = (byte)(flags | 1);
        }
        if (isStatic) {
            flags = (byte)(flags | 2);
        }
        if (isModule) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getStaticReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        if (this.isOnDemand() && refElement instanceof PsiJavaCodeReferenceElementImpl) {
            ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        }
        return refElement;
    }

    @Nullable
    private PsiJavaCodeReferenceElement getRegularReference() {
        PsiJavaCodeReferenceElement refElement = this.createReference();
        if (refElement == null) {
            return null;
        }
        ((PsiJavaCodeReferenceElementImpl)refElement).setKindWhenDummy(this.isOnDemand() ? PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_OR_PACKAGE_NAME_KIND : PsiJavaCodeReferenceElementImpl.Kind.CLASS_FQ_NAME_KIND);
        return refElement;
    }

    @Nullable
    private PsiJavaModuleReferenceElement createModuleReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        try {
            PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            return parserFacade.createModuleReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException ignore) {
            return null;
        }
    }

    @Nullable
    private PsiJavaCodeReferenceElement createReference() {
        String refText = this.getImportReferenceText();
        if (refText == null) {
            return null;
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
        try {
            return parserFacade.createReferenceFromText(refText, (PsiElement)this.getPsi());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("PsiImportStatementStub[");
        if (this.isStatic()) {
            builder2.append("static ");
        }
        if (this.isModule()) {
            builder2.append("module ");
        }
        builder2.append(this.getImportReferenceText());
        if (this.isOnDemand() && !this.isModule()) {
            builder2.append(".*");
        }
        builder2.append("]");
        return builder2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiImportStatementStubImpl", "getImportType"));
    }
}

