/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc;

import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.AbstractElementManipulator;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaFileCodeStyleFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.javadoc.PsiSnippetDocTagImpl;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiDocComment;
import org.jetbrains.kotlin.com.intellij.psi.javadoc.PsiSnippetDocTag;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class SnippetDocTagManipulator
extends AbstractElementManipulator<PsiSnippetDocTagImpl> {
    @Override
    public PsiSnippetDocTagImpl handleContentChange(@NotNull PsiSnippetDocTagImpl element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(1);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(element.getProject());
        JavaFileCodeStyleFacade codeStyleFacade = JavaFileCodeStyleFacade.forContext(element.getContainingFile());
        String newSnippetTagContent = codeStyleFacade.isJavaDocLeadingAsterisksEnabled() ? SnippetDocTagManipulator.prependAbsentAsterisks(newContent) : newContent;
        PsiDocComment text = factory.createDocCommentFromText("/**\n" + newSnippetTagContent + "\n*/");
        PsiSnippetDocTag snippet = PsiTreeUtil.findChildOfType(text, PsiSnippetDocTag.class);
        if (snippet == null) {
            return element;
        }
        return (PsiSnippetDocTagImpl)element.replace(snippet);
    }

    @Contract(pure=true)
    @NotNull
    private static String prependAbsentAsterisks(@NotNull String input) {
        if (input == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(2);
        }
        String string = input.replaceAll("(\\n\\s*)([^*\\s])", "$1 * $2");
        if (string == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement(@NotNull PsiSnippetDocTagImpl element) {
        List<TextRange> ranges;
        if (element == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(4);
        }
        if ((ranges = element.getContentRanges()).isEmpty()) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                SnippetDocTagManipulator.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        int startOffset = ranges.get(0).getStartOffset();
        int endOffset = ContainerUtil.getLastItem(ranges).getEndOffset();
        TextRange textRange = TextRange.create(startOffset, endOffset);
        if (textRange == null) {
            SnippetDocTagManipulator.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/SnippetDocTagManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/javadoc/SnippetDocTagManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prependAbsentAsterisks";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "prependAbsentAsterisks";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

