/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class ClassInitializerElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(ClassInitializerElement.class);

    public ClassInitializerElement() {
        super(CLASS_INITIALIZER);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 8: {
                return this.findChildByType(MODIFIER_LIST);
            }
            case 17: {
                return this.findChildByType(CODE_BLOCK);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ClassInitializerElement.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == C_STYLE_COMMENT || i == END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i == MODIFIER_LIST) {
            return 8;
        }
        if (i == CODE_BLOCK) {
            return 17;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/ClassInitializerElement", "getChildRole"));
    }
}

