/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.ResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiNewExpressionImpl
extends ExpressionPsiElement
implements PsiNewExpression {
    private static final Logger LOG = Logger.getInstance(PsiNewExpressionImpl.class);
    private static final TokenSet CLASS_REF = TokenSet.create(JavaElementType.JAVA_CODE_REFERENCE, JavaElementType.ANONYMOUS_CLASS);

    public PsiNewExpressionImpl() {
        super(JavaElementType.NEW_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return this.doGetType(null);
    }

    @Override
    public PsiType getOwner(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(0);
        }
        assert (annotation.getParent() == this) : annotation.getParent() + " != " + this;
        return this.doGetType(annotation);
    }

    @Nullable
    private PsiType doGetType(@Nullable PsiAnnotation stopAt) {
        PsiType type = null;
        SmartList<PsiAnnotation> annotations2 = new SmartList<PsiAnnotation>();
        ArrayList<TypeAnnotationProvider> arrayComponentAnnotations = new ArrayList<TypeAnnotationProvider>();
        boolean stop = false;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PsiElementFactory factory;
            IElementType elementType = child.getElementType();
            if (elementType == JavaElementType.ANNOTATION) {
                PsiAnnotation annotation = (PsiAnnotation)child.getPsi();
                annotations2.add(annotation);
                if (annotation != stopAt) continue;
                arrayComponentAnnotations.clear();
                stop = true;
                continue;
            }
            if (elementType == JavaElementType.JAVA_CODE_REFERENCE) {
                assert (type == null) : this;
                type = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child.getPsi(), null);
                if (!stop) continue;
                return type;
            }
            if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(elementType)) {
                assert (type == null) : this;
                factory = JavaPsiFacade.getElementFactory(this.getProject());
                PsiAnnotation[] copy = ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true);
                type = factory.createPrimitiveTypeFromText(child.getText()).annotate(TypeAnnotationProvider.Static.create(copy));
                if (!stop) continue;
                return type;
            }
            if (elementType == JavaTokenType.LBRACKET) {
                assert (type != null) : this;
                PsiAnnotation[] copy = ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true);
                arrayComponentAnnotations.add(TypeAnnotationProvider.Static.create(copy));
                continue;
            }
            if (elementType != JavaElementType.ANONYMOUS_CLASS) continue;
            factory = JavaPsiFacade.getElementFactory(this.getProject());
            PsiClass aClass = (PsiClass)child.getPsi();
            PsiSubstitutor substitutor2 = aClass instanceof PsiTypeParameter ? PsiSubstitutor.EMPTY : factory.createRawSubstitutor(aClass);
            PsiAnnotation[] copy = ContainerUtil.copyAndClear(annotations2, PsiAnnotation.ARRAY_FACTORY, true);
            type = factory.createType(aClass, substitutor2, PsiUtil.getLanguageLevel(aClass)).annotate(TypeAnnotationProvider.Static.create(copy));
            if (!stop) continue;
            return type;
        }
        for (int i = arrayComponentAnnotations.size() - 1; i >= 0; --i) {
            TypeAnnotationProvider provider = (TypeAnnotationProvider)arrayComponentAnnotations.get(i);
            type = new PsiArrayType(type, provider);
        }
        return type;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list != null) {
            return list;
        }
        CompositeElement anonymousClass = (CompositeElement)SourceTreeToPsiMap.psiElementToTree(this.findChildByRoleAsPsiElement(70));
        if (anonymousClass != null) {
            return (PsiExpressionList)anonymousClass.findChildByRoleAsPsiElement(73);
        }
        return null;
    }

    @Override
    public PsiExpression @NotNull [] getArrayDimensions() {
        PsiExpression[] expressions = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.ARRAY_DIMENSION_BIT_SET, PsiExpression.ARRAY_FACTORY);
        PsiExpression qualifier = this.getQualifier();
        if (qualifier == null || !ElementType.ARRAY_DIMENSION_BIT_SET.contains(qualifier.getNode().getElementType())) {
            if (expressions == null) {
                PsiNewExpressionImpl.$$$reportNull$$$0(1);
            }
            return expressions;
        }
        LOG.assertTrue(expressions[0] == qualifier);
        PsiExpression[] psiExpressionArray = Arrays.copyOfRange(expressions, 1, expressions.length);
        if (psiExpressionArray == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiExpressionArray;
    }

    @Override
    public PsiArrayInitializerExpression getArrayInitializer() {
        return (PsiArrayInitializerExpression)this.findChildByRoleAsPsiElement(77);
    }

    @Override
    public PsiMethod resolveMethod() {
        return this.resolveConstructor();
    }

    public PsiPolyVariantCachingReference getConstructorFakeReference() {
        return (PsiPolyVariantCachingReference)CachedValuesManager.getCachedValue(this, () -> new CachedValueProvider.Result<1>(new PsiPolyVariantCachingReference(){

            public JavaResolveResult @NotNull [] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
                ASTNode classRef;
                if (containingFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((classRef = PsiNewExpressionImpl.this.findChildByRole(71)) != null) {
                    ASTNode argumentList = PsiImplUtil.skipWhitespaceAndComments(classRef.getTreeNext());
                    if (argumentList != null && argumentList.getElementType() == JavaElementType.EXPRESSION_LIST) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(containingFile.getProject());
                        PsiClassType aClass = facade.getElementFactory().createType((PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(classRef));
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList), PsiNewExpressionImpl.this);
                        if (javaResolveResultArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return javaResolveResultArray;
                    }
                } else {
                    ASTNode anonymousClassElement = PsiNewExpressionImpl.this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
                    if (anonymousClassElement != null) {
                        JavaPsiFacade facade = JavaPsiFacade.getInstance(containingFile.getProject());
                        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClassElement);
                        PsiClassType aClass = anonymousClass.getBaseClassType();
                        ASTNode argumentList = anonymousClassElement.findChildByType(JavaElementType.EXPRESSION_LIST);
                        JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(aClass, (PsiExpressionList)SourceTreeToPsiMap.treeElementToPsi(argumentList), anonymousClass);
                        if (javaResolveResultArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return javaResolveResultArray;
                    }
                }
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiNewExpressionImpl psiNewExpressionImpl = PsiNewExpressionImpl.this;
                if (psiNewExpressionImpl == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiNewExpressionImpl;
            }

            @Override
            @NotNull
            public TextRange getRangeInElement() {
                if (null == null) {
                    1.$$$reportNull$$$0(5);
                }
                return null;
            }

            @Override
            @NotNull
            public String getCanonicalText() {
                throw new UnsupportedOperationException();
            }

            @Override
            public PsiElement handleElementRename(@NotNull String newElementName) {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(6);
                }
                return null;
            }

            @Override
            public PsiElement bindToElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(7);
                }
                return null;
            }

            public int hashCode() {
                return this.getElement().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof PsiPolyVariantCachingReference && this.getElement() == ((PsiReference)obj).getElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containingFile";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolveInner";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeInElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "resolveInner";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        ResolveResult[] results = this.getConstructorFakeReference().multiResolve(false);
        JavaResolveResult javaResolveResult = results.length == 1 ? (JavaResolveResult)results[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResult;
    }

    @Override
    public PsiExpression getQualifier() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceParameterList psiReferenceParameterList = (PsiReferenceParameterList)this.findChildByRoleAsPsiElement(246);
        if (psiReferenceParameterList == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(4);
        }
        return psiReferenceParameterList;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] psiTypeArray = this.getTypeArgumentList().getTypeArguments();
        if (psiTypeArray == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiTypeArray;
    }

    @Override
    public PsiMethod resolveConstructor() {
        return (PsiMethod)this.resolveMethodGenerics().getElement();
    }

    @Override
    public PsiJavaCodeReferenceElement getClassReference() {
        return (PsiJavaCodeReferenceElement)this.findChildByRoleAsPsiElement(71);
    }

    @Override
    public PsiAnonymousClass getAnonymousClass() {
        ASTNode anonymousClass = this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
        if (anonymousClass == null) {
            return null;
        }
        return (PsiAnonymousClass)SourceTreeToPsiMap.treeElementToPsi(anonymousClass);
    }

    @Override
    @Nullable
    public PsiJavaCodeReferenceElement getClassOrAnonymousClassReference() {
        ASTNode ref = this.findChildByType(CLASS_REF);
        if (ref == null) {
            return null;
        }
        if (ref instanceof PsiJavaCodeReferenceElement) {
            return (PsiJavaCodeReferenceElement)((Object)ref);
        }
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)ref.getPsi();
        return anonymousClass.getBaseClassReference();
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(6);
        }
        if (this.getChildRole(child) == 54) {
            ASTNode dot = this.findChildByRole(55);
            super.deleteChildInternal(child);
            this.deleteChildInternal(dot);
        } else {
            super.deleteChildInternal(child);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                if (firstChild != null && firstChild.getElementType() != JavaTokenType.NEW_KEYWORD) {
                    return firstChild;
                }
                return null;
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
            case 69: {
                return this.findChildByType(JavaTokenType.NEW_KEYWORD);
            }
            case 70: {
                return this.findChildByType(JavaElementType.ANONYMOUS_CLASS);
            }
            case 71: {
                return this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
            }
            case 72: {
                return this.findChildByType(ElementType.PRIMITIVE_TYPE_BIT_SET);
            }
            case 73: {
                return this.findChildByType(JavaElementType.EXPRESSION_LIST);
            }
            case 74: {
                return this.findChildByType(JavaTokenType.LBRACKET);
            }
            case 75: {
                return this.findChildByType(JavaTokenType.RBRACKET);
            }
            case 77: {
                if (this.getLastChildNode().getElementType() == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
                    return this.getLastChildNode();
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.NEW_KEYWORD) {
            return 69;
        }
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.JAVA_CODE_REFERENCE) {
            return 71;
        }
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (i == JavaTokenType.LBRACKET) {
            return 74;
        }
        if (i == JavaTokenType.RBRACKET) {
            return 75;
        }
        if (i == JavaElementType.ARRAY_INITIALIZER_EXPRESSION) {
            if (child == this.getLastChildNode()) {
                return 77;
            }
            if (child == this.getFirstChildNode()) {
                return 54;
            }
            return 76;
        }
        if (i == JavaElementType.ANONYMOUS_CLASS) {
            return 70;
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(child.getElementType())) {
            return 72;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return child == this.getFirstChildNode() ? 54 : 76;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiNewExpressionImpl.$$$reportNull$$$0(8);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitNewExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiNewExpression:" + this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiNewExpressionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayDimensions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodGenerics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOwner";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

