/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.Factory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.CharTable;

public class ReferenceListElement
extends CompositeElement {
    private final IElementType myKeyword;
    private final String myKeywordText;
    private final IElementType mySeparator;
    private final String mySeparatorText;

    public ReferenceListElement(IElementType type, IElementType keywordType, String keywordText) {
        this(type, keywordType, keywordText, JavaTokenType.COMMA, ",");
    }

    public ReferenceListElement(IElementType type, IElementType keyword, String keywordText, IElementType separator, String separatorText) {
        super(type);
        this.myKeyword = keyword;
        this.myKeywordText = keywordText;
        this.mySeparator = separator;
        this.mySeparatorText = separatorText;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (first == last && first.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            LeafElement separator;
            ASTNode child;
            for (child = first.getTreeNext(); child != null && child.getElementType() != this.mySeparator; child = child.getTreeNext()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                separator = Factory.createSingleLeafElement(this.mySeparator, this.mySeparatorText, treeCharTab, this.getManager());
                super.addInternal(separator, separator, first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != this.mySeparator; child = child.getTreePrev()) {
                if (child.getElementType() != JavaElementType.JAVA_CODE_REFERENCE) continue;
                separator = Factory.createSingleLeafElement(this.mySeparator, this.mySeparatorText, treeCharTab, this.getManager());
                super.addInternal(separator, separator, child, Boolean.FALSE);
                break;
            }
        }
        if (this.findChildByType(this.myKeyword) == null && this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE) != null) {
            LeafElement keyword = Factory.createSingleLeafElement(this.myKeyword, this.myKeywordText, treeCharTab, this.getManager());
            super.addInternal(keyword, keyword, this.getFirstChildNode(), Boolean.TRUE);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            ReferenceListElement.$$$reportNull$$$0(0);
        }
        if (child.getElementType() == JavaElementType.JAVA_CODE_REFERENCE) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == this.mySeparator) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && (prev.getElementType() == this.mySeparator || prev.getElementType() == this.myKeyword)) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ReferenceListElement.$$$reportNull$$$0(1);
        }
        assert (child.getTreeParent() == this) : child;
        IElementType childType = child.getElementType();
        if (childType == JavaTokenType.COMMA) {
            return 23;
        }
        if (childType == JavaElementType.JAVA_CODE_REFERENCE) {
            return 29;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "child";
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/ReferenceListElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

