/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileWithId;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.impl.VirtualFileEnumeration;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

@ApiStatus.Experimental
final class FileWeakScope
extends GlobalSearchScope
implements VirtualFileEnumeration {
    private final WeakReference<VirtualFile> myVirtualFile;
    @Nullable
    @Nls
    private final String myDisplayName;
    @Nullable
    private final Module myModule;

    FileWeakScope(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable @Nls String displayName) {
        if (project == null) {
            FileWeakScope.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            FileWeakScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myVirtualFile = new WeakReference<VirtualFile>(virtualFile);
        this.myDisplayName = displayName;
        FileIndexFacade facade = project.isDefault() ? null : FileIndexFacade.getInstance(project);
        this.myModule = facade == null ? null : facade.getModuleForFile(virtualFile);
    }

    @Override
    @NotNull
    public @Unmodifiable Collection<VirtualFile> getFilesIfCollection() {
        VirtualFile file = (VirtualFile)this.myVirtualFile.get();
        if (file == null) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                FileWeakScope.$$$reportNull$$$0(2);
            }
            return list;
        }
        Set<VirtualFile> set = Collections.singleton(file);
        if (set == null) {
            FileWeakScope.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileWeakScope.$$$reportNull$$$0(4);
        }
        return Comparing.equal((VirtualFile)this.myVirtualFile.get(), file);
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            FileWeakScope.$$$reportNull$$$0(5);
        }
        return aModule == this.myModule;
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myModule == null;
    }

    public String toString() {
        return "Weak File: " + this.myVirtualFile.get();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
        if (string == null) {
            FileWeakScope.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean contains(int fileId) {
        VirtualFile file = (VirtualFile)this.myVirtualFile.get();
        return file instanceof VirtualFileWithId && ((VirtualFileWithId)((Object)file)).getId() == fileId;
    }

    @Override
    public int @NotNull [] asArray() {
        int[] nArray;
        VirtualFile file = (VirtualFile)this.myVirtualFile.get();
        if (file instanceof VirtualFileWithId) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = ((VirtualFileWithId)((Object)file)).getId();
        } else {
            nArray = ArrayUtil.EMPTY_INT_ARRAY;
        }
        if (nArray == null) {
            FileWeakScope.$$$reportNull$$$0(7);
        }
        return nArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/FileWeakScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/FileWeakScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesIfCollection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

