/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;

class GlobalAndLocalUnionScope
extends GlobalSearchScope {
    @NotNull
    private final LocalSearchScope myLocalScope;
    private final GlobalSearchScope myMyGlobalScope;

    GlobalAndLocalUnionScope(GlobalSearchScope myGlobalScope, @NotNull LocalSearchScope localScope, @NotNull Project project) {
        if (localScope == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(1);
        }
        super(project);
        this.myLocalScope = localScope;
        this.myMyGlobalScope = myGlobalScope;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(2);
        }
        return this.myMyGlobalScope.contains(file) || this.myLocalScope.isInScope(file);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(4);
        }
        return this.myMyGlobalScope.contains(file1) && this.myMyGlobalScope.contains(file2) ? this.myMyGlobalScope.compare(file1, file2) : 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(5);
        }
        return this.myMyGlobalScope.isSearchInModuleContent(aModule);
    }

    @Override
    public boolean isSearchInLibraries() {
        return this.myMyGlobalScope.isSearchInLibraries();
    }

    @Override
    public @Unmodifiable @NotNull Collection<Object> getUnloadedModulesBelongingToScope() {
        Collection<Object> collection = this.myMyGlobalScope.getUnloadedModulesBelongingToScope();
        if (collection == null) {
            GlobalAndLocalUnionScope.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NonNls
    public String toString() {
        return "UnionToLocal: (" + this.myMyGlobalScope + ", " + this.myLocalScope + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalAndLocalUnionScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/GlobalAndLocalUnionScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

