/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.core.CoreBundle;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextAwareSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextInfo;
import org.jetbrains.kotlin.com.intellij.psi.search.CodeInsightContextInfoUnionKt;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.UnionFileEnumeration;
import org.jetbrains.kotlin.com.intellij.psi.search.impl.VirtualFileEnumeration;
import org.jetbrains.kotlin.com.intellij.psi.search.impl.VirtualFileEnumerationAware;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

final class UnionScope
extends GlobalSearchScope
implements CodeInsightContextAwareSearchScope,
VirtualFileEnumerationAware {
    private final GlobalSearchScope @NotNull [] myScopes;

    @Override
    @Nullable
    public VirtualFileEnumeration extractFileEnumeration() {
        SmartList<VirtualFileEnumeration> fileEnumerations = new SmartList<VirtualFileEnumeration>();
        for (GlobalSearchScope scope2 : this.myScopes) {
            VirtualFileEnumeration fileEnumeration = VirtualFileEnumeration.extract(scope2);
            if (fileEnumeration == null) {
                return null;
            }
            fileEnumerations.add(fileEnumeration);
        }
        return new UnionFileEnumeration(fileEnumerations);
    }

    @NotNull
    static GlobalSearchScope create(GlobalSearchScope @NotNull [] scopes) {
        GlobalSearchScope unionScope;
        if (scopes == null) {
            UnionScope.$$$reportNull$$$0(0);
        }
        if (scopes.length == 2 && (unionScope = UnionScope.tryCreateUnionFor2Scopes(scopes)) != null) {
            GlobalSearchScope globalSearchScope = unionScope;
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        HashSet<GlobalSearchScope> result2 = new HashSet<GlobalSearchScope>(scopes.length);
        Project project = null;
        for (GlobalSearchScope scope2 : scopes) {
            if (scope2 == EMPTY_SCOPE) continue;
            Project scopeProject = scope2.getProject();
            if (scopeProject != null) {
                project = scopeProject;
            }
            if (scope2 instanceof UnionScope) {
                ContainerUtil.addAll(result2, ((UnionScope)scope2).myScopes);
                continue;
            }
            result2.add(scope2);
        }
        if (result2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        if (result2.size() == 1) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)result2.iterator().next();
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        return new UnionScope(project, result2.toArray(EMPTY_ARRAY));
    }

    @Nullable
    private static GlobalSearchScope tryCreateUnionFor2Scopes(GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            UnionScope.$$$reportNull$$$0(4);
        }
        assert (scopes.length == 2);
        GlobalSearchScope scope0 = scopes[0];
        GlobalSearchScope scope1 = scopes[1];
        if (scope0 == EMPTY_SCOPE) {
            return scope1;
        }
        if (scope1 == EMPTY_SCOPE) {
            return scope0;
        }
        if (scope0 instanceof UnionScope && scope1 instanceof UnionScope) {
            return null;
        }
        Project project = ObjectUtils.chooseNotNull(scope0.getProject(), scope1.getProject());
        if (scope0 instanceof UnionScope) {
            return UnionScope.unionWithUnionScope(scope0, scope1, project);
        }
        if (scope1 instanceof UnionScope) {
            return UnionScope.unionWithUnionScope(scope1, scope0, project);
        }
        return new UnionScope(project, scopes);
    }

    @NotNull
    private static GlobalSearchScope unionWithUnionScope(GlobalSearchScope scope0, GlobalSearchScope scope1, Project project) {
        GlobalSearchScope[] scopes0 = ((UnionScope)scope0).myScopes;
        if (ArrayUtil.contains(scope1, scopes0)) {
            GlobalSearchScope globalSearchScope = scope0;
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        return new UnionScope(project, ArrayUtil.append(scopes0, scope1));
    }

    private UnionScope(Project project, GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            UnionScope.$$$reportNull$$$0(6);
        }
        super(project);
        this.myScopes = scopes;
        if (scopes.length < 2) {
            throw new IllegalArgumentException("expected >= 2 scopes but got: " + Arrays.toString(scopes));
        }
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = CoreBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
        if (string == null) {
            UnionScope.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            UnionScope.$$$reportNull$$$0(8);
        }
        return ContainerUtil.find(this.myScopes, scope2 -> scope2.contains(file)) != null;
    }

    @Override
    @NotNull
    public CodeInsightContextInfo getCodeInsightContextInfo() {
        CodeInsightContextInfo codeInsightContextInfo = CodeInsightContextInfoUnionKt.createCodeInsightContextInfoUnion(this.myScopes);
        if (codeInsightContextInfo == null) {
            UnionScope.$$$reportNull$$$0(9);
        }
        return codeInsightContextInfo;
    }

    @Override
    @NotNull
    public Collection<Object> getUnloadedModulesBelongingToScope() {
        LinkedHashSet<Object> result2 = new LinkedHashSet<Object>();
        for (GlobalSearchScope scope2 : this.myScopes) {
            result2.addAll(scope2.getUnloadedModulesBelongingToScope());
        }
        LinkedHashSet<Object> linkedHashSet = result2;
        if (linkedHashSet == null) {
            UnionScope.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            UnionScope.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            UnionScope.$$$reportNull$$$0(12);
        }
        int[] result2 = new int[]{0};
        ContainerUtil.process(this.myScopes, scope2 -> {
            if (!scope2.contains(file1) || !scope2.contains(file2)) {
                return true;
            }
            int cmp = scope2.compare(file1, file2);
            if (result2[0] == 0) {
                result2[0] = cmp;
                return true;
            }
            if (cmp == 0) {
                return true;
            }
            if (result2[0] > 0 == cmp > 0) {
                return true;
            }
            result2[0] = 0;
            return false;
        });
        return result2[0];
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module2) {
        if (module2 == null) {
            UnionScope.$$$reportNull$$$0(13);
        }
        return ContainerUtil.find(this.myScopes, scope2 -> scope2.isSearchInModuleContent(module2)) != null;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module module2, boolean testSources) {
        if (module2 == null) {
            UnionScope.$$$reportNull$$$0(14);
        }
        return ContainerUtil.find(this.myScopes, scope2 -> scope2.isSearchInModuleContent(module2, testSources)) != null;
    }

    @Override
    public boolean isSearchInLibraries() {
        return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnionScope)) {
            return false;
        }
        UnionScope that = (UnionScope)o;
        return ContainerUtil.newHashSet(this.myScopes).equals(ContainerUtil.newHashSet(that.myScopes));
    }

    @Override
    public int calcHashCode() {
        return Arrays.hashCode(this.myScopes);
    }

    @NonNls
    public String toString() {
        return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope2) {
        if (scope2 == null) {
            UnionScope.$$$reportNull$$$0(15);
        }
        if (scope2 instanceof UnionScope) {
            GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope2).myScopes);
            return UnionScope.create(newScopes);
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope2);
        if (globalSearchScope == null) {
            UnionScope.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/UnionScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/UnionScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unionWithUnionScope";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeInsightContextInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateUnionFor2Scopes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

