/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementTypeHolderEP;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public abstract class IStubElementType<StubT extends StubElement<?>, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static final Set<String> NOT_INITIALIZED_SET = Collections.emptySet();
    private static volatile Set<String> lazyExternalIds = NOT_INITIALIZED_SET;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (IStubElementType.isInitialized() && !this.isLazilyRegistered()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + this.getClass() + " with external ID " + this.getExternalId() + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList() + "\nRegistered lazy ids: " + lazyExternalIds);
        }
    }

    public static void checkNotInstantiatedTooLate(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        if (IStubElementType.isInitialized()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList());
        }
    }

    private static boolean isInitialized() {
        return lazyExternalIds != NOT_INITIALIZED_SET;
    }

    private boolean isLazilyRegistered() {
        try {
            return lazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement<? extends PsiElement> var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/stubs/IStubElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/IStubElementType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRegisteredStubElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

